/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc.tsl;

import ee.sk.digidoc.tsl.MultiLangString;
import ee.sk.digidoc.tsl.Quality;
import ee.sk.utils.ConvertUtils;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TSPService {
    private String m_type = null;
    private List m_names = null;
    private List m_certs = null;
    private List m_subjectNames = null;
    private String m_status = null;
    private Date m_statusSdt = null;
    private List m_definitionUris = null;
    private List m_qualities = null;
    private List m_accessPoints = null;
    private String m_cn = null;
    private String m_hash = null;
    private String m_caCN = null;
    private String m_caHash = null;
    public static final String TSP_TYPE_CA_QC = "http://uri.etsi.org/TrstSvc/Svctype/CA/QC";
    public static final String TSP_TYPE_EXT_OCSP_QC = "http://uri.etsi.org/TrstSvc/eSigDir-1999-93-EC-TrustedList/SvcInfoExt/OCSP-QC";
    public static final String TSP_TYPE_EXT_CRL_QC = "http://uri.etsi.org/TrstSvc/eSigDir-1999-93-EC-TrustedList/SvcInfoExt/CRL-QC";
    public static final String TSP_TYPE_EXT_ROOT_QC = "http://uri.etsi.org/TrstSvc/eSigDir-1999-93-EC-TrustedList/SvcInfoExt/RootCA-QC";
    public static final String TSP_TYPE_EXT_TSS_QC = "http://uri.etsi.org/TrstSvc/eSigDir-1999-93-EC-TrustedList/SvcInfoExt/TSS-QC";
    public static final String TSP_TYPE_QC_WITHSSCD = "http://uri.etsi.org/TrstSvc/eSigDir-1999-93-EC-TrustedList/SvcInfoExt/QCWithSSCD";
    public static final String TSP_TYPE_OCSP = "http://uri.etsi.org/TrstSvc/Svctype/Certstatus/OCSP";
    public static final String TSP_STATUS_UNDERSUPERVISION = "http://uri.etsi.org/TrstSvc/eSigDir-1999-93-EC-TrustedList/Svcstatus/undersupervision";
    public static final String TSP_STATUS_SUPERVISIONINCESSATION = "http: //uri.etsi.org/TrstSvc/eSigDir-1999-93-EC-TrustedList /Svcstatus/supervisionincessation";
    public static final String TSP_STATUS_SUPERVISIONCEASED = "http://uri.etsi.org/TrstSvc/eSigDir-1999-93-EC-TrustedList /Svcstatus/supervisionceased";
    public static final String TSP_STATUS_SUPERVISIONREVOKED = "http://uri.etsi.org/TrstSvc/eSigDir-1999-93-EC-TrustedList /Svcstatus/supervisionrevoked";
    public static final String TSP_STATUS_ACCREDITED = "http://uri.etsi.org/TrstSvc/eSigDir-1999-93-EC-TrustedList /Svcstatus/accredited";
    public static final String TSP_STATUS_ACCREDITATIONCEASED = "http://uri.etsi.org/TrstSvc/eSigDir-1999-93-EC-TrustedList /Svcstatus/accreditationceased";
    public static final String TSP_STATUS_ACCREDITATIONREVOKED = "http://uri.etsi.org/TrstSvc/eSigDir-1999-93-EC-TrustedList /Svcstatus/accreditationrevoked";

    public String getType() {
        return this.m_type;
    }

    public MultiLangString[] getNames() {
        return ConvertUtils.list2mls(this.m_names);
    }

    public MultiLangString getName(int n) {
        return ConvertUtils.getListObj(this.m_names, n);
    }

    public MultiLangString[] getSubjectNames() {
        return ConvertUtils.list2mls(this.m_subjectNames);
    }

    public MultiLangString getSubjectName(int n) {
        return ConvertUtils.getListObj(this.m_subjectNames, n);
    }

    public MultiLangString[] getServiceDefinitionURIs() {
        return ConvertUtils.list2mls(this.m_definitionUris);
    }

    public MultiLangString getServiceDefinitionURI(int n) {
        return ConvertUtils.getListObj(this.m_definitionUris, n);
    }

    public String getStatus() {
        return this.m_status;
    }

    public Date getStatusStartingTime() {
        return this.m_statusSdt;
    }

    public int getNumCertificates() {
        return this.m_certs != null ? this.m_certs.size() : 0;
    }

    public X509Certificate[] getCertificates() {
        X509Certificate[] arr = null;
        if (this.m_certs != null && this.m_certs.size() > 0) {
            arr = new X509Certificate[this.m_certs.size()];
            for (int i = 0; i < this.m_certs.size(); ++i) {
                arr[i] = (X509Certificate)this.m_certs.get(i);
            }
        }
        return arr;
    }

    public X509Certificate getCertificate(int n) {
        if (this.m_certs != null && n >= 0 && n < this.m_certs.size()) {
            return (X509Certificate)this.m_certs.get(n);
        }
        return null;
    }

    public Quality[] getQualities() {
        Quality[] arr = null;
        if (this.m_qualities != null && this.m_qualities.size() > 0) {
            arr = new Quality[this.m_qualities.size()];
            for (int i = 0; i < this.m_qualities.size(); ++i) {
                arr[i] = (Quality)this.m_qualities.get(i);
            }
        }
        return arr;
    }

    public Quality getQuality(int n) {
        if (this.m_qualities != null && n >= 0 && n < this.m_qualities.size()) {
            return (Quality)this.m_qualities.get(n);
        }
        return null;
    }

    public String[] getServiceAccessPoints() {
        return ConvertUtils.list2strings(this.m_accessPoints);
    }

    public String getServiceAccessPoint(int n) {
        return ConvertUtils.getListString(this.m_accessPoints, n);
    }

    public String getCn() {
        return this.m_cn;
    }

    public String getHash() {
        return this.m_hash;
    }

    public String getCaCn() {
        return this.m_caCN;
    }

    public String getCaHash() {
        return this.m_caHash;
    }

    public boolean isCA() {
        return this.m_type == null || this.m_type.equals(TSP_TYPE_CA_QC);
    }

    public boolean isOCSP() {
        return this.m_type != null || this.m_type.equals(TSP_TYPE_OCSP);
    }

    public void setType(String s) {
        this.m_type = s;
    }

    public void addName(MultiLangString s) {
        this.m_names = ConvertUtils.addObject(this.m_names, s);
    }

    public void addSubjectName(MultiLangString s) {
        this.m_subjectNames = ConvertUtils.addObject(this.m_subjectNames, s);
    }

    public void addServiceDefinitionURI(MultiLangString s) {
        this.m_definitionUris = ConvertUtils.addObject(this.m_definitionUris, s);
    }

    public void setStatus(String s) {
        this.m_status = s;
    }

    public void setStatusStartingTime(Date d) {
        this.m_statusSdt = d;
    }

    public void addCertificate(X509Certificate a) {
        if (this.m_certs == null) {
            this.m_certs = new ArrayList();
        }
        this.m_certs.add(a);
    }

    public void addQuality(Quality a) {
        if (this.m_qualities == null) {
            this.m_qualities = new ArrayList();
        }
        this.m_qualities.add(a);
    }

    public void addServiceAccessPoint(String s) {
        this.m_accessPoints = ConvertUtils.addObject(this.m_accessPoints, s);
    }

    public void setCn(String s) {
        this.m_cn = s;
    }

    public void setHash(String s) {
        this.m_hash = s;
    }

    public void setCaCn(String s) {
        this.m_caCN = s;
    }

    public void setCaHash(String s) {
        this.m_caHash = s;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer("[TSPService");
        sb.append(ConvertUtils.stringElemToString("type", this.m_type));
        sb.append(ConvertUtils.stringElemToString("status", this.m_status));
        sb.append(ConvertUtils.dateElemToString("status-dt", this.m_statusSdt));
        sb.append(ConvertUtils.stringElemToString("cn", this.m_cn));
        sb.append(ConvertUtils.stringElemToString("hash", this.m_hash));
        sb.append(ConvertUtils.stringElemToString("ca-cn", this.m_caCN));
        sb.append(ConvertUtils.stringElemToString("ca-hash", this.m_caHash));
        sb.append("[Names");
        for (i = 0; this.m_names != null && i < this.m_names.size(); ++i) {
            sb.append((MultiLangString)this.m_names.get(i));
        }
        sb.append("][SubjectNames");
        for (i = 0; this.m_subjectNames != null && i < this.m_subjectNames.size(); ++i) {
            sb.append((MultiLangString)this.m_subjectNames.get(i));
        }
        sb.append("][ServiceDefinitionURIs");
        for (i = 0; this.m_definitionUris != null && i < this.m_definitionUris.size(); ++i) {
            sb.append((MultiLangString)this.m_definitionUris.get(i));
        }
        sb.append("][Certs");
        for (i = 0; this.m_certs != null && i < this.m_certs.size(); ++i) {
            sb.append(ConvertUtils.stringElemToString("cert", ((X509Certificate)this.m_certs.get(i)).getSubjectDN().getName()));
        }
        sb.append("]");
        if (this.m_qualities != null && this.m_qualities.size() > 0) {
            sb.append("[Qualities");
            for (i = 0; this.m_qualities != null && i < this.m_qualities.size(); ++i) {
                sb.append((Quality)this.m_qualities.get(i));
            }
            sb.append("]");
        }
        if (this.m_accessPoints != null && this.m_accessPoints.size() > 0) {
            sb.append("[AccessPoints");
            for (i = 0; this.m_accessPoints != null && i < this.m_accessPoints.size(); ++i) {
                sb.append((String)this.m_accessPoints.get(i));
            }
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }
}

