/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc.tsl;

import ee.sk.digidoc.tsl.SchemeInformation;
import ee.sk.digidoc.tsl.TrustServiceProvider;
import java.util.ArrayList;
import java.util.List;

public class TrustServiceStatusList {
    private SchemeInformation m_schemeInfo = null;
    private List m_tsps = null;

    public SchemeInformation getSchemeInformation() {
        return this.m_schemeInfo;
    }

    public int getNumProviders() {
        return this.m_tsps != null ? this.m_tsps.size() : 0;
    }

    public TrustServiceProvider[] getTrustServiceProviders() {
        TrustServiceProvider[] arr = null;
        if (this.m_tsps != null && this.m_tsps.size() > 0) {
            arr = new TrustServiceProvider[this.m_tsps.size()];
            for (int i = 0; i < this.m_tsps.size(); ++i) {
                arr[i] = (TrustServiceProvider)this.m_tsps.get(i);
            }
        }
        return arr;
    }

    public TrustServiceProvider getTrustServiceProvider(int n) {
        if (this.m_tsps != null && n >= 0 && n < this.m_tsps.size()) {
            return (TrustServiceProvider)this.m_tsps.get(n);
        }
        return null;
    }

    public boolean isLocal() {
        return this.m_schemeInfo != null && this.m_schemeInfo.getType() != null && this.m_schemeInfo.getType().equals("LOCAL");
    }

    public void setSchemeInformation(SchemeInformation si) {
        this.m_schemeInfo = si;
    }

    public void addTrustServiceProvider(TrustServiceProvider a) {
        if (this.m_tsps == null) {
            this.m_tsps = new ArrayList();
        }
        this.m_tsps.add(a);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[TrustServiceStatusList");
        if (this.m_schemeInfo != null) {
            sb.append(this.m_schemeInfo);
        }
        for (int i = 0; this.m_tsps != null && i < this.m_tsps.size(); ++i) {
            sb.append((TrustServiceProvider)this.m_tsps.get(i));
        }
        sb.append("]");
        return sb.toString();
    }
}

