/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc.tsl;

import ee.sk.digidoc.Base64Util;
import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.SignedDoc;
import ee.sk.digidoc.factory.SAXDigiDocException;
import ee.sk.digidoc.tsl.MultiLangString;
import ee.sk.digidoc.tsl.PostalAddress;
import ee.sk.digidoc.tsl.Quality;
import ee.sk.digidoc.tsl.SchemeInformation;
import ee.sk.digidoc.tsl.TSPInformation;
import ee.sk.digidoc.tsl.TSPService;
import ee.sk.digidoc.tsl.TrustServiceProvider;
import ee.sk.digidoc.tsl.TrustServiceStatusList;
import ee.sk.utils.ConvertUtils;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TslParser
extends DefaultHandler {
    private static Logger m_logger = Logger.getLogger(TslParser.class);
    private Stack m_tags;
    private TrustServiceStatusList m_tsl;
    private StringBuffer m_sbCollectItem;
    private SchemeInformation m_si;
    private TrustServiceProvider m_tsp;
    private MultiLangString m_mls;
    private PostalAddress m_adr;
    private TSPService m_tsps;
    private Quality m_qual;

    public TrustServiceStatusList readTSL(InputStream is) throws DigiDocException {
        TslParser handler = this;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(is, (DefaultHandler)handler);
        }
        catch (SAXDigiDocException ex) {
            throw ex.getDigiDocException();
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 75);
        }
        if (this.m_tsl == null) {
            throw new DigiDocException(13, "This document is not in TSL format", null);
        }
        return this.m_tsl;
    }

    @Override
    public void startDocument() throws SAXException {
        this.m_tags = new Stack();
        this.m_tsl = null;
        this.m_sbCollectItem = null;
        this.m_si = null;
        this.m_tsp = null;
        this.m_mls = null;
        this.m_adr = null;
        this.m_tsps = null;
        this.m_qual = null;
    }

    @Override
    public void endDocument() throws SAXException {
    }

    private String getAttrValue(Attributes attrs, String key) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String key2 = attrs.getQName(i);
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Attr: " + key2 + " value: " + attrs.getValue(i)));
            }
            if (key2.indexOf(key) == -1) continue;
            return attrs.getValue(i);
        }
        return null;
    }

    private boolean findTagOnStack(String tag) {
        Enumeration eTags = this.m_tags.elements();
        while (eTags.hasMoreElements()) {
            String t2 = (String)eTags.nextElement();
            if (!t2.equals(tag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXDigiDocException {
        String tag = qName;
        if (tag.indexOf(58) != -1) {
            tag = qName.substring(qName.indexOf(58) + 1);
        }
        this.m_tags.push(tag);
        this.m_sbCollectItem = new StringBuffer();
        if (tag.equals("TrustServiceStatusList")) {
            this.m_tsl = new TrustServiceStatusList();
        }
        if (tag.equals("SchemeInformation")) {
            this.m_si = new SchemeInformation();
            if (this.m_tsl != null) {
                this.m_tsl.setSchemeInformation(this.m_si);
            }
        }
        if (tag.equals("PostalAddress")) {
            this.m_adr = new PostalAddress();
            if (this.m_si != null && this.findTagOnStack("SchemeOperatorAddress")) {
                this.m_si.addPostalAddress(this.m_adr);
            }
            if (this.m_tsp != null && this.m_tsp.getTSPInformation() != null && this.findTagOnStack("TSPAddress")) {
                this.m_tsp.getTSPInformation().addPostalAddress(this.m_adr);
            }
        }
        if (tag.equals("URI")) {
            this.m_mls = new MultiLangString();
            this.m_mls.setLang(this.getAttrValue(attrs, "lang"));
            if (this.m_si != null && this.findTagOnStack("SchemeOperatorAddress")) {
                this.m_si.addElectronicAddress(this.m_mls);
            }
            if (this.m_si != null && this.findTagOnStack("SchemeTypeCommunityRules")) {
                this.m_si.addSchemeTypeCommunityRule(this.m_mls);
            }
            if (this.m_si != null && this.findTagOnStack("DistributionPoints")) {
                this.m_si.addDistributionPoint(this.m_mls);
            }
            if (this.m_si != null && this.findTagOnStack("SchemeInformationURI")) {
                this.m_si.addSchemeInformationURI(this.m_mls);
            }
            if (this.m_tsp != null && this.m_tsp.getTSPInformation() != null && this.findTagOnStack("TSPAddress")) {
                this.m_tsp.getTSPInformation().addElectronicAddress(this.m_mls);
            }
            if (this.m_tsp != null && this.m_tsp.getTSPInformation() != null && this.findTagOnStack("TSPInformationURI")) {
                this.m_tsp.getTSPInformation().addInformationURI(this.m_mls);
            }
            if (this.m_tsps != null && this.findTagOnStack("TSPServiceDefinitionURI")) {
                this.m_tsps.addServiceDefinitionURI(this.m_mls);
            }
        }
        if (tag.equals("TSLLegalNotice")) {
            this.m_mls = new MultiLangString();
            this.m_mls.setLang(this.getAttrValue(attrs, "lang"));
            if (this.m_si != null) {
                this.m_si.addPolicyOrLegalNotice(this.m_mls);
            }
        }
        if (tag.equals("Name")) {
            this.m_mls = new MultiLangString();
            this.m_mls.setLang(this.getAttrValue(attrs, "lang"));
            if (this.m_si != null && this.findTagOnStack("SchemeOperatorName")) {
                this.m_si.addOperatorName(this.m_mls);
            }
            if (this.m_si != null && this.findTagOnStack("SchemeName")) {
                this.m_si.addSchemeName(this.m_mls);
            }
            if (this.m_tsp != null && this.m_tsp.getTSPInformation() != null && this.findTagOnStack("TSPName")) {
                this.m_tsp.getTSPInformation().addName(this.m_mls);
            }
            if (this.m_tsp != null && this.m_tsp.getTSPInformation() != null && this.findTagOnStack("TSPTradeName")) {
                this.m_tsp.getTSPInformation().addTradeName(this.m_mls);
            }
            if (this.m_tsps != null) {
                this.m_tsps.addName(this.m_mls);
            }
        }
        if (tag.equals("TrustServiceProvider")) {
            this.m_tsp = new TrustServiceProvider();
            if (this.m_tsl != null) {
                this.m_tsl.addTrustServiceProvider(this.m_tsp);
            }
        }
        if (tag.equals("TSPInformation") && this.m_tsp != null) {
            this.m_tsp.setTSPInformation(new TSPInformation());
        }
        if (tag.equals("TSPService")) {
            this.m_tsps = new TSPService();
            if (this.m_tsp != null) {
                this.m_tsp.addTSPService(this.m_tsps);
            }
        }
        if (tag.equals("QualityElement")) {
            this.m_qual = new Quality();
            if (this.m_tsps != null) {
                this.m_tsps.addQuality(this.m_qual);
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        String tag = qName;
        String nsPref = null;
        if (tag.indexOf(58) != -1) {
            tag = qName.substring(qName.indexOf(58) + 1);
            nsPref = qName.substring(0, qName.indexOf(58));
        }
        String currTag = (String)this.m_tags.pop();
        if (tag.equals("SchemeInformation")) {
            this.m_si = null;
        }
        if (tag.equals("TSLVersionIdentifier") && this.m_si != null) {
            this.m_si.setVersionIdentifier(Integer.parseInt(this.m_sbCollectItem.toString()));
        }
        if (tag.equals("TSLSequenceNumber") && this.m_si != null) {
            this.m_si.setSequenceNumber(Integer.parseInt(this.m_sbCollectItem.toString()));
        }
        if (tag.equals("TSLType") && this.m_si != null) {
            this.m_si.setType(this.m_sbCollectItem.toString());
        }
        if (tag.equals("Name")) {
            if (this.m_mls != null) {
                this.m_mls.setValue(this.m_sbCollectItem.toString());
            }
            this.m_mls = null;
        }
        if (tag.equals("PostalAddress")) {
            this.m_adr = null;
        }
        if (tag.equals("StreetAddress") && this.m_adr != null) {
            this.m_adr.setStreetAddress(this.m_sbCollectItem.toString());
        }
        if (tag.equals("Locality") && this.m_adr != null) {
            this.m_adr.setLocality(this.m_sbCollectItem.toString());
        }
        if (tag.equals("PostalCode") && this.m_adr != null) {
            this.m_adr.setPostalCode(this.m_sbCollectItem.toString());
        }
        if (tag.equals("CountryName") && this.m_adr != null) {
            this.m_adr.setCountryName(this.m_sbCollectItem.toString());
        }
        if (tag.equals("URI")) {
            if (this.m_mls != null) {
                this.m_mls.setValue(this.m_sbCollectItem.toString());
            }
            this.m_mls = null;
        }
        if (tag.equals("TSLLegalNotice")) {
            if (this.m_mls != null) {
                this.m_mls.setValue(this.m_sbCollectItem.toString());
            }
            this.m_mls = null;
        }
        if (tag.equals("StatusDeterminationApproach") && this.m_si != null) {
            this.m_si.setStatusDeterminationApproach(this.m_sbCollectItem.toString());
        }
        if (tag.equals("SchemeTerritory") && this.m_si != null) {
            this.m_si.setSchemeTerritory(this.m_sbCollectItem.toString());
        }
        if (tag.equals("HistoricalInformationPeriod") && this.m_si != null) {
            this.m_si.setHistoricalInformationPeriod(Integer.parseInt(this.m_sbCollectItem.toString()));
        }
        if (tag.equals("ListIssueDateTime") && this.m_si != null) {
            this.m_si.setListIssueDate(ConvertUtils.str2date(this.m_sbCollectItem.toString()));
        }
        if (tag.equals("dateTime") && this.m_si != null && this.findTagOnStack("NextUpdate")) {
            this.m_si.addNextUpdate(ConvertUtils.str2date(this.m_sbCollectItem.toString()));
        }
        if (tag.equals("ServiceTypeIdentifier") && this.m_tsps != null) {
            this.m_tsps.setType(this.m_sbCollectItem.toString());
        }
        if (tag.equals("X509Certificate")) {
            try {
                X509Certificate cert;
                if (this.m_tsps != null && this.findTagOnStack("ServiceDigitalIdentity") && (cert = SignedDoc.readCertificate(Base64Util.decode(this.m_sbCollectItem.toString()))) != null) {
                    this.m_tsps.addCertificate(cert);
                    String sDn = ConvertUtils.convX509Name(cert.getIssuerX500Principal());
                    String sCn = ConvertUtils.getCommonName(sDn);
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("DN: " + sDn + " CN: " + sCn));
                    }
                    this.m_tsps.setCaCn(sCn);
                }
            }
            catch (DigiDocException ex) {
                SAXDigiDocException.handleException(ex);
            }
        }
        if (tag.equals("X509SubjectName")) {
            if (this.m_tsps != null && this.findTagOnStack("ServiceDigitalIdentity")) {
                this.m_tsps.addSubjectName(new MultiLangString(null, this.m_sbCollectItem.toString()));
            }
            if (this.m_tsps != null && this.findTagOnStack("DigitalId")) {
                this.m_tsps.addSubjectName(new MultiLangString(null, this.m_sbCollectItem.toString()));
                String cn = ConvertUtils.getCommonName(this.m_sbCollectItem.toString());
                if (cn != null && cn.trim().length() > 0) {
                    this.m_tsps.setCn(cn);
                }
            }
        }
        if (tag.equals("ServiceStatus") && this.m_tsps != null) {
            this.m_tsps.setStatus(this.m_sbCollectItem.toString());
        }
        if (tag.equals("StatusStartingTime") && this.m_tsps != null) {
            this.m_tsps.setStatusStartingTime(ConvertUtils.str2date(this.m_sbCollectItem.toString()));
        }
        if (tag.equals("QualityName") && this.m_qual != null) {
            this.m_qual.setName(this.m_sbCollectItem.toString());
        }
        if (tag.equals("QualityValue") && this.m_qual != null) {
            this.m_qual.setValue(Integer.parseInt(this.m_sbCollectItem.toString()));
        }
        if (tag.equals("ServiceSupplyPoint") && this.m_tsp != null) {
            this.m_tsps.addServiceAccessPoint(this.m_sbCollectItem.toString());
        }
        if (tag.equals("QualityElement")) {
            this.m_qual = null;
        }
        if (tag.equals("TSPService")) {
            this.m_tsps = null;
        }
        if (tag.equals("TrustServiceProvider")) {
            this.m_tsp = null;
        }
        this.m_sbCollectItem = null;
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
        if (s != null && this.m_sbCollectItem != null) {
            this.m_sbCollectItem.append(s);
        }
    }
}

