/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.test;

import ee.sk.digidoc.CertValue;
import ee.sk.digidoc.DataFile;
import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.KeyInfo;
import ee.sk.digidoc.Signature;
import ee.sk.digidoc.SignatureProductionPlace;
import ee.sk.digidoc.SignedDoc;
import ee.sk.digidoc.TokenKeyInfo;
import ee.sk.digidoc.factory.DigiDocFactory;
import ee.sk.digidoc.factory.DigiDocGenFactory;
import ee.sk.digidoc.factory.DigiDocVerifyFactory;
import ee.sk.digidoc.factory.NotaryFactory;
import ee.sk.digidoc.factory.PKCS11SignatureFactory;
import ee.sk.digidoc.factory.Pkcs12SignatureFactory;
import ee.sk.digidoc.factory.SAXDigiDocFactory;
import ee.sk.digidoc.factory.SignatureFactory;
import ee.sk.utils.ConfigManager;
import ee.sk.utils.ConvertUtils;
import ee.sk.xmlenc.EncryptedData;
import ee.sk.xmlenc.EncryptedKey;
import ee.sk.xmlenc.EncryptionProperty;
import ee.sk.xmlenc.factory.EncryptedDataParser;
import ee.sk.xmlenc.factory.EncryptedStreamParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;

public class jdigidoc {
    private SignedDoc m_sdoc = null;
    private EncryptedData m_cdoc = null;
    String sFilIn;
    String sFilOut;

    private boolean runNewSignedDocCmds(String[] args) {
        boolean bFound = false;
        boolean bOk = true;
        String format = "DIGIDOC-XML";
        String version = null;
        String ver = null;
        String profile = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-ddoc-new")) continue;
            bFound = true;
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                format = args[i + 1];
                ++i;
            }
            if (i >= args.length - 1 || args[i + 1].startsWith("-")) continue;
            version = args[i + 1];
            ++i;
        }
        if (bFound) {
            try {
                profile = version;
                if (format != null && format.equals("BDOC")) {
                    if (ver == null) {
                        ver = "2.1";
                    }
                    if (profile != null && profile.equals("TS")) {
                        System.out.println("TS profile is currently not supported!");
                        return false;
                    }
                    if (profile != null && version.equals("2.1")) {
                        profile = "TM";
                    }
                    if (profile == null || profile.trim().length() == 0) {
                        profile = ConfigManager.instance().getStringProperty("DIGIDOC_DEFAULT_PROFILE", "TM");
                    }
                }
                if (format != null && (format.equals("SK-XML") || format.equals("DIGIDOC-XML"))) {
                    if (ver == null) {
                        ver = "1.3";
                    }
                    profile = "TM";
                }
                System.out.println("Creating digidoc: " + format + " / " + ver + " / " + profile);
                this.m_sdoc = new SignedDoc(format, ver);
                this.m_sdoc.setProfile(profile);
            }
            catch (Exception ex) {
                bOk = false;
                System.err.println("ERROR: creating digidoc format: " + format + " / " + version + " - " + ex);
                ex.printStackTrace(System.err);
            }
        }
        return bOk;
    }

    private boolean runWriteSignedDocCmds(String[] args) {
        boolean bOk = true;
        boolean bFound = false;
        boolean bStream = false;
        boolean bOStream = false;
        String outFile = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-ddoc-out") && !args[i].equals("-ddoc-out-stream") && !args[i].equals("-ddoc-out-ostream")) continue;
            bFound = true;
            if (args[i].equals("-ddoc-out-stream")) {
                bStream = true;
            }
            if (args[i].equals("-ddoc-out-ostream")) {
                bOStream = true;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                this.sFilOut = outFile = args[i + 1];
                ++i;
                continue;
            }
            bOk = false;
            System.err.println("Missing output file of -ddoc-out command");
        }
        if (bFound && outFile != null) {
            try {
                if (this.m_sdoc == null) {
                    System.err.println("No signed document to sign. Use -ddoc-in or -ddoc-new commands!");
                    return false;
                }
                if (bOStream) {
                    ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(outFile));
                    oos.writeObject(this.m_sdoc);
                    oos.close();
                } else if (bStream) {
                    FileOutputStream fos = new FileOutputStream(outFile);
                    this.m_sdoc.writeToStream(fos);
                    fos.close();
                } else {
                    this.m_sdoc.writeToFile(new File(outFile));
                }
                bOk = true;
            }
            catch (Exception ex) {
                bOk = false;
                System.err.println("ERROR: writing digidoc: " + ex);
                ex.printStackTrace(System.err);
            }
        }
        return bOk;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean runSignSignedDocCmds(String[] args) {
        boolean bOk = true;
        String sImpl = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            block40: {
                if (!args[i].equals("-ddoc-sign")) continue;
                String pin = null;
                String rollReso = null;
                String country = null;
                String city = null;
                String state = null;
                String zip = null;
                String profile = null;
                String keystoreFile = null;
                int nSlot = 0;
                if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                    pin = args[i + 1];
                    ++i;
                }
                if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                    rollReso = args[i + 1];
                    ++i;
                }
                if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                    country = args[i + 1];
                    ++i;
                }
                if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                    state = args[i + 1];
                    ++i;
                }
                if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                    city = args[i + 1];
                    ++i;
                }
                if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                    zip = args[i + 1];
                    ++i;
                }
                if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                    nSlot = Integer.parseInt(args[i + 1]);
                    ++i;
                }
                if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                    profile = args[i + 1];
                    ++i;
                }
                if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                    sImpl = args[i + 1];
                    ++i;
                }
                if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                    keystoreFile = args[i + 1];
                    ++i;
                }
                if (pin == null) break block40;
                try {
                    SignatureFactory sigFac;
                    SignatureProductionPlace adr;
                    String[] roles;
                    block42: {
                        Pkcs12SignatureFactory p12sfac;
                        ConfigManager cfg;
                        block41: {
                            if (this.m_sdoc == null) {
                                System.err.println("No signed document to sign. Use -ddoc-in or -ddoc-new commands!");
                                return false;
                            }
                            roles = null;
                            if (rollReso != null && rollReso.trim().length() > 0) {
                                roles = new String[]{rollReso};
                            }
                            adr = null;
                            if (country != null || state != null || city != null || zip != null) {
                                adr = new SignatureProductionPlace(city, state, country, zip);
                            }
                            System.out.println("Signing digidoc");
                            cfg = ConfigManager.instance();
                            System.err.println("Signing of type: " + sImpl);
                            sigFac = null;
                            Object lerrs = null;
                            DigiDocException ex1 = this.m_sdoc.validateFormatAndVersion();
                            if (ex1 != null) {
                                System.err.println("Validation error: " + ex1 + ". Signing cancelled!");
                                return false;
                            }
                            if (sImpl == null) break block41;
                            if (sImpl.equals("PKCS11")) {
                                sigFac = cfg.getSignatureFactoryOfType(sImpl);
                                break block42;
                            } else {
                                if (!sImpl.equals("PKCS12")) {
                                    System.err.println("No signature factory of type: " + sImpl);
                                    return false;
                                }
                                sigFac = cfg.getSignatureFactoryOfType(sImpl);
                                p12sfac = (Pkcs12SignatureFactory)sigFac;
                                if (keystoreFile == null || keystoreFile.trim().length() == 0) {
                                    keystoreFile = cfg.getProperty("DIGIDOC_KEYSTORE_FILE");
                                }
                                if (pin == null || pin.trim().length() == 0) {
                                    pin = cfg.getProperty("DIGIDOC_KEYSTORE_PASSWD");
                                }
                                if (p12sfac != null) {
                                    bOk = p12sfac.load(keystoreFile, "PKCS12", pin);
                                }
                            }
                            break block42;
                        }
                        sigFac = cfg.getSignatureFactory();
                        if (sigFac != null && sigFac.getType().equals("PKCS12")) {
                            p12sfac = (Pkcs12SignatureFactory)sigFac;
                            if (keystoreFile == null || keystoreFile.trim().length() == 0) {
                                keystoreFile = cfg.getProperty("DIGIDOC_KEYSTORE_FILE");
                            }
                            if (pin == null || pin.trim().length() == 0) {
                                pin = cfg.getProperty("DIGIDOC_KEYSTORE_PASSWD");
                            }
                            bOk = p12sfac.load(keystoreFile, "PKCS12", pin);
                        }
                    }
                    if (!bOk) {
                        System.out.println("Failed to load signature token!");
                        return bOk;
                    }
                    System.out.println("GET Cert in slot: " + nSlot + " cmd-profile: " + profile);
                    X509Certificate cert = null;
                    if (sigFac != null) {
                        cert = sigFac.getCertificate(nSlot, pin);
                    }
                    if (cert == null) {
                        System.out.println("Failed to load signers certificate!");
                        return bOk;
                    }
                    if (profile == null) {
                        profile = this.m_sdoc.getProfile();
                    }
                    if (!(profile == null || this.m_sdoc.getProfile() != null && this.m_sdoc.getProfile().equals(profile))) {
                        if (profile.equals("TM.v21")) {
                            this.m_sdoc.setProfile("TM");
                            this.m_sdoc.setVersion("2.1");
                        } else if (this.m_sdoc.getProfile() == null || this.m_sdoc.getProfile().trim().length() == 0 || this.m_sdoc.getProfile().trim().equalsIgnoreCase("BES")) {
                            this.m_sdoc.setProfile(profile);
                        }
                    }
                    Signature sig = this.m_sdoc.prepareSignature(cert, roles, adr);
                    if (profile == null || profile.trim().length() == 0 || profile.trim().equalsIgnoreCase("BES")) {
                        profile = ConfigManager.instance().getStringProperty("DIGIDOC_DEFAULT_PROFILE", "TM");
                    }
                    System.out.println("Prepare signature, cert: " + (cert != null ? "OK" : "NULL") + " status: " + bOk + " cfg-profile: " + profile + " sig-profile: " + sig.getProfile());
                    if (!(profile == null || sig.getProfile() != null && profile.startsWith(sig.getProfile()))) {
                        sig.setProfile(profile);
                        if (this.m_sdoc.getProfile() == null || this.m_sdoc.getProfile().trim().length() == 0 || this.m_sdoc.getProfile().trim().equalsIgnoreCase("BES")) {
                            this.m_sdoc.setProfile(profile);
                        }
                    }
                    if (profile != null && profile.trim().equals("TS")) {
                        System.out.println("TS profile is currently not supported!");
                        return false;
                    }
                    byte[] sidigest = null;
                    if (sigFac.getType().equals("PKCS11")) {
                        sidigest = sig.calculateSignedInfoDigest();
                    }
                    if (sigFac.getType().equals("PKCS12")) {
                        sidigest = sig.calculateSignedInfoXML();
                    }
                    System.out.println("Create signature, cert: " + (cert != null ? "OK" : "NULL") + " status: " + bOk + " sig-profile: " + sig.getProfile());
                    byte[] sigval = sidigest != null ? sigFac.sign(sidigest, nSlot, pin, sig) : null;
                    System.out.println("Finalize signature: " + sig.getId() + " profile: " + sig.getProfile() + " sig-len: " + (sigval != null ? sigval.length : 0));
                    sig.setSignatureValue(sigval);
                    sig.setHttpFrom(this.composeHttpFrom());
                    if (!sig.getProfile().trim().equals("TM") && !sig.getProfile().equals("TS") && !sig.getProfile().equals("TS-A") && !sig.getProfile().equals("T") && !sig.getProfile().equals("C-L") && !sig.getProfile().equals("TM-A")) continue;
                    sig.getConfirmation();
                }
                catch (Exception ex) {
                    bOk = false;
                    System.err.println("ERROR signing: " + ex);
                    ex.printStackTrace(System.err);
                }
                continue;
            }
            bOk = false;
            System.err.println("Missing pin of -ddoc-sign command");
        }
        return bOk;
    }

    private boolean runCalcSignCmds(String[] args) {
        boolean bOk = true;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-ddoc-calc-sign")) continue;
            String certFile = null;
            String rollReso = null;
            String country = null;
            String city = null;
            String state = null;
            String zip = null;
            String profile = null;
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                certFile = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                rollReso = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                country = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                state = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                city = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                zip = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                profile = args[i + 1];
                ++i;
            }
            if (certFile != null) {
                try {
                    if (this.m_sdoc == null) {
                        System.err.println("No signed document to calc-sign. Use -ddoc-in or -ddoc-new commands!");
                        return false;
                    }
                    String[] roles = null;
                    if (rollReso != null && rollReso.trim().length() > 0) {
                        roles = new String[]{rollReso};
                    }
                    SignatureProductionPlace adr = null;
                    if (country != null || state != null || city != null || zip != null) {
                        adr = new SignatureProductionPlace(city, state, country, zip);
                    }
                    System.out.println("Calculating signature");
                    ConfigManager cfg = ConfigManager.instance();
                    Object lerrs = null;
                    DigiDocException ex1 = this.m_sdoc.validateFormatAndVersion();
                    if (ex1 != null) {
                        System.err.println("Validation error: " + ex1 + ". Signing cancelled!");
                        return false;
                    }
                    System.out.println("GET Cert in file: " + certFile + " cmd-profile: " + profile);
                    if (profile == null) {
                        profile = this.m_sdoc.getProfile();
                    }
                    X509Certificate cert = SignedDoc.readCertificate(certFile);
                    System.out.println("Prepare signature, cert: " + (cert != null ? "OK" : "NULL") + " status: " + bOk + " container-profile: " + profile);
                    Signature sig = this.m_sdoc.prepareSignature(cert, roles, adr);
                    if (profile == null || profile.trim().length() == 0 || profile.trim().equalsIgnoreCase("BES")) {
                        profile = ConfigManager.instance().getStringProperty("DIGIDOC_DEFAULT_PROFILE", "TM");
                    }
                    System.out.println("Prepare signature, cert: " + (cert != null ? "OK" : "NULL") + " status: " + bOk + " cfg-profile: " + profile);
                    if (!(profile == null || sig.getProfile() != null && sig.getProfile().equals(profile))) {
                        sig.setProfile(profile);
                        if (this.m_sdoc.getProfile() == null || this.m_sdoc.getProfile().trim().length() == 0 || this.m_sdoc.getProfile().trim().equalsIgnoreCase("BES")) {
                            this.m_sdoc.setProfile(profile);
                        }
                    }
                    if (profile != null && profile.trim().equals("TS")) {
                        System.out.println("TS profile is currently not supported!");
                        return false;
                    }
                    byte[] sidigest = sig.calculateSignedInfoDigest();
                    if (sidigest != null) {
                        String sDigHex = ConvertUtils.bin2hex(sidigest);
                        System.out.println("SignatureHash id: " + sig.getId() + " hash: " + sDigHex);
                        continue;
                    }
                    System.err.println("ERROR: calculating signed info digest");
                }
                catch (Exception ex) {
                    bOk = false;
                    System.err.println("ERROR: calculating signature value: " + ex);
                    ex.printStackTrace(System.err);
                }
                continue;
            }
            bOk = false;
            System.err.println("Missing certFile of -ddoc-calc-sign command");
        }
        return bOk;
    }

    private boolean runAddSignValueCmds(String[] args) {
        boolean bOk = true;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-ddoc-add-sign-value")) continue;
            String signFile = null;
            String sigId = null;
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                signFile = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                sigId = args[i + 1];
                ++i;
            }
            if (signFile != null && sigId != null) {
                try {
                    if (this.m_sdoc == null) {
                        System.err.println("No signed document to calc-sign. Use -ddoc-in or -ddoc-new commands!");
                        return false;
                    }
                    byte[] bValHex = SignedDoc.readFile(new File(signFile));
                    String sValHex = new String(bValHex).trim();
                    System.out.println("Sign val: " + sValHex + " len: " + sValHex.length());
                    byte[] sigval = ConvertUtils.hex2bin(sValHex);
                    if (sigval == null || sigval.length < 128) {
                        System.err.println("Must provide at least 128 bytes rsa signature value in hex encoding!");
                        return false;
                    }
                    Signature sig = this.m_sdoc.findSignatureById(sigId);
                    if (sig == null) {
                        System.err.println("No signature found with id: " + sigId);
                        return false;
                    }
                    sig.setSignatureValue(sigval);
                    System.out.println("Getting confirmation for signature: " + sig.getId());
                    sig.getConfirmation();
                }
                catch (Exception ex) {
                    bOk = false;
                    System.err.println("ERROR: adding signature value: " + ex);
                    ex.printStackTrace(System.err);
                }
                continue;
            }
            bOk = false;
            System.err.println("Missing signFile or sigId of -ddoc-add-sign-value command");
        }
        return bOk;
    }

    private boolean runAddSignedDocCmds(String[] args) {
        boolean bOk = true;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-ddoc-add")) continue;
            String inFile = null;
            String inMime = null;
            String inContent = "EMBEDDED_BASE64";
            if (this.m_sdoc != null && this.m_sdoc.getFormat().equals("BDOC")) {
                inContent = "BINARY";
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                inFile = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                inMime = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                inContent = args[i + 1];
                ++i;
            }
            if (inFile != null && inMime != null) {
                try {
                    if (this.m_sdoc == null) {
                        System.out.println("Creating digidoc: DIGIDOC-XML, 1.3");
                        this.m_sdoc = new SignedDoc("DIGIDOC-XML", "1.3");
                    }
                    System.out.println("Adding data-file: " + inFile + ", " + inMime + ", " + inContent);
                    File f = new File(inFile);
                    if (!f.isFile() && !f.canRead()) {
                        System.err.println("File not found: " + inFile);
                        return false;
                    }
                    DataFile dataFile = this.m_sdoc.addDataFile(new File(inFile), inMime, inContent);
                }
                catch (Exception ex) {
                    bOk = false;
                    System.err.println("ERROR: adding DataFile: " + ex);
                    ex.printStackTrace(System.err);
                }
                continue;
            }
            bOk = false;
            System.err.println("Missing input file or mime type of -ddoc-add command");
        }
        return bOk;
    }

    private boolean runAddMemSignedDocCmds(String[] args) {
        boolean bOk = true;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-ddoc-add-mem")) continue;
            String inFile = null;
            String inMime = null;
            String inContent = "EMBEDDED_BASE64";
            if (this.m_sdoc != null && this.m_sdoc.getFormat().equals("BDOC")) {
                inContent = "BINARY";
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                inFile = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                inMime = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                inContent = args[i + 1];
                ++i;
            }
            if (inFile != null && inMime != null) {
                try {
                    if (this.m_sdoc == null) {
                        System.out.println("Creating digidoc: DIGIDOC-XML, 1.3");
                        this.m_sdoc = new SignedDoc("DIGIDOC-XML", "1.3");
                    }
                    System.out.println("Adding mem-data-file: " + inFile + ", " + inMime + ", " + inContent);
                    File f = new File(inFile);
                    if (!f.isFile() && !f.canRead()) {
                        System.err.println("File not found: " + inFile);
                        return false;
                    }
                    byte[] data = SignedDoc.readFile(f);
                    DataFile df = new DataFile(this.m_sdoc.getNewDataFileId(), inContent, f.getName(), inMime, this.m_sdoc);
                    df.setBody(data);
                    this.m_sdoc.addDataFile(df);
                }
                catch (Exception ex) {
                    bOk = false;
                    System.err.println("ERROR: adding DataFile: " + ex);
                    ex.printStackTrace(System.err);
                }
                continue;
            }
            bOk = false;
            System.err.println("Missing input file or mime type of -ddoc-add command");
        }
        return bOk;
    }

    private boolean isWarning(SignedDoc sdoc, DigiDocException ex) {
        return ex != null && (ex.getCode() == 173 || ex.getCode() == 177 || ex.getCode() == 178 || ex.getCode() == 129 || ex.getCode() == 176 && !sdoc.getFormat().equals("SK-XML"));
    }

    private boolean hasNonWarningErrs(SignedDoc sdoc, ArrayList lerrs) {
        for (int i = 0; lerrs != null && i < lerrs.size(); ++i) {
            DigiDocException ex = (DigiDocException)lerrs.get(i);
            if (this.isWarning(sdoc, ex)) continue;
            return true;
        }
        return false;
    }

    private boolean runValidateSignedDocCmds(String[] args) {
        boolean bFound = false;
        boolean bOk = true;
        boolean b = false;
        boolean bLibErrs = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i].equals("-ddoc-validate")) {
                bFound = true;
            }
            if (!args[i].equals("-libraryerrors")) continue;
            bLibErrs = true;
        }
        if (bFound) {
            if (this.m_sdoc != null) {
                int i;
                System.out.println("Validating DigiDoc document: " + this.m_sdoc.getFormat() + "/" + this.m_sdoc.getVersion() + " profile: " + this.m_sdoc.getProfile());
                ArrayList lerrs = this.m_sdoc.verify(true, true);
                if (lerrs.size() > 0) {
                    this.printErrsAndWarnings(this.m_sdoc, lerrs, bLibErrs);
                }
                if (SignedDoc.hasFatalErrs(lerrs)) {
                    return false;
                }
                bOk = !this.hasNonWarningErrs(this.m_sdoc, lerrs);
                for (i = 0; i < this.m_sdoc.countDataFiles(); ++i) {
                    DataFile df = this.m_sdoc.getDataFile(i);
                    System.out.println("\tDataFile: " + df.getId() + " file: " + df.getFileName() + " mime: " + df.getMimeType() + " size: " + df.getSize());
                    ArrayList lerrs1 = new ArrayList();
                    lerrs1 = df.validate(true);
                    if (lerrs1.size() <= 0) continue;
                    this.printErrsAndWarnings(this.m_sdoc, lerrs1, bLibErrs);
                }
                for (i = 0; i < this.m_sdoc.countSignatures(); ++i) {
                    Signature sig = this.m_sdoc.getSignature(i);
                    System.out.println("\tSignature: " + sig.getId() + " profile: " + sig.getProfile());
                    KeyInfo keyInfo = this.m_sdoc.getSignature(i).getKeyInfo();
                    String userId = null;
                    String firstName = null;
                    String familyName = null;
                    String cn = null;
                    if (keyInfo != null) {
                        userId = keyInfo.getSubjectPersonalCode();
                        firstName = keyInfo.getSubjectFirstName();
                        familyName = keyInfo.getSubjectLastName();
                        if (keyInfo.getSignersCertificate() != null) {
                            cn = SignedDoc.getCommonName(keyInfo.getSignersCertificate().getSubjectDN().getName());
                        }
                    }
                    ArrayList<DigiDocException> lerrs1 = new ArrayList<DigiDocException>();
                    b = sig.verify(this.m_sdoc, lerrs1);
                    X509Certificate cert = null;
                    CertValue cv = sig.getCertValueOfType(1);
                    if (cv != null) {
                        cert = cv.getCert();
                    }
                    if (cv != null && DigiDocGenFactory.isTestCard(cert)) {
                        lerrs1.add(new DigiDocException(178, "Test signature!", null));
                    }
                    DigiDocVerifyFactory.verifySignatureFromLiveAndOcspFromTest(sig, lerrs1);
                    System.out.print("\tSignature: " + sig.getId() + " profile: " + sig.getProfile() + " - ");
                    System.out.print(cn);
                    if (!b && this.hasNonWarningErrs(this.m_sdoc, lerrs1)) {
                        System.out.println(" --> ERROR");
                    } else {
                        System.out.println(" --> OK");
                    }
                    this.printErrsAndWarnings(this.m_sdoc, lerrs1, bLibErrs);
                }
            } else {
                return false;
            }
        }
        return bOk;
    }

    private boolean runNotarizeSignedDocCmds(String[] args) {
        int i;
        boolean bFound = false;
        for (i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-ddoc-notarize")) continue;
            bFound = true;
            break;
        }
        if (bFound) {
            if (this.m_sdoc != null) {
                System.out.println("Notarizing digidoc: ");
                for (i = 0; i < this.m_sdoc.countSignatures(); ++i) {
                    Signature sig = this.m_sdoc.getSignature(i);
                    System.out.print("\tSignature: " + sig.getId() + " - ");
                    KeyInfo keyInfo = this.m_sdoc.getSignature(i).getKeyInfo();
                    String userId = keyInfo.getSubjectPersonalCode();
                    String firstName = keyInfo.getSubjectFirstName();
                    String familyName = keyInfo.getSubjectLastName();
                    System.out.println(userId + "," + firstName + "," + familyName);
                    try {
                        sig.getConfirmation();
                    }
                    catch (DigiDocException ex) {
                        System.out.println("ERROR: getting confirmation for: " + sig.getId() + " - " + ex);
                    }
                    ArrayList errs = sig.verify(this.m_sdoc, false, true);
                    if (errs.size() == 0) {
                        System.out.println(" --> OK");
                    } else {
                        System.out.println(" --> ERROR");
                    }
                    for (int j = 0; j < errs.size(); ++j) {
                        System.out.println("\t\t" + (DigiDocException)errs.get(i));
                    }
                }
            } else {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runExtractDataFileCmds(String[] args) {
        int i;
        boolean bFound = false;
        String dfId = null;
        String dfName = null;
        FileOutputStream fos = null;
        InputStream is = null;
        for (i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-ddoc-extract")) continue;
            dfId = args[i + 1];
            dfName = args[i + 2];
            break;
        }
        if (this.m_sdoc != null && dfId != null && dfName != null) {
            System.out.println("Search DF: " + dfId);
            bFound = false;
            for (i = 0; i < this.m_sdoc.countDataFiles(); ++i) {
                DataFile df = this.m_sdoc.getDataFile(i);
                System.out.println("DF: " + i + " - " + df.getId());
                if (!df.getId().equals(dfId)) continue;
                try {
                    System.out.println("Extracting DF: " + dfId + " to: " + dfName);
                    fos = new FileOutputStream(dfName);
                    is = df.getBodyAsStream();
                    if (is == null) {
                        System.err.println("DataFile has no data!");
                        boolean bl = false;
                        return bl;
                    }
                    byte[] data = new byte[4096];
                    int n = 0;
                    int m = 0;
                    while ((n = is.read(data)) > 0) {
                        fos.write(data, 0, n);
                        m += n;
                    }
                    fos.close();
                    fos = null;
                    is.close();
                    is = null;
                    bFound = true;
                    System.out.println("Wrote: " + m + " bytes to: " + dfName);
                    continue;
                }
                catch (Exception ex) {
                    System.err.println("ERROR: extracting df: " + dfId + " - " + ex);
                    continue;
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (Exception ex2) {
                        System.err.println("ERROR closing streams: " + ex2);
                    }
                }
            }
            if (!bFound) {
                System.err.println("No datafile found: " + dfId);
            }
        }
        return true;
    }

    private boolean runRmvSigCmds(String[] args) {
        int i;
        boolean bFound = false;
        String sigId = null;
        for (i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-ddoc-rm-sig")) continue;
            sigId = args[i + 1];
            break;
        }
        if (this.m_sdoc != null && sigId != null) {
            System.out.println("Remove signature: " + sigId);
            bFound = false;
            for (i = 0; i < this.m_sdoc.countSignatures(); ++i) {
                Signature sig = this.m_sdoc.getSignature(i);
                if (!sig.getId().equals(sigId)) continue;
                try {
                    System.out.println("Removing signature: " + sigId);
                    this.m_sdoc.removeSignature(i);
                    bFound = true;
                    continue;
                }
                catch (Exception ex) {
                    System.err.println("ERROR: removing signature: " + sigId + " - " + ex);
                }
            }
            if (!bFound) {
                System.err.println("No signature found: " + sigId);
                return false;
            }
        }
        return true;
    }

    private boolean runRmvDfCmds(String[] args) {
        int i;
        boolean bFound = false;
        String dfId = null;
        for (i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-ddoc-rm-df")) continue;
            dfId = args[i + 1];
            break;
        }
        if (this.m_sdoc != null && dfId != null) {
            System.out.println("Remove data-file: " + dfId);
            bFound = false;
            for (i = 0; i < this.m_sdoc.countDataFiles(); ++i) {
                DataFile df = this.m_sdoc.getDataFile(i);
                System.out.println("DF: " + i + " - " + df.getId());
                if (!df.getId().equals(dfId)) continue;
                try {
                    this.m_sdoc.removeDataFile(i);
                    bFound = true;
                    continue;
                }
                catch (Exception ex) {
                    System.err.println("ERROR: removing data-file: " + dfId + " - " + ex);
                }
            }
            if (!bFound) {
                System.err.println("No data-file found: " + dfId);
                return false;
            }
        }
        return true;
    }

    private boolean runListEncryptedDataCmds(String[] args) {
        boolean bFound = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-cdoc-list")) continue;
            bFound = true;
            break;
        }
        if (bFound) {
            if (this.m_cdoc != null) {
                int i;
                System.out.println("Encrypted document: ");
                System.out.print("\tEncryptedData ");
                if (this.m_cdoc.getId() != null) {
                    System.out.print(" Id: " + this.m_cdoc.getId());
                }
                if (this.m_cdoc.getType() != null) {
                    System.out.print(" type: " + this.m_cdoc.getType());
                }
                if (this.m_cdoc.getMimeType() != null) {
                    System.out.print(" mime: " + this.m_cdoc.getMimeType());
                }
                if (this.m_cdoc.getEncryptionMethod() != null) {
                    System.out.print(" algorithm: " + this.m_cdoc.getEncryptionMethod());
                }
                System.out.println();
                System.out.println("\tFORMAT: " + this.m_cdoc.getPropFormatName() + " VER: " + this.m_cdoc.getPropFormatVersion());
                System.out.println("\tLIBRARY: " + this.m_cdoc.getPropLibraryName() + " VER: " + this.m_cdoc.getPropLibraryVersion());
                int nFiles = this.m_cdoc.getPropOrigFileCount();
                for (i = 0; i < nFiles; ++i) {
                    System.out.println("\tDF: " + this.m_cdoc.getPropOrigFileId(i) + " FILE: " + this.m_cdoc.getPropOrigFileName(i) + " SIZE: " + this.m_cdoc.getPropOrigFileSize(i) + " MIME: " + this.m_cdoc.getPropOrigFileMime(i));
                }
                for (i = 0; i < this.m_cdoc.getNumKeys(); ++i) {
                    EncryptedKey ekey = this.m_cdoc.getEncryptedKey(i);
                    System.out.print("\tEncryptedKey");
                    if (ekey.getId() != null) {
                        System.out.print(" Id: " + ekey.getId());
                    }
                    if (ekey.getRecipient() != null) {
                        System.out.print(" Recipient: " + ekey.getRecipient());
                    }
                    if (ekey.getKeyName() != null) {
                        System.out.print(" key-name: " + ekey.getKeyName());
                    }
                    if (ekey.getCarriedKeyName() != null) {
                        System.out.print(" carried-key-name: " + ekey.getCarriedKeyName());
                    }
                    if (ekey.getEncryptionMethod() != null) {
                        System.out.print("\n\t\talgorithm: " + ekey.getEncryptionMethod());
                    }
                    if (ekey.getRecipientsCertificate() != null) {
                        System.out.print("\n\t\tCERT: " + ekey.getRecipientsCertificate().getSubjectDN().getName());
                    }
                    System.out.println();
                }
                System.out.print("\tEncryptionProperties");
                if (this.m_cdoc.getEncryptionPropertiesId() != null) {
                    System.out.print(" Id: " + this.m_cdoc.getEncryptionPropertiesId());
                }
                System.out.println();
                for (i = 0; i < this.m_cdoc.getNumProperties(); ++i) {
                    EncryptionProperty eprop = this.m_cdoc.getProperty(i);
                    System.out.print("\t\tEncryptionProperty");
                    if (eprop != null) {
                        if (eprop.getId() != null) {
                            System.out.print(" Id: " + eprop.getId());
                        }
                        if (eprop.getTarget() != null) {
                            System.out.print(" Target: " + eprop.getTarget());
                        }
                        if (eprop.getName() != null) {
                            System.out.print(" Name: " + eprop.getName());
                        }
                        if (eprop.getContent() != null) {
                            System.out.print(" --> " + eprop.getContent());
                        }
                    }
                    System.out.println();
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean runValidateEncryptedDataCmds(String[] args) {
        boolean bFound = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-cdoc-validate")) continue;
            bFound = true;
            break;
        }
        if (bFound) {
            if (this.m_cdoc != null) {
                System.out.println("Validating Encrypted document: ");
                ArrayList errs = this.m_cdoc.validate();
                if (errs.size() == 0) {
                    System.out.println(" --> OK");
                } else {
                    System.out.println(" --> ERROR");
                }
                for (int j = 0; j < errs.size(); ++j) {
                    System.out.println("\t\t" + (DigiDocException)errs.get(j));
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean runCheckCertCmds(String[] args) {
        boolean bOk = true;
        String inFile = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-check-cert")) continue;
            if (i < args.length - 1) {
                inFile = args[i + 1];
                break;
            }
            bOk = false;
        }
        if (bOk && inFile != null) {
            System.out.println("Reading certificate file: " + inFile);
            try {
                NotaryFactory notFac = ConfigManager.instance().getNotaryFactory();
                X509Certificate cert = SignedDoc.readCertificate(new File(inFile));
                notFac.checkCertificate(cert);
                System.out.println("Certificate is OK");
                bOk = true;
            }
            catch (Exception ex) {
                bOk = false;
                System.err.println("ERROR: checking certificate: " + inFile + " - " + ex);
                ex.printStackTrace(System.err);
            }
        }
        return bOk;
    }

    private void printErrsAndWarnings(SignedDoc sdoc, ArrayList lerrs, boolean bLibErrs) {
        DigiDocException err;
        int i;
        for (i = 0; i < lerrs.size(); ++i) {
            err = (DigiDocException)lerrs.get(i);
            if (this.isWarning(this.m_sdoc, err)) continue;
            System.err.println("ERROR: " + err.getCode() + " - " + err.getMessage());
        }
        for (i = 0; i < lerrs.size(); ++i) {
            err = (DigiDocException)lerrs.get(i);
            if (!this.isWarning(this.m_sdoc, err)) continue;
            System.err.println("WARNING: " + err.getCode() + " - " + err.getMessage());
        }
        if (bLibErrs) {
            for (i = 0; i < lerrs.size(); ++i) {
                err = (DigiDocException)lerrs.get(i);
                if (err.getCode() == 178) continue;
                System.err.println("LIBRARY-ERROR: " + err.getCode() + " - " + err.getMessage());
            }
        }
    }

    private boolean runReadSignedDocCmds(String[] args, ArrayList lerr) {
        int i;
        boolean bOk = true;
        boolean bStream = false;
        boolean bOStream = false;
        boolean bLibErrs = false;
        boolean bFatal = false;
        String inFile = null;
        for (i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-libraryerrors")) continue;
            bLibErrs = true;
        }
        for (i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-ddoc-in") && !args[i].equals("-ddoc-in-stream") && !args[i].equals("-ddoc-in-ostream")) continue;
            if (args[i].equals("-ddoc-in-stream")) {
                bStream = true;
            }
            if (args[i].equals("-ddoc-in-ostream")) {
                bOStream = true;
            }
            if (i < args.length - 1) {
                this.sFilIn = inFile = args[i + 1];
                break;
            }
            bOk = false;
        }
        if (bOk && inFile != null) {
            System.out.println("Reading digidoc file: " + inFile);
            DigiDocFactory digFac = null;
            try {
                if (bOStream) {
                    ObjectInputStream ois = new ObjectInputStream(new FileInputStream(inFile));
                    this.m_sdoc = (SignedDoc)ois.readObject();
                    bOk = true;
                    ois.close();
                } else if (bStream) {
                    SAXDigiDocFactory saxFac = new SAXDigiDocFactory();
                    this.m_sdoc = saxFac.readSignedDocFromStreamOfType(new FileInputStream(inFile), saxFac.isBdocExtension(inFile), lerr);
                    bOk = !this.hasNonWarningErrs(this.m_sdoc, lerr);
                    this.printErrsAndWarnings(this.m_sdoc, lerr, bLibErrs);
                } else {
                    digFac = ConfigManager.instance().getDigiDocFactory();
                    this.m_sdoc = digFac.readSignedDocOfType(inFile, digFac.isBdocExtension(inFile), lerr);
                    bOk = !this.hasNonWarningErrs(this.m_sdoc, lerr);
                    this.printErrsAndWarnings(this.m_sdoc, lerr, bLibErrs);
                }
                if (this.m_sdoc != null && this.m_sdoc.getFormat() != null && this.m_sdoc.getVersion() != null && (this.m_sdoc.getFormat().equals("SK-XML") || this.m_sdoc.getFormat().equals("DIGIDOC-XML") && (this.m_sdoc.getVersion().equals("1.1") || this.m_sdoc.getVersion().equals("1.2")))) {
                    this.printErrsAndWarnings(this.m_sdoc, lerr, bLibErrs);
                }
            }
            catch (Exception ex) {
                DigiDocException dex;
                boolean bHasSigValCmd = false;
                if (ex instanceof DigiDocException && (dex = (DigiDocException)ex).getCode() == 37) {
                    for (int i2 = 0; args != null && i2 < args.length; ++i2) {
                        if (!args[i2].equals("-ddoc-add-sign-value")) continue;
                        bHasSigValCmd = true;
                        break;
                    }
                }
                if (!bHasSigValCmd) {
                    bOk = false;
                    System.err.println("ERROR: reading digidoc: " + inFile + " - " + ex);
                    ex.printStackTrace(System.err);
                }
                System.err.println("Signature with no signature value read in input");
                bOk = true;
            }
        }
        return bOk;
    }

    private boolean runReadEncryptedDataCmds(String[] args) {
        boolean bOk = true;
        String inFile = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-cdoc-in")) continue;
            if (i < args.length - 2) {
                this.sFilIn = inFile = args[i + 1];
                break;
            }
            bOk = false;
        }
        if (bOk && inFile != null) {
            System.out.println("Reading encrypted file: " + inFile);
            try {
                EncryptedDataParser dencFac = ConfigManager.instance().getEncryptedDataParser();
                this.m_cdoc = dencFac.readEncryptedData(inFile);
                bOk = true;
            }
            catch (Exception ex) {
                bOk = false;
                System.err.println("ERROR: reading encrypted file: " + inFile + " - " + ex);
                ex.printStackTrace(System.err);
            }
        }
        return bOk;
    }

    private boolean runEncryptEncryptedDataCmds(String[] args) {
        boolean bOk = true;
        boolean bFound = false;
        String inFile = null;
        String outFile = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-cdoc-encrypt")) continue;
            bFound = true;
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                inFile = args[i + 1];
                ++i;
            }
            if (i >= args.length - 1 || args[i + 1].startsWith("-")) continue;
            outFile = args[i + 1];
            ++i;
        }
        if (bFound) {
            if (outFile != null && inFile != null) {
                System.out.println("Encrypting file: " + inFile + " to: " + outFile);
                bOk = this.m_cdoc.encryptFileData(inFile, outFile);
            } else {
                bOk = false;
                System.err.println("Missing input file or output file of the -cdoc-encrypt command");
            }
        }
        return bOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runEncryptEncryptedDataSKCmds(String[] args) {
        boolean bOk = true;
        boolean bFound = false;
        String inFile = null;
        String outFile = null;
        FileOutputStream fos = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-cdoc-encrypt-sk")) continue;
            bFound = true;
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                inFile = args[i + 1];
                ++i;
            }
            if (i >= args.length - 1 || args[i + 1].startsWith("-")) continue;
            outFile = args[i + 1];
            ++i;
        }
        if (bFound) {
            if (outFile != null && inFile != null) {
                System.out.println("Encrypting file: " + inFile + " to: " + outFile);
                try {
                    File fIn = new File(inFile);
                    this.m_sdoc = new SignedDoc("DIGIDOC-XML", "1.3");
                    DataFile df = this.m_sdoc.addDataFile(new File(inFile), SignedDoc.xmlns_digidoc13, "EMBEDDED_BASE64");
                    byte[] data = SignedDoc.readFile(new File(inFile));
                    df.setBase64Body(data);
                    byte[] inData = this.m_sdoc.toXML().getBytes("UTF-8");
                    this.m_cdoc.setData(inData);
                    this.m_cdoc.setDataStatus(1);
                    this.m_cdoc.addProperty("Filename", inFile + ".ddoc");
                    this.m_cdoc.setMimeType("http://www.sk.ee/DigiDoc/v1.3.0/digidoc.xsd");
                    StringBuffer sb = new StringBuffer();
                    sb.append(fIn.getName());
                    sb.append("|");
                    sb.append(new Long(fIn.length()).toString());
                    sb.append("|");
                    sb.append("application/unknown|");
                    sb.append(df.getId());
                    this.m_cdoc.addProperty("orig_file", sb.toString());
                    this.m_cdoc.addProperty("OriginalSize", new Long(data.length).toString());
                    this.m_cdoc.encrypt(1);
                    fos = new FileOutputStream(outFile);
                    fos.write(this.m_cdoc.toXML());
                    fos.close();
                    fos = null;
                    bOk = true;
                }
                catch (Exception ex) {
                    bOk = false;
                    System.err.println("ERROR: encrypting file: " + inFile + " - " + ex);
                    ex.printStackTrace(System.err);
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception ex2) {
                            System.err.println("Error closing streams: " + ex2);
                        }
                    }
                }
            } else {
                bOk = false;
                System.err.println("Missing input file or output file of the -cdoc-encrypt command");
            }
        }
        return bOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runDecryptEncryptedDataCmds(String[] args) {
        boolean bOk = true;
        boolean bFound = false;
        boolean bExtract = false;
        String pin = null;
        String outFile = null;
        String keystoreFile = null;
        String sImpl = "PKCS11";
        FileOutputStream fos = null;
        InputStream is = null;
        int nSlot = 0;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-cdoc-decrypt") && !args[i].equals("-cdoc-decrypt-sk")) continue;
            if (args[i].equals("-cdoc-decrypt-sk")) {
                bExtract = true;
            }
            bFound = true;
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                pin = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                outFile = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                nSlot = Integer.parseInt(args[i + 1]);
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                sImpl = args[i + 1];
                ++i;
            }
            if (i >= args.length - 1 || args[i + 1].startsWith("-")) continue;
            keystoreFile = args[i + 1];
            ++i;
        }
        if (bFound) {
            if (pin != null && outFile != null) {
                System.out.println("Decrypting to: " + outFile);
                try {
                    ConfigManager cfg = ConfigManager.instance();
                    SignatureFactory sigFac = cfg.getSignatureFactoryOfType(sImpl);
                    if (sigFac == null) {
                        System.err.println("No signature factory of type: " + sImpl);
                        boolean bl = false;
                        return bl;
                    }
                    if (sigFac.getType().equals("PKCS12")) {
                        Pkcs12SignatureFactory p12sfac = (Pkcs12SignatureFactory)sigFac;
                        bOk = p12sfac.load(keystoreFile, "PKCS12", pin);
                    }
                    if (!bOk) {
                        System.out.println("Failed to load signature token!");
                        boolean p12sfac = bOk;
                        return p12sfac;
                    }
                    X509Certificate cert = sigFac.getAuthCertificate(nSlot, pin);
                    int nIdx = this.m_cdoc.getRecvIndex(cert);
                    if (nIdx < 0) {
                        System.err.println("No decryption key found on smartcard to decrypt this file!");
                        boolean bl = false;
                        return bl;
                    }
                    this.m_cdoc.decrypt(sImpl, keystoreFile, nIdx, nSlot, pin);
                    if (bExtract) {
                        fos = new FileOutputStream(outFile);
                        fos.write(this.m_cdoc.getData());
                        fos.close();
                        fos = null;
                        DigiDocFactory digFac = ConfigManager.instance().getDigiDocFactory();
                        this.m_sdoc = digFac.readSignedDoc(outFile);
                        DataFile df = this.m_sdoc.getDataFile(0);
                        fos = new FileOutputStream(outFile);
                        is = df.getBodyAsStream();
                        if (is == null) {
                            System.err.println("DataFile has no data!");
                            boolean bl = false;
                            return bl;
                        }
                        byte[] data = new byte[4096];
                        int n = 0;
                        int m = 0;
                        while ((n = is.read(data)) > 0) {
                            fos.write(data, 0, n);
                            m += n;
                        }
                        fos.close();
                        fos = null;
                        is.close();
                        is = null;
                    } else {
                        fos = new FileOutputStream(outFile);
                        fos.write(this.m_cdoc.getData());
                        fos.close();
                        fos = null;
                    }
                    bOk = true;
                }
                catch (Exception ex) {
                    bOk = false;
                    System.err.println("ERROR: decrypting file: " + ex);
                    ex.printStackTrace(System.err);
                }
                finally {
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (Exception ex2) {
                        System.err.println("Error closing streams: " + ex2);
                    }
                }
            } else {
                bOk = false;
                System.err.println("Missing pin or output file of the -cdoc-decrypt command");
            }
        }
        return bOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runDecryptEncryptedDataPkcs12Cmds(String[] args) {
        boolean bOk = true;
        boolean bFound = false;
        boolean bExtract = false;
        String outFile = null;
        String keystoreFile = null;
        String keystorePasswd = null;
        String keystoreType = "JKS";
        FileOutputStream fos = null;
        InputStream is = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-cdoc-decrypt-pkcs12") && !args[i].equals("-cdoc-decrypt-pkcs12-sk")) continue;
            if (args[i].equals("-cdoc-decrypt-pkcs12-sk")) {
                bExtract = true;
            }
            bFound = true;
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                keystoreFile = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                keystorePasswd = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                keystoreType = args[i + 1];
                ++i;
            }
            if (i >= args.length - 1 || args[i + 1].startsWith("-")) continue;
            outFile = args[i + 1];
            ++i;
        }
        if (bFound) {
            if (keystoreFile != null && keystorePasswd != null && outFile != null) {
                System.out.println("Decrypting to: " + outFile);
                try {
                    int nKey = -1;
                    try {
                        System.out.println("Load keystore: " + keystoreFile + " pwd: " + keystorePasswd);
                        Pkcs12SignatureFactory p12fac = new Pkcs12SignatureFactory();
                        p12fac.init();
                        p12fac.load(keystoreFile, keystoreType, keystorePasswd);
                        X509Certificate cert = p12fac.getAuthCertificate(0, keystorePasswd);
                        System.out.println("Cert: " + (cert != null ? cert.getSubjectDN().getName() : "NULL"));
                        nKey = this.m_cdoc.getRecvIndex(cert);
                        System.out.println("Using recipient: " + nKey);
                    }
                    catch (Exception ex) {
                        System.err.println("ERROR: finding cdoc recipient: " + ex);
                    }
                    this.m_cdoc.decryptPkcs12(nKey, keystoreFile, keystorePasswd, keystoreType);
                    if (bExtract) {
                        fos = new FileOutputStream(outFile);
                        fos.write(this.m_cdoc.getData());
                        fos.close();
                        fos = null;
                        DigiDocFactory digFac = ConfigManager.instance().getDigiDocFactory();
                        this.m_sdoc = digFac.readSignedDoc(outFile);
                        DataFile df = this.m_sdoc.getDataFile(0);
                        fos = new FileOutputStream(outFile);
                        is = df.getBodyAsStream();
                        if (is == null) {
                            System.err.println("DataFile has no data!");
                            boolean bl = false;
                            return bl;
                        }
                        byte[] data = new byte[4096];
                        int n = 0;
                        int m = 0;
                        while ((n = is.read(data)) > 0) {
                            fos.write(data, 0, n);
                            m += n;
                        }
                        fos.close();
                        fos = null;
                        is.close();
                        is = null;
                    } else {
                        fos = new FileOutputStream(outFile);
                        fos.write(this.m_cdoc.getData());
                        fos.close();
                        fos = null;
                    }
                    bOk = true;
                }
                catch (Exception ex) {
                    bOk = false;
                    System.err.println("ERROR: decrypting file: " + ex);
                    ex.printStackTrace(System.err);
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (Exception ex2) {
                        System.err.println("ERROR: closing file streams - " + ex2);
                    }
                }
            } else {
                bOk = false;
                System.err.println("Missing keystore file, password or output file of the -cdoc-decrypt-pkcs12 command");
            }
        }
        return bOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runDecryptEncryptedDataPkcs12StreamCmds(String[] args) {
        boolean bOk = true;
        boolean bFound = false;
        boolean bExtract = false;
        String inFile = null;
        String outFile = null;
        String keystoreFile = null;
        String keystorePasswd = null;
        String keystoreType = "JKS";
        String recipient = null;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        InputStream is = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-cdoc-decrypt-pkcs12-stream") && !args[i].equals("-cdoc-decrypt-pkcs12-stream-sk")) continue;
            if (args[i].equals("-cdoc-decrypt-pkcs12-stream-sk")) {
                bExtract = true;
            }
            bFound = true;
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                inFile = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                keystoreFile = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                keystorePasswd = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                keystoreType = args[i + 1];
                ++i;
            }
            if (i >= args.length - 1 || args[i + 1].startsWith("-")) continue;
            outFile = args[i + 1];
            ++i;
        }
        if (bFound) {
            if (keystoreFile != null && keystorePasswd != null && outFile != null && inFile != null) {
                try {
                    System.out.println("Decrypting: " + inFile + " to: " + outFile + " recv: " + recipient);
                    try {
                        fis = new FileInputStream(inFile);
                        fos = new FileOutputStream(outFile);
                        EncryptedStreamParser streamParser = ConfigManager.instance().getEncryptedStreamParser();
                        streamParser.decryptStreamUsingTokenType(fis, fos, 0, keystorePasswd, "PKCS12", keystoreFile);
                        fos.close();
                        fos = null;
                        fis.close();
                        fis = null;
                        bOk = true;
                    }
                    catch (Exception ex) {
                        bOk = false;
                        System.err.println("ERROR: decrypting file: " + ex);
                        ex.printStackTrace(System.err);
                    }
                    if (bExtract) {
                        DigiDocFactory digFac = ConfigManager.instance().getDigiDocFactory();
                        this.m_sdoc = digFac.readSignedDoc(outFile);
                        DataFile df = this.m_sdoc.getDataFile(0);
                        fos = new FileOutputStream(outFile);
                        is = df.getBodyAsStream();
                        if (is == null) {
                            System.err.println("DataFile has no data!");
                            boolean bl = false;
                            return bl;
                        }
                        byte[] data = new byte[4096];
                        int n = 0;
                        int m = 0;
                        while ((n = is.read(data)) > 0) {
                            fos.write(data, 0, n);
                            m += n;
                        }
                        fos.close();
                        fos = null;
                        is.close();
                        is = null;
                    }
                    bOk = true;
                }
                catch (Exception ex) {
                    bOk = false;
                    System.err.println("ERROR: decrypting file: " + ex);
                    ex.printStackTrace(System.err);
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (Exception ex2) {
                        System.err.println("ERROR: closing file streams - " + ex2);
                    }
                }
            } else {
                bOk = false;
                System.err.println("Missing keystore file, password or output file of the -cdoc-decrypt-pkcs12-stream command");
            }
        }
        return bOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runDecryptEncryptedStreamCmds(String[] args) {
        boolean bOk = true;
        boolean bFound = false;
        String pin = null;
        String outFile = null;
        String inFile = null;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-cdoc-decrypt-stream")) continue;
            bFound = true;
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                inFile = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                pin = args[i + 1];
                ++i;
            }
            if (i >= args.length - 1 || args[i + 1].startsWith("-")) continue;
            outFile = args[i + 1];
            ++i;
        }
        if (bFound) {
            if (pin != null && outFile != null && inFile != null) {
                System.out.println("Decrypting: " + inFile + " to: " + outFile);
                try {
                    fis = new FileInputStream(inFile);
                    fos = new FileOutputStream(outFile);
                    EncryptedStreamParser streamParser = ConfigManager.instance().getEncryptedStreamParser();
                    streamParser.decryptStreamUsingTokenType(fis, fos, 0, pin, "PKCS11", null);
                    fos.close();
                    fos = null;
                    fis.close();
                    fis = null;
                    bOk = true;
                }
                catch (Exception ex) {
                    bOk = false;
                    System.err.println("ERROR: decrypting file: " + ex);
                    ex.printStackTrace(System.err);
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (Exception ex2) {
                        System.err.println("ERROR: closing file streams - " + ex2);
                    }
                }
            } else {
                bOk = false;
                System.err.println("Missing input file, recipient name, pin or output file of the -cdoc-decrypt-stream command");
            }
        }
        return bOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runDecryptEncryptedStreamRecvCmds(String[] args) {
        boolean bOk = true;
        boolean bFound = false;
        String pin = null;
        String outFile = null;
        String inFile = null;
        String recv = null;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-cdoc-decrypt-stream-recv")) continue;
            bFound = true;
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                inFile = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                pin = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                outFile = args[i + 1];
                ++i;
            }
            if (i >= args.length - 1 || args[i + 1].startsWith("-")) continue;
            recv = args[i + 1];
            ++i;
        }
        if (bFound) {
            if (pin != null && outFile != null && inFile != null && recv != null) {
                System.out.println("Decrypting: " + inFile + " to: " + outFile);
                try {
                    fis = new FileInputStream(inFile);
                    fos = new FileOutputStream(outFile);
                    EncryptedStreamParser streamParser = ConfigManager.instance().getEncryptedStreamParser();
                    streamParser.decryptStreamUsingRecipientName(fis, fos, 0, pin, recv);
                    fos.close();
                    fos = null;
                    fis.close();
                    fis = null;
                    bOk = true;
                }
                catch (Exception ex) {
                    bOk = false;
                    System.err.println("ERROR: decrypting file: " + ex);
                    ex.printStackTrace(System.err);
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (Exception ex2) {
                        System.err.println("ERROR: closing file streams - " + ex2);
                    }
                }
            } else {
                bOk = false;
                System.err.println("Missing input file, recipient name, pin or output file of the -cdoc-decrypt-stream command");
            }
        }
        return bOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runDecryptEncryptedStreamSlotAndLabelCmds(String[] args) {
        boolean bOk = true;
        boolean bFound = false;
        String pin = null;
        String outFile = null;
        String inFile = null;
        String slot = null;
        String label = null;
        int nSlot = 0;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-cdoc-decrypt-stream-slot-label")) continue;
            bFound = true;
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                inFile = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                pin = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                outFile = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                slot = args[i + 1];
                if (slot != null && slot.length() > 0) {
                    nSlot = Integer.parseInt(slot);
                }
                ++i;
            }
            if (i >= args.length - 1 || args[i + 1].startsWith("-")) continue;
            label = args[i + 1];
            ++i;
        }
        if (bFound) {
            if (pin != null && outFile != null && inFile != null && label != null && nSlot > 0) {
                System.out.println("Decrypting: " + inFile + " to: " + outFile);
                try {
                    fis = new FileInputStream(inFile);
                    fos = new FileOutputStream(outFile);
                    EncryptedStreamParser streamParser = ConfigManager.instance().getEncryptedStreamParser();
                    streamParser.decryptStreamUsingRecipientSlotIdAndTokenLabel(fis, fos, nSlot, label, pin);
                    fos.close();
                    fos = null;
                    fis.close();
                    fis = null;
                    bOk = true;
                }
                catch (Exception ex) {
                    bOk = false;
                    System.err.println("ERROR: decrypting file: " + ex);
                    ex.printStackTrace(System.err);
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (Exception ex2) {
                        System.err.println("ERROR: closing file streams - " + ex2);
                    }
                }
            } else {
                bOk = false;
                System.err.println("Missing input file, recipient name, pin or output file of the -cdoc-decrypt-stream command");
            }
        }
        return bOk;
    }

    private boolean runEncryptStreamCmds(String[] args) {
        boolean bOk = true;
        boolean bFound = false;
        String inFile = null;
        String outFile = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-cdoc-encrypt-stream")) continue;
            bFound = true;
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                inFile = args[i + 1];
                ++i;
            }
            if (i >= args.length - 1 || args[i + 1].startsWith("-")) continue;
            outFile = args[i + 1];
            ++i;
        }
        if (bFound) {
            if (outFile != null && inFile != null) {
                System.out.println("Encrypting file: " + inFile + " to: " + outFile);
                try {
                    File fin = new File(inFile);
                    this.m_cdoc.addProperty("Filename", inFile);
                    if (inFile.endsWith(".bdoc") || inFile.endsWith(".asice")) {
                        this.m_cdoc.setMimeType("application/vnd.etsi.asic-e+zip");
                    }
                    this.m_cdoc.encryptStream(new FileInputStream(inFile), new FileOutputStream(outFile), 1);
                    bOk = true;
                }
                catch (Exception ex) {
                    bOk = false;
                    System.err.println("ERROR: encrypting file: " + inFile + " - " + ex);
                    ex.printStackTrace(System.err);
                }
            } else {
                bOk = false;
                System.err.println("Missing input file or output file of the -cdoc-encrypt-stream command");
            }
        }
        return bOk;
    }

    private boolean runAddRecipientsCmds(String[] args) {
        boolean bOk = true;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-cdoc-recipient")) continue;
            String certFile = null;
            String recipient = null;
            String keyName = null;
            String carriedKeyName = null;
            String sId = null;
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                certFile = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                recipient = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                keyName = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                carriedKeyName = args[i + 1];
                ++i;
            }
            if (certFile != null) {
                try {
                    if (this.m_cdoc == null) {
                        System.out.println("Creating encrypted document");
                        this.m_cdoc = new EncryptedData(null, null, null, "http://www.w3.org/2001/04/xmlenc#", "http://www.w3.org/2001/04/xmlenc#aes128-cbc");
                    }
                    System.out.println("Adding recipient: " + certFile + ", " + recipient + ", " + keyName + ", " + carriedKeyName);
                    X509Certificate recvCert = SignedDoc.readCertificate(new File(certFile));
                    if (recvCert != null && recipient == null) {
                        recipient = SignedDoc.getCommonName(recvCert.getSubjectDN().getName());
                    }
                    if (sId == null) {
                        int n = this.m_cdoc.getNumKeys() + 1;
                        sId = "ID" + n;
                    }
                    EncryptedKey ekey = new EncryptedKey(sId, recipient, "http://www.w3.org/2001/04/xmlenc#rsa-1_5", keyName, carriedKeyName, recvCert);
                    this.m_cdoc.addEncryptedKey(ekey);
                }
                catch (Exception ex) {
                    bOk = false;
                    System.err.println("ERROR: adding EncryptedKey: " + ex);
                    ex.printStackTrace(System.err);
                }
                continue;
            }
            bOk = false;
            System.err.println("Missing certificate file of -cdoc-recipient command");
        }
        return bOk;
    }

    private boolean runHelpCmds(String[] args) {
        boolean bOk = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-?") && !args[i].equals("-help")) continue;
            return true;
        }
        if (args.length == 0) {
            System.out.println("args: " + args.length);
            return true;
        }
        return false;
    }

    private boolean runConfigCmds(String[] args) {
        boolean bOk = true;
        String cfgFile = "jar://jdigidoc.cfg";
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-config")) continue;
            if (i < args.length - 2) {
                cfgFile = args[i + 1];
                continue;
            }
            bOk = false;
        }
        if (bOk) {
            System.out.println("Reading config file: " + cfgFile);
            bOk = ConfigManager.init(cfgFile);
        }
        return bOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runCheckValidDdocCmds(String[] args) {
        boolean bOk = true;
        ByteArrayOutputStream bos = null;
        FileInputStream fis = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-cdoc-test")) continue;
            String testFile = null;
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                testFile = args[i + 1];
                ++i;
            }
            if (testFile != null) {
                try {
                    bos = new ByteArrayOutputStream();
                    fis = new FileInputStream(testFile);
                    byte[] data = new byte[1024];
                    int n = 0;
                    while ((n = fis.read(data)) > 0) {
                        bos.write(data, 0, n);
                    }
                    fis.close();
                    fis = null;
                    data = bos.toByteArray();
                    bos.close();
                    bos = null;
                    String s = new String(data);
                    if (!s.startsWith("<?xml") && !s.startsWith("<SignedDoc")) {
                        System.err.println("Invalid ddoc: " + testFile + " - bad file begin");
                        bOk = false;
                        continue;
                    }
                    if (!s.endsWith("</SignedDoc>")) {
                        System.err.println("Invalid ddoc: " + testFile + " - bad file end");
                        bOk = false;
                        continue;
                    }
                    System.err.println("Good ddoc: " + testFile);
                    bOk = true;
                    continue;
                }
                catch (Exception ex) {
                    System.err.println("ERROR: testing ddoc: " + testFile + " - " + ex);
                    ex.printStackTrace(System.err);
                    continue;
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        if (bos != null) {
                            bos.close();
                        }
                    }
                    catch (Exception ex2) {
                        System.err.println("ERROR: closing file streams - " + ex2);
                    }
                }
            }
            bOk = false;
            System.err.println("Missing certificate file of -cdoc-recipient command");
        }
        return bOk;
    }

    private String composeHttpFrom() {
        String sFrom = null;
        try {
            NetworkInterface ni = null;
            Enumeration<NetworkInterface> eNi = NetworkInterface.getNetworkInterfaces();
            if (eNi != null && eNi.hasMoreElements()) {
                ni = eNi.nextElement();
            }
            if (ni != null) {
                InetAddress ia = null;
                Enumeration<InetAddress> eA = ni.getInetAddresses();
                if (eA != null && eA.hasMoreElements()) {
                    ia = eA.nextElement();
                }
                if (ia != null) {
                    sFrom = ia.getHostAddress();
                }
                System.err.println("FROM: " + sFrom);
            }
        }
        catch (Exception ex2) {
            System.err.println("ERROR: finding ip-adr: " + ex2);
        }
        return sFrom;
    }

    private boolean runSignSignedDocSlotLabelCmds(String[] args) {
        boolean bOk = true;
        String sImpl = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-ddoc-sign-slot-label")) continue;
            String pin = null;
            String rollReso = null;
            String country = null;
            String city = null;
            String state = null;
            String zip = null;
            String profile = null;
            String slot = null;
            int nSlot = 0;
            String label = null;
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                slot = args[i + 1];
                if (slot != null && slot.length() > 0) {
                    nSlot = Integer.parseInt(slot);
                }
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                label = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                pin = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                rollReso = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                country = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                state = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                city = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                zip = args[i + 1];
                ++i;
            }
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                profile = args[i + 1];
                ++i;
            }
            if (pin != null) {
                try {
                    if (this.m_sdoc == null) {
                        System.err.println("No signed document to sign. Use -ddoc-in or -ddoc-new commands!");
                        return false;
                    }
                    String[] roles = null;
                    if (rollReso != null && rollReso.trim().length() > 0) {
                        roles = new String[]{rollReso};
                    }
                    SignatureProductionPlace adr = null;
                    if (country != null || state != null || city != null || zip != null) {
                        adr = new SignatureProductionPlace(city, state, country, zip);
                    }
                    System.out.println("Signing digidoc");
                    ConfigManager cfg = ConfigManager.instance();
                    System.err.println("Signing of type: " + sImpl);
                    PKCS11SignatureFactory sigFac = (PKCS11SignatureFactory)cfg.getSignatureFactoryOfType("PKCS11");
                    if (sigFac == null) {
                        System.err.println("No PKCS11 signature factory");
                        return false;
                    }
                    TokenKeyInfo tki = sigFac.getTokenWithSlotIdAndLabel(nSlot, label);
                    if (tki == null) {
                        System.err.println("No token with slot: " + nSlot + " and label: " + label);
                        return false;
                    }
                    X509Certificate cert = sigFac.getCertificateWithSlotIdAndLabel(nSlot, label);
                    System.out.println("Prepare signature, cert: " + (cert != null ? "OK" : "NULL") + " status: " + bOk);
                    Signature sig = this.m_sdoc.prepareSignature(cert, roles, adr);
                    if (profile == null) {
                        profile = ConfigManager.instance().getStringProperty("DIGIDOC_DEFAULT_PROFILE", "TM");
                    }
                    if (profile != null) {
                        sig.setProfile(profile);
                    }
                    byte[] sidigest = sig.calculateSignedInfoDigest();
                    byte[] sigval = sigFac.sign(sidigest, nSlot, label, pin, sig);
                    System.out.println("Finalize signature: " + sig.getId() + " profile: " + profile + " sig-len: " + (sigval != null ? sigval.length : 0));
                    sig.setSignatureValue(sigval);
                    sig.setHttpFrom(this.composeHttpFrom());
                    sig.getConfirmation();
                }
                catch (Exception ex) {
                    bOk = false;
                    System.err.println("ERROR: signing: " + ex);
                    ex.printStackTrace(System.err);
                }
                continue;
            }
            bOk = false;
            System.err.println("Missing pin of -ddoc-sign-slot-label command");
        }
        return bOk;
    }

    private boolean runListKeysCmds(String[] args) {
        boolean bOk = true;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!args[i].equals("-ddoc-list-keys")) continue;
            try {
                PKCS11SignatureFactory sigFac = (PKCS11SignatureFactory)ConfigManager.instance().getSignatureFactoryOfType("PKCS11");
                if (sigFac == null) {
                    System.err.println("PKCS11 interface not available!");
                    return false;
                }
                TokenKeyInfo[] ltok = sigFac.getTokenKeys();
                for (int j = 0; ltok != null && j < ltok.length; ++j) {
                    TokenKeyInfo tok = ltok[j];
                    System.out.println("Token: " + tok.getNr() + " slot: " + tok.getSlot() + " label " + tok.getLabel() + " id: " + tok.getIdHex() + " cert: " + tok.getCertSerial() + " CN: " + tok.getCertName() + " signing: " + tok.isSignatureKey() + " encryption: " + tok.isEncryptKey());
                }
                bOk = true;
                continue;
            }
            catch (Exception ex) {
                System.err.println("ERROR: listing keys: " + ex);
                ex.printStackTrace(System.err);
            }
        }
        return bOk;
    }

    public boolean run(String[] args) {
        boolean bOk = true;
        boolean b = false;
        boolean bContinue = true;
        boolean bHelp = false;
        ArrayList lerr = new ArrayList();
        bHelp = this.runHelpCmds(args);
        bOk = this.runConfigCmds(args);
        if (bOk) {
            ConfigManager.addProvider();
        }
        if (bOk) {
            bOk = this.runCheckCertCmds(args);
        }
        if (bOk) {
            bOk = this.runListKeysCmds(args);
        }
        if (bOk) {
            bOk = this.runReadSignedDocCmds(args, lerr);
            boolean bl = bContinue = !SignedDoc.hasFatalErrs(lerr);
        }
        if (bOk) {
            bOk = this.runNewSignedDocCmds(args);
        }
        if (bOk) {
            bOk = this.runAddSignedDocCmds(args);
        }
        if (bOk) {
            bOk = this.runAddMemSignedDocCmds(args);
        }
        if (bOk) {
            bOk = this.runSignSignedDocCmds(args);
        }
        if (bOk) {
            bOk = this.runSignSignedDocSlotLabelCmds(args);
        }
        if (bOk) {
            bOk = this.runCalcSignCmds(args);
        }
        if (bOk) {
            bOk = this.runAddSignValueCmds(args);
        }
        if (bOk) {
            bOk = this.runNotarizeSignedDocCmds(args);
        }
        if (bOk) {
            bOk = this.runRmvSigCmds(args);
        }
        if (bOk) {
            bOk = this.runRmvDfCmds(args);
        }
        if (bOk) {
            bOk = this.runWriteSignedDocCmds(args);
        }
        if (bContinue && !(b = this.runValidateSignedDocCmds(args))) {
            bOk = false;
        }
        if (bOk) {
            bOk = this.runExtractDataFileCmds(args);
        }
        if (bOk) {
            bOk = this.runReadEncryptedDataCmds(args);
        }
        if (bOk) {
            bOk = this.runAddRecipientsCmds(args);
        }
        if (bOk) {
            bOk = this.runEncryptEncryptedDataCmds(args);
        }
        if (bOk) {
            bOk = this.runEncryptEncryptedDataSKCmds(args);
        }
        if (bOk) {
            bOk = this.runEncryptStreamCmds(args);
        }
        if (bOk) {
            bOk = this.runDecryptEncryptedDataCmds(args);
        }
        if (bOk) {
            bOk = this.runDecryptEncryptedDataPkcs12Cmds(args);
        }
        if (bOk) {
            bOk = this.runDecryptEncryptedDataPkcs12StreamCmds(args);
        }
        if (bOk) {
            bOk = this.runDecryptEncryptedStreamCmds(args);
        }
        if (bOk) {
            bOk = this.runDecryptEncryptedStreamRecvCmds(args);
        }
        if (bOk) {
            bOk = this.runDecryptEncryptedStreamSlotAndLabelCmds(args);
        }
        if (bOk) {
            bOk = this.runListEncryptedDataCmds(args);
        }
        if (bOk) {
            bOk = this.runValidateEncryptedDataCmds(args);
        }
        if (bOk) {
            bOk = this.runCheckValidDdocCmds(args);
        }
        if (bHelp) {
            System.err.println("USAGE: ee.sk.test.jdigidoc [commands]");
            System.err.println("\t-? or -help - displays this help screen");
            System.err.println("\t-config <configuration-file> [default: jar://jdigidoc.cfg]");
            System.err.println("\t-check-cert <certficate-file-in-pem-format>");
            System.err.println("\t-ddoc-in <input-digidoc-file>");
            System.err.println("\t-ddoc-in-stream <input-digidoc-file>");
            System.err.println("\t-ddoc-in-ostream <input-digidoc-file>");
            System.err.println("\t-ddoc-new [format] [version]");
            System.err.println("\t-ddoc-add <input-file> <mime-typ> [content-type]");
            System.err.println("\t-ddoc-add-mem <input-file> <mime-typ> [content-type]");
            System.err.println("\t-ddoc-sign <pin-code> [roll/resolutsioon] [country] [state] [city] [zip] [slot(0)] [profile] [driver(PKCS11)] [keystoreFile]");
            System.err.println("\t-ddoc-out <ouput-file>");
            System.err.println("\t-ddoc-out-stream <ouput-file>");
            System.err.println("\t-ddoc-out-ostream <ouput-file>");
            System.err.println("\t-ddoc-validate");
            System.err.println("\t-ddoc-extract <data-file-id> <output-file>");
            System.err.println("\t-ddoc-rm-sig <signature-id>");
            System.err.println("\t-ddoc-rm-df <data-file-id>");
            System.err.println("\t-ddoc-list-keys");
            System.err.println("\t-ddoc-sign-slot-label <slot-id> <label> <pin-code> [manifest] [country] [state] [city] [zip] [profile]");
            System.err.println("\t-cdoc-decrypt-stream-slot-label <input-file> <pin> <output-file> <slot> <label>");
            System.err.println("\t-ddoc-calc-sign <cert-file> [roll/resolutsioon] [country] [state] [city] [zip]] [profile]");
            System.err.println("\t-ddoc-add-sign-value <sign-val-file> <sign-id>");
            System.err.println("\t-cdoc-in <input-encrypted-file>");
            System.err.println("\t-cdoc-list");
            System.err.println("\t-cdoc-validate");
            System.err.println("\t-cdoc-recipient <certificate-file> [recipient] [KeyName] [CarriedKeyName]");
            System.err.println("\t-cdoc-encrypt <input-file> <output-file>");
            System.err.println("\t-cdoc-encrypt-sk <input-file> <output-file>");
            System.err.println("\t-cdoc-encrypt-stream <input-file> <output-file>");
            System.err.println("\t-cdoc-decrypt <pin> <output-file> [slot(0)]");
            System.err.println("\t-cdoc-decrypt-sk <pin> <output-file> [slot(0)]");
            System.err.println("\t-cdoc-decrypt-stream <input-file> <pin> <output-file>");
            System.err.println("\t-cdoc-decrypt-stream-recv <input-file> <pin> <output-file> <recipient>");
            System.err.println("\t-cdoc-test <input-file>");
            System.err.println("\t-cdoc-decrypt-pkcs12 <keystore-file> <keystore-passwd> <keystore-type> <output-file>");
            System.err.println("\t-cdoc-decrypt-pkcs12-sk <keystore-file> <keystore-passwd> <keystore-type> <output-file>");
            System.err.println("\t-cdoc-decrypt-pkcs12-stream <input-file> <keystore-file> <keystore-passwd> <keystore-type> <output-file>");
            System.err.println("\t-cdoc-decrypt-pkcs12-stream-sk <input-file> <keystore-file> <keystore-passwd> <keystore-type> <output-file>");
            System.err.println("\t-libraryerrors");
        }
        if (this.m_sdoc != null) {
            this.m_sdoc.cleanupDfCache();
        }
        return bOk;
    }

    public static void main(String[] args) {
        System.out.println("JDigiDoc - ${env.JDD_VERSION}");
        Date ds = new Date();
        jdigidoc prog = new jdigidoc();
        boolean bOk = prog.run(args);
        Date de = new Date();
        System.out.println("JDigiDoc end, time: " + (de.getTime() - ds.getTime()) / 1000L + " sec result: " + (bOk ? "success" : "failure"));
    }
}

