/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends FilterInputStream {
    private int[] buffer;
    private int bufferCounter = 0;
    private boolean eof = false;
    static String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    static char pad = (char)61;

    public Base64InputStream(InputStream is) {
        super(is);
    }

    @Override
    public int read() throws IOException {
        if (this.buffer == null || this.bufferCounter == this.buffer.length) {
            if (this.eof) {
                return -1;
            }
            this.acquire();
            if (this.buffer.length == 0) {
                this.buffer = null;
                return -1;
            }
            this.bufferCounter = 0;
        }
        return this.buffer[this.bufferCounter++];
    }

    private void acquire() throws IOException {
        int l;
        char[] four = new char[4];
        int i = 0;
        do {
            int b;
            if ((b = this.in.read()) == -1) {
                if (i != 0) {
                    throw new IOException("Bad base64 stream");
                }
                this.buffer = new int[0];
                this.eof = true;
                return;
            }
            char c = (char)b;
            if (chars.indexOf(c) == -1 && c != pad) continue;
            four[i++] = c;
        } while (i < 4);
        if (four[0] == pad || four[1] == pad) {
            throw new IOException("Bad base64 stream");
        }
        if (four[2] == pad && four[3] != pad) {
            throw new IOException("Bad base64 stream");
        }
        if (four[3] == pad) {
            this.eof = true;
            l = four[2] == pad ? 1 : 2;
        } else {
            l = 3;
        }
        int aux = 0;
        for (i = 0; i < 4; ++i) {
            if (four[i] == pad) continue;
            aux |= chars.indexOf(four[i]) << 6 * (3 - i);
        }
        this.buffer = new int[l];
        for (i = 0; i < l; ++i) {
            this.buffer[i] = aux >>> 8 * (2 - i) & 0xFF;
        }
    }
}

