/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.utils;

import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.SignedDoc;
import ee.sk.digidoc.factory.CanonicalizationFactory;
import ee.sk.digidoc.factory.DigiDocFactory;
import ee.sk.digidoc.factory.NotaryFactory;
import ee.sk.digidoc.factory.SignatureFactory;
import ee.sk.digidoc.factory.TimestampFactory;
import ee.sk.digidoc.factory.TrustServiceFactory;
import ee.sk.xmlenc.factory.EncryptedDataParser;
import ee.sk.xmlenc.factory.EncryptedStreamParser;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ConfigManager {
    private static Properties m_props = null;
    private static ConfigManager m_instance = null;
    private static NotaryFactory m_notFac = null;
    private static CanonicalizationFactory m_canFac = null;
    private static TimestampFactory m_tsFac = null;
    private static Logger m_logger = Logger.getLogger(ConfigManager.class);
    private static SignatureFactory m_sigFac = null;
    private static TrustServiceFactory m_tslFac = null;

    public static ConfigManager instance() {
        if (m_instance == null) {
            m_instance = new ConfigManager();
        }
        return m_instance;
    }

    private ConfigManager() {
        if (this.getProperty("DIGIDOC_LOG4J_CONFIG") != null) {
            PropertyConfigurator.configure((String)this.getProperty("DIGIDOC_LOG4J_CONFIG"));
        }
        m_logger = Logger.getLogger(ConfigManager.class);
    }

    public void reset() {
        m_props = new Properties();
    }

    public static boolean isSignatureKey(X509Certificate cert) {
        boolean[] keyUsages;
        return cert != null && (keyUsages = cert.getKeyUsage()) != null && keyUsages.length > 2 && keyUsages[1];
    }

    public static Provider addProvider() {
        try {
            String s = ConfigManager.instance().getStringProperty("DIGIDOC_SECURITY_PROVIDER", "org.bouncycastle.jce.provider.BouncyCastleProvider");
            Provider prv = (Provider)Class.forName(ConfigManager.instance().getStringProperty("DIGIDOC_SECURITY_PROVIDER", "org.bouncycastle.jce.provider.BouncyCastleProvider")).newInstance();
            Security.addProvider(prv);
            return prv;
        }
        catch (Exception ex) {
            m_logger.error((Object)("Error adding provider: " + ex));
            return null;
        }
    }

    public static boolean init(String cfgFileName) {
        boolean bOk = false;
        try {
            if (m_props == null) {
                m_props = new Properties();
            }
            InputStream isCfg = null;
            URL url = null;
            if (cfgFileName.startsWith("http")) {
                url = new URL(cfgFileName);
                isCfg = url.openStream();
            } else if (cfgFileName.startsWith("jar://")) {
                ClassLoader cl = ConfigManager.class.getClassLoader();
                isCfg = cl.getResourceAsStream(cfgFileName.substring(6));
            } else {
                isCfg = new FileInputStream(cfgFileName);
            }
            m_props.load(isCfg);
            isCfg.close();
            url = null;
            bOk = true;
        }
        catch (Exception ex) {
            m_logger.error((Object)("Cannot read config file: " + cfgFileName + " Reason: " + ex.toString()));
        }
        return bOk;
    }

    public static void init(Hashtable hProps) {
        m_props = new Properties();
        m_props.putAll((Map<?, ?>)hProps);
    }

    public SignatureFactory getSignatureFactory() throws DigiDocException {
        try {
            if (m_sigFac == null && (m_sigFac = (SignatureFactory)Class.forName(this.getProperty("DIGIDOC_SIGN_IMPL")).newInstance()) != null) {
                m_sigFac.init();
            }
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 56);
        }
        return m_sigFac;
    }

    public SignatureFactory getSignatureFactoryOfType(String sType) throws DigiDocException {
        try {
            SignatureFactory sFac = null;
            if ("PKCS11".equals(sType)) {
                sFac = (SignatureFactory)Class.forName(this.getProperty("DIGIDOC_SIGN_IMPL_PKCS11")).newInstance();
            }
            if ("PKCS12".equals(sType)) {
                sFac = (SignatureFactory)Class.forName(this.getProperty("DIGIDOC_SIGN_IMPL_PKCS12")).newInstance();
            }
            if (sFac != null) {
                sFac.init();
            }
            return sFac;
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 56);
            return m_sigFac;
        }
    }

    public TrustServiceFactory getTslFactory() throws DigiDocException {
        try {
            if (m_tslFac == null && (m_tslFac = (TrustServiceFactory)Class.forName(this.getProperty("DIGIDOC_TSLFAC_IMPL")).newInstance()) != null) {
                m_tslFac.init();
            }
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 56);
        }
        return m_tslFac;
    }

    public SignatureFactory getSignatureFactory(String type) throws DigiDocException {
        SignatureFactory sigFac = null;
        try {
            String strClass = this.getProperty("DIGIDOC_SIGN_IMPL_" + type);
            if (strClass != null && (sigFac = (SignatureFactory)Class.forName(strClass).newInstance()) != null && sigFac.getType().equals("PKCS11")) {
                sigFac.init();
            }
            if (sigFac == null) {
                throw new DigiDocException(56, "No signature factory of type: " + type, null);
            }
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 56);
        }
        return sigFac;
    }

    public NotaryFactory getNotaryFactory() throws DigiDocException {
        try {
            if (m_notFac == null) {
                m_notFac = (NotaryFactory)Class.forName(this.getProperty("DIGIDOC_NOTARY_IMPL")).newInstance();
                m_notFac.init();
            }
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 67);
        }
        return m_notFac;
    }

    public TimestampFactory getTimestampFactory() throws DigiDocException {
        try {
            if (m_tsFac == null) {
                m_tsFac = (TimestampFactory)Class.forName(this.getProperty("DIGIDOC_TIMESTAMP_IMPL")).newInstance();
                m_tsFac.init();
            }
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 125);
        }
        return m_tsFac;
    }

    public DigiDocFactory getDigiDocFactory() throws DigiDocException {
        DigiDocFactory ddocFac = null;
        try {
            ddocFac = (DigiDocFactory)Class.forName(this.getProperty("DIGIDOC_FACTORY_IMPL")).newInstance();
            ddocFac.init();
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 76);
        }
        return ddocFac;
    }

    public CanonicalizationFactory getCanonicalizationFactory() throws DigiDocException {
        try {
            if (m_canFac == null) {
                m_canFac = (CanonicalizationFactory)Class.forName(this.getProperty("CANONICALIZATION_FACTORY_IMPL")).newInstance();
                m_canFac.init();
            }
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 86);
        }
        return m_canFac;
    }

    public EncryptedDataParser getEncryptedDataParser() throws DigiDocException {
        EncryptedDataParser dencFac = null;
        try {
            dencFac = (EncryptedDataParser)Class.forName(this.getProperty("ENCRYPTED_DATA_PARSER_IMPL")).newInstance();
            dencFac.init();
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 76);
        }
        return dencFac;
    }

    public EncryptedStreamParser getEncryptedStreamParser() throws DigiDocException {
        EncryptedStreamParser dstrFac = null;
        try {
            dstrFac = (EncryptedStreamParser)Class.forName(this.getProperty("ENCRYPTED_STREAM_PARSER_IMPL")).newInstance();
            dstrFac.init();
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 76);
        }
        return dstrFac;
    }

    public String getProperty(String key) {
        return m_props.getProperty(key);
    }

    public String getStringProperty(String key, String def) {
        return m_props.getProperty(key, def);
    }

    public void setStringProperty(String key, String value) {
        if (m_props != null) {
            m_props.put(key, value);
        }
    }

    public int getIntProperty(String key, int def) {
        int rc = def;
        try {
            String s = m_props.getProperty(key);
            if (s != null && s.trim().length() > 0) {
                rc = Integer.parseInt(s);
            }
        }
        catch (NumberFormatException ex) {
            m_logger.error((Object)("Error parsing number: " + key), (Throwable)ex);
        }
        return rc;
    }

    public long getLongProperty(String key, long def) {
        long rc = def;
        try {
            String s = m_props.getProperty(key);
            if (s != null && s.trim().length() > 0) {
                rc = Long.parseLong(s);
            }
        }
        catch (NumberFormatException ex) {
            m_logger.error((Object)("Error parsing number: " + key), (Throwable)ex);
        }
        return rc;
    }

    public boolean getBooleanProperty(String key, boolean def) {
        boolean rc = def;
        try {
            String s = m_props.getProperty(key);
            if (s != null) {
                if (s.trim().equalsIgnoreCase("TRUE")) {
                    rc = true;
                }
                if (s.trim().equalsIgnoreCase("FALSE")) {
                    rc = false;
                }
            }
        }
        catch (NumberFormatException ex) {
            m_logger.error((Object)("Error parsing boolean: " + key), (Throwable)ex);
        }
        return rc;
    }

    public String getDefaultDigestType(SignedDoc sdoc) {
        if (sdoc != null && sdoc.getFormat() != null && sdoc.getFormat().equals("BDOC")) {
            return this.getStringProperty("DIGIDOC_DIGEST_TYPE", "SHA-256");
        }
        return "SHA-1";
    }

    public static String digType2Alg(String digType) {
        if (digType != null) {
            if (digType.equals("SHA-1")) {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            if (digType.equals("SHA-224")) {
                return "http://www.w3.org/2001/04/xmldsig-more#sha224";
            }
            if (digType.equals("SHA-256")) {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
            if (digType.equals("SHA-384")) {
                return "http://www.w3.org/2001/04/xmldsig-more#sha384";
            }
            if (digType.equals("SHA-512")) {
                return "http://www.w3.org/2001/04/xmlenc#sha512";
            }
        }
        return null;
    }

    public static String digType2SigMeth(String digType, boolean isEC) {
        if (digType != null) {
            if (isEC) {
                if (digType.equals("SHA-1")) {
                    return "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1";
                }
                if (digType.equals("SHA-224")) {
                    return "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224";
                }
                if (digType.equals("SHA-256")) {
                    return "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256";
                }
                if (digType.equals("SHA-384")) {
                    return "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384";
                }
                if (digType.equals("SHA-512")) {
                    return "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512";
                }
            } else {
                if (digType.equals("SHA-1")) {
                    return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
                }
                if (digType.equals("SHA-224")) {
                    return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha224";
                }
                if (digType.equals("SHA-256")) {
                    return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
                }
                if (digType.equals("SHA-384")) {
                    return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
                }
                if (digType.equals("SHA-512")) {
                    return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
                }
            }
        }
        return null;
    }

    public static String sigMeth2SigType(String sigMeth, boolean bCvc) {
        if (sigMeth != null) {
            if (sigMeth.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1")) {
                return bCvc ? "SHA1withCVC-ECDSA" : "SHA1withECDSA";
            }
            if (sigMeth.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224")) {
                return bCvc ? "SHA224withCVC-ECDSA" : "SHA224withECDSA";
            }
            if (sigMeth.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256")) {
                return bCvc ? "SHA256withCVC-ECDSA" : "SHA256withECDSA";
            }
            if (sigMeth.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384")) {
                return bCvc ? "SHA384withCVC-ECDSA" : "SHA384withECDSA";
            }
            if (sigMeth.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512")) {
                return bCvc ? "SHA512withCVC-ECDSA" : "SHA512withECDSA";
            }
            if (sigMeth.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
                return "SHA1withRSA";
            }
            if (sigMeth.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha224")) {
                return "SHA224withRSA";
            }
            if (sigMeth.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256")) {
                return "SHA256withRSA";
            }
            if (sigMeth.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384")) {
                return "SHA384withRSA";
            }
            if (sigMeth.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512")) {
                return "SHA512withRSA";
            }
        }
        return null;
    }

    public static String digAlg2Type(String digAlg) {
        if (digAlg != null) {
            if (digAlg.equals("http://www.w3.org/2000/09/xmldsig#sha1")) {
                return "SHA-1";
            }
            if (digAlg.equals("http://www.w3.org/2001/04/xmldsig-more#sha224")) {
                return "SHA-224";
            }
            if (digAlg.equals("http://www.w3.org/2001/04/xmlenc#sha256") || digAlg.equals("http://www.w3.org/2001/04/xmldsig-more#sha256")) {
                return "SHA-256";
            }
            if (digAlg.equals("http://www.w3.org/2001/04/xmldsig-more#sha384")) {
                return "SHA-384";
            }
            if (digAlg.equals("http://www.w3.org/2001/04/xmlenc#sha512")) {
                return "SHA-512";
            }
        }
        return null;
    }

    public static boolean isEcdsaCvcAlgorithm(String sAlgo) {
        return sAlgo != null && ("SHA1withCVC-ECDSA".equals(sAlgo) || "SHA224withCVC-ECDSA".equals(sAlgo) || "SHA256withCVC-ECDSA".equals(sAlgo) || "SHA384withCVC-ECDSA".equals(sAlgo) || "SHA512withCVC-ECDSA".equals(sAlgo));
    }

    public static String sigMeth2Type(String sigMeth) {
        if (sigMeth != null) {
            if (sigMeth.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
                return "SHA-1";
            }
            if (sigMeth.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha224")) {
                return "SHA-224";
            }
            if (sigMeth.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256")) {
                return "SHA-256";
            }
            if (sigMeth.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384")) {
                return "SHA-384";
            }
            if (sigMeth.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512")) {
                return "SHA-512";
            }
            if (sigMeth.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1")) {
                return "SHA-1";
            }
            if (sigMeth.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224")) {
                return "SHA-224";
            }
            if (sigMeth.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256")) {
                return "SHA-256";
            }
            if (sigMeth.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384")) {
                return "SHA-384";
            }
            if (sigMeth.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512")) {
                return "SHA-512";
            }
        }
        return null;
    }
}

