/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.utils;

import ee.sk.digidoc.DigiDocException;
import java.io.InputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class LabelsManager {
    private static ResourceBundle resourceBundle;
    private static LabelsManager m_instance;

    public static LabelsManager instance() {
        if (m_instance == null) {
            m_instance = new LabelsManager();
        }
        return m_instance;
    }

    private LabelsManager() {
    }

    public static void init(String defResBundleName) throws DigiDocException {
        try {
            if (defResBundleName.startsWith("jar://")) {
                ClassLoader cl = LabelsManager.instance().getClass().getClassLoader();
                InputStream isLabels = cl.getResourceAsStream(defResBundleName.substring(6));
                resourceBundle = new PropertyResourceBundle(isLabels);
                isLabels.close();
            } else {
                LabelsManager.init(defResBundleName, Locale.getDefault());
            }
        }
        catch (Exception ex) {
            throw new DigiDocException(55, "Error loading labels from: " + defResBundleName, null);
        }
    }

    public static void init(String defResBundleName, String language, String country) {
        Locale locale = new Locale(language, country);
        LabelsManager.init(defResBundleName, locale);
    }

    public static void init(String defResBundleName, Locale locale) {
        resourceBundle = ResourceBundle.getBundle(defResBundleName, locale);
    }

    public String getLabel(String key) {
        String value = null;
        try {
            value = resourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return value;
    }

    static {
        m_instance = null;
    }
}

