/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.xmlenc;

import ee.sk.digidoc.Base64Util;
import ee.sk.digidoc.DataFile;
import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.SignedDoc;
import ee.sk.digidoc.factory.Pkcs12SignatureFactory;
import ee.sk.digidoc.factory.SignatureFactory;
import ee.sk.utils.ConfigManager;
import ee.sk.utils.ConvertUtils;
import ee.sk.xmlenc.EncryptedKey;
import ee.sk.xmlenc.EncryptionProperties;
import ee.sk.xmlenc.EncryptionProperty;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;

public class EncryptedData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_id;
    private String m_type;
    private String m_mimeType;
    private String m_xmlns;
    private String m_encryptionMethod;
    private byte[] m_data;
    private int m_nDataStatus;
    private ArrayList m_arrEncryptedKeys;
    private EncryptionProperties m_encProperties;
    private static Logger m_logger = Logger.getLogger(EncryptedData.class);
    private transient SecretKey m_transportKey;
    public static final String DENC_ENCDATA_TYPE_DDOC = "http://www.sk.ee/DigiDoc/v1.3.0/digidoc.xsd";
    public static final String DENC_ENCDATA_MIME_XML = "text/xml";
    public static final String DENC_ENCDATA_MIME_ZLIB = "http://www.isi.edu/in-noes/iana/assignments/media-types/application/zip";
    public static final String DENC_ENC_METHOD_AES128 = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    public static final String DENC_ENC_METHOD_RSA1_5 = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    public static final String DENC_ENC_METHOD_RSA1_5_BUGGY = "http://www.w3.org/2001/04/xmlenc#rsa-1-5";
    public static final String DENC_XMLNS_XMLENC = "http://www.w3.org/2001/04/xmlenc#";
    public static final String DENC_XMLNS_XMLENC_ELEMENT = "http://www.w3.org/2001/04/xmlenc#Element";
    public static final String DENC_XMLNS_XMLENC_CONTENT = "http://www.w3.org/2001/04/xmlenc#Content";
    public static final String DENC_XMLNS_XMLENC_ENCPROP = "http://www.w3.org/2001/04/xmlenc#EncryptionProperties";
    public static final String DENC_XMLNS_XMLDSIG = "http://www.w3.org/2000/09/xmldsig#";
    public static final int DENC_DATA_STATUS_UNINITIALIZED = 0;
    public static final int DENC_DATA_STATUS_UNENCRYPTED_AND_NOT_COMPRESSED = 1;
    public static final int DENC_DATA_STATUS_UNENCRYPTED_AND_COMPRESSED = 2;
    public static final int DENC_DATA_STATUS_ENCRYPTED_AND_NOT_COMPRESSED = 3;
    public static final int DENC_DATA_STATUS_ENCRYPTED_AND_COMPRESSED = 4;
    public static final int DENC_COMPRESS_ALLWAYS = 0;
    public static final int DENC_COMPRESS_NEVER = 1;
    public static final int DENC_COMPRESS_BEST_EFFORT = 2;
    public static final String ENCPROP_FILENAME = "Filename";
    public static final String ENCPROP_ORIG_SIZE = "OriginalSize";
    public static final String ENCPROP_ORIG_MIME = "OriginalMimeType";
    public static final String ENCPROP_ORIG_FILE = "orig_file";
    public static final String ENCPROP_LIB_VER = "LibraryVersion";
    public static final String ENCPROP_FORMAT_VER = "DocumentFormat";
    public static final String FORMAT_ENCDOC_XML = "ENCDOC-XML";
    public static final String VERSION_1_0 = "1.0";
    public static final String DIGDOC_ENCRYPT_KEY_ALG = "AES";
    public static final String DIGIDOC_ENCRYPTION_ALOGORITHM2 = "AES/CBC/PKCS7Padding";
    public static final String DIGIDOC_ENCRYPTION_ALOGORITHM = "AES/CBC/NOPadding";
    public static final String DIGIDOC_SECRANDOM_ALGORITHM = "SHA1PRNG";
    public static final String DIGIDOC_KEY_ALOGORITHM = "RSA/NONE/PKCS1Padding";
    public static final boolean DIGDOC_ENCRYPT_USE_IV = true;
    public static final String DIGIDOC_SECURITY_PROVIDER_NAME = "BC";
    public static final String DIGIDOC_SECURITY_PROVIDER = "org.bouncycastle.jce.provider.BouncyCastleProvider";

    public EncryptedData(String id, String type, String mimeType, String xmlns, String encryptionMethod) throws DigiDocException {
        this.setId(id);
        this.setType(type);
        this.setMimeType(mimeType);
        this.setXmlns(xmlns);
        this.setEncryptionMethod(encryptionMethod);
        this.m_data = null;
        this.m_transportKey = null;
        this.m_nDataStatus = 0;
        this.m_arrEncryptedKeys = null;
        this.m_encProperties = null;
        this.setPropLibraryNameAndVersion();
        this.setPropFormatNameAndVersion();
    }

    public EncryptedData(String xmlns) throws DigiDocException {
        this.m_id = null;
        this.m_type = null;
        this.m_mimeType = null;
        this.setXmlns(xmlns);
        this.m_encryptionMethod = null;
        this.m_data = null;
        this.m_transportKey = null;
        this.m_nDataStatus = 0;
        this.m_arrEncryptedKeys = null;
        this.m_encProperties = null;
    }

    public int getDataStatus() {
        return this.m_nDataStatus;
    }

    public void setDataStatus(int status) {
        this.m_nDataStatus = status;
    }

    public byte[] getData() {
        return this.m_data;
    }

    public void setData(byte[] data) {
        this.m_data = data;
    }

    public SecretKey getTransportKey() {
        return this.m_transportKey;
    }

    public void setTransportKey(SecretKey key) {
        this.m_transportKey = key;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String str) {
        this.m_id = str;
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String str) {
        this.m_type = str;
    }

    public String getMimeType() {
        return this.m_mimeType;
    }

    public void setMimeType(String str) {
        this.m_mimeType = str;
    }

    public String getEncryptionMethod() {
        return this.m_encryptionMethod;
    }

    public void setEncryptionMethod(String str) throws DigiDocException {
        DigiDocException ex = this.validateEncryptionMethod(str);
        if (ex != null) {
            throw ex;
        }
        this.m_encryptionMethod = str;
    }

    private DigiDocException validateEncryptionMethod(String str) {
        DigiDocException ex = null;
        if (str == null || !str.equals(DENC_ENC_METHOD_AES128)) {
            ex = new DigiDocException(103, "EncryptionMethod atribute is required and currently the only supported value is: http://www.w3.org/2001/04/xmlenc#aes128-cbc", null);
        }
        return ex;
    }

    public String getXmlns() {
        return this.m_xmlns;
    }

    public void setXmlns(String str) throws DigiDocException {
        DigiDocException ex = this.validateXmlns(str);
        if (ex != null) {
            throw ex;
        }
        this.m_xmlns = str;
    }

    private DigiDocException validateXmlns(String str) {
        DigiDocException ex = null;
        if (str == null || !str.equals(DENC_XMLNS_XMLENC)) {
            ex = new DigiDocException(104, "xmlns atribute is required and currently the only supported value is: http://www.w3.org/2001/04/xmlenc#", null);
        }
        return ex;
    }

    public String getEncryptionPropertiesId() {
        if (this.m_encProperties != null) {
            return this.m_encProperties.getId();
        }
        return null;
    }

    public void setEncryptionPropertiesId(String id) {
        if (this.m_encProperties == null) {
            this.m_encProperties = new EncryptionProperties(id);
        } else {
            this.m_encProperties.setId(id);
        }
    }

    public boolean encryptFileData(String sInFile, String sOutFile) {
        try {
            int nCompressOption = 2;
            byte[] inData = SignedDoc.readFile(new File(sInFile));
            this.setData(inData);
            this.setDataStatus(1);
            this.addProperty(ENCPROP_FILENAME, sInFile);
            if (sInFile.endsWith(".bdoc") || sInFile.endsWith(".asice")) {
                this.setMimeType("application/vnd.etsi.asic-e+zip");
            }
            this.addProperty(ENCPROP_ORIG_SIZE, new Long(inData.length).toString());
            this.encrypt(1);
            FileOutputStream fos = new FileOutputStream(sOutFile);
            fos.write(this.toXML());
            fos.close();
            return true;
        }
        catch (Exception ex) {
            m_logger.error((Object)("Error encrypting from: " + sInFile + " to: " + sOutFile + " - " + ex));
            ex.printStackTrace(System.err);
            return false;
        }
    }

    public void addProperty(EncryptionProperty prop) {
        if (this.m_encProperties == null) {
            this.m_encProperties = new EncryptionProperties(null);
        }
        this.m_encProperties.addProperty(prop);
    }

    public void addProperty(String name, String content) throws DigiDocException {
        if (this.m_encProperties == null) {
            this.m_encProperties = new EncryptionProperties(null);
        }
        this.m_encProperties.addProperty(new EncryptionProperty(name, content));
    }

    public int getNumProperties() {
        return this.m_encProperties == null ? 0 : this.m_encProperties.getNumProperties();
    }

    public EncryptionProperty getProperty(int nIdx) {
        if (nIdx < this.getNumProperties()) {
            return this.m_encProperties.getProperty(nIdx);
        }
        return null;
    }

    public EncryptionProperty findPropertyById(String id) {
        if (this.m_encProperties != null) {
            return this.m_encProperties.findPropertyById(id);
        }
        return null;
    }

    public EncryptionProperty findPropertyByName(String name) {
        if (this.m_encProperties != null) {
            return this.m_encProperties.findPropertyByName(name);
        }
        return null;
    }

    public EncryptionProperty getLastProperty() {
        if (this.m_encProperties != null && this.m_encProperties.getNumProperties() > 0) {
            return this.m_encProperties.getProperty(this.m_encProperties.getNumProperties() - 1);
        }
        return null;
    }

    public String findPropertyContentByName(String name) {
        EncryptionProperty prop = this.findPropertyByName(name);
        if (prop != null) {
            return prop.getContent();
        }
        return null;
    }

    public void setPropLibraryNameAndVersion() throws DigiDocException {
        EncryptionProperty prop = this.findPropertyByName(ENCPROP_LIB_VER);
        StringBuffer sb = new StringBuffer();
        sb.append("JDigiDoc");
        sb.append("|");
        sb.append("${env.JDD_VERSION}");
        if (prop == null) {
            prop = new EncryptionProperty(ENCPROP_LIB_VER, sb.toString());
            this.addProperty(prop);
        } else {
            prop.setContent(sb.toString());
        }
    }

    public String getPropLibraryName() {
        StringBuffer sb = new StringBuffer();
        EncryptionProperty prop = this.findPropertyByName(ENCPROP_LIB_VER);
        if (prop != null) {
            String content = prop.getContent();
            int nIdx1 = 0;
            if (content != null && (nIdx1 = content.indexOf("|")) != -1) {
                sb.append(content.substring(0, nIdx1));
            }
        }
        return sb.toString();
    }

    public String getPropLibraryVersion() {
        StringBuffer sb = new StringBuffer();
        EncryptionProperty prop = this.findPropertyByName(ENCPROP_LIB_VER);
        if (prop != null) {
            String content = prop.getContent();
            int nIdx1 = 0;
            if (content != null && (nIdx1 = content.indexOf("|")) != -1) {
                sb.append(content.substring(nIdx1 + 1));
            }
        }
        return sb.toString();
    }

    public void setPropFormatNameAndVersion() throws DigiDocException {
        EncryptionProperty prop = this.findPropertyByName(ENCPROP_FORMAT_VER);
        StringBuffer sb = new StringBuffer();
        sb.append(FORMAT_ENCDOC_XML);
        sb.append("|");
        sb.append(VERSION_1_0);
        if (prop == null) {
            prop = new EncryptionProperty(ENCPROP_FORMAT_VER, sb.toString());
            this.addProperty(prop);
        } else {
            prop.setContent(sb.toString());
        }
    }

    public String getPropFormatName() {
        StringBuffer sb = new StringBuffer();
        EncryptionProperty prop = this.findPropertyByName(ENCPROP_FORMAT_VER);
        if (prop != null) {
            String content = prop.getContent();
            int nIdx1 = 0;
            if (content != null && (nIdx1 = content.indexOf("|")) != -1) {
                sb.append(content.substring(0, nIdx1));
            }
        }
        return sb.toString();
    }

    public String getPropFormatVersion() {
        StringBuffer sb = new StringBuffer();
        EncryptionProperty prop = this.findPropertyByName(ENCPROP_FORMAT_VER);
        if (prop != null) {
            String content = prop.getContent();
            int nIdx1 = 0;
            if (content != null && (nIdx1 = content.indexOf("|")) != -1) {
                sb.append(content.substring(nIdx1 + 1));
            }
        }
        return sb.toString();
    }

    public void setPropRegisterDigiDoc(SignedDoc sdoc) throws DigiDocException {
        for (int i = 0; i < sdoc.countDataFiles(); ++i) {
            DataFile df = sdoc.getDataFile(i);
            StringBuffer sb = new StringBuffer();
            sb.append(df.getFileName());
            sb.append("|");
            sb.append(new Long(df.getSize()).toString());
            sb.append("|");
            sb.append(df.getMimeType());
            sb.append("|");
            sb.append(df.getId());
            this.addProperty(new EncryptionProperty(ENCPROP_ORIG_FILE, sb.toString()));
        }
    }

    public int getPropOrigFileCount() {
        int n = 0;
        for (int i = 0; this.m_encProperties != null && i < this.m_encProperties.getNumProperties(); ++i) {
            EncryptionProperty prop = this.m_encProperties.getProperty(i);
            if (prop.getName() == null || !prop.getName().equals(ENCPROP_ORIG_FILE)) continue;
            ++n;
        }
        return n;
    }

    public String getPropOrigFileName(int nProp) {
        String str = null;
        int n = 0;
        int nIdx1 = 0;
        for (int i = 0; this.m_encProperties != null && i < this.m_encProperties.getNumProperties(); ++i) {
            EncryptionProperty prop = this.m_encProperties.getProperty(i);
            if (prop.getName() == null || !prop.getName().equals(ENCPROP_ORIG_FILE) || ++n != nProp) continue;
            String content = prop.getContent();
            if (content == null || (nIdx1 = content.indexOf("|")) == -1) break;
            str = content.substring(0, nIdx1);
            break;
        }
        return str;
    }

    public String getPropByName(String sName) {
        for (int i = 0; this.m_encProperties != null && i < this.m_encProperties.getNumProperties(); ++i) {
            EncryptionProperty prop = this.m_encProperties.getProperty(i);
            if (prop.getName() == null || !prop.getName().equals(sName)) continue;
            return prop.getContent();
        }
        return null;
    }

    public String getPropOrigFileSize(int nProp) {
        String str = null;
        int n = 0;
        int nIdx1 = 0;
        int nIdx2 = 0;
        for (int i = 0; this.m_encProperties != null && i < this.m_encProperties.getNumProperties(); ++i) {
            EncryptionProperty prop = this.m_encProperties.getProperty(i);
            if (prop.getName() == null || !prop.getName().equals(ENCPROP_ORIG_FILE) || ++n != nProp) continue;
            String content = prop.getContent();
            if (content == null || (nIdx1 = content.indexOf("|")) == -1 || (nIdx2 = content.indexOf("|", nIdx1 + 1)) == -1) break;
            str = content.substring(nIdx1 + 1, nIdx2);
            break;
        }
        return str;
    }

    public String getPropOrigFileMime(int nProp) {
        String str = null;
        int n = 0;
        int nIdx1 = 0;
        int nIdx2 = 0;
        int nIdx3 = 0;
        for (int i = 0; this.m_encProperties != null && i < this.m_encProperties.getNumProperties(); ++i) {
            EncryptionProperty prop = this.m_encProperties.getProperty(i);
            if (prop.getName() == null || !prop.getName().equals(ENCPROP_ORIG_FILE) || ++n != nProp) continue;
            String content = prop.getContent();
            if (content == null || (nIdx3 = content.indexOf("|")) == -1 || (nIdx1 = content.indexOf("|", nIdx3 + 1)) == -1 || (nIdx2 = content.indexOf("|", nIdx1 + 1)) == -1) break;
            str = content.substring(nIdx1 + 1, nIdx2);
            break;
        }
        return str;
    }

    public String getPropOrigFileId(int nProp) {
        String str = null;
        int n = 0;
        int nIdx1 = 0;
        for (int i = 0; this.m_encProperties != null && i < this.m_encProperties.getNumProperties(); ++i) {
            EncryptionProperty prop = this.m_encProperties.getProperty(i);
            if (prop.getName() == null || !prop.getName().equals(ENCPROP_ORIG_FILE) || ++n != nProp) continue;
            String content = prop.getContent();
            if (content == null || (nIdx1 = content.lastIndexOf("|")) == -1) break;
            str = content.substring(nIdx1 + 1);
            break;
        }
        return str;
    }

    public void addEncryptedKey(EncryptedKey key) {
        if (this.m_arrEncryptedKeys == null) {
            this.m_arrEncryptedKeys = new ArrayList();
        }
        this.m_arrEncryptedKeys.add(key);
    }

    public int getNumKeys() {
        return this.m_arrEncryptedKeys == null ? 0 : this.m_arrEncryptedKeys.size();
    }

    public EncryptedKey getEncryptedKey(int nIdx) {
        if (nIdx < this.getNumKeys()) {
            return (EncryptedKey)this.m_arrEncryptedKeys.get(nIdx);
        }
        return null;
    }

    public EncryptedKey getLastEncryptedKey() {
        if (this.m_arrEncryptedKeys != null && this.m_arrEncryptedKeys.size() > 0) {
            return (EncryptedKey)this.m_arrEncryptedKeys.get(this.m_arrEncryptedKeys.size() - 1);
        }
        return null;
    }

    public EncryptedKey findKeyById(String id) {
        for (int i = 0; this.m_arrEncryptedKeys != null && i < this.m_arrEncryptedKeys.size(); ++i) {
            EncryptedKey key = (EncryptedKey)this.m_arrEncryptedKeys.get(i);
            if (key.getId() == null || !key.getId().equals(id)) continue;
            return key;
        }
        return null;
    }

    public EncryptedKey findKeyByRecipient(String recv) {
        for (int i = 0; this.m_arrEncryptedKeys != null && i < this.m_arrEncryptedKeys.size(); ++i) {
            EncryptedKey key = (EncryptedKey)this.m_arrEncryptedKeys.get(i);
            if (key.getRecipient() == null || !key.getRecipient().equals(recv)) continue;
            return key;
        }
        return null;
    }

    private void initKey() throws DigiDocException {
        try {
            Security.addProvider((Provider)Class.forName(DIGIDOC_SECURITY_PROVIDER).newInstance());
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 116);
        }
        if (this.m_transportKey != null) {
            throw new DigiDocException(110, "Transport key allready initialized!", null);
        }
        try {
            SecureRandom random = SecureRandom.getInstance(DIGIDOC_SECRANDOM_ALGORITHM);
            KeyGenerator keygen = KeyGenerator.getInstance(DIGDOC_ENCRYPT_KEY_ALG, DIGIDOC_SECURITY_PROVIDER_NAME);
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Keygen:" + keygen.getClass().getName() + " algorithm: " + keygen.getAlgorithm()));
            }
            keygen.init(128, random);
            this.m_transportKey = keygen.generateKey();
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("key0: " + this.m_transportKey.getEncoded().length));
            }
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 107);
        }
        if (this.m_transportKey == null) {
            throw new DigiDocException(107, "Failure to initialize the transport key!", null);
        }
    }

    public Cipher getCipher(int mode, SecretKey transportKey, byte[] iv) throws DigiDocException {
        Cipher cip = null;
        byte[] ivdata = null;
        if (this.m_transportKey == null && transportKey == null) {
            throw new DigiDocException(110, "Transport key has not been initialized!", null);
        }
        try {
            if (mode == 2) {
                cip = Cipher.getInstance(DIGIDOC_ENCRYPTION_ALOGORITHM, DIGIDOC_SECURITY_PROVIDER_NAME);
                IvParameterSpec ivSpec = new IvParameterSpec(iv);
                cip.init(mode, (Key)(transportKey == null ? this.m_transportKey : transportKey), ivSpec);
            } else {
                cip = Cipher.getInstance(DIGIDOC_ENCRYPTION_ALOGORITHM2, DIGIDOC_SECURITY_PROVIDER_NAME);
                cip.init(mode, transportKey == null ? this.m_transportKey : transportKey);
                ivdata = cip.getIV();
                System.arraycopy(ivdata, 0, iv, 0, 16);
            }
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Cipher: " + cip.getAlgorithm() + " provider: " + cip.getProvider().getName()));
                ivdata = cip.getIV();
            }
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 112);
        }
        return cip;
    }

    public void encrypt(int nCompressOption) throws DigiDocException {
        byte[] ivdata = new byte[16];
        if (this.m_transportKey == null) {
            this.initKey();
        }
        if (this.m_data == null || this.m_nDataStatus != 2 && this.m_nDataStatus != 1) {
            throw new DigiDocException(115, "Invalid data status for encryption operation!", null);
        }
        int nTotalInput = this.m_data.length;
        int nTotalCompressed = 0;
        int nTotalEncrypted = 0;
        this.compress(nCompressOption);
        nTotalCompressed = this.m_data.length;
        Cipher cipher = this.getCipher(1, null, ivdata);
        try {
            int i;
            int nOrigLen;
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Encrypt - algorithm: " + cipher.getAlgorithm() + " blocksize: " + cipher.getBlockSize()));
            }
            int nBlockSize = cipher.getBlockSize();
            byte[] cdata = null;
            int nInput = nOrigLen = this.m_data.length;
            int nLastBlockSize = this.m_data.length % nBlockSize;
            nInput = nOrigLen - nLastBlockSize + nBlockSize;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(this.m_data, 0, this.m_data.length - nLastBlockSize);
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Encrypt - body: " + this.m_data.length + " full-data: " + (this.m_data.length - nLastBlockSize) + " left: " + nLastBlockSize));
            }
            cdata = new byte[nBlockSize];
            if (nLastBlockSize > 0) {
                System.arraycopy(this.m_data, this.m_data.length - nLastBlockSize, cdata, 0, nLastBlockSize);
                for (i = nLastBlockSize; i < nBlockSize; ++i) {
                    cdata[i] = 0;
                }
                cdata[nBlockSize - 1] = new Integer(nBlockSize - nLastBlockSize).byteValue();
            } else {
                for (i = nLastBlockSize; i < nBlockSize; ++i) {
                    cdata[i] = 0;
                }
                cdata[nBlockSize - 1] = 16;
            }
            bos.write(cdata);
            if (m_logger.isDebugEnabled()) {
                for (i = 0; i < nBlockSize; ++i) {
                    m_logger.debug((Object)("Byte at: " + i + " = " + cdata[i]));
                }
            }
            cdata = cipher.doFinal(bos.toByteArray());
            nTotalEncrypted = cdata.length;
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Encrypt - orig: " + nOrigLen + " input: " + nInput + " encrypted: " + cdata.length));
            }
            this.m_data = new byte[cdata.length + 16];
            System.arraycopy(ivdata, 0, this.m_data, 0, 16);
            System.arraycopy(cdata, 0, this.m_data, 16, cdata.length);
            this.m_nDataStatus = 3;
            for (i = 0; i < this.getNumKeys(); ++i) {
                EncryptedKey ekey = this.getEncryptedKey(i);
                ekey.encryptKey(this);
            }
            if (m_logger.isInfoEnabled()) {
                m_logger.info((Object)("Encrypt total - input: " + nTotalInput + " compressed: " + nTotalCompressed + " encrypted: " + nTotalEncrypted));
            }
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 112);
        }
    }

    public int getRecvIndex(X509Certificate cert) {
        if (cert == null) {
            return -1;
        }
        for (int i = 0; this.m_arrEncryptedKeys != null && i < this.m_arrEncryptedKeys.size(); ++i) {
            EncryptedKey key = (EncryptedKey)this.m_arrEncryptedKeys.get(i);
            if (key.getRecipientsCertificate() == null || !key.getRecipientsCertificate().getSerialNumber().equals(cert.getSerialNumber())) continue;
            return i;
        }
        return -1;
    }

    public void decrypt(int nKey, int token, String pin) throws DigiDocException {
        EncryptedKey ekey = this.getEncryptedKey(nKey);
        try {
            SignatureFactory sfac = ConfigManager.instance().getSignatureFactory();
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Decrypting key: " + nKey + " with token: " + token));
            }
            byte[] decdata = sfac.decrypt(ekey.getTransportKeyData(), token, pin);
            this.decryptWithKey(decdata);
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 111);
        }
    }

    public void decryptPkcs12(int nKey, String keystore, String storepass, String storetype) throws DigiDocException {
        EncryptedKey ekey = this.getEncryptedKey(nKey);
        try {
            Pkcs12SignatureFactory p12fac = new Pkcs12SignatureFactory();
            p12fac.init();
            p12fac.load(keystore, storetype, storepass);
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Decrypting key: " + nKey + " with token: " + nKey));
            }
            byte[] decdata = p12fac.decrypt(ekey.getTransportKeyData(), 0, storepass);
            this.decryptWithKey(decdata);
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 111);
        }
    }

    public void decrypt(String driver, String keystoreFile, int nKey, int token, String pin) throws DigiDocException {
        EncryptedKey ekey = this.getEncryptedKey(nKey);
        boolean bOk = true;
        try {
            ConfigManager cfg = ConfigManager.instance();
            SignatureFactory sigFac = cfg.getSignatureFactoryOfType(driver);
            if (sigFac == null) {
                m_logger.error((Object)("No signature factory of type: " + driver));
                throw new DigiDocException(111, "No signature factory of type: " + driver, null);
            }
            if (sigFac.getType().equals("PKCS12")) {
                Pkcs12SignatureFactory p12sfac = (Pkcs12SignatureFactory)sigFac;
                bOk = p12sfac.load(keystoreFile, "PKCS12", pin);
            }
            if (!bOk) {
                m_logger.error((Object)"Failed to load signature token!");
                throw new DigiDocException(111, "Failed to load signature token!", null);
            }
            if (ekey == null) {
                m_logger.error((Object)("No recipient nr: " + nKey));
                throw new DigiDocException(111, "No recipient nr: " + nKey, null);
            }
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Decrypting key: " + nKey + " with token: " + token + " key-data: " + (ekey.getTransportKeyData() != null ? ekey.getTransportKeyData().length : 0)));
            }
            byte[] decdata = sigFac.decrypt(ekey.getTransportKeyData(), token, pin);
            this.decryptWithKey(decdata);
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 111);
        }
    }

    public void decryptWithKey(byte[] deckey) throws DigiDocException {
        byte[] ivdata = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        if (this.m_data == null || this.m_nDataStatus != 4 && this.m_nDataStatus != 3) {
            throw new DigiDocException(115, "Invalid data status for decryption operation!", null);
        }
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Decrypting " + this.m_data.length + " using iv " + ivdata.length + " left: " + (this.m_data.length - ivdata.length)));
        }
        System.arraycopy(this.m_data, 0, ivdata, 0, ivdata.length);
        try {
            boolean bPadOk;
            this.m_transportKey = new SecretKeySpec(deckey, DIGIDOC_ENCRYPTION_ALOGORITHM);
            Cipher cipher = this.getCipher(2, this.m_transportKey, ivdata);
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Decrypting: " + this.m_data.length + " bytes"));
            }
            this.m_data = cipher.doFinal(this.m_data, 16, this.m_data.length - 16);
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Decrypted data: " + this.m_data.length + " bytes"));
                for (int i = this.m_data.length - 16; i < this.m_data.length; ++i) {
                    m_logger.debug((Object)("byte at: " + i + " = " + this.m_data[i]));
                }
            }
            int nPadLen = new Integer(this.m_data[this.m_data.length - 1]);
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Decrypted: " + this.m_data.length + " bytes, check padding: " + nPadLen));
            }
            if (bPadOk = this.checkPadding(this.m_data, nPadLen)) {
                this.m_data = this.removePadding(this.m_data, nPadLen);
            }
            if (bPadOk = this.checkPadding(this.m_data, nPadLen = new Integer(this.m_data[this.m_data.length - 1]).intValue())) {
                this.m_data = this.removePadding(this.m_data, nPadLen);
            }
            if (this.m_nDataStatus == 4) {
                this.m_nDataStatus = 2;
            }
            if (this.m_nDataStatus == 3) {
                this.m_nDataStatus = 1;
            }
            if (this.m_nDataStatus == 2) {
                this.decompress();
            }
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 111);
        }
    }

    private boolean checkPadding(byte[] data, int nPadLen) {
        boolean bPadOk = true;
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Checking padding: " + nPadLen + " bytes"));
        }
        if (nPadLen < 0 || nPadLen > 16 || data == null || data.length < nPadLen) {
            return false;
        }
        for (int i = data.length - nPadLen; nPadLen > 0 && i < data.length - 1; ++i) {
            if (data[i] == 0 || nPadLen == 16) continue;
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Data at: " + i + " = " + data[i] + " cancel padding"));
            }
            bPadOk = false;
            break;
        }
        return bPadOk;
    }

    private byte[] removePadding(byte[] data, int nPadLen) {
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Removing padding: " + nPadLen + " bytes"));
        }
        byte[] data2 = new byte[data.length - nPadLen];
        System.arraycopy(data, 0, data2, 0, data.length - nPadLen);
        return data2;
    }

    private void compress(int nCompressOption) throws DigiDocException {
        if (nCompressOption == 1) {
            return;
        }
        if (this.m_data == null || this.m_nDataStatus != 1) {
            throw new DigiDocException(115, "Invalid data status for compression operation!", null);
        }
        try {
            int nOldSize = this.m_data.length;
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Compressing: " + this.m_data.length + " bytes"));
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DeflaterOutputStream gout = new DeflaterOutputStream(bout);
            gout.write(this.m_data);
            gout.flush();
            gout.close();
            bout.close();
            byte[] n_data = bout.toByteArray();
            int nNewSize = n_data.length;
            if (nCompressOption == 0 || nCompressOption == 2 && nNewSize < nOldSize) {
                this.m_nDataStatus = 2;
                this.m_data = n_data;
                this.addProperty(ENCPROP_ORIG_SIZE, new Integer(nOldSize).toString());
                if (this.m_mimeType != null) {
                    this.addProperty(ENCPROP_ORIG_MIME, this.m_mimeType);
                }
                this.m_mimeType = DENC_ENCDATA_MIME_ZLIB;
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Keeping compressed: " + this.m_data.length + " bytes"));
                }
            } else if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Discarding compressed: " + this.m_data.length + " bytes"));
            }
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 113);
        }
    }

    private void decompress() throws DigiDocException {
        if (this.m_data == null || this.m_nDataStatus != 2) {
            throw new DigiDocException(115, "Invalid data status for decompression operation!", null);
        }
        try {
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Decompressing: " + this.m_data.length + " bytes"));
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(this.m_data);
            InflaterInputStream gin = new InflaterInputStream(bin);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] data = new byte[2048];
            int nRead = 0;
            while ((nRead = gin.read(data)) > 0) {
                bos.write(data, 0, nRead);
            }
            gin.close();
            bin.close();
            bos.close();
            this.m_data = bos.toByteArray();
            this.m_nDataStatus = 1;
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Decompressed: " + this.m_data.length + " bytes"));
            }
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 114);
        }
    }

    public void encryptStream(InputStream in, OutputStream out, int nCompressOption) throws DigiDocException {
        byte[] ivdata = new byte[16];
        if (this.m_transportKey == null) {
            this.initKey();
        }
        if (this.m_data != null || this.m_nDataStatus != 0) {
            throw new DigiDocException(115, "Invalid data status for encryption operation!", null);
        }
        Cipher cipher = this.getCipher(1, null, ivdata);
        Deflater compressor = null;
        if (nCompressOption == 0) {
            compressor = new Deflater();
            if (this.m_mimeType != null) {
                this.addProperty(ENCPROP_ORIG_MIME, this.m_mimeType);
            }
            this.m_mimeType = DENC_ENCDATA_MIME_ZLIB;
        }
        int nCiphBlockSize = cipher.getBlockSize();
        int nBlockSize = 2048;
        int nTotalInput = 0;
        int nTotalCompressed = 0;
        int nTotalEncrypted = 0;
        int nTotalBase64 = 0;
        int nTotalEncInp = 0;
        int nB64left = 0;
        byte[] data1 = new byte[nBlockSize];
        byte[] data2 = new byte[nBlockSize * 10];
        byte[] b64leftover = new byte[65];
        try {
            int nLen1;
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("EncryptStream - algorithm: " + cipher.getAlgorithm() + " blocksize: " + nCiphBlockSize));
            }
            for (int i = 0; i < this.getNumKeys(); ++i) {
                EncryptedKey ekey = this.getEncryptedKey(i);
                ekey.encryptKey(this);
            }
            out.write(this.xmlHeader());
            boolean isLastBlock = false;
            boolean isReadFromFile = true;
            do {
                int nLen2;
                if (isReadFromFile) {
                    nLen1 = in.read(data1);
                    if (nLen1 < 0) {
                        nLen1 = 0;
                    }
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("EncryptStream - input: " + nLen1));
                    }
                    nTotalInput += nLen1;
                    boolean bl = isLastBlock = nLen1 < nBlockSize;
                    if (nCompressOption == 0) {
                        if (nLen1 > 0) {
                            compressor.setInput(data1, 0, nLen1);
                        }
                        if (isLastBlock) {
                            compressor.finish();
                            nLen2 = compressor.deflate(data2);
                            isReadFromFile = compressor.finished();
                        } else {
                            nLen2 = compressor.deflate(data2);
                            if (nLen2 > 0) {
                                isReadFromFile = false;
                            }
                        }
                        nTotalCompressed += nLen2;
                        if (m_logger.isDebugEnabled()) {
                            m_logger.debug((Object)("EncryptStream - input: " + nLen1 + " compressed: " + nLen2 + " needin: " + compressor.needsInput()));
                        }
                    } else {
                        if (nLen1 > 0 && data2.length < nLen1) {
                            data2 = new byte[nLen1];
                        }
                        if (nLen1 > 0) {
                            System.arraycopy(data1, 0, data2, 0, nLen1);
                            nLen2 = nLen1;
                        } else {
                            nLen2 = 0;
                        }
                    }
                } else {
                    nLen1 = 0;
                    nLen2 = compressor.deflate(data2);
                    isReadFromFile = isLastBlock ? compressor.finished() : nLen2 == 0;
                    nTotalCompressed += nLen2;
                }
                byte[] encdata = null;
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("EncryptStream - input: " + nLen1 + " enc-input: " + nLen2));
                }
                if (isReadFromFile && isLastBlock) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("EncryptStream - last-data: " + nLen2));
                    }
                    if ((encdata = cipher.update(data2, 0, nLen2)) != null) {
                        bos.write(encdata);
                    }
                    int nLastBlockSize = nCiphBlockSize - (nTotalEncInp += nLen2) % nCiphBlockSize;
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("EncryptStream - total-data: " + nTotalEncInp + " padding: " + nLastBlockSize));
                    }
                    if (nLastBlockSize == 0) {
                        nLastBlockSize = 16;
                    }
                    byte[] ldata = new byte[nLastBlockSize];
                    for (int i = 0; i < nLastBlockSize; ++i) {
                        ldata[i] = 0;
                    }
                    ldata[nLastBlockSize - 1] = new Integer(nLastBlockSize).byteValue();
                    encdata = cipher.doFinal(ldata);
                    bos.write(encdata);
                    encdata = bos.toByteArray();
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("EncryptStream - encrypted: " + (encdata != null ? encdata.length : 0)));
                    }
                } else if (nLen2 > 0) {
                    encdata = cipher.update(data2, 0, nLen2);
                    nTotalEncInp += nLen2;
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("EncryptStream - norm input: " + nLen2 + " encrypted: " + (encdata != null ? encdata.length : 0)));
                    }
                }
                if (encdata == null) continue;
                if (nTotalEncrypted == 0) {
                    byte[] tdata = new byte[encdata.length + 16];
                    System.arraycopy(ivdata, 0, tdata, 0, 16);
                    System.arraycopy(encdata, 0, tdata, 16, encdata.length);
                    nTotalEncrypted += encdata.length;
                    encdata = tdata;
                } else {
                    nTotalEncrypted += encdata.length;
                }
                if (nB64left > 0) {
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("EncryptStream - input: " + encdata.length + " left: " + nB64left));
                    }
                    byte[] data3 = new byte[encdata.length + nB64left];
                    System.arraycopy(b64leftover, 0, data3, 0, nB64left);
                    System.arraycopy(encdata, 0, data3, nB64left, encdata.length);
                    encdata = data3;
                }
                int nUsed = Base64Util.encodeToStream(encdata, out, isLastBlock && isReadFromFile);
                nB64left = encdata.length - nUsed;
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("EncryptStream - input: " + encdata.length + " used: " + nUsed + " copy: " + nB64left + " pos: " + nUsed));
                }
                if (nB64left <= 0) continue;
                System.arraycopy(encdata, nUsed, b64leftover, 0, nB64left);
                nTotalBase64 += nUsed / 3 * 4;
                if (!m_logger.isDebugEnabled()) continue;
                m_logger.debug((Object)("EncryptStream - input: " + encdata.length + " used: " + nUsed + " base64: " + nUsed / 3 * 4 + " left: " + nB64left));
            } while (!isLastBlock || nLen1 == nBlockSize || !isReadFromFile);
            this.addProperty(ENCPROP_ORIG_SIZE, new Integer(nTotalInput).toString());
            out.write(this.xmlTrailer());
            out.flush();
            if (m_logger.isInfoEnabled()) {
                m_logger.info((Object)("EncryptStream total - input: " + nTotalInput + " compressed: " + nTotalCompressed + " encrypted: " + nTotalEncrypted + " base64: " + nTotalBase64));
            }
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 112);
        }
    }

    public byte[] toXML() throws DigiDocException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            bos.write(this.xmlHeader());
            byte[] b64data = ConvertUtils.str2data(Base64Util.encode(this.m_data, 64));
            int nTotalBase64 = b64data.length;
            bos.write(b64data);
            if (m_logger.isInfoEnabled()) {
                m_logger.info((Object)("Encrypt total - base64: " + nTotalBase64));
            }
            bos.write(this.xmlTrailer());
        }
        catch (IOException ex) {
            DigiDocException.handleException(ex, 89);
        }
        return bos.toByteArray();
    }

    private byte[] xmlHeader() throws DigiDocException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            bos.write(ConvertUtils.str2data("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>"));
            bos.write(ConvertUtils.str2data("<denc:EncryptedData xmlns:denc=\"" + this.m_xmlns + "\""));
            if (this.m_id != null) {
                bos.write(ConvertUtils.str2data(" Id=\"" + this.m_id + "\""));
            }
            if (this.m_mimeType != null) {
                bos.write(ConvertUtils.str2data(" MimeType=\"" + this.m_mimeType + "\""));
            }
            if (this.m_type != null) {
                bos.write(ConvertUtils.str2data(" Type=\"" + this.m_type + "\""));
            }
            bos.write(ConvertUtils.str2data(">"));
            bos.write(ConvertUtils.str2data("<denc:EncryptionMethod Algorithm=\""));
            bos.write(ConvertUtils.str2data(this.m_encryptionMethod));
            bos.write(ConvertUtils.str2data("\"></denc:EncryptionMethod>"));
            bos.write(ConvertUtils.str2data("<ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">"));
            for (int i = 0; i < this.getNumKeys(); ++i) {
                EncryptedKey key = this.getEncryptedKey(i);
                bos.write(key.toXML());
            }
            bos.write(ConvertUtils.str2data("</ds:KeyInfo>"));
            bos.write(ConvertUtils.str2data("<denc:CipherData><denc:CipherValue>"));
        }
        catch (IOException ex) {
            DigiDocException.handleException(ex, 89);
        }
        return bos.toByteArray();
    }

    private byte[] xmlTrailer() throws DigiDocException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            bos.write(ConvertUtils.str2data("</denc:CipherValue></denc:CipherData>"));
            if (this.getNumProperties() > 0) {
                bos.write(ConvertUtils.str2data("<denc:EncryptionProperties"));
                if (this.getEncryptionPropertiesId() != null) {
                    bos.write(ConvertUtils.str2data(" Id=\"" + this.getEncryptionPropertiesId() + "\""));
                }
                bos.write(ConvertUtils.str2data(">"));
                for (int i = 0; i < this.getNumProperties(); ++i) {
                    EncryptionProperty prop = this.getProperty(i);
                    bos.write(prop.toXML());
                }
                bos.write(ConvertUtils.str2data("</denc:EncryptionProperties>"));
            }
            bos.write(ConvertUtils.str2data("</denc:EncryptedData>"));
        }
        catch (IOException ex) {
            DigiDocException.handleException(ex, 89);
        }
        return bos.toByteArray();
    }

    public ArrayList validate() {
        ArrayList e;
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        DigiDocException ex = this.validateEncryptionMethod(this.m_encryptionMethod);
        if (ex != null) {
            errs.add(ex);
        }
        if ((ex = this.validateXmlns(this.m_xmlns)) != null) {
            errs.add(ex);
        }
        if (this.m_encProperties != null && !(e = this.m_encProperties.validate()).isEmpty()) {
            errs.addAll(e);
        }
        for (int i = 0; i < this.getNumKeys(); ++i) {
            EncryptedKey ekey = this.getEncryptedKey(i);
            ArrayList e2 = ekey.validate();
            if (e2.isEmpty()) continue;
            errs.addAll(e2);
        }
        return errs;
    }

    public String toString() {
        String str = null;
        try {
            str = new String(this.toXML());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }
}

