/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.xmlenc;

import ee.sk.digidoc.Base64Util;
import ee.sk.digidoc.DigiDocException;
import ee.sk.utils.ConvertUtils;
import ee.sk.xmlenc.EncryptedData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.crypto.Cipher;
import org.apache.log4j.Logger;

public class EncryptedKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_id;
    private String m_recipient;
    private String m_encryptionMethod;
    private String m_keyName;
    private String m_carriedKeyName;
    private X509Certificate m_recipientsCert;
    private byte[] m_transportKeyData;
    private static Logger m_logger = Logger.getLogger(EncryptedKey.class);

    public EncryptedKey(X509Certificate recvCert) throws DigiDocException {
        this.setId(null);
        this.setRecipient(null);
        this.setEncryptionMethod("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        this.setKeyName(null);
        this.setCarriedKeyName(null);
        this.setRecipientsCertificate(recvCert);
        this.m_transportKeyData = null;
    }

    public EncryptedKey() {
        m_logger = Logger.getLogger(EncryptedKey.class);
        this.setId(null);
        this.setRecipient(null);
        this.m_encryptionMethod = null;
        this.setKeyName(null);
        this.setCarriedKeyName(null);
        this.m_recipientsCert = null;
        this.m_transportKeyData = null;
    }

    public EncryptedKey(String id, String recipient, String encryptionMethod, String keyName, String carriedKeyName, X509Certificate recvCert) throws DigiDocException {
        this.setId(id);
        this.setRecipient(recipient);
        this.setEncryptionMethod(encryptionMethod);
        this.setKeyName(keyName);
        this.setCarriedKeyName(carriedKeyName);
        this.setRecipientsCertificate(recvCert);
        this.m_transportKeyData = null;
    }

    public byte[] getTransportKeyData() {
        return this.m_transportKeyData;
    }

    public void setTransportKeyData(byte[] key) {
        this.m_transportKeyData = key;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String str) {
        this.m_id = str;
    }

    public String getRecipient() {
        return this.m_recipient;
    }

    public void setRecipient(String str) {
        this.m_recipient = str;
    }

    public String getEncryptionMethod() {
        return this.m_encryptionMethod;
    }

    public void setEncryptionMethod(String str) throws DigiDocException {
        DigiDocException ex;
        String str2 = str;
        if (str2 != null && str2.equals("http://www.w3.org/2001/04/xmlenc#rsa-1-5")) {
            str2 = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
        }
        if ((ex = this.validateEncryptionMethod(str2)) != null) {
            throw ex;
        }
        this.m_encryptionMethod = str2;
    }

    private DigiDocException validateEncryptionMethod(String str) {
        DigiDocException ex = null;
        if (str == null || !str.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5")) {
            ex = new DigiDocException(102, "EncryptionMethod atribute is required and currently the only supported value is: http://www.w3.org/2001/04/xmlenc#rsa-1_5", null);
        }
        return ex;
    }

    public String getKeyName() {
        return this.m_keyName;
    }

    public void setKeyName(String str) {
        this.m_keyName = str;
    }

    public String getCarriedKeyName() {
        return this.m_carriedKeyName;
    }

    public void setCarriedKeyName(String str) {
        this.m_carriedKeyName = str;
    }

    public X509Certificate getRecipientsCertificate() {
        return this.m_recipientsCert;
    }

    public void setRecipientsCertificate(X509Certificate cert) throws DigiDocException {
        DigiDocException ex = this.validateRecipientsCertificate(cert);
        if (ex != null) {
            throw ex;
        }
        this.m_recipientsCert = cert;
    }

    private DigiDocException validateRecipientsCertificate(X509Certificate cert) {
        boolean[] keyUsages;
        DigiDocException ex = null;
        if (cert == null) {
            ex = new DigiDocException(101, "RecipientsCertificate atribute is required", null);
        }
        if ((keyUsages = cert.getKeyUsage()) == null || keyUsages.length < 2 || !keyUsages[2]) {
            ex = new DigiDocException(101, "RecipientsCertificate is not suitable for encryption - keyEncipherment flag not set!", null);
        }
        return ex;
    }

    public void encryptKey(EncryptedData encData) throws DigiDocException {
        if (encData.getTransportKey() == null) {
            throw new DigiDocException(110, "Transport key has not been initialized!", null);
        }
        if (this.m_recipientsCert == null) {
            throw new DigiDocException(110, "Recipients certificate has not been initialized!", null);
        }
        try {
            Cipher alg = Cipher.getInstance("RSA/NONE/PKCS1Padding", "BC");
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("EncryptKey - algorithm: " + alg.getAlgorithm()));
            }
            alg.init(3, this.m_recipientsCert.getPublicKey());
            this.m_transportKeyData = alg.wrap(encData.getTransportKey());
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("EncryptKey - data: " + (this.m_transportKeyData == null ? 0 : this.m_transportKeyData.length)));
            }
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 109);
        }
    }

    public byte[] toXML() throws DigiDocException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            bos.write(ConvertUtils.str2data("<denc:EncryptedKey"));
            if (this.m_id != null) {
                bos.write(ConvertUtils.str2data(" Id=\"" + this.m_id + "\""));
            }
            if (this.m_recipient != null) {
                bos.write(ConvertUtils.str2data(" Recipient=\"" + this.m_recipient + "\""));
            }
            bos.write(ConvertUtils.str2data(">"));
            bos.write(ConvertUtils.str2data("<denc:EncryptionMethod Algorithm=\""));
            bos.write(ConvertUtils.str2data(this.m_encryptionMethod));
            bos.write(ConvertUtils.str2data("\"></denc:EncryptionMethod>"));
            bos.write(ConvertUtils.str2data("<ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">"));
            if (this.m_keyName != null) {
                bos.write(ConvertUtils.str2data("<ds:KeyName>"));
                bos.write(ConvertUtils.str2data(this.m_keyName));
                bos.write(ConvertUtils.str2data("</ds:KeyName>"));
            }
            bos.write(ConvertUtils.str2data("<ds:X509Data><ds:X509Certificate>"));
            try {
                bos.write(ConvertUtils.str2data(Base64Util.encode(this.m_recipientsCert.getEncoded(), 64)));
            }
            catch (CertificateEncodingException ex) {
                DigiDocException.handleException(ex, 74);
            }
            bos.write(ConvertUtils.str2data("</ds:X509Certificate></ds:X509Data>"));
            bos.write(ConvertUtils.str2data("</ds:KeyInfo>"));
            bos.write(ConvertUtils.str2data("<denc:CipherData><denc:CipherValue>"));
            if (this.m_transportKeyData == null) {
                throw new DigiDocException(110, "Invalid transport key status for transport!", null);
            }
            bos.write(ConvertUtils.str2data(Base64Util.encode(this.m_transportKeyData, 64)));
            bos.write(ConvertUtils.str2data("</denc:CipherValue></denc:CipherData>"));
            if (this.m_carriedKeyName != null) {
                bos.write(ConvertUtils.str2data("<denc:CarriedKeyName>"));
                bos.write(ConvertUtils.str2data(this.m_carriedKeyName));
                bos.write(ConvertUtils.str2data("</denc:CarriedKeyName>"));
            }
            bos.write(ConvertUtils.str2data("</denc:EncryptedKey>"));
        }
        catch (IOException ex) {
            DigiDocException.handleException(ex, 89);
        }
        return bos.toByteArray();
    }

    public ArrayList validate() {
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        DigiDocException ex = this.validateEncryptionMethod(this.m_encryptionMethod);
        if (ex != null) {
            errs.add(ex);
        }
        if ((ex = this.validateRecipientsCertificate(this.m_recipientsCert)) != null) {
            errs.add(ex);
        }
        return errs;
    }

    public String toString() {
        String str = null;
        try {
            str = new String(this.toXML());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }
}

