/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.xmlenc;

import ee.sk.digidoc.DigiDocException;
import ee.sk.utils.ConvertUtils;
import ee.sk.xmlenc.EncryptionProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

public class EncryptionProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_id;
    private ArrayList m_arrProperties;

    public EncryptionProperties(String id) {
        this.setId(id);
        this.m_arrProperties = null;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String str) {
        this.m_id = str;
    }

    public void addProperty(EncryptionProperty prop) {
        if (this.m_arrProperties == null) {
            this.m_arrProperties = new ArrayList();
        }
        this.m_arrProperties.add(prop);
    }

    public int getNumProperties() {
        return this.m_arrProperties == null ? 0 : this.m_arrProperties.size();
    }

    public EncryptionProperty getProperty(int nIdx) {
        if (nIdx < this.getNumProperties()) {
            return (EncryptionProperty)this.m_arrProperties.get(nIdx);
        }
        return null;
    }

    public EncryptionProperty findPropertyById(String id) {
        for (int i = 0; this.m_arrProperties != null && i < this.m_arrProperties.size(); ++i) {
            EncryptionProperty prop = (EncryptionProperty)this.m_arrProperties.get(i);
            if (prop.getId() == null || !prop.getId().equals(id)) continue;
            return prop;
        }
        return null;
    }

    public EncryptionProperty findPropertyByName(String name) {
        for (int i = 0; this.m_arrProperties != null && i < this.m_arrProperties.size(); ++i) {
            EncryptionProperty prop = (EncryptionProperty)this.m_arrProperties.get(i);
            if (prop.getName() == null || !prop.getName().equals(name)) continue;
            return prop;
        }
        return null;
    }

    public byte[] toXML() throws DigiDocException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            bos.write(ConvertUtils.str2data("<denc:EncryptionProperties"));
            if (this.m_id != null) {
                bos.write(ConvertUtils.str2data(" Id=\"" + this.m_id + "\""));
            }
            bos.write(ConvertUtils.str2data(">"));
            for (int i = 0; i < this.getNumProperties(); ++i) {
                EncryptionProperty prop = this.getProperty(i);
                bos.write(prop.toXML());
            }
            bos.write(ConvertUtils.str2data("</denc:EncryptionProperties>"));
        }
        catch (IOException ex) {
            DigiDocException.handleException(ex, 89);
        }
        return bos.toByteArray();
    }

    public ArrayList validate() {
        ArrayList errs = new ArrayList();
        for (int i = 0; i < this.getNumProperties(); ++i) {
            EncryptionProperty eprop = this.getProperty(i);
            ArrayList e = eprop.validate();
            if (e.isEmpty()) continue;
            errs.addAll(e);
        }
        return errs;
    }

    public String toString() {
        String str = null;
        try {
            str = new String(this.toXML());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }
}

