/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.xmlenc;

import ee.sk.digidoc.DigiDocException;
import ee.sk.utils.ConvertUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

public class EncryptionProperty
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_id;
    private String m_target;
    private String m_name;
    private String m_content;
    public static String ENCPROP_FILENAME = "Filename";
    public static String ENCPROP_ORIG_SIZE = "OriginalSize";
    public static String ENCPROP_ORIG_MIME = "OriginalMimeType";

    public EncryptionProperty() {
        this.m_id = null;
        this.m_target = null;
        this.m_name = null;
        this.m_content = null;
    }

    public EncryptionProperty(String name, String content) throws DigiDocException {
        this.setName(name);
        this.setContent(content);
    }

    public EncryptionProperty(String id, String target, String name, String content) throws DigiDocException {
        this.setId(id);
        this.setTarget(target);
        this.setName(name);
        this.setContent(content);
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String str) {
        this.m_id = str;
    }

    public String getTarget() {
        return this.m_target;
    }

    public void setTarget(String str) {
        this.m_target = str;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String str) throws DigiDocException {
        DigiDocException ex = this.validateName(str);
        if (ex != null) {
            throw ex;
        }
        this.m_name = str;
    }

    private DigiDocException validateName(String str) {
        DigiDocException ex = null;
        if (str == null) {
            ex = new DigiDocException(99, "Name atribute is required", null);
        }
        return ex;
    }

    public String getContent() {
        return this.m_content;
    }

    public void setContent(String str) throws DigiDocException {
        DigiDocException ex = this.validateContent(str);
        if (ex != null) {
            throw ex;
        }
        this.m_content = str;
    }

    private DigiDocException validateContent(String str) {
        DigiDocException ex = null;
        if (str == null) {
            ex = new DigiDocException(100, "content of <EncryptionProperty> element is required", null);
        }
        return ex;
    }

    public byte[] toXML() throws DigiDocException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            bos.write(ConvertUtils.str2data("<denc:EncryptionProperty"));
            if (this.m_id != null) {
                bos.write(ConvertUtils.str2data(" Id=\"" + this.m_id + "\""));
            }
            if (this.m_target != null) {
                bos.write(ConvertUtils.str2data(" Target=\"" + this.m_target + "\""));
            }
            if (this.m_name != null) {
                bos.write(ConvertUtils.str2data(" Name=\"" + this.m_name + "\""));
            }
            bos.write(ConvertUtils.str2data(">"));
            if (this.m_name != null) {
                bos.write(ConvertUtils.str2data(ConvertUtils.escapeXmlSymbols(this.m_content)));
            }
            bos.write(ConvertUtils.str2data("</denc:EncryptionProperty>"));
        }
        catch (IOException ex) {
            DigiDocException.handleException(ex, 89);
        }
        return bos.toByteArray();
    }

    public ArrayList validate() {
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        DigiDocException ex = this.validateName(this.m_name);
        if (ex != null) {
            errs.add(ex);
        }
        if ((ex = this.validateContent(this.m_content)) != null) {
            errs.add(ex);
        }
        return errs;
    }

    public String toString() {
        String str = null;
        try {
            str = new String(this.toXML());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }
}

