/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.xmlenc.factory;

import ee.sk.digidoc.Base64Util;
import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.SignedDoc;
import ee.sk.digidoc.factory.SAXDigiDocException;
import ee.sk.xmlenc.EncryptedData;
import ee.sk.xmlenc.EncryptedKey;
import ee.sk.xmlenc.EncryptionProperty;
import ee.sk.xmlenc.factory.EncryptedDataParser;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EncryptedDataSAXParser
extends DefaultHandler
implements EncryptedDataParser {
    private Stack m_tags = new Stack();
    private EncryptedData m_doc = null;
    private StringBuffer m_sbCollectChars = null;
    private Logger m_logger = Logger.getLogger(EncryptedDataSAXParser.class);

    @Override
    public void init() throws DigiDocException {
    }

    @Override
    public EncryptedData readEncryptedData(InputStream dencStream) throws DigiDocException {
        EncryptedDataSAXParser handler = this;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(dencStream, (DefaultHandler)handler);
        }
        catch (SAXDigiDocException ex) {
            throw ex.getDigiDocException();
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 75);
        }
        if (this.m_doc == null) {
            throw new DigiDocException(13, "This document is not in EncryptedData format", null);
        }
        return this.m_doc;
    }

    @Override
    public EncryptedData readEncryptedData(String fileName) throws DigiDocException {
        EncryptedDataSAXParser handler = this;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser saxParser = factory.newSAXParser();
            FileInputStream is = new FileInputStream(fileName);
            saxParser.parse((InputStream)is, (DefaultHandler)handler);
            is.close();
        }
        catch (SAXDigiDocException ex) {
            throw ex.getDigiDocException();
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 75);
        }
        if (this.m_doc == null) {
            throw new DigiDocException(13, "This document is not in EncryptedData format", null);
        }
        return this.m_doc;
    }

    @Override
    public void startDocument() throws SAXException {
        this.m_doc = null;
        this.m_sbCollectChars = null;
    }

    @Override
    public void endDocument() throws SAXException {
    }

    private String findAtributeValue(Attributes attrs, String attName) {
        String value = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            String key = attrs.getQName(i);
            if (!key.equals(attName) && key.indexOf(attName) == -1) continue;
            value = attrs.getValue(i);
            break;
        }
        return value;
    }

    private void checkEncryptedData() throws SAXDigiDocException {
        if (this.m_doc == null) {
            throw new SAXDigiDocException(27, "This document is not in EncryptedData format!");
        }
    }

    private void checkEncryptedKey(EncryptedKey key) throws SAXDigiDocException {
        if (key == null) {
            throw new SAXDigiDocException(106, "This <EncryptedKey> object does not exist!");
        }
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXDigiDocException {
        String str;
        EncryptedKey ekey;
        String str2;
        String tName = qName;
        if (tName.indexOf(":") != -1) {
            tName = qName.substring(qName.indexOf(":") + 1);
        }
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug((Object)("Start Element: " + tName + " qname: " + qName + " lname: " + lName + " uri: " + namespaceURI));
        }
        this.m_tags.push(tName);
        if (tName.equals("KeyName") || tName.equals("CarriedKeyName") || tName.equals("X509Certificate") || tName.equals("CipherValue") || tName.equals("EncryptionProperty")) {
            this.m_sbCollectChars = new StringBuffer();
        }
        if (tName.equals("EncryptedData")) {
            str2 = this.findAtributeValue(attrs, "xmlns");
            try {
                this.m_doc = new EncryptedData(str2);
                str2 = this.findAtributeValue(attrs, "Id");
                if (str2 != null) {
                    this.m_doc.setId(str2);
                }
                if ((str2 = this.findAtributeValue(attrs, "Type")) != null) {
                    this.m_doc.setType(str2);
                }
                if ((str2 = this.findAtributeValue(attrs, "MimeType")) != null) {
                    this.m_doc.setMimeType(str2);
                }
            }
            catch (DigiDocException ex) {
                SAXDigiDocException.handleException(ex);
            }
        }
        if (tName.equals("EncryptionMethod")) {
            this.checkEncryptedData();
            if (this.m_tags.search("EncryptedKey") != -1) {
                ekey = this.m_doc.getLastEncryptedKey();
                this.checkEncryptedKey(ekey);
                try {
                    ekey.setEncryptionMethod(this.findAtributeValue(attrs, "Algorithm"));
                }
                catch (DigiDocException ex) {
                    SAXDigiDocException.handleException(ex);
                }
            } else {
                try {
                    this.m_doc.setEncryptionMethod(this.findAtributeValue(attrs, "Algorithm"));
                }
                catch (DigiDocException ex) {
                    SAXDigiDocException.handleException(ex);
                }
            }
        }
        if (tName.equals("EncryptedKey")) {
            this.checkEncryptedData();
            ekey = new EncryptedKey();
            this.m_doc.addEncryptedKey(ekey);
            str = this.findAtributeValue(attrs, "Recipient");
            if (str != null) {
                ekey.setRecipient(str);
            }
            if ((str = this.findAtributeValue(attrs, "Id")) != null) {
                ekey.setId(str);
            }
        }
        if (tName.equals("EncryptionProperties")) {
            this.checkEncryptedData();
            str2 = this.findAtributeValue(attrs, "Id");
            if (str2 != null) {
                this.m_doc.setEncryptionPropertiesId(str2);
            }
        }
        if (tName.equals("EncryptionProperty")) {
            this.checkEncryptedData();
            EncryptionProperty eprop = new EncryptionProperty();
            this.m_doc.addProperty(eprop);
            str = this.findAtributeValue(attrs, "Id");
            if (str != null) {
                eprop.setId(str);
            }
            if ((str = this.findAtributeValue(attrs, "Target")) != null) {
                eprop.setTarget(str);
            }
            str = this.findAtributeValue(attrs, "Name");
            try {
                if (str != null) {
                    eprop.setName(str);
                }
            }
            catch (DigiDocException ex) {
                SAXDigiDocException.handleException(ex);
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        EncryptedKey ekey;
        String tName = qName;
        if (tName.indexOf(":") != -1) {
            tName = qName.substring(tName.indexOf(":") + 1);
        }
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug((Object)("End Element: " + tName));
        }
        String currTag = (String)this.m_tags.pop();
        if (tName.equals("KeyName")) {
            this.checkEncryptedData();
            ekey = this.m_doc.getLastEncryptedKey();
            this.checkEncryptedKey(ekey);
            ekey.setKeyName(this.m_sbCollectChars.toString());
            this.m_sbCollectChars = null;
        }
        if (tName.equals("CarriedKeyName")) {
            this.checkEncryptedData();
            ekey = this.m_doc.getLastEncryptedKey();
            this.checkEncryptedKey(ekey);
            ekey.setCarriedKeyName(this.m_sbCollectChars.toString());
            this.m_sbCollectChars = null;
        }
        if (tName.equals("X509Certificate")) {
            this.checkEncryptedData();
            ekey = this.m_doc.getLastEncryptedKey();
            this.checkEncryptedKey(ekey);
            try {
                X509Certificate cert = SignedDoc.readCertificate(Base64Util.decode(this.m_sbCollectChars.toString().getBytes()));
                ekey.setRecipientsCertificate(cert);
            }
            catch (DigiDocException ex) {
                SAXDigiDocException.handleException(ex);
            }
            this.m_sbCollectChars = null;
        }
        if (tName.equals("CipherValue")) {
            this.checkEncryptedData();
            if (this.m_tags.search("EncryptedKey") != -1) {
                ekey = this.m_doc.getLastEncryptedKey();
                this.checkEncryptedKey(ekey);
                ekey.setTransportKeyData(Base64Util.decode(this.m_sbCollectChars.toString().getBytes()));
            } else {
                this.m_doc.setData(Base64Util.decode(this.m_sbCollectChars.toString().getBytes()));
                if (this.m_doc.getMimeType() != null && this.m_doc.getMimeType().equals("http://www.isi.edu/in-noes/iana/assignments/media-types/application/zip")) {
                    this.m_doc.setDataStatus(4);
                } else {
                    this.m_doc.setDataStatus(3);
                }
            }
            this.m_sbCollectChars = null;
        }
        if (tName.equals("EncryptionProperty")) {
            this.checkEncryptedData();
            EncryptionProperty eprop = this.m_doc.getLastProperty();
            try {
                if (eprop != null && this.m_sbCollectChars != null) {
                    eprop.setContent(this.m_sbCollectChars.toString());
                }
            }
            catch (DigiDocException ex) {
                SAXDigiDocException.handleException(ex);
            }
            this.m_sbCollectChars = null;
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
        if (s != null && this.m_sbCollectChars != null) {
            this.m_sbCollectChars.append(s);
        }
    }
}

