/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.xmlenc.factory;

import ee.sk.digidoc.Base64Util;
import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.SignedDoc;
import ee.sk.digidoc.TokenKeyInfo;
import ee.sk.digidoc.factory.PKCS11SignatureFactory;
import ee.sk.digidoc.factory.Pkcs12SignatureFactory;
import ee.sk.digidoc.factory.SAXDigiDocException;
import ee.sk.digidoc.factory.SignatureFactory;
import ee.sk.utils.ConfigManager;
import ee.sk.xmlenc.EncryptedData;
import ee.sk.xmlenc.EncryptedKey;
import ee.sk.xmlenc.EncryptionProperty;
import ee.sk.xmlenc.factory.EncryptedStreamParser;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Stack;
import java.util.zip.Inflater;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EncryptedStreamSAXParser
extends DefaultHandler
implements EncryptedStreamParser {
    private Stack m_tags = new Stack();
    private EncryptedData m_doc = null;
    private StringBuffer m_sbCollectChars = null;
    private TokenKeyInfo m_tki;
    private Logger m_logger = Logger.getLogger(EncryptedStreamSAXParser.class);
    private int m_totalDecrypted = 0;
    private int m_totalDecompressed = 0;
    private int m_totalInput = 0;
    private OutputStream m_outStream = null;
    private String m_recvName = null;
    private String m_pin = null;
    private int m_token = 0;
    private byte[] m_transpkey = null;
    private Cipher m_cipher = null;
    private boolean m_bDecrypting = false;
    private Inflater m_decompressor = null;
    private StringBuffer m_sbParseBuf;
    private StringBuffer m_sbB64Buf;
    private static final int ENC_BLOCK_SIZE = 256;
    private X509Certificate m_decCert = null;
    private SecretKey m_transportKey = null;
    private int m_nBlockType;
    private static int DENC_BLOCK_FIRST = 1;
    private static int DENC_BLOCK_MIDDLE = 2;
    private static int DENC_BLOCK_LAST = 3;
    private SignatureFactory m_sigFac = null;
    private byte[] m_lblock = null;
    private static final int DECBLOCK_SIZE = 8192;

    @Override
    public void init() throws DigiDocException {
        try {
            Provider prv = (Provider)Class.forName(ConfigManager.instance().getProperty("DIGIDOC_SECURITY_PROVIDER")).newInstance();
            Security.addProvider(prv);
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 67);
        }
    }

    public void setRecipientName(String s) {
        this.m_recvName = s;
    }

    public void setOutputStream(OutputStream outs) {
        this.m_outStream = outs;
    }

    public void setPin(String pin) {
        this.m_pin = pin;
    }

    public void setToken(int tok) {
        this.m_token = tok;
    }

    @Override
    public EncryptedData getCdoc() {
        return this.m_doc;
    }

    @Override
    public int decryptStreamUsingRecipientName(InputStream dencStream, OutputStream outs, int token, String pin, String recipientName) throws DigiDocException {
        EncryptedStreamSAXParser handler = this;
        handler.setRecipientName(recipientName);
        handler.setOutputStream(outs);
        handler.setPin(pin);
        handler.setToken(token);
        try {
            this.m_sigFac = ConfigManager.instance().getSignatureFactory();
            this.m_decCert = this.m_sigFac.getAuthCertificate(token, pin);
        }
        catch (Exception ex) {
            throw new DigiDocException(13, "Error loading decryption cert!", null);
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(dencStream, (DefaultHandler)handler);
        }
        catch (SAXDigiDocException ex) {
            throw ex.getDigiDocException();
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 75);
        }
        if (this.m_doc == null) {
            throw new DigiDocException(13, "This document is not in EncryptedData format", null);
        }
        return this.m_totalDecrypted;
    }

    @Override
    public int decryptStreamUsingRecipientSlotIdAndTokenLabel(InputStream dencStream, OutputStream outs, int slot, String label, String pin) throws DigiDocException {
        EncryptedStreamSAXParser handler = this;
        handler.setOutputStream(outs);
        handler.setPin(pin);
        ConfigManager cfg = ConfigManager.instance();
        PKCS11SignatureFactory p11SigFac = null;
        SignatureFactory sigFac = cfg.getSignatureFactory();
        p11SigFac = sigFac instanceof PKCS11SignatureFactory ? (PKCS11SignatureFactory)sigFac : (PKCS11SignatureFactory)cfg.getSignatureFactoryOfType("PKCS11");
        if (p11SigFac == null) {
            this.m_logger.error((Object)"No PKCS11 signature factory");
            return 0;
        }
        this.m_sigFac = p11SigFac;
        TokenKeyInfo tki = p11SigFac.getTokenWithSlotIdAndLabel(slot, label);
        if (tki == null) {
            this.m_logger.error((Object)("No token with slot: " + slot + " and label: " + label));
            return 0;
        }
        if (tki != null && !tki.isEncryptKey()) {
            this.m_logger.error((Object)("Token with slot: " + slot + " and label: " + label + " is not an encryption key!"));
            return 0;
        }
        this.m_decCert = tki.getCert();
        this.m_tki = tki;
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug((Object)("Decrypt with slot: " + slot + " label: " + label + " token: " + (this.m_tki != null ? "OK" : "NULL") + " cert: " + (this.m_decCert != null ? "OK" : "NULL")));
        }
        if (this.m_decCert == null) {
            throw new DigiDocException(13, "Error loading decryption cert!", null);
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(dencStream, (DefaultHandler)handler);
        }
        catch (SAXDigiDocException ex) {
            throw ex.getDigiDocException();
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 75);
        }
        if (this.m_doc == null) {
            throw new DigiDocException(13, "This document is not in EncryptedData format", null);
        }
        return this.m_totalDecrypted;
    }

    @Override
    public int decryptStreamUsingTokenType(InputStream dencStream, OutputStream outs, int token, String pin, String tokenType, String pkcs12Keystore) throws DigiDocException {
        EncryptedStreamSAXParser handler = this;
        handler.setOutputStream(outs);
        handler.setPin(pin);
        handler.setToken(token);
        if (tokenType == null || !tokenType.equals("PKCS11") && !tokenType.equals("PKCS12")) {
            throw new DigiDocException(111, "Invalid token type. Must be PKCS11 or PKCS12!", null);
        }
        try {
            this.m_sigFac = ConfigManager.instance().getSignatureFactoryOfType(tokenType);
            if (this.m_sigFac != null && this.m_sigFac instanceof Pkcs12SignatureFactory) {
                Pkcs12SignatureFactory pfac = (Pkcs12SignatureFactory)this.m_sigFac;
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Loading pkcs12 keystore: " + pkcs12Keystore));
                }
                pfac.load(pkcs12Keystore, tokenType, pin);
            }
            if (this.m_sigFac != null) {
                this.m_decCert = this.m_sigFac.getAuthCertificate(token, pin);
            }
        }
        catch (Exception ex) {
            this.m_logger.error((Object)("Error loading decryption cert: " + ex));
            throw new DigiDocException(111, "Error loading decryption cert!", ex);
        }
        if (this.m_decCert == null) {
            throw new DigiDocException(111, "Error loading decryption cert!", null);
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(dencStream, (DefaultHandler)handler);
        }
        catch (SAXDigiDocException ex) {
            throw ex.getDigiDocException();
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 75);
        }
        if (this.m_doc == null) {
            throw new DigiDocException(13, "This document is not in EncryptedData format", null);
        }
        return this.m_totalDecrypted;
    }

    @Override
    public int decryptStreamUsingRecipientNameAndKey(InputStream dencStream, OutputStream outs, byte[] deckey, String recipientName) throws DigiDocException {
        EncryptedStreamSAXParser handler = this;
        handler.setRecipientName(recipientName);
        handler.setOutputStream(outs);
        this.m_transpkey = deckey;
        this.m_transportKey = new SecretKeySpec(this.m_transpkey, "AES/CBC/NOPadding");
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug((Object)("Transport key: " + (this.m_transportKey == null ? "ERROR" : "OK") + " len: " + this.m_transpkey.length));
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(dencStream, (DefaultHandler)handler);
        }
        catch (SAXDigiDocException ex) {
            throw ex.getDigiDocException();
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 75);
        }
        if (this.m_doc == null) {
            throw new DigiDocException(13, "This document is not in EncryptedData format", null);
        }
        return this.m_totalDecrypted;
    }

    @Override
    public void startDocument() throws SAXException {
        this.m_doc = null;
        this.m_sbCollectChars = null;
        this.m_decompressor = null;
        this.m_totalDecrypted = 0;
        this.m_totalDecompressed = 0;
        this.m_totalInput = 0;
        this.m_sbParseBuf = new StringBuffer();
        this.m_sbB64Buf = new StringBuffer();
        this.m_nBlockType = DENC_BLOCK_FIRST;
    }

    @Override
    public void endDocument() throws SAXException {
    }

    private String findAtributeValue(Attributes attrs, String attName) {
        String value = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            String key = attrs.getQName(i);
            if (!key.equals(attName) && key.indexOf(attName) == -1) continue;
            value = attrs.getValue(i);
            break;
        }
        return value;
    }

    private void checkEncryptedData() throws SAXDigiDocException {
        if (this.m_doc == null) {
            throw new SAXDigiDocException(27, "This document is not in EncryptedData format!");
        }
    }

    private void checkEncryptedKey(EncryptedKey key) throws SAXDigiDocException {
        if (key == null) {
            throw new SAXDigiDocException(106, "This <EncryptedKey> object does not exist!");
        }
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXDigiDocException {
        String str;
        EncryptedKey ekey;
        String str2;
        String tName = qName;
        if (tName.indexOf(":") != -1) {
            tName = qName.substring(qName.indexOf(":") + 1);
        }
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug((Object)("Start Element: " + tName + " qname: " + qName + " lname: " + lName + " uri: " + namespaceURI));
        }
        this.m_tags.push(tName);
        if (tName.equals("KeyName") || tName.equals("CarriedKeyName") || tName.equals("X509Certificate") || tName.equals("EncryptionProperty")) {
            this.m_sbCollectChars = new StringBuffer();
        }
        if (tName.equals("CipherValue")) {
            if (this.m_tags.search("EncryptedKey") != -1) {
                this.m_sbCollectChars = new StringBuffer();
            } else {
                this.m_sbCollectChars = null;
                this.m_bDecrypting = true;
            }
        }
        if (tName.equals("EncryptedData")) {
            str2 = this.findAtributeValue(attrs, "xmlns");
            try {
                this.m_doc = new EncryptedData(str2);
                str2 = this.findAtributeValue(attrs, "Id");
                if (str2 != null) {
                    this.m_doc.setId(str2);
                }
                if ((str2 = this.findAtributeValue(attrs, "Type")) != null) {
                    this.m_doc.setType(str2);
                }
                if ((str2 = this.findAtributeValue(attrs, "MimeType")) != null) {
                    this.m_doc.setMimeType(str2);
                }
                if (this.m_doc.getMimeType() != null && this.m_doc.getMimeType().equals("http://www.isi.edu/in-noes/iana/assignments/media-types/application/zip")) {
                    this.m_decompressor = new Inflater();
                }
            }
            catch (DigiDocException ex) {
                SAXDigiDocException.handleException(ex);
            }
            try {
                if (this.m_transportKey != null) {
                    byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                    this.m_cipher = this.m_doc.getCipher(2, this.m_transportKey, iv);
                }
            }
            catch (DigiDocException ex) {
                this.m_logger.error((Object)("Error using key: " + (this.m_transpkey != null ? Base64Util.encode(this.m_transpkey) : "NULL") + " - " + ex));
                SAXDigiDocException.handleException(ex);
            }
        }
        if (tName.equals("EncryptionMethod")) {
            this.checkEncryptedData();
            if (this.m_tags.search("EncryptedKey") != -1) {
                ekey = this.m_doc.getLastEncryptedKey();
                this.checkEncryptedKey(ekey);
                try {
                    ekey.setEncryptionMethod(this.findAtributeValue(attrs, "Algorithm"));
                }
                catch (DigiDocException ex) {
                    SAXDigiDocException.handleException(ex);
                }
            } else {
                try {
                    this.m_doc.setEncryptionMethod(this.findAtributeValue(attrs, "Algorithm"));
                }
                catch (DigiDocException ex) {
                    SAXDigiDocException.handleException(ex);
                }
            }
        }
        if (tName.equals("EncryptedKey")) {
            this.checkEncryptedData();
            ekey = new EncryptedKey();
            this.m_doc.addEncryptedKey(ekey);
            str = this.findAtributeValue(attrs, "Recipient");
            if (str != null) {
                ekey.setRecipient(str);
            }
            if ((str = this.findAtributeValue(attrs, "Id")) != null) {
                ekey.setId(str);
            }
        }
        if (tName.equals("EncryptionProperties")) {
            this.checkEncryptedData();
            str2 = this.findAtributeValue(attrs, "Id");
            if (str2 != null) {
                this.m_doc.setEncryptionPropertiesId(str2);
            }
        }
        if (tName.equals("EncryptionProperty")) {
            this.checkEncryptedData();
            EncryptionProperty eprop = new EncryptionProperty();
            this.m_doc.addProperty(eprop);
            str = this.findAtributeValue(attrs, "Id");
            if (str != null) {
                eprop.setId(str);
            }
            if ((str = this.findAtributeValue(attrs, "Target")) != null) {
                eprop.setTarget(str);
            }
            str = this.findAtributeValue(attrs, "Name");
            try {
                if (str != null) {
                    eprop.setName(str);
                }
            }
            catch (DigiDocException ex) {
                SAXDigiDocException.handleException(ex);
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        EncryptedKey ekey;
        String tName = qName;
        if (tName.indexOf(":") != -1) {
            tName = qName.substring(tName.indexOf(":") + 1);
        }
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug((Object)("End Element: " + tName));
        }
        String currTag = (String)this.m_tags.pop();
        if (tName.equals("KeyName")) {
            this.checkEncryptedData();
            ekey = this.m_doc.getLastEncryptedKey();
            this.checkEncryptedKey(ekey);
            ekey.setKeyName(this.m_sbCollectChars.toString());
            this.m_sbCollectChars = null;
        }
        if (tName.equals("CarriedKeyName")) {
            this.checkEncryptedData();
            ekey = this.m_doc.getLastEncryptedKey();
            this.checkEncryptedKey(ekey);
            ekey.setCarriedKeyName(this.m_sbCollectChars.toString());
            this.m_sbCollectChars = null;
        }
        if (tName.equals("X509Certificate")) {
            this.checkEncryptedData();
            ekey = this.m_doc.getLastEncryptedKey();
            this.checkEncryptedKey(ekey);
            try {
                X509Certificate cert = SignedDoc.readCertificate(Base64Util.decode(this.m_sbCollectChars.toString().getBytes()));
                ekey.setRecipientsCertificate(cert);
            }
            catch (DigiDocException ex) {
                SAXDigiDocException.handleException(ex);
            }
            this.m_sbCollectChars = null;
        }
        if (tName.equals("CipherValue")) {
            this.checkEncryptedData();
            if (this.m_tags.search("EncryptedKey") != -1) {
                if (this.m_cipher == null) {
                    ekey = this.m_doc.getLastEncryptedKey();
                    this.checkEncryptedKey(ekey);
                    ekey.setTransportKeyData(Base64Util.decode(this.m_sbCollectChars.toString().getBytes()));
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("Recipient: " + ekey.getRecipient() + " cert-nr: " + ekey.getRecipientsCertificate().getSerialNumber() + " decrypt-cert: " + this.m_decCert.getSerialNumber()));
                    }
                    if (this.m_decCert != null && ekey.getRecipientsCertificate() != null && this.m_decCert.getSerialNumber().equals(ekey.getRecipientsCertificate().getSerialNumber())) {
                        byte[] decdata = null;
                        if (this.m_sigFac == null) {
                            DigiDocException ex2 = new DigiDocException(108, "SignatureFactory not initialized!", null);
                            SAXDigiDocException.handleException(ex2);
                        }
                        try {
                            if (this.m_logger.isDebugEnabled()) {
                                this.m_logger.debug((Object)("Decrypting key: " + this.m_recvName + " serial: " + this.m_decCert.getSerialNumber()));
                            }
                            decdata = this.m_transpkey != null ? this.m_transpkey : (this.m_tki != null ? ((PKCS11SignatureFactory)this.m_sigFac).decrypt(ekey.getTransportKeyData(), this.m_tki.getSlot(), this.m_tki.getLabel(), this.m_pin) : this.m_sigFac.decrypt(ekey.getTransportKeyData(), this.m_token, this.m_pin));
                            if (this.m_logger.isDebugEnabled()) {
                                this.m_logger.debug((Object)("Using key: " + this.m_recvName + " decdata: " + Base64Util.encode(decdata)));
                            }
                            this.m_transportKey = new SecretKeySpec(decdata, "AES/CBC/NOPadding");
                            byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                            this.m_cipher = this.m_doc.getCipher(2, this.m_transportKey, iv);
                            if (this.m_logger.isDebugEnabled()) {
                                this.m_logger.debug((Object)("Transport key: " + (this.m_transportKey == null ? "ERROR" : "OK") + " len: " + decdata.length));
                            }
                        }
                        catch (DigiDocException ex) {
                            this.m_logger.error((Object)("Error decrypting key1: " + (decdata != null ? Base64Util.encode(decdata) : "NULL") + " - " + ex));
                            SAXDigiDocException.handleException(ex);
                        }
                        catch (Exception ex) {
                            this.m_logger.error((Object)("Error decrypting key2: " + (decdata != null ? Base64Util.encode(decdata) : "NULL") + " - " + ex));
                            DigiDocException ex2 = new DigiDocException(108, ex.getMessage(), ex);
                            SAXDigiDocException.handleException(ex2);
                        }
                    }
                }
            } else {
                this.m_bDecrypting = false;
                this.decryptBlock(null, DENC_BLOCK_LAST);
                if (this.m_logger.isInfoEnabled()) {
                    this.m_logger.info((Object)("Total input: " + this.m_totalInput + " decrypted: " + this.m_totalDecrypted + " decompressed: " + this.m_totalDecompressed));
                }
            }
            this.m_sbCollectChars = null;
        }
        if (tName.equals("EncryptionProperty")) {
            this.checkEncryptedData();
            EncryptionProperty eprop = this.m_doc.getLastProperty();
            try {
                if (eprop != null && this.m_sbCollectChars != null) {
                    eprop.setContent(this.m_sbCollectChars.toString());
                }
            }
            catch (DigiDocException ex) {
                SAXDigiDocException.handleException(ex);
            }
            this.m_sbCollectChars = null;
        }
    }

    private void decryptBlock(String data, int nBlockType) throws SAXException {
        if (data != null && data.length() > 0) {
            this.m_sbParseBuf.append(data);
        }
        String indata = null;
        if (nBlockType == DENC_BLOCK_LAST) {
            indata = this.m_sbParseBuf.toString();
        } else if (this.m_sbParseBuf.length() > 256) {
            indata = this.m_sbParseBuf.substring(0, 256);
            this.m_sbParseBuf.delete(0, 256);
        }
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug((Object)("IN " + (data != null ? data.length() : 0) + " input: " + (indata != null ? indata.length() : 0) + " buffered: " + (this.m_sbParseBuf != null ? this.m_sbParseBuf.length() : 0) + " b64left: " + (this.m_sbB64Buf != null ? this.m_sbB64Buf.length() : 0) + " block-type: " + nBlockType));
        }
        if (this.m_cipher == null) {
            DigiDocException de = new DigiDocException(111, "Cipher has not been initialized! No transport key for selected recipient?", null);
            SAXDigiDocException.handleException(de);
        }
        if (indata != null) {
            this.m_sbB64Buf.append(indata);
            this.m_totalInput += indata.length();
        } else {
            return;
        }
        try {
            byte[] encdata = null;
            byte[] decdata = null;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int nUsed = 0;
            if (this.m_sbB64Buf.length() > 0) {
                nUsed = Base64Util.decodeBlock(this.m_sbB64Buf.toString(), bos, nBlockType == DENC_BLOCK_LAST);
                encdata = bos.toByteArray();
                if (nBlockType == DENC_BLOCK_FIRST && encdata != null && encdata.length > 16) {
                    byte[] b1 = new byte[encdata.length - 16];
                    System.arraycopy(encdata, 16, b1, 0, b1.length);
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("Removed IV from: " + encdata.length + " block1, left: " + b1.length));
                    }
                    encdata = b1;
                }
                bos = null;
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Decoding: " + this.m_sbB64Buf.length() + " got: " + (encdata != null ? encdata.length : 0) + " last: " + (nBlockType == DENC_BLOCK_LAST)));
                }
                if (nUsed > 0) {
                    this.m_sbB64Buf.delete(0, nUsed);
                }
            }
            decdata = this.m_cipher.update(encdata);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Decrypted input: " + indata.length() + " decoded: " + (encdata != null ? encdata.length : 0) + " decrypted: " + (decdata != null ? decdata.length : 0)));
            }
            if (this.m_totalDecrypted == 0 && decdata != null && decdata.length > 16) {
                byte[] ddata = new byte[decdata.length - 16];
                System.arraycopy(decdata, 16, ddata, 0, decdata.length - 16);
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Removing IV data from: " + decdata.length + " remaining: " + ddata.length));
                }
                decdata = ddata;
            }
            if (nBlockType == DENC_BLOCK_LAST) {
                int n1 = this.m_lblock != null ? this.m_lblock.length : 0;
                int n2 = decdata != null ? decdata.length : 0;
                byte[] ddata = new byte[n1 + n2];
                if (n1 > 0) {
                    System.arraycopy(this.m_lblock, 0, ddata, 0, n1);
                }
                if (n2 > 0) {
                    System.arraycopy(decdata, 0, ddata, n1, n2);
                }
                decdata = ddata;
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Last block: " + decdata.length));
                }
                this.m_lblock = null;
            }
            if (decdata != null && encdata != null && nBlockType == DENC_BLOCK_LAST) {
                boolean bPadOk;
                int nPadLen = new Integer(decdata[decdata.length - 1]);
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Check padding 1: " + nPadLen));
                }
                if (bPadOk = this.checkPadding(decdata, nPadLen)) {
                    decdata = this.removePadding(decdata, nPadLen);
                }
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Decdata remaining: " + (decdata != null ? decdata.length : 0)));
                }
                if (decdata != null && decdata.length > 0) {
                    nPadLen = new Integer(decdata[decdata.length - 1]);
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("Check padding 2: " + nPadLen));
                    }
                    if (nPadLen > 0 && nPadLen <= 16 && decdata.length > nPadLen && (bPadOk = this.checkPadding(decdata, nPadLen))) {
                        decdata = this.removePadding(decdata, nPadLen);
                    }
                } else if (this.m_lblock != null) {
                    nPadLen = new Integer(this.m_lblock[this.m_lblock.length - 1]);
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("Check padding 3: " + nPadLen));
                    }
                    if (nPadLen > 0 && nPadLen <= 16 && this.m_lblock.length > nPadLen && (bPadOk = this.checkPadding(this.m_lblock, nPadLen))) {
                        this.m_lblock = this.removePadding(this.m_lblock, nPadLen);
                    }
                }
            }
            if (this.m_lblock != null || decdata != null) {
                if (this.m_decompressor != null) {
                    if (nBlockType == DENC_BLOCK_LAST) {
                        this.m_lblock = decdata;
                    }
                    int nDecomp = 0;
                    byte[] m_decbuf = null;
                    if (this.m_lblock != null) {
                        if (this.m_logger.isDebugEnabled()) {
                            this.m_logger.debug((Object)("Decompressing: " + this.m_lblock.length));
                        }
                        this.m_decompressor.setInput(this.m_lblock);
                        m_decbuf = new byte[8192];
                        if (this.m_logger.isDebugEnabled()) {
                            this.m_logger.debug((Object)("Decompressing: " + this.m_lblock.length + " into: " + m_decbuf.length));
                        }
                        while ((nDecomp = this.m_decompressor.inflate(m_decbuf)) > 0) {
                            if (this.m_logger.isDebugEnabled()) {
                                this.m_logger.debug((Object)("Decompressed: " + this.m_lblock.length + " into: " + m_decbuf.length + " got: " + nDecomp));
                            }
                            this.m_outStream.write(m_decbuf, 0, nDecomp);
                            this.m_totalDecompressed += nDecomp;
                        }
                    }
                    if (!(nBlockType != DENC_BLOCK_LAST || this.m_decompressor.finished() && this.m_decompressor.getRemaining() <= 0)) {
                        if (this.m_logger.isDebugEnabled()) {
                            this.m_logger.debug((Object)("Decompressor finished: " + this.m_decompressor.finished() + " remaining: " + this.m_decompressor.getRemaining()));
                        }
                        m_decbuf = new byte[8192];
                        while ((nDecomp = this.m_decompressor.inflate(m_decbuf)) > 0) {
                            this.m_outStream.write(m_decbuf, 0, nDecomp);
                            this.m_totalDecompressed += nDecomp;
                            if (!this.m_logger.isDebugEnabled()) continue;
                            this.m_logger.debug((Object)("Decompressing final: " + nDecomp));
                        }
                    }
                } else {
                    if (this.m_lblock != null) {
                        this.m_outStream.write(this.m_lblock);
                    }
                    if (nBlockType == DENC_BLOCK_LAST && decdata != null) {
                        this.m_outStream.write(decdata);
                    }
                }
                this.m_totalDecrypted += decdata.length;
            }
            this.m_lblock = decdata;
        }
        catch (Exception ex) {
            DigiDocException de = new DigiDocException(111, "Error decrypting: " + ex, ex);
            SAXDigiDocException.handleException(de);
        }
    }

    private boolean checkPadding(byte[] data, int nPadLen) {
        boolean bPadOk = true;
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug((Object)("Checking padding: " + nPadLen + " bytes"));
        }
        if (nPadLen < 0 || nPadLen > 16 || data == null || data.length < nPadLen) {
            return false;
        }
        for (int i = data.length - nPadLen; nPadLen > 0 && i < data.length - 1; ++i) {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Data at: " + i + " = " + data[i]));
            }
            if ((data[i] == 0 || nPadLen == 16) && (nPadLen != 16 || data[i] == 16 || data[i] == 0)) continue;
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Data at: " + i + " = " + data[i] + " cancel padding"));
            }
            bPadOk = false;
            break;
        }
        return bPadOk;
    }

    private byte[] removePadding(byte[] data, int nPadLen) {
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug((Object)("Removing padding: " + nPadLen + " bytes"));
        }
        if (nPadLen < 0 || nPadLen > 16 || data == null || data.length < nPadLen) {
            return data;
        }
        byte[] data2 = new byte[data.length - nPadLen];
        System.arraycopy(data, 0, data2, 0, data.length - nPadLen);
        return data2;
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
        if (s != null) {
            if (this.m_sbCollectChars != null) {
                this.m_sbCollectChars.append(s);
            }
            if (this.m_bDecrypting) {
                this.decryptBlock(s, this.m_nBlockType);
                if (this.m_nBlockType == DENC_BLOCK_FIRST) {
                    this.m_nBlockType = DENC_BLOCK_MIDDLE;
                }
            }
        }
    }
}

