/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.signers;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.util.tree.AOTreeModel;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;

public final class AOPkcs1Signer
implements AOSigner {
    private static final String PKCS1_FILE_SUFFIX = ".p1";
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    @Override
    public byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        byte[] byArray2;
        block15: {
            Provider provider;
            Object object;
            if (string == null) {
                throw new IllegalArgumentException("Es necesario indicar el algoritmo de firma, no puede ser nulo");
            }
            LOGGER.info("Se ha solicitado una firma '" + string + "' con una clave de tipo " + privateKey.getAlgorithm());
            if (properties != null) {
                object = properties.getProperty("Provider." + privateKey.getClass().getName());
                provider = Security.getProvider((String)object);
            } else {
                provider = null;
            }
            try {
                object = provider != null ? Signature.getInstance(string, provider) : Signature.getInstance(string);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new AOException("No se soporta el algoritmo de firma (" + string + "): " + noSuchAlgorithmException, noSuchAlgorithmException);
            }
            try {
                ((Signature)object).initSign(privateKey);
            }
            catch (Exception exception) {
                throw new AOException("Error al inicializar la firma con la clave privada para el algoritmo '" + string + "': " + exception, exception);
            }
            try {
                ((Signature)object).update(byArray);
            }
            catch (Exception exception) {
                throw new AOException("Error al configurar los datos a firmar: " + exception, exception);
            }
            try {
                byArray2 = ((Signature)object).sign();
            }
            catch (Exception exception) {
                throw new AOException("Error durante el proceso de firma PKCS#1: " + exception, exception);
            }
            if (certificateArray != null && certificateArray.length > 0) {
                try {
                    Signature signature = Signature.getInstance(string);
                    signature.initVerify(certificateArray[0].getPublicKey());
                    signature.update(byArray);
                    if (!signature.verify(byArray2)) {
                        throw new AOException("El PKCS#1 de firma obtenido no se genero con el certificado indicado");
                    }
                    break block15;
                }
                catch (Exception exception) {
                    throw new AOException("Error al verificar el PKCS#1 de la firma", exception);
                }
            }
            LOGGER.warning("No se ha proporcionado el certificado para comprobar la integridad del PKCS#1");
        }
        return byArray2;
    }

    @Override
    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) {
        throw new UnsupportedOperationException("No se pueden hacer cofirmas en PKCS#1");
    }

    @Override
    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) {
        throw new UnsupportedOperationException("No se pueden hacer cofirmas en PKCS#1");
    }

    @Override
    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) {
        throw new UnsupportedOperationException("No se pueden hacer contrafirmas en PKCS#1");
    }

    @Override
    public AOTreeModel getSignersStructure(byte[] byArray, boolean bl) {
        throw new UnsupportedOperationException("No se puede obtener la estructura de firmantes en PKCS#1");
    }

    @Override
    public boolean isSign(byte[] byArray) {
        return false;
    }

    @Override
    public boolean isValidDataFile(byte[] byArray) {
        return byArray != null && byArray.length > 0;
    }

    @Override
    public String getSignedName(String string, String string2) {
        String string3;
        String string4 = string3 = string2 != null ? string2 : "";
        if (string == null) {
            return "signature.p1";
        }
        if (string.toLowerCase(Locale.US).endsWith(PKCS1_FILE_SUFFIX)) {
            return string.substring(0, string.length() - PKCS1_FILE_SUFFIX.length()) + string3 + PKCS1_FILE_SUFFIX;
        }
        return string + string3 + PKCS1_FILE_SUFFIX;
    }

    @Override
    public byte[] getData(byte[] byArray) {
        throw new UnsupportedOperationException("No se pueden obtener los datos firmados en PKCS#1");
    }

    @Override
    public AOSignInfo getSignInfo(byte[] byArray) {
        throw new UnsupportedOperationException("No se puede obtener informacion de las firmas PKCS#1");
    }
}

