/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.ui.core.jse;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.ui.AOUIManager;
import es.gob.afirma.core.ui.GenericFileFilter;
import es.gob.afirma.core.ui.KeyStoreDialogManager;
import es.gob.afirma.ui.core.jse.JSEUIMessages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class JSEUIManager
implements AOUIManager {
    protected static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final int ASCII_LOWER_INDEX = 32;
    private static final int ASCII_HIGHER_INDEX = 126;
    private static final Preferences preferences = Preferences.userNodeForPackage(JSEUIManager.class);
    public static final String PREFERENCE_DIRECTORY = "currentDir";

    public static String get(String string, String string2) {
        return preferences.get(string, string2);
    }

    public static void put(String string, String string2) {
        preferences.put(string, string2);
    }

    public final char[] getPassword(String string, Object object) {
        return this.getPassword(string, null, null, false, object);
    }

    public final char[] getPassword(String string, Object object, String string2, boolean bl, Object object2) {
        final JPasswordField jPasswordField = new JPasswordField(10);
        if (string2 != null) {
            jPasswordField.setDocument(new JTextFieldFilter(string2, bl));
        }
        JLabel jLabel = new JLabel(string != null ? string : JSEUIMessages.getString("JSEUIManager.24"));
        jLabel.setMinimumSize(new Dimension(jLabel.getFontMetrics(jLabel.getFont()).stringWidth(string), jLabel.getSize().height));
        jLabel.setLabelFor(jPasswordField);
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 10;
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jPasswordField, gridBagConstraints);
        Icon icon = object instanceof Icon ? (Icon)object : null;
        JOptionPane jOptionPane = new JOptionPane(jPanel, 3, 2, icon){
            private static final long serialVersionUID = -3012522768561175760L;

            @Override
            public void selectInitialValue() {
                jPasswordField.requestFocusInWindow();
            }
        };
        Component component = object2 instanceof Component ? (Component)object2 : null;
        JDialog jDialog = jOptionPane.createDialog(component, JSEUIMessages.getString("JSEUIManager.24"));
        jDialog.setVisible(true);
        Object object3 = jOptionPane.getValue();
        if (object3 == null) {
            throw new AOCancelledOperationException("La insercion de contrasena ha sido cancelada por el usuario");
        }
        if ((Integer)object3 == 0) {
            return jPasswordField.getPassword();
        }
        throw new AOCancelledOperationException("La insercion de contrasena ha sido cancelada por el usuario");
    }

    public final char[] getDoublePassword(String string, String string2, Object object, String string3, boolean bl, Object object2) {
        final JPasswordField jPasswordField = new JPasswordField(10);
        if (string3 != null) {
            jPasswordField.setDocument(new JTextFieldFilter(string3, bl));
        }
        JLabel jLabel = new JLabel(string != null ? string : JSEUIMessages.getString("JSEUIManager.24"));
        jLabel.setMinimumSize(new Dimension(jLabel.getFontMetrics(jLabel.getFont()).stringWidth(string != null ? string : JSEUIMessages.getString("JSEUIManager.24")), jLabel.getSize().height));
        jLabel.setLabelFor(jPasswordField);
        final JPasswordField jPasswordField2 = new JPasswordField(10);
        if (string3 != null) {
            jPasswordField2.setDocument(new JTextFieldFilter(string3, bl));
        }
        JLabel jLabel2 = new JLabel(string2 != null ? string2 : JSEUIMessages.getString("JSEUIManager.2"));
        jLabel2.setMinimumSize(new Dimension(jLabel2.getFontMetrics(jLabel2.getFont()).stringWidth(string2 != null ? string2 : JSEUIMessages.getString("JSEUIManager.2")), jLabel2.getSize().height));
        jLabel2.setLabelFor(jPasswordField2);
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 10;
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jPasswordField, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)jPasswordField2, gridBagConstraints);
        Icon icon = object instanceof Icon ? (Icon)object : null;
        final JButton jButton = new JButton(JSEUIMessages.getString("JSEUIManager.3"));
        jButton.getAccessibleContext().setAccessibleDescription(JSEUIMessages.getString("JSEUIManager.4"));
        jButton.setEnabled(false);
        JButton jButton2 = new JButton(JSEUIMessages.getString("JSEUIManager.5"));
        jButton2.getAccessibleContext().setAccessibleDescription(JSEUIMessages.getString("JSEUIManager.6"));
        DocumentListener documentListener = new DocumentListener(){

            private void something() {
                if (jPasswordField.getPassword() != null && jPasswordField.getPassword().length > 1 && Arrays.equals(jPasswordField.getPassword(), jPasswordField2.getPassword())) {
                    jButton.setEnabled(true);
                } else {
                    jButton.setEnabled(false);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.something();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.something();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.something();
            }
        };
        jPasswordField.getDocument().addDocumentListener(documentListener);
        jPasswordField2.getDocument().addDocumentListener(documentListener);
        final JOptionPane jOptionPane = new JOptionPane(jPanel, 3, 2, icon, new Object[]{jButton, jButton2}, jButton){
            private static final long serialVersionUID = -3012522768561175760L;

            @Override
            public void selectInitialValue() {
                jPasswordField.requestFocusInWindow();
            }
        };
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jOptionPane.setValue(0);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jOptionPane.setValue(2);
            }
        });
        Component component = object2 instanceof Component ? (Component)object2 : null;
        JDialog jDialog = jOptionPane.createDialog(component, JSEUIMessages.getString("JSEUIManager.24"));
        jDialog.setVisible(true);
        Object object3 = jOptionPane.getValue();
        if (object3 == null) {
            return new char[0];
        }
        if ((Integer)object3 == 0) {
            return jPasswordField.getPassword();
        }
        throw new AOCancelledOperationException("La insercion de contrasena ha sido cancelada por el usuario");
    }

    public final Object showInputDialog(Object object, Object object2, String string, int n, Object object3, Object[] objectArray, Object object4) {
        Icon icon;
        Component component = object instanceof Component ? (Component)object : null;
        Icon icon2 = icon = object3 instanceof Icon ? (Icon)object3 : null;
        if (objectArray == null) {
            return JOptionPane.showInputDialog(component, object2, string, n);
        }
        return JOptionPane.showInputDialog(component, object2, string, n, icon, objectArray, object4);
    }

    public final String showCertificateSelectionDialog(Object object, KeyStoreDialogManager keyStoreDialogManager) {
        Component component = object instanceof Component ? (Component)object : null;
        try {
            Class<?> clazz = Class.forName("es.gob.afirma.ui.core.jse.certificateselection.CertificateSelectionDialog");
            Constructor<?> constructor = clazz.getConstructor(Component.class, KeyStoreDialogManager.class);
            Object obj = constructor.newInstance(component, keyStoreDialogManager);
            Method method = clazz.getMethod("showDialog", new Class[0]);
            Object object2 = method.invoke(obj, new Object[0]);
            return object2 instanceof String ? (String)object2 : null;
        }
        catch (InvocationTargetException invocationTargetException) {
            LOGGER.severe("Se genero un error en el dialogo de seleccion de certificados: " + invocationTargetException);
            if (invocationTargetException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getCause();
            }
            throw new IllegalStateException("No se encontraron certificados en el almacen o se produjo un error durante la extraccion del certificado seleccionado: " + invocationTargetException, invocationTargetException.getCause());
        }
        catch (Exception exception) {
            LOGGER.severe("No se encuentra disponible el proyecto del interfaz grafico del dialogo de seleccion: " + exception);
            throw new IllegalStateException("No se encuentra disponible el proyecto del interfaz grafico del dialogo de seleccion u ocurrio un error durante su ejecucion: " + exception, exception);
        }
    }

    public final int showConfirmDialog(Object object, Object object2, String string, int n, int n2) {
        return JOptionPane.showConfirmDialog(object instanceof Component ? (Component)object : null, object2, string, n, n2);
    }

    public void showMessageDialog(Object object, Object object2, String string, int n) {
        JOptionPane.showMessageDialog(object instanceof Component ? (Component)object : null, object2, string, n);
    }

    public void showMessageDialog(Object object, Object object2, String string, int n, Object object3) {
        JOptionPane.showMessageDialog(object instanceof Component ? (Component)object : null, object2, string, n, object3 instanceof Icon ? (Icon)object3 : null);
    }

    public final int getPlainMessageCode() {
        return -1;
    }

    public final int getYesNoOptionCode() {
        return 0;
    }

    public final int getWarningMessageCode() {
        return 2;
    }

    public final int getYesOptionCode() {
        return 0;
    }

    public final int getNoOptionCode() {
        return 1;
    }

    public final int getOkCancelOptionCode() {
        return 2;
    }

    public final int getOkOptionCode() {
        return 0;
    }

    public final int getInformationMessageCode() {
        return 1;
    }

    public final int getErrorMessageCode() {
        return 0;
    }

    public final int getQuestionMessageCode() {
        return 3;
    }

    public File[] getLoadFiles(String string, String string2, String string3, String[] stringArray, String string4, boolean bl, boolean bl2, final Object object, Object object2) {
        int n;
        JFileChooser jFileChooser;
        Component component;
        Component component2 = component = object2 instanceof Component ? (Component)object2 : null;
        if (object instanceof Image) {
            jFileChooser = new JFileChooser(){
                private static final long serialVersionUID = 5631612687512882773L;

                @Override
                protected JDialog createDialog(Component component) {
                    JDialog jDialog = super.createDialog(component);
                    jDialog.setIconImage((Image)object);
                    return jDialog;
                }
            };
        } else {
            if (object != null) {
                LOGGER.warning("Se ha proporcionado un icono del tipo " + object.getClass().getName() + ", pero solo se admite Image");
            }
            jFileChooser = new JFileChooser();
        }
        if (bl) {
            jFileChooser.setFileSelectionMode(1);
        }
        JSEUIManager.configureDefaultDir(jFileChooser, string2, string3);
        jFileChooser.setMultiSelectionEnabled(bl2);
        if (string != null && string.length() > 0) {
            jFileChooser.setDialogTitle(string);
        }
        if (stringArray != null && stringArray.length > 0) {
            jFileChooser.setFileFilter(new FileNameExtensionFilter(string4, stringArray));
        }
        if ((n = jFileChooser.showOpenDialog(component)) == 0) {
            File[] fileArray = bl2 ? jFileChooser.getSelectedFiles() : new File[]{jFileChooser.getSelectedFile()};
            JSEUIManager.put(PREFERENCE_DIRECTORY, jFileChooser.getCurrentDirectory().getPath());
            return fileArray;
        }
        throw new AOCancelledOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File saveDataToFile(byte[] byArray, String string, String string2, String string3, List<GenericFileFilter> list, Object object) throws IOException {
        int n;
        Component component = object instanceof Component ? (Component)object : null;
        File file = null;
        boolean bl = true;
        block15: while (true) {
            if (!bl) {
                return file;
            }
            bl = false;
            CustomFileChooserForSave customFileChooserForSave = new CustomFileChooserForSave();
            customFileChooserForSave.getAccessibleContext().setAccessibleName(JSEUIMessages.getString("JSEUIManager.81"));
            customFileChooserForSave.getAccessibleContext().setAccessibleDescription(JSEUIMessages.getString("JSEUIManager.82"));
            customFileChooserForSave.setToolTipText(JSEUIMessages.getString("JSEUIManager.81"));
            if (string != null) {
                customFileChooserForSave.setDialogTitle(string);
            }
            if (list != null) {
                customFileChooserForSave.setAcceptAllFileFilterUsed(false);
                for (GenericFileFilter genericFileFilter : list) {
                    if (genericFileFilter.getExtensions() == null || genericFileFilter.getExtensions().length == 0) continue;
                    customFileChooserForSave.addChoosableFileFilter(new FileNameExtensionFilter(genericFileFilter.getDescription(), genericFileFilter.getExtensions()));
                }
            }
            JSEUIManager.configureDefaultDir(customFileChooserForSave, string2, string3);
            int n2 = 0;
            n = customFileChooserForSave.showSaveDialog(component);
            switch (n) {
                case 1: {
                    throw new AOCancelledOperationException();
                }
                case 0: {
                    Object object2;
                    Object object3;
                    File file2 = customFileChooserForSave.getSelectedFile();
                    if (list != null && (object3 = customFileChooserForSave.getFileFilter()) instanceof FileNameExtensionFilter && !((FileFilter)object3).accept(file2)) {
                        object2 = ((FileNameExtensionFilter)object3).getExtensions();
                        if (object2 != null && ((String[])object2).length > 0) {
                            if (!file2.getName().toLowerCase().endsWith(object2[0].toLowerCase())) {
                                Object object4 = ((String)object2[0]).startsWith(".") ? object2[0] : "." + (String)object2[0];
                                file2 = new File(file2.getParent(), file2.getName() + (String)object4);
                            }
                        } else {
                            file2 = new File(file2.getParent(), file2.getName());
                        }
                    }
                    if (file2.exists() && (n2 = JOptionPane.showConfirmDialog(component, JSEUIMessages.getString("JSEUIManager.77", file2.getAbsolutePath()), JSEUIMessages.getString("JSEUIManager.85"), 1)) == 2) {
                        LOGGER.info("Se ha cancelado la operacion de guardado.");
                        throw new AOCancelledOperationException();
                    }
                    if (n2 == 1) {
                        bl = true;
                        continue block15;
                    }
                    if (byArray != null) {
                        try {
                            object3 = new FileOutputStream(file2);
                            object2 = null;
                            try {
                                ((OutputStream)object3).write(byArray);
                                ((OutputStream)object3).flush();
                            }
                            catch (Throwable throwable) {
                                object2 = throwable;
                                throw throwable;
                            }
                            finally {
                                if (object3 != null) {
                                    if (object2 != null) {
                                        try {
                                            ((OutputStream)object3).close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)object2).addSuppressed(throwable);
                                        }
                                    } else {
                                        ((OutputStream)object3).close();
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            LOGGER.warning("No se pudo guardar la informacion en el fichero indicado: " + exception);
                            this.showErrorMessage(component, JSEUIMessages.getString("JSEUIManager.88"), JSEUIMessages.getString("JSEUIManager.89"), 0);
                            bl = true;
                            continue block15;
                        }
                    }
                    JSEUIManager.put(PREFERENCE_DIRECTORY, customFileChooserForSave.getCurrentDirectory().getPath());
                    return file2;
                }
            }
            break;
        }
        throw new IOException("Error al seleccionar el fichero: " + n);
    }

    private static void configureDefaultDir(JFileChooser jFileChooser, String string, String string2) {
        if (string2 != null && string != null) {
            jFileChooser.setSelectedFile(new File(string, string2));
        } else {
            String string3;
            String string4 = string3 = string != null ? string : JSEUIManager.get(PREFERENCE_DIRECTORY, null);
            if (string2 != null) {
                if (string3 != null) {
                    jFileChooser.setSelectedFile(new File(string3, string2));
                } else {
                    jFileChooser.setSelectedFile(new File(string2));
                }
            } else if (string3 != null) {
                jFileChooser.setCurrentDirectory(new File(string3));
            }
        }
    }

    public void showErrorMessage(Object object, Object object2, String string, int n) {
        String string2 = JSEUIMessages.getString("JSEUIManager.1");
        JOptionPane.showOptionDialog(object instanceof Component ? (Component)object : null, object2, string, 0, n, null, new String[]{string2}, string2);
    }

    private static final class CustomFileChooserForSave
    extends JFileChooser {
        private static final long serialVersionUID = -2107199679670180110L;
        private File file = null;

        File getFile() {
            return this.file;
        }

        CustomFileChooserForSave() {
            this.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (!(propertyChangeEvent.getOldValue() instanceof FileNameExtensionFilter) || !(propertyChangeEvent.getNewValue() instanceof FileNameExtensionFilter)) {
                        return;
                    }
                    FileNameExtensionFilter fileNameExtensionFilter = (FileNameExtensionFilter)propertyChangeEvent.getOldValue();
                    FileNameExtensionFilter fileNameExtensionFilter2 = (FileNameExtensionFilter)propertyChangeEvent.getNewValue();
                    if (fileNameExtensionFilter.getExtensions() == null || fileNameExtensionFilter.getExtensions().length < 1 || fileNameExtensionFilter2.getExtensions() == null || fileNameExtensionFilter2.getExtensions().length < 1) {
                        return;
                    }
                    String string = fileNameExtensionFilter.getExtensions()[0];
                    String string2 = fileNameExtensionFilter2.getExtensions()[0];
                    String string3 = CustomFileChooserForSave.this.getFile().getName();
                    string3 = string3.endsWith(string) ? string3.replace(string, string2) : string3 + string2;
                    CustomFileChooserForSave.this.setSelectedFile(new File(string3));
                }
            });
        }

        @Override
        public void setSelectedFile(File file) {
            super.setSelectedFile(file);
            if (file != null) {
                super.setSelectedFile(file);
                this.file = file;
            }
        }
    }

    public static final class JTextFieldASCIIFilter
    extends PlainDocument {
        private static final long serialVersionUID = 1979726487852842735L;
        private boolean beep = false;

        public JTextFieldASCIIFilter(boolean bl) {
            this.beep = bl;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) >= ' ' && string.charAt(i) <= '~') continue;
                if (this.beep) {
                    Toolkit.getDefaultToolkit().beep();
                }
                return;
            }
            super.insertString(n, string, attributeSet);
        }
    }

    private static final class JTextFieldFilter
    extends PlainDocument {
        private static final long serialVersionUID = -5746396042117084830L;
        private String acceptedChars = null;
        private boolean beep = false;

        JTextFieldFilter(String string, boolean bl) {
            this.beep = bl;
            this.acceptedChars = string;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (this.acceptedChars.indexOf(String.valueOf(string.charAt(i))) != -1) continue;
                if (this.beep) {
                    Toolkit.getDefaultToolkit().beep();
                }
                return;
            }
            super.insertString(n, string, attributeSet);
        }
    }
}

