/*
 * Decompiled with CFR 0.152.
 */
package com.aowagie.text;

import com.aowagie.text.DocListener;
import com.aowagie.text.Document;
import com.aowagie.text.DocumentException;
import com.aowagie.text.Element;
import com.aowagie.text.ExceptionConverter;
import com.aowagie.text.HeaderFooter;
import com.aowagie.text.Rectangle;
import com.aowagie.text.pdf.OutputStreamCounter;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class DocWriter
implements DocListener {
    private static final byte SPACE = 32;
    private static final byte EQUALS = 61;
    private static final byte QUOTE = 34;
    private static final byte GT = 62;
    private static final byte FORWARD = 47;
    protected OutputStreamCounter os;
    protected boolean open = false;
    private final boolean pause = false;
    private boolean closeStream = true;

    protected DocWriter() {
    }

    protected DocWriter(Document document, OutputStream os) {
        this.os = new OutputStreamCounter(new BufferedOutputStream(os));
    }

    @Override
    public boolean add(Element element) throws DocumentException {
        return false;
    }

    @Override
    public void open() {
        this.open = true;
    }

    @Override
    public boolean setPageSize(Rectangle pageSize) {
        return true;
    }

    @Override
    public boolean setMargins(float marginLeft, float marginRight, float marginTop, float marginBottom) {
        return false;
    }

    @Override
    public boolean newPage() {
        return this.open;
    }

    @Override
    public void setHeader(HeaderFooter header) {
    }

    @Override
    public void resetHeader() {
    }

    @Override
    public void setFooter(HeaderFooter footer) {
    }

    @Override
    public void resetFooter() {
    }

    @Override
    public void resetPageCount() {
    }

    @Override
    public void setPageCount(int pageN) {
    }

    @Override
    public void close() {
        this.open = false;
        try {
            this.os.flush();
            if (this.closeStream) {
                this.os.close();
            }
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
    }

    public static final byte[] getISOBytes(String text) {
        if (text == null) {
            return null;
        }
        int len = text.length();
        byte[] b = new byte[len];
        for (int k = 0; k < len; ++k) {
            b[k] = (byte)text.charAt(k);
        }
        return b;
    }

    public boolean isPaused() {
        return this.pause;
    }

    private void write(String string) throws IOException {
        this.os.write(DocWriter.getISOBytes(string));
    }

    private void write(String key, String value) throws IOException {
        this.os.write(32);
        this.write(key);
        this.os.write(61);
        this.os.write(34);
        this.write(value);
        this.os.write(34);
    }

    public boolean isCloseStream() {
        return this.closeStream;
    }

    public void setCloseStream(boolean closeStream) {
        this.closeStream = closeStream;
    }

    @Override
    public boolean setMarginMirroring(boolean MarginMirroring) {
        return false;
    }

    @Override
    public boolean setMarginMirroringTopBottom(boolean MarginMirroring) {
        return false;
    }
}

