/*
 * Decompiled with CFR 0.152.
 */
package com.aowagie.text.pdf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public final class BoundedBufferedReader
extends BufferedReader {
    private static final int DEFAULT_MAX_LINES = 4096;
    private static final int DEFAULT_MAX_LINE_LENGTH = 4096;
    private final int readerMaxLines;
    private final int readerMaxLineLen;
    private int currentLine = 1;

    public BoundedBufferedReader(Reader reader, int maxLines, int maxLineLen) {
        super(reader);
        if (maxLines <= 0 || maxLineLen <= 0) {
            throw new IllegalArgumentException("BoundedBufferedReader - maxLines and maxLineLen must be greater than 0");
        }
        this.readerMaxLines = maxLines;
        this.readerMaxLineLen = maxLineLen;
    }

    public BoundedBufferedReader(Reader reader) {
        super(reader);
        this.readerMaxLines = 4096;
        this.readerMaxLineLen = 4096;
    }

    @Override
    public String readLine() throws IOException {
        if (this.currentLine > this.readerMaxLines) {
            throw new IOException("BoundedBufferedReader - Line read limit has been reached.");
        }
        ++this.currentLine;
        int currentPos = 0;
        char[] data = new char[this.readerMaxLineLen];
        int CR = 13;
        int LF = 10;
        int currentCharVal = super.read();
        while (currentCharVal != 13 && currentCharVal != 10 && currentCharVal >= 0) {
            data[currentPos++] = (char)currentCharVal;
            if (currentPos >= this.readerMaxLineLen) break;
            currentCharVal = super.read();
        }
        if (currentCharVal < 0) {
            if (currentPos > 0) {
                return new String(data, 0, currentPos);
            }
            return null;
        }
        if (currentCharVal == 13) {
            super.mark(1);
            if (super.read() != 10) {
                super.reset();
            }
        } else if (currentCharVal != 10) {
            super.mark(1);
            int nextCharVal = super.read();
            if (nextCharVal == 13) {
                super.mark(1);
                if (super.read() != 10) {
                    super.reset();
                }
            } else if (nextCharVal != 10) {
                super.reset();
            }
        }
        return new String(data, 0, currentPos);
    }
}

