/*
 * Decompiled with CFR 0.152.
 */
package com.aowagie.text.pdf;

import com.aowagie.text.pdf.PdfDictionary;
import com.aowagie.text.pdf.PdfIndirectReference;
import com.aowagie.text.pdf.PdfName;
import com.aowagie.text.pdf.PdfOCG;
import com.aowagie.text.pdf.PdfObject;
import com.aowagie.text.pdf.PdfString;
import java.util.ArrayList;

class PdfLayer
extends PdfDictionary
implements PdfOCG {
    private PdfIndirectReference ref;
    private ArrayList children;
    private PdfLayer parent;
    private final String title;
    private boolean on = true;
    private boolean onPanel = true;

    PdfLayer(String title) {
        this.title = title;
    }

    String getTitle() {
        return this.title;
    }

    void addChild(PdfLayer child) {
        if (child.parent != null) {
            throw new IllegalArgumentException("The layer '" + ((PdfString)child.get(PdfName.NAME)).toUnicodeString() + "' already has a parent.");
        }
        child.parent = this;
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
    }

    public PdfLayer getParent() {
        return this.parent;
    }

    public ArrayList getChildren() {
        return this.children;
    }

    @Override
    public PdfIndirectReference getRef() {
        return this.ref;
    }

    void setRef(PdfIndirectReference ref) {
        this.ref = ref;
    }

    public void setName(String name) {
        this.put(PdfName.NAME, new PdfString(name, "UnicodeBig"));
    }

    @Override
    public PdfObject getPdfObject() {
        return this;
    }

    public boolean isOn() {
        return this.on;
    }

    public void setOn(boolean on) {
        this.on = on;
    }

    private PdfDictionary getUsage() {
        PdfDictionary usage = (PdfDictionary)this.get(PdfName.USAGE);
        if (usage == null) {
            usage = new PdfDictionary();
            this.put(PdfName.USAGE, usage);
        }
        return usage;
    }

    public void setExport(boolean export) {
        PdfDictionary usage = this.getUsage();
        PdfDictionary dic = new PdfDictionary();
        dic.put(PdfName.EXPORTSTATE, export ? PdfName.ON : PdfName.OFF);
        usage.put(PdfName.EXPORT, dic);
    }

    public void setView(boolean view) {
        PdfDictionary usage = this.getUsage();
        PdfDictionary dic = new PdfDictionary();
        dic.put(PdfName.VIEWSTATE, view ? PdfName.ON : PdfName.OFF);
        usage.put(PdfName.VIEW, dic);
    }

    public boolean isOnPanel() {
        return this.onPanel;
    }

    public void setOnPanel(boolean onPanel) {
        this.onPanel = onPanel;
    }
}

