/*
 * Decompiled with CFR 0.152.
 */
package com.aowagie.text.pdf.collection;

import com.aowagie.text.pdf.PdfArray;
import com.aowagie.text.pdf.PdfBoolean;
import com.aowagie.text.pdf.PdfDictionary;
import com.aowagie.text.pdf.PdfName;
import com.aowagie.text.pdf.PdfObject;

class PdfCollectionSort
extends PdfDictionary {
    PdfCollectionSort() {
    }

    public void setSortOrder(boolean ascending) {
        PdfObject o = this.get(PdfName.S);
        if (!(o instanceof PdfName)) {
            throw new IllegalArgumentException("You have to define a boolean array for this collection sort dictionary.");
        }
        this.put(PdfName.A, new PdfBoolean(ascending));
    }

    public void setSortOrder(boolean[] ascending) {
        PdfArray array;
        PdfObject o = this.get(PdfName.S);
        if (o instanceof PdfArray) {
            if (((PdfArray)o).size() != ascending.length) {
                throw new IllegalArgumentException("The number of booleans in this array doesn't correspond with the number of fields.");
            }
            array = new PdfArray();
            for (boolean element : ascending) {
                array.add(new PdfBoolean(element));
            }
        } else {
            throw new IllegalArgumentException("You need a single boolean for this collection sort dictionary.");
        }
        this.put(PdfName.A, array);
    }
}

