/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vci;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jwt.SignedJWT;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0005*\u00020\u0006H\u0000\u001a\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\nH\u0000\u001a\u0014\u0010\r\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002*\"\u0010\u0000\"\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a8\u0006\u0010"}, d2={"ClientAttestation", "Lkotlin/Pair;", "Leu/europa/ec/eudi/openid4vci/ClientAttestationJWT;", "Leu/europa/ec/eudi/openid4vci/ClientAttestationPoPJWT;", "ensureSignedOrVerified", "", "Lcom/nimbusds/jwt/SignedJWT;", "ensureSignedNotMAC", "requireIsNotMAC", "alg", "Lcom/nimbusds/jose/JWSAlgorithm;", "isMACSigning", "", "ensureType", "expectedType", "Lcom/nimbusds/jose/JOSEObjectType;", "eudi-lib-jvm-openid4vci-kt"})
@SourceDebugExtension(value={"SMAP\nClientAttestation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientAttestation.kt\neu/europa/ec/eudi/openid4vci/ClientAttestationKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n1#2:165\n*E\n"})
public final class ClientAttestationKt {
    public static final void ensureSignedOrVerified(@NotNull SignedJWT $this$ensureSignedOrVerified) {
        Intrinsics.checkNotNullParameter((Object)$this$ensureSignedOrVerified, (String)"<this>");
        if (!($this$ensureSignedOrVerified.getState() == JWSObject.State.SIGNED || $this$ensureSignedOrVerified.getState() == JWSObject.State.VERIFIED)) {
            boolean bl = false;
            String string = "Provided JWT is not signed";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final void ensureSignedNotMAC(@NotNull SignedJWT $this$ensureSignedNotMAC) {
        Intrinsics.checkNotNullParameter((Object)$this$ensureSignedNotMAC, (String)"<this>");
        ClientAttestationKt.ensureSignedOrVerified($this$ensureSignedNotMAC);
        JWSAlgorithm jWSAlgorithm = $this$ensureSignedNotMAC.getHeader().getAlgorithm();
        if (jWSAlgorithm == null) {
            boolean bl = false;
            String string = "Invalid JWT misses header alg";
            throw new IllegalArgumentException(string.toString());
        }
        JWSAlgorithm alg = jWSAlgorithm;
        ClientAttestationKt.requireIsNotMAC(alg);
    }

    public static final void requireIsNotMAC(@NotNull JWSAlgorithm alg) {
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        if (!(!ClientAttestationKt.isMACSigning(alg))) {
            boolean bl = false;
            String string = "MAC signing algorithm not allowed";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final boolean isMACSigning(@NotNull JWSAlgorithm $this$isMACSigning) {
        Intrinsics.checkNotNullParameter((Object)$this$isMACSigning, (String)"<this>");
        return MACSigner.SUPPORTED_ALGORITHMS.contains($this$isMACSigning);
    }

    private static final void ensureType(SignedJWT $this$ensureType, JOSEObjectType expectedType) {
        if (!Intrinsics.areEqual((Object)expectedType, (Object)$this$ensureType.getHeader().getType())) {
            boolean bl = false;
            JOSEObjectType jOSEObjectType = $this$ensureType.getHeader().getType();
            String string = "Expected SignedJWT `typ` to be '" + expectedType.getType() + "', but found '" + (jOSEObjectType != null ? jOSEObjectType.getType() : null) + "' instead";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final /* synthetic */ void access$ensureType(SignedJWT $receiver, JOSEObjectType expectedType) {
        ClientAttestationKt.ensureType($receiver, expectedType);
    }
}

