/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vci;

import com.nimbusds.jwt.SignedJWT;
import eu.europa.ec.eudi.openid4vci.ClientAttestationJWT;
import eu.europa.ec.eudi.openid4vci.ClientAttestationPoPJWTSpec;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0007\bR\u0016\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\t\n\u00a8\u0006\u000b"}, d2={"Leu/europa/ec/eudi/openid4vci/ClientAuthentication;", "Ljava/io/Serializable;", "id", "", "Leu/europa/ec/eudi/openid4vci/ClientId;", "getId", "()Ljava/lang/String;", "None", "AttestationBased", "Leu/europa/ec/eudi/openid4vci/ClientAuthentication$AttestationBased;", "Leu/europa/ec/eudi/openid4vci/ClientAuthentication$None;", "eudi-lib-jvm-openid4vci-kt"})
public interface ClientAuthentication
extends Serializable {
    @NotNull
    public String getId();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\tJ\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J$\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u000eH\u00d6\u0001R\u0013\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u00060\u000ej\u0002`\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Leu/europa/ec/eudi/openid4vci/ClientAuthentication$AttestationBased;", "Leu/europa/ec/eudi/openid4vci/ClientAuthentication;", "attestationJWT", "Leu/europa/ec/eudi/openid4vci/ClientAttestationJWT;", "popJwtSpec", "Leu/europa/ec/eudi/openid4vci/ClientAttestationPoPJWTSpec;", "<init>", "(Lcom/nimbusds/jwt/SignedJWT;Leu/europa/ec/eudi/openid4vci/ClientAttestationPoPJWTSpec;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getAttestationJWT-JKpmwrk", "()Lcom/nimbusds/jwt/SignedJWT;", "Lcom/nimbusds/jwt/SignedJWT;", "getPopJwtSpec", "()Leu/europa/ec/eudi/openid4vci/ClientAttestationPoPJWTSpec;", "id", "", "Leu/europa/ec/eudi/openid4vci/ClientId;", "getId", "()Ljava/lang/String;", "component1", "component1-JKpmwrk", "component2", "copy", "copy-P6dWUjY", "(Lcom/nimbusds/jwt/SignedJWT;Leu/europa/ec/eudi/openid4vci/ClientAttestationPoPJWTSpec;)Leu/europa/ec/eudi/openid4vci/ClientAuthentication$AttestationBased;", "equals", "", "other", "", "hashCode", "", "toString", "eudi-lib-jvm-openid4vci-kt"})
    @SourceDebugExtension(value={"SMAP\nConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Config.kt\neu/europa/ec/eudi/openid4vci/ClientAuthentication$AttestationBased\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1#2:249\n*E\n"})
    public static final class AttestationBased
    implements ClientAuthentication {
        @NotNull
        private final SignedJWT attestationJWT;
        @NotNull
        private final ClientAttestationPoPJWTSpec popJwtSpec;

        private AttestationBased(SignedJWT attestationJWT, ClientAttestationPoPJWTSpec popJwtSpec) {
            Intrinsics.checkNotNullParameter((Object)attestationJWT, (String)"attestationJWT");
            Intrinsics.checkNotNullParameter((Object)popJwtSpec, (String)"popJwtSpec");
            this.attestationJWT = attestationJWT;
            this.popJwtSpec = popJwtSpec;
            if (!(!StringsKt.isBlank((CharSequence)ClientAttestationJWT.getClientId-impl(this.attestationJWT)))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(!ClientAttestationJWT.getPublicKey-impl(this.attestationJWT).isPrivate())) {
                boolean bl = false;
                String string = "InstanceKey should be public";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final SignedJWT getAttestationJWT-JKpmwrk() {
            return this.attestationJWT;
        }

        @NotNull
        public final ClientAttestationPoPJWTSpec getPopJwtSpec() {
            return this.popJwtSpec;
        }

        @Override
        @NotNull
        public String getId() {
            return ClientAttestationJWT.getClientId-impl(this.attestationJWT);
        }

        @NotNull
        public final SignedJWT component1-JKpmwrk() {
            return this.attestationJWT;
        }

        @NotNull
        public final ClientAttestationPoPJWTSpec component2() {
            return this.popJwtSpec;
        }

        @NotNull
        public final AttestationBased copy-P6dWUjY(@NotNull SignedJWT attestationJWT, @NotNull ClientAttestationPoPJWTSpec popJwtSpec) {
            Intrinsics.checkNotNullParameter((Object)attestationJWT, (String)"attestationJWT");
            Intrinsics.checkNotNullParameter((Object)popJwtSpec, (String)"popJwtSpec");
            return new AttestationBased(attestationJWT, popJwtSpec, null);
        }

        public static /* synthetic */ AttestationBased copy-P6dWUjY$default(AttestationBased attestationBased, SignedJWT signedJWT, ClientAttestationPoPJWTSpec clientAttestationPoPJWTSpec, int n, Object object) {
            if ((n & 1) != 0) {
                signedJWT = attestationBased.attestationJWT;
            }
            if ((n & 2) != 0) {
                clientAttestationPoPJWTSpec = attestationBased.popJwtSpec;
            }
            return attestationBased.copy-P6dWUjY(signedJWT, clientAttestationPoPJWTSpec);
        }

        @NotNull
        public String toString() {
            return "AttestationBased(attestationJWT=" + ClientAttestationJWT.toString-impl(this.attestationJWT) + ", popJwtSpec=" + this.popJwtSpec + ")";
        }

        public int hashCode() {
            int result = ClientAttestationJWT.hashCode-impl(this.attestationJWT);
            result = result * 31 + this.popJwtSpec.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AttestationBased)) {
                return false;
            }
            AttestationBased attestationBased = (AttestationBased)other;
            if (!ClientAttestationJWT.equals-impl0(this.attestationJWT, attestationBased.attestationJWT)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.popJwtSpec, (Object)attestationBased.popJwtSpec);
        }

        public /* synthetic */ AttestationBased(SignedJWT attestationJWT, ClientAttestationPoPJWTSpec popJwtSpec, DefaultConstructorMarker $constructor_marker) {
            this(attestationJWT, popJwtSpec);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\t\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\u0017\u0010\n\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Leu/europa/ec/eudi/openid4vci/ClientAuthentication$None;", "Leu/europa/ec/eudi/openid4vci/ClientAuthentication;", "id", "", "Leu/europa/ec/eudi/openid4vci/ClientId;", "<init>", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "eudi-lib-jvm-openid4vci-kt"})
    public static final class None
    implements ClientAuthentication {
        @NotNull
        private final String id;

        public None(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final None copy(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new None(id);
        }

        public static /* synthetic */ None copy$default(None none, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = none.id;
            }
            return none.copy(string);
        }

        @NotNull
        public String toString() {
            return "None(id=" + this.id + ")";
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof None)) {
                return false;
            }
            None none = (None)other;
            return Intrinsics.areEqual((Object)this.id, (Object)none.id);
        }
    }
}

