/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vci;

import com.nimbusds.jose.jwk.JWK;
import eu.europa.ec.eudi.openid4vci.AuthorizeIssuanceConfig;
import eu.europa.ec.eudi.openid4vci.ClientAttestationPoPBuilder;
import eu.europa.ec.eudi.openid4vci.ClientAuthentication;
import eu.europa.ec.eudi.openid4vci.EncryptionSupportConfig;
import eu.europa.ec.eudi.openid4vci.IssuerMetadataPolicy;
import eu.europa.ec.eudi.openid4vci.ParUsage;
import eu.europa.ec.eudi.openid4vci.Signer;
import java.net.URI;
import java.time.Clock;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\"\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001Bc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016Bi\b\u0016\u0012\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u001aJ\t\u00101\u001a\u00020\u0003H\u00c6\u0003J\t\u00102\u001a\u00020\u0005H\u00c6\u0003J\t\u00103\u001a\u00020\u0007H\u00c6\u0003J\t\u00104\u001a\u00020\tH\u00c6\u0003J\u0011\u00105\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u00c6\u0003J\t\u00106\u001a\u00020\u000eH\u00c6\u0003J\t\u00107\u001a\u00020\u0010H\u00c6\u0003J\t\u00108\u001a\u00020\u0012H\u00c6\u0003J\t\u00109\u001a\u00020\u0014H\u00c6\u0003Jk\u0010:\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u00c6\u0001J\u0013\u0010;\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010>\u001a\u00020?H\u00d6\u0001J\t\u0010@\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0019\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001e\u0010\u0017\u001a\u00060\u0018j\u0002`\u00198FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b-\u0010.\u001a\u0004\b/\u00100\u00a8\u0006A"}, d2={"Leu/europa/ec/eudi/openid4vci/OpenId4VCIConfig;", "", "clientAuthentication", "Leu/europa/ec/eudi/openid4vci/ClientAuthentication;", "authFlowRedirectionURI", "Ljava/net/URI;", "encryptionSupportConfig", "Leu/europa/ec/eudi/openid4vci/EncryptionSupportConfig;", "authorizeIssuanceConfig", "Leu/europa/ec/eudi/openid4vci/AuthorizeIssuanceConfig;", "dPoPSigner", "Leu/europa/ec/eudi/openid4vci/Signer;", "Lcom/nimbusds/jose/jwk/JWK;", "clientAttestationPoPBuilder", "Leu/europa/ec/eudi/openid4vci/ClientAttestationPoPBuilder;", "parUsage", "Leu/europa/ec/eudi/openid4vci/ParUsage;", "clock", "Ljava/time/Clock;", "issuerMetadataPolicy", "Leu/europa/ec/eudi/openid4vci/IssuerMetadataPolicy;", "<init>", "(Leu/europa/ec/eudi/openid4vci/ClientAuthentication;Ljava/net/URI;Leu/europa/ec/eudi/openid4vci/EncryptionSupportConfig;Leu/europa/ec/eudi/openid4vci/AuthorizeIssuanceConfig;Leu/europa/ec/eudi/openid4vci/Signer;Leu/europa/ec/eudi/openid4vci/ClientAttestationPoPBuilder;Leu/europa/ec/eudi/openid4vci/ParUsage;Ljava/time/Clock;Leu/europa/ec/eudi/openid4vci/IssuerMetadataPolicy;)V", "clientId", "", "Leu/europa/ec/eudi/openid4vci/ClientId;", "(Ljava/lang/String;Ljava/net/URI;Leu/europa/ec/eudi/openid4vci/EncryptionSupportConfig;Leu/europa/ec/eudi/openid4vci/AuthorizeIssuanceConfig;Leu/europa/ec/eudi/openid4vci/Signer;Leu/europa/ec/eudi/openid4vci/ClientAttestationPoPBuilder;Leu/europa/ec/eudi/openid4vci/ParUsage;Ljava/time/Clock;Leu/europa/ec/eudi/openid4vci/IssuerMetadataPolicy;)V", "getClientAuthentication", "()Leu/europa/ec/eudi/openid4vci/ClientAuthentication;", "getAuthFlowRedirectionURI", "()Ljava/net/URI;", "getEncryptionSupportConfig", "()Leu/europa/ec/eudi/openid4vci/EncryptionSupportConfig;", "getAuthorizeIssuanceConfig", "()Leu/europa/ec/eudi/openid4vci/AuthorizeIssuanceConfig;", "getDPoPSigner", "()Leu/europa/ec/eudi/openid4vci/Signer;", "getClientAttestationPoPBuilder", "()Leu/europa/ec/eudi/openid4vci/ClientAttestationPoPBuilder;", "getParUsage", "()Leu/europa/ec/eudi/openid4vci/ParUsage;", "getClock", "()Ljava/time/Clock;", "getIssuerMetadataPolicy", "()Leu/europa/ec/eudi/openid4vci/IssuerMetadataPolicy;", "getClientId$annotations", "()V", "getClientId", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "toString", "eudi-lib-jvm-openid4vci-kt"})
public final class OpenId4VCIConfig {
    @NotNull
    private final ClientAuthentication clientAuthentication;
    @NotNull
    private final URI authFlowRedirectionURI;
    @NotNull
    private final EncryptionSupportConfig encryptionSupportConfig;
    @NotNull
    private final AuthorizeIssuanceConfig authorizeIssuanceConfig;
    @Nullable
    private final Signer<JWK> dPoPSigner;
    @NotNull
    private final ClientAttestationPoPBuilder clientAttestationPoPBuilder;
    @NotNull
    private final ParUsage parUsage;
    @NotNull
    private final Clock clock;
    @NotNull
    private final IssuerMetadataPolicy issuerMetadataPolicy;

    public OpenId4VCIConfig(@NotNull ClientAuthentication clientAuthentication, @NotNull URI authFlowRedirectionURI, @NotNull EncryptionSupportConfig encryptionSupportConfig, @NotNull AuthorizeIssuanceConfig authorizeIssuanceConfig, @Nullable Signer<? extends JWK> dPoPSigner, @NotNull ClientAttestationPoPBuilder clientAttestationPoPBuilder, @NotNull ParUsage parUsage, @NotNull Clock clock, @NotNull IssuerMetadataPolicy issuerMetadataPolicy) {
        Intrinsics.checkNotNullParameter((Object)clientAuthentication, (String)"clientAuthentication");
        Intrinsics.checkNotNullParameter((Object)authFlowRedirectionURI, (String)"authFlowRedirectionURI");
        Intrinsics.checkNotNullParameter((Object)encryptionSupportConfig, (String)"encryptionSupportConfig");
        Intrinsics.checkNotNullParameter((Object)((Object)authorizeIssuanceConfig), (String)"authorizeIssuanceConfig");
        Intrinsics.checkNotNullParameter((Object)clientAttestationPoPBuilder, (String)"clientAttestationPoPBuilder");
        Intrinsics.checkNotNullParameter((Object)((Object)parUsage), (String)"parUsage");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)issuerMetadataPolicy, (String)"issuerMetadataPolicy");
        this.clientAuthentication = clientAuthentication;
        this.authFlowRedirectionURI = authFlowRedirectionURI;
        this.encryptionSupportConfig = encryptionSupportConfig;
        this.authorizeIssuanceConfig = authorizeIssuanceConfig;
        this.dPoPSigner = dPoPSigner;
        this.clientAttestationPoPBuilder = clientAttestationPoPBuilder;
        this.parUsage = parUsage;
        this.clock = clock;
        this.issuerMetadataPolicy = issuerMetadataPolicy;
    }

    public /* synthetic */ OpenId4VCIConfig(ClientAuthentication clientAuthentication, URI uRI, EncryptionSupportConfig encryptionSupportConfig, AuthorizeIssuanceConfig authorizeIssuanceConfig, Signer signer, ClientAttestationPoPBuilder clientAttestationPoPBuilder, ParUsage parUsage, Clock clock, IssuerMetadataPolicy issuerMetadataPolicy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            authorizeIssuanceConfig = AuthorizeIssuanceConfig.FAVOR_SCOPES;
        }
        if ((n & 0x10) != 0) {
            signer = null;
        }
        if ((n & 0x20) != 0) {
            clientAttestationPoPBuilder = ClientAttestationPoPBuilder.Companion.getDefault();
        }
        if ((n & 0x40) != 0) {
            parUsage = ParUsage.IfSupported;
        }
        if ((n & 0x80) != 0) {
            clock = Clock.systemDefaultZone();
        }
        if ((n & 0x100) != 0) {
            issuerMetadataPolicy = IssuerMetadataPolicy.IgnoreSigned.INSTANCE;
        }
        this(clientAuthentication, uRI, encryptionSupportConfig, authorizeIssuanceConfig, (Signer<? extends JWK>)signer, clientAttestationPoPBuilder, parUsage, clock, issuerMetadataPolicy);
    }

    @NotNull
    public final ClientAuthentication getClientAuthentication() {
        return this.clientAuthentication;
    }

    @NotNull
    public final URI getAuthFlowRedirectionURI() {
        return this.authFlowRedirectionURI;
    }

    @NotNull
    public final EncryptionSupportConfig getEncryptionSupportConfig() {
        return this.encryptionSupportConfig;
    }

    @NotNull
    public final AuthorizeIssuanceConfig getAuthorizeIssuanceConfig() {
        return this.authorizeIssuanceConfig;
    }

    @Nullable
    public final Signer<JWK> getDPoPSigner() {
        return this.dPoPSigner;
    }

    @NotNull
    public final ClientAttestationPoPBuilder getClientAttestationPoPBuilder() {
        return this.clientAttestationPoPBuilder;
    }

    @NotNull
    public final ParUsage getParUsage() {
        return this.parUsage;
    }

    @NotNull
    public final Clock getClock() {
        return this.clock;
    }

    @NotNull
    public final IssuerMetadataPolicy getIssuerMetadataPolicy() {
        return this.issuerMetadataPolicy;
    }

    public OpenId4VCIConfig(@NotNull String clientId, @NotNull URI authFlowRedirectionURI, @NotNull EncryptionSupportConfig encryptionSupportConfig, @NotNull AuthorizeIssuanceConfig authorizeIssuanceConfig, @Nullable Signer<? extends JWK> dPoPSigner, @NotNull ClientAttestationPoPBuilder clientAttestationPoPBuilder, @NotNull ParUsage parUsage, @NotNull Clock clock, @NotNull IssuerMetadataPolicy issuerMetadataPolicy) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)authFlowRedirectionURI, (String)"authFlowRedirectionURI");
        Intrinsics.checkNotNullParameter((Object)encryptionSupportConfig, (String)"encryptionSupportConfig");
        Intrinsics.checkNotNullParameter((Object)((Object)authorizeIssuanceConfig), (String)"authorizeIssuanceConfig");
        Intrinsics.checkNotNullParameter((Object)clientAttestationPoPBuilder, (String)"clientAttestationPoPBuilder");
        Intrinsics.checkNotNullParameter((Object)((Object)parUsage), (String)"parUsage");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)issuerMetadataPolicy, (String)"issuerMetadataPolicy");
        this(new ClientAuthentication.None(clientId), authFlowRedirectionURI, encryptionSupportConfig, authorizeIssuanceConfig, dPoPSigner, clientAttestationPoPBuilder, parUsage, clock, issuerMetadataPolicy);
    }

    public /* synthetic */ OpenId4VCIConfig(String string, URI uRI, EncryptionSupportConfig encryptionSupportConfig, AuthorizeIssuanceConfig authorizeIssuanceConfig, Signer signer, ClientAttestationPoPBuilder clientAttestationPoPBuilder, ParUsage parUsage, Clock clock, IssuerMetadataPolicy issuerMetadataPolicy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            authorizeIssuanceConfig = AuthorizeIssuanceConfig.FAVOR_SCOPES;
        }
        if ((n & 0x10) != 0) {
            signer = null;
        }
        if ((n & 0x20) != 0) {
            clientAttestationPoPBuilder = ClientAttestationPoPBuilder.Companion.getDefault();
        }
        if ((n & 0x40) != 0) {
            parUsage = ParUsage.IfSupported;
        }
        if ((n & 0x80) != 0) {
            clock = Clock.systemDefaultZone();
        }
        if ((n & 0x100) != 0) {
            issuerMetadataPolicy = IssuerMetadataPolicy.IgnoreSigned.INSTANCE;
        }
        this(string, uRI, encryptionSupportConfig, authorizeIssuanceConfig, (Signer<? extends JWK>)signer, clientAttestationPoPBuilder, parUsage, clock, issuerMetadataPolicy);
    }

    @NotNull
    public final String getClientId() {
        return this.clientAuthentication.getId();
    }

    @Deprecated(message="Deprecated in favor of openId4VCIConfig clientAuthentication.id", replaceWith=@ReplaceWith(expression="clientAuthentication.id", imports={}))
    public static /* synthetic */ void getClientId$annotations() {
    }

    @NotNull
    public final ClientAuthentication component1() {
        return this.clientAuthentication;
    }

    @NotNull
    public final URI component2() {
        return this.authFlowRedirectionURI;
    }

    @NotNull
    public final EncryptionSupportConfig component3() {
        return this.encryptionSupportConfig;
    }

    @NotNull
    public final AuthorizeIssuanceConfig component4() {
        return this.authorizeIssuanceConfig;
    }

    @Nullable
    public final Signer<JWK> component5() {
        return this.dPoPSigner;
    }

    @NotNull
    public final ClientAttestationPoPBuilder component6() {
        return this.clientAttestationPoPBuilder;
    }

    @NotNull
    public final ParUsage component7() {
        return this.parUsage;
    }

    @NotNull
    public final Clock component8() {
        return this.clock;
    }

    @NotNull
    public final IssuerMetadataPolicy component9() {
        return this.issuerMetadataPolicy;
    }

    @NotNull
    public final OpenId4VCIConfig copy(@NotNull ClientAuthentication clientAuthentication, @NotNull URI authFlowRedirectionURI, @NotNull EncryptionSupportConfig encryptionSupportConfig, @NotNull AuthorizeIssuanceConfig authorizeIssuanceConfig, @Nullable Signer<? extends JWK> dPoPSigner, @NotNull ClientAttestationPoPBuilder clientAttestationPoPBuilder, @NotNull ParUsage parUsage, @NotNull Clock clock, @NotNull IssuerMetadataPolicy issuerMetadataPolicy) {
        Intrinsics.checkNotNullParameter((Object)clientAuthentication, (String)"clientAuthentication");
        Intrinsics.checkNotNullParameter((Object)authFlowRedirectionURI, (String)"authFlowRedirectionURI");
        Intrinsics.checkNotNullParameter((Object)encryptionSupportConfig, (String)"encryptionSupportConfig");
        Intrinsics.checkNotNullParameter((Object)((Object)authorizeIssuanceConfig), (String)"authorizeIssuanceConfig");
        Intrinsics.checkNotNullParameter((Object)clientAttestationPoPBuilder, (String)"clientAttestationPoPBuilder");
        Intrinsics.checkNotNullParameter((Object)((Object)parUsage), (String)"parUsage");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)issuerMetadataPolicy, (String)"issuerMetadataPolicy");
        return new OpenId4VCIConfig(clientAuthentication, authFlowRedirectionURI, encryptionSupportConfig, authorizeIssuanceConfig, dPoPSigner, clientAttestationPoPBuilder, parUsage, clock, issuerMetadataPolicy);
    }

    public static /* synthetic */ OpenId4VCIConfig copy$default(OpenId4VCIConfig openId4VCIConfig, ClientAuthentication clientAuthentication, URI uRI, EncryptionSupportConfig encryptionSupportConfig, AuthorizeIssuanceConfig authorizeIssuanceConfig, Signer signer, ClientAttestationPoPBuilder clientAttestationPoPBuilder, ParUsage parUsage, Clock clock, IssuerMetadataPolicy issuerMetadataPolicy, int n, Object object) {
        if ((n & 1) != 0) {
            clientAuthentication = openId4VCIConfig.clientAuthentication;
        }
        if ((n & 2) != 0) {
            uRI = openId4VCIConfig.authFlowRedirectionURI;
        }
        if ((n & 4) != 0) {
            encryptionSupportConfig = openId4VCIConfig.encryptionSupportConfig;
        }
        if ((n & 8) != 0) {
            authorizeIssuanceConfig = openId4VCIConfig.authorizeIssuanceConfig;
        }
        if ((n & 0x10) != 0) {
            signer = openId4VCIConfig.dPoPSigner;
        }
        if ((n & 0x20) != 0) {
            clientAttestationPoPBuilder = openId4VCIConfig.clientAttestationPoPBuilder;
        }
        if ((n & 0x40) != 0) {
            parUsage = openId4VCIConfig.parUsage;
        }
        if ((n & 0x80) != 0) {
            clock = openId4VCIConfig.clock;
        }
        if ((n & 0x100) != 0) {
            issuerMetadataPolicy = openId4VCIConfig.issuerMetadataPolicy;
        }
        return openId4VCIConfig.copy(clientAuthentication, uRI, encryptionSupportConfig, authorizeIssuanceConfig, signer, clientAttestationPoPBuilder, parUsage, clock, issuerMetadataPolicy);
    }

    @NotNull
    public String toString() {
        return "OpenId4VCIConfig(clientAuthentication=" + this.clientAuthentication + ", authFlowRedirectionURI=" + this.authFlowRedirectionURI + ", encryptionSupportConfig=" + this.encryptionSupportConfig + ", authorizeIssuanceConfig=" + this.authorizeIssuanceConfig + ", dPoPSigner=" + this.dPoPSigner + ", clientAttestationPoPBuilder=" + this.clientAttestationPoPBuilder + ", parUsage=" + this.parUsage + ", clock=" + this.clock + ", issuerMetadataPolicy=" + this.issuerMetadataPolicy + ")";
    }

    public int hashCode() {
        int result = this.clientAuthentication.hashCode();
        result = result * 31 + this.authFlowRedirectionURI.hashCode();
        result = result * 31 + this.encryptionSupportConfig.hashCode();
        result = result * 31 + this.authorizeIssuanceConfig.hashCode();
        result = result * 31 + (this.dPoPSigner == null ? 0 : this.dPoPSigner.hashCode());
        result = result * 31 + this.clientAttestationPoPBuilder.hashCode();
        result = result * 31 + this.parUsage.hashCode();
        result = result * 31 + this.clock.hashCode();
        result = result * 31 + this.issuerMetadataPolicy.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OpenId4VCIConfig)) {
            return false;
        }
        OpenId4VCIConfig openId4VCIConfig = (OpenId4VCIConfig)other;
        if (!Intrinsics.areEqual((Object)this.clientAuthentication, (Object)openId4VCIConfig.clientAuthentication)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.authFlowRedirectionURI, (Object)openId4VCIConfig.authFlowRedirectionURI)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.encryptionSupportConfig, (Object)openId4VCIConfig.encryptionSupportConfig)) {
            return false;
        }
        if (this.authorizeIssuanceConfig != openId4VCIConfig.authorizeIssuanceConfig) {
            return false;
        }
        if (!Intrinsics.areEqual(this.dPoPSigner, openId4VCIConfig.dPoPSigner)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.clientAttestationPoPBuilder, (Object)openId4VCIConfig.clientAttestationPoPBuilder)) {
            return false;
        }
        if (this.parUsage != openId4VCIConfig.parUsage) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.clock, (Object)openId4VCIConfig.clock)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.issuerMetadataPolicy, (Object)openId4VCIConfig.issuerMetadataPolicy);
    }
}

