/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vci.internal;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import eu.europa.ec.eudi.openid4vci.ProofType;
import eu.europa.ec.eudi.openid4vci.internal.Proof;
import eu.europa.ec.eudi.openid4vci.internal.ProofSerializer$ProofJson$;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Leu/europa/ec/eudi/openid4vci/internal/ProofSerializer;", "Lkotlinx/serialization/KSerializer;", "Leu/europa/ec/eudi/openid4vci/internal/Proof;", "<init>", "()V", "internal", "Leu/europa/ec/eudi/openid4vci/internal/ProofSerializer$ProofJson;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "ProofJson", "eudi-lib-jvm-openid4vci-kt"})
public final class ProofSerializer
implements KSerializer<Proof> {
    @NotNull
    public static final ProofSerializer INSTANCE = new ProofSerializer();
    @NotNull
    private static final KSerializer<ProofJson> internal = ProofJson.Companion.serializer();
    @NotNull
    private static final SerialDescriptor descriptor = SerialDescriptorsKt.SerialDescriptor((String)"Proof", (SerialDescriptor)internal.getDescriptor());

    private ProofSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @NotNull
    public Proof deserialize(@NotNull Decoder decoder) {
        String string;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        ProofJson deserialized = (ProofJson)internal.deserialize(decoder);
        String string2 = deserialized.getProofType();
        String string3 = ProofType.JWT.toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        if (Intrinsics.areEqual((Object)string2, (Object)string3)) {
            string = deserialized.getJwt();
            if (string == null) {
                throw new IllegalStateException("Invalid JWT proof: missing 'jwt' attribute.".toString());
            }
        } else {
            throw new IllegalStateException(("Unsupported proof type: " + deserialized.getProofType()).toString());
        }
        String it = string;
        boolean bl = false;
        SignedJWT signedJWT = SignedJWT.parse((String)deserialized.getJwt());
        Intrinsics.checkNotNullExpressionValue((Object)signedJWT, (String)"parse(...)");
        return Proof.Jwt.box-impl(Proof.Jwt.constructor-impl((JWT)signedJWT));
    }

    public void serialize(@NotNull Encoder encoder, @NotNull Proof value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Proof proof = value;
        if (proof instanceof Proof.Jwt) {
            String string = ProofType.JWT.toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            internal.serialize(encoder, (Object)new ProofJson(string, ((Proof.Jwt)value).unbox-impl().serialize(), null, null, 12, null));
        } else if (proof instanceof Proof.DiVp) {
            String string = ProofType.DI_VP.toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            internal.serialize(encoder, (Object)new ProofJson(string, ((Proof.DiVp)value).unbox-impl(), null, null, 12, null));
        } else if (proof instanceof Proof.Attestation) {
            String string = ProofType.ATTESTATION.toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            internal.serialize(encoder, (Object)new ProofJson(string, null, null, ((Proof.Attestation)value).unbox-impl(), 6, null));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Serializable
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 +2\u00020\u0001:\u0002*+B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bBC\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u0007\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J7\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\nH\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001J%\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0001\u00a2\u0006\u0002\b)R\u001c\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0013\u0010\u0011R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0015\u0010\u0011R\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0016\u0010\u000f\u001a\u0004\b\u0017\u0010\u0011\u00a8\u0006,"}, d2={"Leu/europa/ec/eudi/openid4vci/internal/ProofSerializer$ProofJson;", "", "proofType", "", "jwt", "diVp", "attestation", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getProofType$annotations", "()V", "getProofType", "()Ljava/lang/String;", "getJwt$annotations", "getJwt", "getDiVp$annotations", "getDiVp", "getAttestation$annotations", "getAttestation", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$eudi_lib_jvm_openid4vci_kt", "$serializer", "Companion", "eudi-lib-jvm-openid4vci-kt"})
    public static final class ProofJson {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String proofType;
        @Nullable
        private final String jwt;
        @Nullable
        private final String diVp;
        @Nullable
        private final String attestation;

        public ProofJson(@NotNull String proofType, @Nullable String jwt, @Nullable String diVp, @Nullable String attestation) {
            Intrinsics.checkNotNullParameter((Object)proofType, (String)"proofType");
            this.proofType = proofType;
            this.jwt = jwt;
            this.diVp = diVp;
            this.attestation = attestation;
        }

        public /* synthetic */ ProofJson(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                string4 = null;
            }
            this(string, string2, string3, string4);
        }

        @NotNull
        public final String getProofType() {
            return this.proofType;
        }

        @SerialName(value="proof_type")
        public static /* synthetic */ void getProofType$annotations() {
        }

        @Nullable
        public final String getJwt() {
            return this.jwt;
        }

        @SerialName(value="jwt")
        public static /* synthetic */ void getJwt$annotations() {
        }

        @Nullable
        public final String getDiVp() {
            return this.diVp;
        }

        @SerialName(value="di_vp")
        public static /* synthetic */ void getDiVp$annotations() {
        }

        @Nullable
        public final String getAttestation() {
            return this.attestation;
        }

        @SerialName(value="attestation")
        public static /* synthetic */ void getAttestation$annotations() {
        }

        @NotNull
        public final String component1() {
            return this.proofType;
        }

        @Nullable
        public final String component2() {
            return this.jwt;
        }

        @Nullable
        public final String component3() {
            return this.diVp;
        }

        @Nullable
        public final String component4() {
            return this.attestation;
        }

        @NotNull
        public final ProofJson copy(@NotNull String proofType, @Nullable String jwt, @Nullable String diVp, @Nullable String attestation) {
            Intrinsics.checkNotNullParameter((Object)proofType, (String)"proofType");
            return new ProofJson(proofType, jwt, diVp, attestation);
        }

        public static /* synthetic */ ProofJson copy$default(ProofJson proofJson, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = proofJson.proofType;
            }
            if ((n & 2) != 0) {
                string2 = proofJson.jwt;
            }
            if ((n & 4) != 0) {
                string3 = proofJson.diVp;
            }
            if ((n & 8) != 0) {
                string4 = proofJson.attestation;
            }
            return proofJson.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "ProofJson(proofType=" + this.proofType + ", jwt=" + this.jwt + ", diVp=" + this.diVp + ", attestation=" + this.attestation + ")";
        }

        public int hashCode() {
            int result = this.proofType.hashCode();
            result = result * 31 + (this.jwt == null ? 0 : this.jwt.hashCode());
            result = result * 31 + (this.diVp == null ? 0 : this.diVp.hashCode());
            result = result * 31 + (this.attestation == null ? 0 : this.attestation.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProofJson)) {
                return false;
            }
            ProofJson proofJson = (ProofJson)other;
            if (!Intrinsics.areEqual((Object)this.proofType, (Object)proofJson.proofType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.jwt, (Object)proofJson.jwt)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.diVp, (Object)proofJson.diVp)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.attestation, (Object)proofJson.attestation);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$eudi_lib_jvm_openid4vci_kt(ProofJson self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.proofType);
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.jwt != null) {
                output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.jwt);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.diVp != null) {
                output.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.diVp);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : self.attestation != null) {
                output.encodeNullableSerializableElement(serialDesc, 3, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.attestation);
            }
        }

        public /* synthetic */ ProofJson(int seen0, String proofType, String jwt, String diVp, String attestation, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)ProofJson$$serializer.INSTANCE.getDescriptor());
            }
            this.proofType = proofType;
            this.jwt = (seen0 & 2) == 0 ? null : jwt;
            this.diVp = (seen0 & 4) == 0 ? null : diVp;
            this.attestation = (seen0 & 8) == 0 ? null : attestation;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Leu/europa/ec/eudi/openid4vci/internal/ProofSerializer$ProofJson$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Leu/europa/ec/eudi/openid4vci/internal/ProofSerializer$ProofJson;", "eudi-lib-jvm-openid4vci-kt"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<ProofJson> serializer() {
                return (KSerializer)ProofJson$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

