/*
 * Copyright (c) 2023 European Commission
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package eu.europa.ec.eudi.sdjwt.vc

import eu.europa.ec.eudi.sdjwt.SdJwtVcSpec
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonObject
import java.net.URI

@Serializable
data class SdJwtVcIssuerMetadata(
    @Serializable(with = URISerializer::class)
    @SerialName(SdJwtVcSpec.ISSUER) val issuer: URI,
    @Serializable(with = URISerializer::class)
    @SerialName("jwks_uri") val jwksUri: URI? = null,
    @SerialName("jwks") val jwks: JsonObject? = null,
) {

    init {
        check((jwks != null) xor (jwksUri != null)) {
            "either 'jwks' or 'jwks_uri' must be provided"
        }
    }
}
