/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.sdjwt;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.Ed25519Verifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.OctetKeyPair;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import com.nimbusds.jwt.proc.JWTProcessor;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u0000  *\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001 B9\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J!\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J!\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0012\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J!\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0012\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J!\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0012\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0012\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fR\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Leu/europa/ec/eudi/sdjwt/JwkSourceJWTProcessor;", "C", "Lcom/nimbusds/jose/proc/SecurityContext;", "Lcom/nimbusds/jwt/proc/JWTProcessor;", "typeVerifier", "Lcom/nimbusds/jose/proc/JOSEObjectTypeVerifier;", "claimSetVerifier", "Lcom/nimbusds/jwt/proc/JWTClaimsSetVerifier;", "jwkSource", "Lcom/nimbusds/jose/jwk/source/JWKSource;", "<init>", "(Lcom/nimbusds/jose/proc/JOSEObjectTypeVerifier;Lcom/nimbusds/jwt/proc/JWTClaimsSetVerifier;Lcom/nimbusds/jose/jwk/source/JWKSource;)V", "notSupported", "", "process", "Lcom/nimbusds/jwt/JWTClaimsSet;", "plainJWT", "Lcom/nimbusds/jwt/PlainJWT;", "context", "(Lcom/nimbusds/jwt/PlainJWT;Lcom/nimbusds/jose/proc/SecurityContext;)Lcom/nimbusds/jwt/JWTClaimsSet;", "encryptedJWT", "Lcom/nimbusds/jwt/EncryptedJWT;", "(Lcom/nimbusds/jwt/EncryptedJWT;Lcom/nimbusds/jose/proc/SecurityContext;)Lcom/nimbusds/jwt/JWTClaimsSet;", "jwtString", "", "(Ljava/lang/String;Lcom/nimbusds/jose/proc/SecurityContext;)Lcom/nimbusds/jwt/JWTClaimsSet;", "jwt", "Lcom/nimbusds/jwt/JWT;", "(Lcom/nimbusds/jwt/JWT;Lcom/nimbusds/jose/proc/SecurityContext;)Lcom/nimbusds/jwt/JWTClaimsSet;", "signedJWT", "Lcom/nimbusds/jwt/SignedJWT;", "(Lcom/nimbusds/jwt/SignedJWT;Lcom/nimbusds/jose/proc/SecurityContext;)Lcom/nimbusds/jwt/JWTClaimsSet;", "Companion", "eudi-lib-jvm-sdjwt-kt"})
public class JwkSourceJWTProcessor<C extends SecurityContext>
implements JWTProcessor<C> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final JOSEObjectTypeVerifier<C> typeVerifier;
    @Nullable
    private final JWTClaimsSetVerifier<C> claimSetVerifier;
    @NotNull
    private final JWKSource<C> jwkSource;

    public JwkSourceJWTProcessor(@Nullable JOSEObjectTypeVerifier<C> typeVerifier, @Nullable JWTClaimsSetVerifier<C> claimSetVerifier, @NotNull JWKSource<C> jwkSource) {
        Intrinsics.checkNotNullParameter(jwkSource, (String)"jwkSource");
        this.typeVerifier = typeVerifier;
        this.claimSetVerifier = claimSetVerifier;
        this.jwkSource = jwkSource;
    }

    public /* synthetic */ JwkSourceJWTProcessor(JOSEObjectTypeVerifier jOSEObjectTypeVerifier, JWTClaimsSetVerifier jWTClaimsSetVerifier, JWKSource jWKSource, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            jOSEObjectTypeVerifier = null;
        }
        if ((n & 2) != 0) {
            jWTClaimsSetVerifier = null;
        }
        this(jOSEObjectTypeVerifier, jWTClaimsSetVerifier, jWKSource);
    }

    private final Void notSupported() {
        throw new BadJOSEException("Only Nimbus SignedJWTs are supported");
    }

    @Nullable
    public JWTClaimsSet process(@NotNull PlainJWT plainJWT, @Nullable C context) {
        Intrinsics.checkNotNullParameter((Object)plainJWT, (String)"plainJWT");
        this.notSupported();
        throw new KotlinNothingValueException();
    }

    @Nullable
    public JWTClaimsSet process(@NotNull EncryptedJWT encryptedJWT, @Nullable C context) {
        Intrinsics.checkNotNullParameter((Object)encryptedJWT, (String)"encryptedJWT");
        this.notSupported();
        throw new KotlinNothingValueException();
    }

    @Nullable
    public JWTClaimsSet process(@NotNull String jwtString, @Nullable C context) {
        Intrinsics.checkNotNullParameter((Object)jwtString, (String)"jwtString");
        JWT jWT = JWTParser.parse((String)jwtString);
        Intrinsics.checkNotNullExpressionValue((Object)jWT, (String)"parse(...)");
        return this.process(jWT, context);
    }

    @Nullable
    public JWTClaimsSet process(@NotNull JWT jwt, @Nullable C context) {
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        if (!(jwt instanceof SignedJWT)) {
            this.notSupported();
            throw new KotlinNothingValueException();
        }
        return this.process((SignedJWT)jwt, context);
    }

    @NotNull
    public JWTClaimsSet process(@NotNull SignedJWT signedJWT, @Nullable C context) {
        Intrinsics.checkNotNullParameter((Object)signedJWT, (String)"signedJWT");
        JOSEObjectTypeVerifier<C> jOSEObjectTypeVerifier = this.typeVerifier;
        if (jOSEObjectTypeVerifier != null) {
            jOSEObjectTypeVerifier.verify(signedJWT.getHeader().getType(), context);
        }
        JWTClaimsSet claimsSet = JwkSourceJWTProcessor.Companion.jwtClaimSet(signedJWT);
        JWKSelector jwkSelector = new JWKSelector(JWKMatcher.forJWSHeader((JWSHeader)signedJWT.getHeader()));
        List jwks = this.jwkSource.get(jwkSelector, context);
        Collection collection = jwks;
        if (collection == null || collection.isEmpty()) {
            throw new BadJOSEException("Signed JWT rejected: Another algorithm expected, or no matching key(s) found");
        }
        for (JWK jwk : jwks) {
            JWSAlgorithm jWSAlgorithm = signedJWT.getHeader().getAlgorithm();
            Intrinsics.checkNotNullExpressionValue((Object)jWSAlgorithm, (String)"getAlgorithm(...)");
            Intrinsics.checkNotNull((Object)jwk);
            JWSVerifier verifier = JwkSourceJWTProcessor.Companion.jwsVerifierFor(jWSAlgorithm, jwk);
            if (!signedJWT.verify(verifier)) continue;
            JWTClaimsSetVerifier<C> jWTClaimsSetVerifier = this.claimSetVerifier;
            if (jWTClaimsSetVerifier != null) {
                jWTClaimsSetVerifier.verify(claimsSet, context);
            }
            return claimsSet;
        }
        throw new BadJOSEException("Signed JWT rejected: Invalid signature or no matching verifier(s) found");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u0002H\u000e\"\u0006\b\u0001\u0010\u000e\u0018\u0001*\u00020\fH\u0082\b\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Leu/europa/ec/eudi/sdjwt/JwkSourceJWTProcessor$Companion;", "", "<init>", "()V", "jwtClaimSet", "Lcom/nimbusds/jwt/JWTClaimsSet;", "Lcom/nimbusds/jwt/SignedJWT;", "jwsVerifierFor", "Lcom/nimbusds/jose/JWSVerifier;", "algorithm", "Lcom/nimbusds/jose/JWSAlgorithm;", "jwk", "Lcom/nimbusds/jose/jwk/JWK;", "expectIs", "T", "(Lcom/nimbusds/jose/jwk/JWK;)Ljava/lang/Object;", "eudi-lib-jvm-sdjwt-kt"})
    @SourceDebugExtension(value={"SMAP\nNimbusIntegration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NimbusIntegration.kt\neu/europa/ec/eudi/sdjwt/JwkSourceJWTProcessor$Companion\n*L\n1#1,418:1\n407#1,5:419\n407#1,5:424\n407#1,5:429\n407#1,5:434\n*S KotlinDebug\n*F\n+ 1 NimbusIntegration.kt\neu/europa/ec/eudi/sdjwt/JwkSourceJWTProcessor$Companion\n*L\n399#1:419,5\n400#1:424,5\n401#1:429,5\n402#1:434,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final JWTClaimsSet jwtClaimSet(SignedJWT $this$jwtClaimSet) {
            JWTClaimsSet jWTClaimsSet;
            try {
                jWTClaimsSet = $this$jwtClaimSet.getJWTClaimsSet();
            }
            catch (ParseException e) {
                throw new BadJWTException(e.getMessage(), (Throwable)e);
            }
            return jWTClaimsSet;
        }

        private final JWSVerifier jwsVerifierFor(JWSAlgorithm algorithm, JWK jwk) {
            JWSVerifier jWSVerifier;
            JWSAlgorithm jWSAlgorithm = algorithm;
            if (JWSAlgorithm.Family.HMAC_SHA.contains((Object)jWSAlgorithm)) {
                Companion companion = this;
                JWK $this$expectIs$iv = jwk;
                boolean $i$f$expectIs = false;
                if (!($this$expectIs$iv instanceof OctetSequenceKey)) {
                    throw new BadJOSEException("Expected a JWK of type " + OctetSequenceKey.class.getSimpleName());
                }
                jWSVerifier = (JWSVerifier)new MACVerifier((OctetSequenceKey)$this$expectIs$iv);
            } else if (JWSAlgorithm.Family.RSA.contains((Object)jWSAlgorithm)) {
                Companion this_$iv = this;
                JWK $this$expectIs$iv = jwk;
                boolean $i$f$expectIs = false;
                if (!($this$expectIs$iv instanceof RSAKey)) {
                    throw new BadJOSEException("Expected a JWK of type " + RSAKey.class.getSimpleName());
                }
                jWSVerifier = (JWSVerifier)new RSASSAVerifier((RSAKey)$this$expectIs$iv);
            } else if (JWSAlgorithm.Family.EC.contains((Object)jWSAlgorithm)) {
                Companion this_$iv = this;
                JWK $this$expectIs$iv = jwk;
                boolean $i$f$expectIs = false;
                if (!($this$expectIs$iv instanceof ECKey)) {
                    throw new BadJOSEException("Expected a JWK of type " + ECKey.class.getSimpleName());
                }
                jWSVerifier = (JWSVerifier)new ECDSAVerifier((ECKey)$this$expectIs$iv);
            } else if (JWSAlgorithm.Family.ED.contains((Object)jWSAlgorithm)) {
                Companion this_$iv = this;
                JWK $this$expectIs$iv = jwk;
                boolean $i$f$expectIs = false;
                if (!($this$expectIs$iv instanceof OctetKeyPair)) {
                    throw new BadJOSEException("Expected a JWK of type " + OctetKeyPair.class.getSimpleName());
                }
                jWSVerifier = (JWSVerifier)new Ed25519Verifier((OctetKeyPair)$this$expectIs$iv);
            } else {
                throw new BadJOSEException("Unsupported JWS algorithm " + algorithm);
            }
            return jWSVerifier;
        }

        private final /* synthetic */ <T> T expectIs(JWK $this$expectIs) {
            boolean $i$f$expectIs = false;
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!($this$expectIs instanceof Object)) {
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                throw new BadJOSEException("Expected a JWK of type " + Object.class.getSimpleName());
            }
            return (T)$this$expectIs;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

