/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.sdjwt;

import eu.europa.ec.eudi.sdjwt.ClaimVisitor;
import eu.europa.ec.eudi.sdjwt.DiscloseObject;
import eu.europa.ec.eudi.sdjwt.Disclosure;
import eu.europa.ec.eudi.sdjwt.DisclosureDigest;
import eu.europa.ec.eudi.sdjwt.HashAlgorithm;
import eu.europa.ec.eudi.sdjwt.RecreateClaimsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ&\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Leu/europa/ec/eudi/sdjwt/RecreateClaims;", "", "visitor", "Leu/europa/ec/eudi/sdjwt/ClaimVisitor;", "<init>", "(Leu/europa/ec/eudi/sdjwt/ClaimVisitor;)V", "recreateClaims", "Lkotlinx/serialization/json/JsonObject;", "jwtClaims", "disclosures", "", "Leu/europa/ec/eudi/sdjwt/Disclosure;", "discloseJwt", "hashAlgorithm", "Leu/europa/ec/eudi/sdjwt/HashAlgorithm;", "eudi-lib-jvm-sdjwt-kt"})
@SourceDebugExtension(value={"SMAP\nRecreateClaims.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecreateClaims.kt\neu/europa/ec/eudi/sdjwt/RecreateClaims\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,321:1\n1202#2,2:322\n1230#2,4:324\n1557#2:328\n1628#2,3:329\n*S KotlinDebug\n*F\n+ 1 RecreateClaims.kt\neu/europa/ec/eudi/sdjwt/RecreateClaims\n*L\n103#1:322,2\n103#1:324,4\n112#1:328\n112#1:329,3\n*E\n"})
final class RecreateClaims {
    @Nullable
    private final ClaimVisitor visitor;

    public RecreateClaims(@Nullable ClaimVisitor visitor2) {
        this.visitor = visitor2;
    }

    @NotNull
    public final JsonObject recreateClaims(@NotNull JsonObject jwtClaims, @NotNull List<? extends Disclosure> disclosures) {
        Intrinsics.checkNotNullParameter((Object)jwtClaims, (String)"jwtClaims");
        Intrinsics.checkNotNullParameter(disclosures, (String)"disclosures");
        HashAlgorithm hashAlgorithm = RecreateClaimsKt.hashAlgorithm(jwtClaims);
        if (hashAlgorithm == null) {
            hashAlgorithm = HashAlgorithm.SHA_256;
        }
        HashAlgorithm hashAlgorithm2 = hashAlgorithm;
        return this.discloseJwt(hashAlgorithm2, new JsonObject(MapsKt.minus((Map)((Map)jwtClaims), (Object)"_sd_alg")), disclosures);
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject discloseJwt(HashAlgorithm hashAlgorithm, JsonObject jwtClaims, List<? extends Disclosure> disclosures) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = disclosures;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Disclosure disclosure = (Disclosure)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object object = DisclosureDigest.Companion.digest-gIAlu-s(hashAlgorithm, it.getValue());
            ResultKt.throwOnFailure((Object)object);
            map2.put(DisclosureDigest.box-impl(((DisclosureDigest)object).unbox-impl()), element$iv$iv);
        }
        Map disclosuresPerDigest = MapsKt.toMutableMap((Map)destination$iv$iv);
        DiscloseObject discloseObject2 = new DiscloseObject(this.visitor, disclosuresPerDigest);
        JsonObject disclosedClaims = discloseObject2.invoke-HxKvVN4(null, jwtClaims);
        if (!disclosuresPerDigest.isEmpty()) {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = disclosuresPerDigest.values();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Disclosure disclosure = (Disclosure)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.getValue());
            }
            String string = "Could not find digests for disclosures " + (List)destination$iv$iv2;
            throw new IllegalArgumentException(string.toString());
        }
        return disclosedClaims;
    }
}

