/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.sdjwt;

import eu.europa.ec.eudi.sdjwt.KeyBindingError;
import eu.europa.ec.eudi.sdjwt.SdJwtVerifierKt;
import eu.europa.ec.eudi.sdjwt.VerificationError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0005j\u0002`\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tJ$\u0010\n\u001a\u0018\u0012\b\u0012\u00060\u0005j\u0002`\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\f0\u000b2\u0006\u0010\r\u001a\u00020\u0005J2\u0010\u000e\u001a&\u0012\b\u0012\u00060\u0005j\u0002`\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\f\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00070\u000f2\u0006\u0010\r\u001a\u00020\u0005J,\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0010*\b\u0012\u0004\u0012\u0002H\u00100\t2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u00020\u00050\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Leu/europa/ec/eudi/sdjwt/StandardSerialization;", "", "<init>", "()V", "concat", "", "serializedJwt", "Leu/europa/ec/eudi/sdjwt/Jwt;", "disclosures", "", "parseIssuance", "Lkotlin/Pair;", "", "unverifiedSdJwt", "parse", "Lkotlin/Triple;", "T", "get", "Lkotlin/Function1;", "eudi-lib-jvm-sdjwt-kt"})
@SourceDebugExtension(value={"SMAP\nSdJwtSerialization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdJwtSerialization.kt\neu/europa/ec/eudi/sdjwt/StandardSerialization\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,334:1\n1#2:335\n774#3:336\n865#3,2:337\n*S KotlinDebug\n*F\n+ 1 SdJwtSerialization.kt\neu/europa/ec/eudi/sdjwt/StandardSerialization\n*L\n241#1:336\n241#1:337,2\n*E\n"})
public final class StandardSerialization {
    @NotNull
    public static final StandardSerialization INSTANCE = new StandardSerialization();

    private StandardSerialization() {
    }

    @NotNull
    public final String concat(@NotNull String serializedJwt, @NotNull Iterable<String> disclosures) {
        Intrinsics.checkNotNullParameter((Object)serializedJwt, (String)"serializedJwt");
        Intrinsics.checkNotNullParameter(disclosures, (String)"disclosures");
        String serializedDisclosures = this.concat(disclosures, StandardSerialization::concat$lambda$0);
        return serializedJwt + serializedDisclosures;
    }

    @NotNull
    public final Pair<String, List<String>> parseIssuance(@NotNull String unverifiedSdJwt) {
        Intrinsics.checkNotNullParameter((Object)unverifiedSdJwt, (String)"unverifiedSdJwt");
        Triple<String, List<String>, String> triple = this.parse(unverifiedSdJwt);
        String jwt = (String)triple.component1();
        List ds = (List)triple.component2();
        String kbJwt2 = (String)triple.component3();
        if (kbJwt2 != null) {
            throw SdJwtVerifierKt.asException(KeyBindingError.UnexpectedKeyBindingJwt.INSTANCE);
        }
        return TuplesKt.to((Object)jwt, (Object)ds);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Triple<String, List<String>, String> parse(@NotNull String unverifiedSdJwt) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)unverifiedSdJwt, (String)"unverifiedSdJwt");
        char[] cArray = new char[]{'~'};
        List parts = StringsKt.split$default((CharSequence)unverifiedSdJwt, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (parts.size() <= 1) {
            throw SdJwtVerifierKt.asException(VerificationError.ParsingError.INSTANCE);
        }
        String jwt = (String)parts.get(0);
        boolean containsKeyBinding = !StringsKt.endsWith$default((CharSequence)unverifiedSdJwt, (char)'~', (boolean)false, (int)2, null);
        List $this$parse_u24lambda_u241 = CollectionsKt.drop((Iterable)parts, (int)1);
        boolean $i$a$-run-StandardSerialization$parse$ds$22 = false;
        Iterable iterable = containsKeyBinding ? CollectionsKt.dropLast((List)$this$parse_u24lambda_u241, (int)1) : $this$parse_u24lambda_u241;
        boolean $i$f$filter = false;
        void $i$a$-run-StandardSerialization$parse$ds$22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List ds = (List)destination$iv$iv;
        String kbJwt2 = containsKeyBinding ? (String)CollectionsKt.last((List)parts) : null;
        return new Triple((Object)jwt, (Object)ds, (Object)kbJwt2);
    }

    private final <T> String concat(Iterable<? extends T> $this$concat, Function1<? super T, String> get) {
        return CollectionsKt.joinToString$default($this$concat, (CharSequence)"", (CharSequence)"~", null, (int)0, null, arg_0 -> StandardSerialization.concat$lambda$3(get, arg_0), (int)28, null);
    }

    private static final String concat$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final CharSequence concat$lambda$3(Function1 $get, Object it) {
        return $get.invoke(it) + "~";
    }
}

