/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.sdjwt.vc;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00018\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Leu/europa/ec/eudi/sdjwt/vc/DIDJWKSet;", "C", "Lcom/nimbusds/jose/proc/SecurityContext;", "Lcom/nimbusds/jose/jwk/source/JWKSource;", "jwsHeader", "Lcom/nimbusds/jose/JWSHeader;", "jwkSet", "Lcom/nimbusds/jose/jwk/JWKSet;", "<init>", "(Lcom/nimbusds/jose/JWSHeader;Lcom/nimbusds/jose/jwk/JWKSet;)V", "getJwkSet", "()Lcom/nimbusds/jose/jwk/JWKSet;", "jwkSelector", "Lcom/nimbusds/jose/jwk/JWKSelector;", "getJwkSelector", "()Lcom/nimbusds/jose/jwk/JWKSelector;", "jwkSelector$delegate", "Lkotlin/Lazy;", "get", "", "Lcom/nimbusds/jose/jwk/JWK;", "context", "(Lcom/nimbusds/jose/jwk/JWKSelector;Lcom/nimbusds/jose/proc/SecurityContext;)Ljava/util/List;", "eudi-lib-jvm-sdjwt-kt"})
final class DIDJWKSet<C extends SecurityContext>
implements JWKSource<C> {
    @NotNull
    private final JWKSet jwkSet;
    @NotNull
    private final Lazy jwkSelector$delegate;

    public DIDJWKSet(@NotNull JWSHeader jwsHeader, @NotNull JWKSet jwkSet) {
        Intrinsics.checkNotNullParameter((Object)jwsHeader, (String)"jwsHeader");
        Intrinsics.checkNotNullParameter((Object)jwkSet, (String)"jwkSet");
        this.jwkSet = jwkSet;
        this.jwkSelector$delegate = LazyKt.lazy(() -> DIDJWKSet.jwkSelector_delegate$lambda$0(jwsHeader));
    }

    @NotNull
    public final JWKSet getJwkSet() {
        return this.jwkSet;
    }

    private final JWKSelector getJwkSelector() {
        Lazy lazy = this.jwkSelector$delegate;
        return (JWKSelector)lazy.getValue();
    }

    @NotNull
    public List<JWK> get(@NotNull JWKSelector jwkSelector, @Nullable C context) {
        Intrinsics.checkNotNullParameter((Object)jwkSelector, (String)"jwkSelector");
        List list = this.getJwkSelector().select(this.jwkSet);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"select(...)");
        return list;
    }

    private static final JWKSelector jwkSelector_delegate$lambda$0(JWSHeader $jwsHeader) {
        JWKMatcher jWKMatcher;
        JWSAlgorithm algorithm = $jwsHeader.getAlgorithm();
        if (JWSAlgorithm.Family.RSA.contains((Object)algorithm) || JWSAlgorithm.Family.EC.contains((Object)algorithm)) {
            var3_2 = new KeyUse[]{KeyUse.SIGNATURE, null};
            JWKMatcher.Builder builder = new JWKMatcher.Builder().keyType(KeyType.forAlgorithm((Algorithm)((Algorithm)algorithm))).keyUses(var3_2);
            var3_2 = new Algorithm[]{algorithm, null};
            jWKMatcher = builder.algorithms((Algorithm[])var3_2).x509CertSHA256Thumbprint($jwsHeader.getX509CertSHA256Thumbprint()).build();
        } else if (JWSAlgorithm.Family.ED.contains((Object)algorithm)) {
            var3_2 = new KeyUse[]{KeyUse.SIGNATURE, null};
            JWKMatcher.Builder builder = new JWKMatcher.Builder().keyType(KeyType.forAlgorithm((Algorithm)((Algorithm)algorithm))).keyUses(var3_2);
            var3_2 = new Algorithm[]{algorithm, null};
            jWKMatcher = builder.algorithms((Algorithm[])var3_2).curves(Curve.forJWSAlgorithm((JWSAlgorithm)algorithm)).build();
        } else {
            throw new IllegalStateException(("Unsupported JWSAlgorithm '" + algorithm + "'").toString());
        }
        JWKMatcher matcher = jWKMatcher;
        return new JWKSelector(matcher);
    }
}

