/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.sdjwt.vc;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jwt.SignedJWT;
import eu.europa.ec.eudi.sdjwt.JwtSignatureVerifier;
import eu.europa.ec.eudi.sdjwt.vc.IssuerVerificationMethod;
import eu.europa.ec.eudi.sdjwt.vc.NimbusSdJwtVcVerifier;
import eu.europa.ec.eudi.sdjwt.vc.NimbusSdJwtVcVerifierFactoryKt;
import eu.europa.ec.eudi.sdjwt.vc.SdJwtVcVerifier;
import eu.europa.ec.eudi.sdjwt.vc.SdJwtVcVerifierFactory;
import eu.europa.ec.eudi.sdjwt.vc.TypeMetadataPolicy;
import java.security.cert.X509Certificate;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J7\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u001e\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0002\u00a8\u0006\u000e"}, d2={"Leu/europa/ec/eudi/sdjwt/vc/NimbusSdJwtVcVerifierFactory;", "Leu/europa/ec/eudi/sdjwt/vc/SdJwtVcVerifierFactory;", "Lcom/nimbusds/jwt/SignedJWT;", "Lcom/nimbusds/jose/jwk/JWK;", "", "Ljava/security/cert/X509Certificate;", "<init>", "()V", "invoke", "Leu/europa/ec/eudi/sdjwt/vc/SdJwtVcVerifier;", "issuerVerificationMethod", "Leu/europa/ec/eudi/sdjwt/vc/IssuerVerificationMethod;", "typeMetadataPolicy", "Leu/europa/ec/eudi/sdjwt/vc/TypeMetadataPolicy;", "eudi-lib-jvm-sdjwt-kt"})
public final class NimbusSdJwtVcVerifierFactory
implements SdJwtVcVerifierFactory<SignedJWT, JWK, List<? extends X509Certificate>> {
    @NotNull
    public static final NimbusSdJwtVcVerifierFactory INSTANCE = new NimbusSdJwtVcVerifierFactory();

    private NimbusSdJwtVcVerifierFactory() {
    }

    @Override
    @NotNull
    public SdJwtVcVerifier<SignedJWT> invoke(@NotNull IssuerVerificationMethod<? extends SignedJWT, ? extends JWK, ? super List<? extends X509Certificate>> issuerVerificationMethod, @NotNull TypeMetadataPolicy typeMetadataPolicy) {
        JwtSignatureVerifier jwtSignatureVerifier;
        Intrinsics.checkNotNullParameter(issuerVerificationMethod, (String)"issuerVerificationMethod");
        Intrinsics.checkNotNullParameter((Object)typeMetadataPolicy, (String)"typeMetadataPolicy");
        IssuerVerificationMethod<? extends SignedJWT, ? extends JWK, ? super List<? extends X509Certificate>> issuerVerificationMethod2 = issuerVerificationMethod;
        if (issuerVerificationMethod2 instanceof IssuerVerificationMethod.UsingIssuerMetadata) {
            jwtSignatureVerifier = NimbusSdJwtVcVerifierFactoryKt.sdJwtVcSignatureVerifier$default(((IssuerVerificationMethod.UsingIssuerMetadata)issuerVerificationMethod).getHttpClient(), null, null, 6, null);
        } else if (issuerVerificationMethod2 instanceof IssuerVerificationMethod.UsingX5c) {
            jwtSignatureVerifier = NimbusSdJwtVcVerifierFactoryKt.sdJwtVcSignatureVerifier$default(null, ((IssuerVerificationMethod.UsingX5c)issuerVerificationMethod).getX509CertificateTrust(), null, 5, null);
        } else if (issuerVerificationMethod2 instanceof IssuerVerificationMethod.UsingDID) {
            jwtSignatureVerifier = NimbusSdJwtVcVerifierFactoryKt.sdJwtVcSignatureVerifier$default(null, null, ((IssuerVerificationMethod.UsingDID)issuerVerificationMethod).getDidLookup(), 3, null);
        } else if (issuerVerificationMethod2 instanceof IssuerVerificationMethod.UsingX5cOrIssuerMetadata) {
            jwtSignatureVerifier = NimbusSdJwtVcVerifierFactoryKt.sdJwtVcSignatureVerifier$default(((IssuerVerificationMethod.UsingX5cOrIssuerMetadata)issuerVerificationMethod).getHttpClient(), ((IssuerVerificationMethod.UsingX5cOrIssuerMetadata)issuerVerificationMethod).getX509CertificateTrust(), null, 4, null);
        } else if (issuerVerificationMethod2 instanceof IssuerVerificationMethod.Custom) {
            jwtSignatureVerifier = ((IssuerVerificationMethod.Custom)issuerVerificationMethod).getJwtSignatureVerifier();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        JwtSignatureVerifier jwtSignatureVerifier2 = jwtSignatureVerifier;
        return new NimbusSdJwtVcVerifier(jwtSignatureVerifier2, typeMetadataPolicy);
    }

    @Override
    @NotNull
    public <JWT1, JWK1, X509Chain1> SdJwtVcVerifierFactory<JWT1, JWK1, X509Chain1> transform(@NotNull Function1<? super JWT1, ? extends SignedJWT> convertFromJwt, @NotNull Function1<? super SignedJWT, ? extends JWT1> convertToJwt, @NotNull Function1<? super JWK1, ? extends JWK> convertFromJwk, @NotNull Function1<? super List<? extends X509Certificate>, ? extends X509Chain1> convertToX509Chain) {
        return SdJwtVcVerifierFactory.DefaultImpls.transform(this, convertFromJwt, convertToJwt, convertFromJwk, convertToX509Chain);
    }
}

