/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.sdjwt.vc;

import eu.europa.ec.eudi.sdjwt.PlatformKt;
import eu.europa.ec.eudi.sdjwt.vc.DocumentHash;
import eu.europa.ec.eudi.sdjwt.vc.DocumentIntegrity;
import eu.europa.ec.eudi.sdjwt.vc.IntegrityAlgorithm;
import eu.europa.ec.eudi.sdjwt.vc.SubResourceIntegrityKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Leu/europa/ec/eudi/sdjwt/vc/SRIValidator;", "", "allowedAlgorithms", "", "Leu/europa/ec/eudi/sdjwt/vc/IntegrityAlgorithm;", "<init>", "(Ljava/util/Set;)V", "base64Padding", "Lkotlin/io/encoding/Base64;", "isValid", "", "expectedIntegrity", "Leu/europa/ec/eudi/sdjwt/vc/DocumentIntegrity;", "contentToValidate", "", "isValid-a-2eeLU", "(Ljava/lang/String;[B)Z", "eudi-lib-jvm-sdjwt-kt"})
@SourceDebugExtension(value={"SMAP\nSubResourceIntegrity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubResourceIntegrity.kt\neu/europa/ec/eudi/sdjwt/vc/SRIValidator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,120:1\n1#2:121\n1491#3:122\n1516#3,3:123\n1519#3,3:133\n774#3:136\n865#3,2:137\n1999#3,14:139\n1761#3,3:153\n384#4,7:126\n*S KotlinDebug\n*F\n+ 1 SubResourceIntegrity.kt\neu/europa/ec/eudi/sdjwt/vc/SRIValidator\n*L\n92#1:122\n92#1:123,3\n92#1:133,3\n94#1:136\n94#1:137,2\n95#1:139,14\n109#1:153,3\n92#1:126,7\n*E\n"})
public final class SRIValidator {
    @NotNull
    private final Set<IntegrityAlgorithm> allowedAlgorithms;
    @NotNull
    private final Base64 base64Padding;

    public SRIValidator(@NotNull Set<? extends IntegrityAlgorithm> allowedAlgorithms) {
        Intrinsics.checkNotNullParameter(allowedAlgorithms, (String)"allowedAlgorithms");
        this.allowedAlgorithms = allowedAlgorithms;
        this.base64Padding = Base64.Default.withPadding(Base64.PaddingOption.PRESENT);
        if (!(!((Collection)this.allowedAlgorithms).isEmpty())) {
            boolean bl = false;
            String string = "At least one integrity algorithm must be provided";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ SRIValidator(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = CollectionsKt.toSet((Iterable)((Iterable)IntegrityAlgorithm.getEntries()));
        }
        this(set);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isValid-a-2eeLU(@NotNull String expectedIntegrity, @NotNull byte[] contentToValidate) {
        boolean bl;
        block19: {
            IntegrityAlgorithm maybeStrongestAlgorithm;
            Object v1;
            void $this$maxByOrNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$groupByTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)expectedIntegrity, (String)"expectedIntegrity");
            Intrinsics.checkNotNullParameter((Object)contentToValidate, (String)"contentToValidate");
            Iterable $this$groupBy$iv = DocumentIntegrity.getHashes-impl(expectedIntegrity);
            boolean $i$f$groupBy22 = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                DocumentHash it = (DocumentHash)element$iv$iv;
                boolean bl2 = false;
                IntegrityAlgorithm key$iv$iv = it.getAlgorithm();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map expectedHashesByAlgorithm = destination$iv$iv;
            Iterable $i$f$groupBy22 = expectedHashesByAlgorithm.keySet();
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IntegrityAlgorithm it = (IntegrityAlgorithm)((Object)element$iv$iv);
                boolean bl4 = false;
                if (!this.allowedAlgorithms.contains((Object)it)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = maxElem$iv;
                } else {
                    IntegrityAlgorithm it = (IntegrityAlgorithm)((Object)maxElem$iv);
                    boolean bl5 = false;
                    int maxValue$iv = SubResourceIntegrityKt.access$getStrength(it);
                    do {
                        Object e$iv = iterator$iv.next();
                        IntegrityAlgorithm it2 = (IntegrityAlgorithm)((Object)e$iv);
                        $i$a$-maxByOrNull-SRIValidator$isValid$maybeStrongestAlgorithm$2 = false;
                        int v$iv = SubResourceIntegrityKt.access$getStrength(it2);
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = maxElem$iv;
                }
            }
            IntegrityAlgorithm integrityAlgorithm = maybeStrongestAlgorithm = (IntegrityAlgorithm)v1;
            if (integrityAlgorithm != null) {
                IntegrityAlgorithm strongestAlgorithm = integrityAlgorithm;
                boolean bl6 = false;
                Object v = expectedHashesByAlgorithm.get((Object)strongestAlgorithm);
                Intrinsics.checkNotNull(v);
                List strongestExpectedHashes = (List)v;
                SRIValidator $this$isValid_a_2eeLU_u24lambda_u246_u24lambda_u244 = this;
                boolean bl7 = false;
                byte[] digest = switch (WhenMappings.$EnumSwitchMapping$0[strongestAlgorithm.ordinal()]) {
                    case 1 -> PlatformKt.platform().getHashes().sha256(contentToValidate);
                    case 2 -> PlatformKt.platform().getHashes().sha384(contentToValidate);
                    case 3 -> PlatformKt.platform().getHashes().sha512(contentToValidate);
                    default -> throw new NoWhenBranchMatchedException();
                };
                String actualEncodedHash = Base64.encode$default((Base64)$this$isValid_a_2eeLU_u24lambda_u246_u24lambda_u244.base64Padding, (byte[])digest, (int)0, (int)0, (int)6, null);
                Iterable $this$any$iv = strongestExpectedHashes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DocumentHash it = (DocumentHash)element$iv;
                        boolean bl8 = false;
                        if (!Intrinsics.areEqual((Object)actualEncodedHash, (Object)it.getEncodedHash())) continue;
                        bl = true;
                        break block19;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public SRIValidator() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IntegrityAlgorithm.values().length];
            try {
                nArray[IntegrityAlgorithm.SHA256.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntegrityAlgorithm.SHA384.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntegrityAlgorithm.SHA512.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

