/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp;

import eu.europa.ec.eudi.openid4vp.ClientIdPrefix;
import eu.europa.ec.eudi.openid4vp.VerifierId;
import java.io.Serializable;
import java.net.URI;
import java.security.cert.X509Certificate;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0006\u0006\u0007\b\t\n\u000bR\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0006\f\r\u000e\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Leu/europa/ec/eudi/openid4vp/Client;", "Ljava/io/Serializable;", "id", "Leu/europa/ec/eudi/openid4vp/VerifierId;", "getId", "()Leu/europa/ec/eudi/openid4vp/VerifierId;", "Preregistered", "RedirectUri", "DecentralizedIdentifier", "VerifierAttestation", "X509SanDns", "X509Hash", "Leu/europa/ec/eudi/openid4vp/Client$DecentralizedIdentifier;", "Leu/europa/ec/eudi/openid4vp/Client$Preregistered;", "Leu/europa/ec/eudi/openid4vp/Client$RedirectUri;", "Leu/europa/ec/eudi/openid4vp/Client$VerifierAttestation;", "Leu/europa/ec/eudi/openid4vp/Client$X509Hash;", "Leu/europa/ec/eudi/openid4vp/Client$X509SanDns;", "eudi-lib-jvm-siop-openid4vp-kt"})
public interface Client
extends Serializable {
    @NotNull
    public VerifierId getId();

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Leu/europa/ec/eudi/openid4vp/Client$DecentralizedIdentifier;", "Leu/europa/ec/eudi/openid4vp/Client;", "clientId", "Ljava/net/URI;", "<init>", "(Ljava/net/URI;)V", "getClientId", "()Ljava/net/URI;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "eudi-lib-jvm-siop-openid4vp-kt"})
    public static final class DecentralizedIdentifier
    implements Client {
        @NotNull
        private final URI clientId;

        public DecentralizedIdentifier(@NotNull URI clientId) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            this.clientId = clientId;
        }

        @NotNull
        public final URI getClientId() {
            return this.clientId;
        }

        @NotNull
        public final URI component1() {
            return this.clientId;
        }

        @NotNull
        public final DecentralizedIdentifier copy(@NotNull URI clientId) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            return new DecentralizedIdentifier(clientId);
        }

        public static /* synthetic */ DecentralizedIdentifier copy$default(DecentralizedIdentifier decentralizedIdentifier, URI uRI, int n, Object object) {
            if ((n & 1) != 0) {
                uRI = decentralizedIdentifier.clientId;
            }
            return decentralizedIdentifier.copy(uRI);
        }

        @NotNull
        public String toString() {
            return "DecentralizedIdentifier(clientId=" + this.clientId + ")";
        }

        public int hashCode() {
            return this.clientId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DecentralizedIdentifier)) {
                return false;
            }
            DecentralizedIdentifier decentralizedIdentifier = (DecentralizedIdentifier)other;
            return Intrinsics.areEqual((Object)this.clientId, (Object)decentralizedIdentifier.clientId);
        }

        @Override
        @NotNull
        public VerifierId getId() {
            return DefaultImpls.getId(this);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static VerifierId getId(@NotNull Client $this) {
            VerifierId verifierId;
            Client client = $this;
            if (client instanceof Preregistered) {
                verifierId = new VerifierId(ClientIdPrefix.PreRegistered, ((Preregistered)$this).getClientId());
            } else if (client instanceof RedirectUri) {
                String string = ((RedirectUri)$this).getClientId().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                verifierId = new VerifierId(ClientIdPrefix.RedirectUri, string);
            } else if (client instanceof DecentralizedIdentifier) {
                String string = ((DecentralizedIdentifier)$this).getClientId().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                verifierId = new VerifierId(ClientIdPrefix.DecentralizedIdentifier, string);
            } else if (client instanceof VerifierAttestation) {
                verifierId = new VerifierId(ClientIdPrefix.VerifierAttestation, ((VerifierAttestation)$this).getClientId());
            } else if (client instanceof X509SanDns) {
                verifierId = new VerifierId(ClientIdPrefix.X509SanDns, ((X509SanDns)$this).getClientId());
            } else if (client instanceof X509Hash) {
                verifierId = new VerifierId(ClientIdPrefix.X509Hash, ((X509Hash)$this).getClientId());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return verifierId;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\u000b\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0015"}, d2={"Leu/europa/ec/eudi/openid4vp/Client$Preregistered;", "Leu/europa/ec/eudi/openid4vp/Client;", "clientId", "", "Leu/europa/ec/eudi/openid4vp/OriginalClientId;", "legalName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getClientId", "()Ljava/lang/String;", "getLegalName", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "eudi-lib-jvm-siop-openid4vp-kt"})
    public static final class Preregistered
    implements Client {
        @NotNull
        private final String clientId;
        @NotNull
        private final String legalName;

        public Preregistered(@NotNull String clientId, @NotNull String legalName2) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)legalName2, (String)"legalName");
            this.clientId = clientId;
            this.legalName = legalName2;
        }

        @NotNull
        public final String getClientId() {
            return this.clientId;
        }

        @NotNull
        public final String getLegalName() {
            return this.legalName;
        }

        @NotNull
        public final String component1() {
            return this.clientId;
        }

        @NotNull
        public final String component2() {
            return this.legalName;
        }

        @NotNull
        public final Preregistered copy(@NotNull String clientId, @NotNull String legalName2) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)legalName2, (String)"legalName");
            return new Preregistered(clientId, legalName2);
        }

        public static /* synthetic */ Preregistered copy$default(Preregistered preregistered, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = preregistered.clientId;
            }
            if ((n & 2) != 0) {
                string2 = preregistered.legalName;
            }
            return preregistered.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Preregistered(clientId=" + this.clientId + ", legalName=" + this.legalName + ")";
        }

        public int hashCode() {
            int result = this.clientId.hashCode();
            result = result * 31 + this.legalName.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Preregistered)) {
                return false;
            }
            Preregistered preregistered = (Preregistered)other;
            if (!Intrinsics.areEqual((Object)this.clientId, (Object)preregistered.clientId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.legalName, (Object)preregistered.legalName);
        }

        @Override
        @NotNull
        public VerifierId getId() {
            return DefaultImpls.getId(this);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Leu/europa/ec/eudi/openid4vp/Client$RedirectUri;", "Leu/europa/ec/eudi/openid4vp/Client;", "clientId", "Ljava/net/URI;", "<init>", "(Ljava/net/URI;)V", "getClientId", "()Ljava/net/URI;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "eudi-lib-jvm-siop-openid4vp-kt"})
    public static final class RedirectUri
    implements Client {
        @NotNull
        private final URI clientId;

        public RedirectUri(@NotNull URI clientId) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            this.clientId = clientId;
        }

        @NotNull
        public final URI getClientId() {
            return this.clientId;
        }

        @NotNull
        public final URI component1() {
            return this.clientId;
        }

        @NotNull
        public final RedirectUri copy(@NotNull URI clientId) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            return new RedirectUri(clientId);
        }

        public static /* synthetic */ RedirectUri copy$default(RedirectUri redirectUri, URI uRI, int n, Object object) {
            if ((n & 1) != 0) {
                uRI = redirectUri.clientId;
            }
            return redirectUri.copy(uRI);
        }

        @NotNull
        public String toString() {
            return "RedirectUri(clientId=" + this.clientId + ")";
        }

        public int hashCode() {
            return this.clientId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RedirectUri)) {
                return false;
            }
            RedirectUri redirectUri = (RedirectUri)other;
            return Intrinsics.areEqual((Object)this.clientId, (Object)redirectUri.clientId);
        }

        @Override
        @NotNull
        public VerifierId getId() {
            return DefaultImpls.getId(this);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\t\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\u0017\u0010\n\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Leu/europa/ec/eudi/openid4vp/Client$VerifierAttestation;", "Leu/europa/ec/eudi/openid4vp/Client;", "clientId", "", "Leu/europa/ec/eudi/openid4vp/OriginalClientId;", "<init>", "(Ljava/lang/String;)V", "getClientId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "eudi-lib-jvm-siop-openid4vp-kt"})
    public static final class VerifierAttestation
    implements Client {
        @NotNull
        private final String clientId;

        public VerifierAttestation(@NotNull String clientId) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            this.clientId = clientId;
        }

        @NotNull
        public final String getClientId() {
            return this.clientId;
        }

        @NotNull
        public final String component1() {
            return this.clientId;
        }

        @NotNull
        public final VerifierAttestation copy(@NotNull String clientId) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            return new VerifierAttestation(clientId);
        }

        public static /* synthetic */ VerifierAttestation copy$default(VerifierAttestation verifierAttestation, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = verifierAttestation.clientId;
            }
            return verifierAttestation.copy(string);
        }

        @NotNull
        public String toString() {
            return "VerifierAttestation(clientId=" + this.clientId + ")";
        }

        public int hashCode() {
            return this.clientId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VerifierAttestation)) {
                return false;
            }
            VerifierAttestation verifierAttestation = (VerifierAttestation)other;
            return Intrinsics.areEqual((Object)this.clientId, (Object)verifierAttestation.clientId);
        }

        @Override
        @NotNull
        public VerifierId getId() {
            return DefaultImpls.getId(this);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\r\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J!\u0010\u000f\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Leu/europa/ec/eudi/openid4vp/Client$X509Hash;", "Leu/europa/ec/eudi/openid4vp/Client;", "clientId", "", "Leu/europa/ec/eudi/openid4vp/OriginalClientId;", "cert", "Ljava/security/cert/X509Certificate;", "<init>", "(Ljava/lang/String;Ljava/security/cert/X509Certificate;)V", "getClientId", "()Ljava/lang/String;", "getCert", "()Ljava/security/cert/X509Certificate;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "eudi-lib-jvm-siop-openid4vp-kt"})
    public static final class X509Hash
    implements Client {
        @NotNull
        private final String clientId;
        @NotNull
        private final X509Certificate cert;

        public X509Hash(@NotNull String clientId, @NotNull X509Certificate cert) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
            this.clientId = clientId;
            this.cert = cert;
        }

        @NotNull
        public final String getClientId() {
            return this.clientId;
        }

        @NotNull
        public final X509Certificate getCert() {
            return this.cert;
        }

        @NotNull
        public final String component1() {
            return this.clientId;
        }

        @NotNull
        public final X509Certificate component2() {
            return this.cert;
        }

        @NotNull
        public final X509Hash copy(@NotNull String clientId, @NotNull X509Certificate cert) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
            return new X509Hash(clientId, cert);
        }

        public static /* synthetic */ X509Hash copy$default(X509Hash x509Hash, String string, X509Certificate x509Certificate, int n, Object object) {
            if ((n & 1) != 0) {
                string = x509Hash.clientId;
            }
            if ((n & 2) != 0) {
                x509Certificate = x509Hash.cert;
            }
            return x509Hash.copy(string, x509Certificate);
        }

        @NotNull
        public String toString() {
            return "X509Hash(clientId=" + this.clientId + ", cert=" + this.cert + ")";
        }

        public int hashCode() {
            int result = this.clientId.hashCode();
            result = result * 31 + this.cert.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof X509Hash)) {
                return false;
            }
            X509Hash x509Hash = (X509Hash)other;
            if (!Intrinsics.areEqual((Object)this.clientId, (Object)x509Hash.clientId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.cert, (Object)x509Hash.cert);
        }

        @Override
        @NotNull
        public VerifierId getId() {
            return DefaultImpls.getId(this);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\r\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J!\u0010\u000f\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Leu/europa/ec/eudi/openid4vp/Client$X509SanDns;", "Leu/europa/ec/eudi/openid4vp/Client;", "clientId", "", "Leu/europa/ec/eudi/openid4vp/OriginalClientId;", "cert", "Ljava/security/cert/X509Certificate;", "<init>", "(Ljava/lang/String;Ljava/security/cert/X509Certificate;)V", "getClientId", "()Ljava/lang/String;", "getCert", "()Ljava/security/cert/X509Certificate;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "eudi-lib-jvm-siop-openid4vp-kt"})
    public static final class X509SanDns
    implements Client {
        @NotNull
        private final String clientId;
        @NotNull
        private final X509Certificate cert;

        public X509SanDns(@NotNull String clientId, @NotNull X509Certificate cert) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
            this.clientId = clientId;
            this.cert = cert;
        }

        @NotNull
        public final String getClientId() {
            return this.clientId;
        }

        @NotNull
        public final X509Certificate getCert() {
            return this.cert;
        }

        @NotNull
        public final String component1() {
            return this.clientId;
        }

        @NotNull
        public final X509Certificate component2() {
            return this.cert;
        }

        @NotNull
        public final X509SanDns copy(@NotNull String clientId, @NotNull X509Certificate cert) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
            return new X509SanDns(clientId, cert);
        }

        public static /* synthetic */ X509SanDns copy$default(X509SanDns x509SanDns, String string, X509Certificate x509Certificate, int n, Object object) {
            if ((n & 1) != 0) {
                string = x509SanDns.clientId;
            }
            if ((n & 2) != 0) {
                x509Certificate = x509SanDns.cert;
            }
            return x509SanDns.copy(string, x509Certificate);
        }

        @NotNull
        public String toString() {
            return "X509SanDns(clientId=" + this.clientId + ", cert=" + this.cert + ")";
        }

        public int hashCode() {
            int result = this.clientId.hashCode();
            result = result * 31 + this.cert.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof X509SanDns)) {
                return false;
            }
            X509SanDns x509SanDns = (X509SanDns)other;
            if (!Intrinsics.areEqual((Object)this.clientId, (Object)x509SanDns.clientId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.cert, (Object)x509SanDns.cert);
        }

        @Override
        @NotNull
        public VerifierId getId() {
            return DefaultImpls.getId(this);
        }
    }
}

