/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp;

import com.nimbusds.jose.JWSVerifier;
import eu.europa.ec.eudi.openid4vp.ClientIdPrefix;
import eu.europa.ec.eudi.openid4vp.LookupPublicKeyByDIDUrl;
import eu.europa.ec.eudi.openid4vp.PreregisteredClient;
import eu.europa.ec.eudi.openid4vp.X509CertificateTrust;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0006\u0004\u0005\u0006\u0007\b\tJ\b\u0010\u0002\u001a\u00020\u0003H\u0016\u0082\u0001\u0006\n\u000b\f\r\u000e\u000f\u00a8\u0006\u0010"}, d2={"Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix;", "", "prefix", "Leu/europa/ec/eudi/openid4vp/ClientIdPrefix;", "Preregistered", "RedirectUri", "DecentralizedIdentifier", "VerifierAttestation", "X509SanDns", "X509Hash", "Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix$DecentralizedIdentifier;", "Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix$Preregistered;", "Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix$RedirectUri;", "Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix$VerifierAttestation;", "Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix$X509Hash;", "Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix$X509SanDns;", "eudi-lib-jvm-siop-openid4vp-kt"})
public interface SupportedClientIdPrefix {
    @NotNull
    public ClientIdPrefix prefix();

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix$DecentralizedIdentifier;", "Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix;", "lookup", "Leu/europa/ec/eudi/openid4vp/LookupPublicKeyByDIDUrl;", "<init>", "(Leu/europa/ec/eudi/openid4vp/LookupPublicKeyByDIDUrl;)V", "getLookup", "()Leu/europa/ec/eudi/openid4vp/LookupPublicKeyByDIDUrl;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "eudi-lib-jvm-siop-openid4vp-kt"})
    public static final class DecentralizedIdentifier
    implements SupportedClientIdPrefix {
        @NotNull
        private final LookupPublicKeyByDIDUrl lookup;

        public DecentralizedIdentifier(@NotNull LookupPublicKeyByDIDUrl lookup) {
            Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
            this.lookup = lookup;
        }

        @NotNull
        public final LookupPublicKeyByDIDUrl getLookup() {
            return this.lookup;
        }

        @NotNull
        public final LookupPublicKeyByDIDUrl component1() {
            return this.lookup;
        }

        @NotNull
        public final DecentralizedIdentifier copy(@NotNull LookupPublicKeyByDIDUrl lookup) {
            Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
            return new DecentralizedIdentifier(lookup);
        }

        public static /* synthetic */ DecentralizedIdentifier copy$default(DecentralizedIdentifier decentralizedIdentifier, LookupPublicKeyByDIDUrl lookupPublicKeyByDIDUrl, int n, Object object) {
            if ((n & 1) != 0) {
                lookupPublicKeyByDIDUrl = decentralizedIdentifier.lookup;
            }
            return decentralizedIdentifier.copy(lookupPublicKeyByDIDUrl);
        }

        @NotNull
        public String toString() {
            return "DecentralizedIdentifier(lookup=" + this.lookup + ")";
        }

        public int hashCode() {
            return this.lookup.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DecentralizedIdentifier)) {
                return false;
            }
            DecentralizedIdentifier decentralizedIdentifier = (DecentralizedIdentifier)other;
            return Intrinsics.areEqual((Object)this.lookup, (Object)decentralizedIdentifier.lookup);
        }

        @Override
        @NotNull
        public ClientIdPrefix prefix() {
            return DefaultImpls.prefix(this);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static ClientIdPrefix prefix(@NotNull SupportedClientIdPrefix $this) {
            ClientIdPrefix clientIdPrefix;
            SupportedClientIdPrefix supportedClientIdPrefix = $this;
            if (supportedClientIdPrefix instanceof Preregistered) {
                clientIdPrefix = ClientIdPrefix.PreRegistered;
            } else if (Intrinsics.areEqual((Object)supportedClientIdPrefix, (Object)RedirectUri.INSTANCE)) {
                clientIdPrefix = ClientIdPrefix.RedirectUri;
            } else if (supportedClientIdPrefix instanceof DecentralizedIdentifier) {
                clientIdPrefix = ClientIdPrefix.DecentralizedIdentifier;
            } else if (supportedClientIdPrefix instanceof VerifierAttestation) {
                clientIdPrefix = ClientIdPrefix.VerifierAttestation;
            } else if (supportedClientIdPrefix instanceof X509SanDns) {
                clientIdPrefix = ClientIdPrefix.X509SanDns;
            } else if (supportedClientIdPrefix instanceof X509Hash) {
                clientIdPrefix = ClientIdPrefix.X509Hash;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return clientIdPrefix;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0016\u0010\u0002\u001a\u0012\u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB\u001d\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\t\"\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\nJ\u0019\u0010\r\u001a\u0012\u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u0018\b\u0002\u0010\u0002\u001a\u0012\u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001R!\u0010\u0002\u001a\u0012\u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix$Preregistered;", "Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix;", "clients", "", "", "Leu/europa/ec/eudi/openid4vp/OriginalClientId;", "Leu/europa/ec/eudi/openid4vp/PreregisteredClient;", "<init>", "(Ljava/util/Map;)V", "", "([Leu/europa/ec/eudi/openid4vp/PreregisteredClient;)V", "getClients", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "eudi-lib-jvm-siop-openid4vp-kt"})
    @SourceDebugExtension(value={"SMAP\nConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Config.kt\neu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix$Preregistered\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,431:1\n1208#2,2:432\n1236#2,4:434\n*S KotlinDebug\n*F\n+ 1 Config.kt\neu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix$Preregistered\n*L\n71#1:432,2\n71#1:434,4\n*E\n"})
    public static final class Preregistered
    implements SupportedClientIdPrefix {
        @NotNull
        private final Map<String, PreregisteredClient> clients;

        public Preregistered(@NotNull Map<String, PreregisteredClient> clients) {
            Intrinsics.checkNotNullParameter(clients, (String)"clients");
            this.clients = clients;
        }

        @NotNull
        public final Map<String, PreregisteredClient> getClients() {
            return this.clients;
        }

        /*
         * WARNING - void declaration
         */
        public Preregistered(PreregisteredClient ... clients) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            Intrinsics.checkNotNullParameter((Object)clients, (String)"clients");
            Iterable iterable = ArraysKt.toList((Object[])clients);
            Preregistered preregistered = this;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var5_6 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                PreregisteredClient preregisteredClient = (PreregisteredClient)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(it.getClientId(), element$iv$iv);
            }
            preregistered(destination$iv$iv);
        }

        @NotNull
        public final Map<String, PreregisteredClient> component1() {
            return this.clients;
        }

        @NotNull
        public final Preregistered copy(@NotNull Map<String, PreregisteredClient> clients) {
            Intrinsics.checkNotNullParameter(clients, (String)"clients");
            return new Preregistered(clients);
        }

        public static /* synthetic */ Preregistered copy$default(Preregistered preregistered, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = preregistered.clients;
            }
            return preregistered.copy(map);
        }

        @NotNull
        public String toString() {
            return "Preregistered(clients=" + this.clients + ")";
        }

        public int hashCode() {
            return ((Object)this.clients).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Preregistered)) {
                return false;
            }
            Preregistered preregistered = (Preregistered)other;
            return Intrinsics.areEqual(this.clients, preregistered.clients);
        }

        @Override
        @NotNull
        public ClientIdPrefix prefix() {
            return DefaultImpls.prefix(this);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix$RedirectUri;", "Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "eudi-lib-jvm-siop-openid4vp-kt"})
    public static final class RedirectUri
    implements SupportedClientIdPrefix {
        @NotNull
        public static final RedirectUri INSTANCE = new RedirectUri();

        private RedirectUri() {
        }

        @NotNull
        public String toString() {
            return "RedirectUri";
        }

        public int hashCode() {
            return -278248312;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RedirectUri)) {
                return false;
            }
            RedirectUri cfr_ignored_0 = (RedirectUri)other;
            return true;
        }

        @Override
        @NotNull
        public ClientIdPrefix prefix() {
            return DefaultImpls.prefix(this);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix$VerifierAttestation;", "Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix;", "trust", "Lcom/nimbusds/jose/JWSVerifier;", "clockSkew", "Ljava/time/Duration;", "<init>", "(Lcom/nimbusds/jose/JWSVerifier;Ljava/time/Duration;)V", "getTrust", "()Lcom/nimbusds/jose/JWSVerifier;", "getClockSkew", "()Ljava/time/Duration;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "eudi-lib-jvm-siop-openid4vp-kt"})
    public static final class VerifierAttestation
    implements SupportedClientIdPrefix {
        @NotNull
        private final JWSVerifier trust;
        @NotNull
        private final Duration clockSkew;

        public VerifierAttestation(@NotNull JWSVerifier trust, @NotNull Duration clockSkew) {
            Intrinsics.checkNotNullParameter((Object)trust, (String)"trust");
            Intrinsics.checkNotNullParameter((Object)clockSkew, (String)"clockSkew");
            this.trust = trust;
            this.clockSkew = clockSkew;
        }

        public /* synthetic */ VerifierAttestation(JWSVerifier jWSVerifier, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                duration = Duration.ofSeconds(15L);
            }
            this(jWSVerifier, duration);
        }

        @NotNull
        public final JWSVerifier getTrust() {
            return this.trust;
        }

        @NotNull
        public final Duration getClockSkew() {
            return this.clockSkew;
        }

        @NotNull
        public final JWSVerifier component1() {
            return this.trust;
        }

        @NotNull
        public final Duration component2() {
            return this.clockSkew;
        }

        @NotNull
        public final VerifierAttestation copy(@NotNull JWSVerifier trust, @NotNull Duration clockSkew) {
            Intrinsics.checkNotNullParameter((Object)trust, (String)"trust");
            Intrinsics.checkNotNullParameter((Object)clockSkew, (String)"clockSkew");
            return new VerifierAttestation(trust, clockSkew);
        }

        public static /* synthetic */ VerifierAttestation copy$default(VerifierAttestation verifierAttestation, JWSVerifier jWSVerifier, Duration duration, int n, Object object) {
            if ((n & 1) != 0) {
                jWSVerifier = verifierAttestation.trust;
            }
            if ((n & 2) != 0) {
                duration = verifierAttestation.clockSkew;
            }
            return verifierAttestation.copy(jWSVerifier, duration);
        }

        @NotNull
        public String toString() {
            return "VerifierAttestation(trust=" + this.trust + ", clockSkew=" + this.clockSkew + ")";
        }

        public int hashCode() {
            int result = this.trust.hashCode();
            result = result * 31 + this.clockSkew.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VerifierAttestation)) {
                return false;
            }
            VerifierAttestation verifierAttestation = (VerifierAttestation)other;
            if (!Intrinsics.areEqual((Object)this.trust, (Object)verifierAttestation.trust)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.clockSkew, (Object)verifierAttestation.clockSkew);
        }

        @Override
        @NotNull
        public ClientIdPrefix prefix() {
            return DefaultImpls.prefix(this);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix$X509Hash;", "Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix;", "trust", "Leu/europa/ec/eudi/openid4vp/X509CertificateTrust;", "<init>", "(Leu/europa/ec/eudi/openid4vp/X509CertificateTrust;)V", "getTrust", "()Leu/europa/ec/eudi/openid4vp/X509CertificateTrust;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "eudi-lib-jvm-siop-openid4vp-kt"})
    public static final class X509Hash
    implements SupportedClientIdPrefix {
        @NotNull
        private final X509CertificateTrust trust;

        public X509Hash(@NotNull X509CertificateTrust trust) {
            Intrinsics.checkNotNullParameter((Object)trust, (String)"trust");
            this.trust = trust;
        }

        @NotNull
        public final X509CertificateTrust getTrust() {
            return this.trust;
        }

        @NotNull
        public final X509CertificateTrust component1() {
            return this.trust;
        }

        @NotNull
        public final X509Hash copy(@NotNull X509CertificateTrust trust) {
            Intrinsics.checkNotNullParameter((Object)trust, (String)"trust");
            return new X509Hash(trust);
        }

        public static /* synthetic */ X509Hash copy$default(X509Hash x509Hash, X509CertificateTrust x509CertificateTrust, int n, Object object) {
            if ((n & 1) != 0) {
                x509CertificateTrust = x509Hash.trust;
            }
            return x509Hash.copy(x509CertificateTrust);
        }

        @NotNull
        public String toString() {
            return "X509Hash(trust=" + this.trust + ")";
        }

        public int hashCode() {
            return this.trust.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof X509Hash)) {
                return false;
            }
            X509Hash x509Hash = (X509Hash)other;
            return Intrinsics.areEqual((Object)this.trust, (Object)x509Hash.trust);
        }

        @Override
        @NotNull
        public ClientIdPrefix prefix() {
            return DefaultImpls.prefix(this);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix$X509SanDns;", "Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix;", "trust", "Leu/europa/ec/eudi/openid4vp/X509CertificateTrust;", "<init>", "(Leu/europa/ec/eudi/openid4vp/X509CertificateTrust;)V", "getTrust", "()Leu/europa/ec/eudi/openid4vp/X509CertificateTrust;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "eudi-lib-jvm-siop-openid4vp-kt"})
    public static final class X509SanDns
    implements SupportedClientIdPrefix {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final X509CertificateTrust trust;
        @NotNull
        private static final X509SanDns NoValidation = new X509SanDns(X509SanDns::NoValidation$lambda$0);

        public X509SanDns(@NotNull X509CertificateTrust trust) {
            Intrinsics.checkNotNullParameter((Object)trust, (String)"trust");
            this.trust = trust;
        }

        @NotNull
        public final X509CertificateTrust getTrust() {
            return this.trust;
        }

        @NotNull
        public final X509CertificateTrust component1() {
            return this.trust;
        }

        @NotNull
        public final X509SanDns copy(@NotNull X509CertificateTrust trust) {
            Intrinsics.checkNotNullParameter((Object)trust, (String)"trust");
            return new X509SanDns(trust);
        }

        public static /* synthetic */ X509SanDns copy$default(X509SanDns x509SanDns, X509CertificateTrust x509CertificateTrust, int n, Object object) {
            if ((n & 1) != 0) {
                x509CertificateTrust = x509SanDns.trust;
            }
            return x509SanDns.copy(x509CertificateTrust);
        }

        @NotNull
        public String toString() {
            return "X509SanDns(trust=" + this.trust + ")";
        }

        public int hashCode() {
            return this.trust.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof X509SanDns)) {
                return false;
            }
            X509SanDns x509SanDns = (X509SanDns)other;
            return Intrinsics.areEqual((Object)this.trust, (Object)x509SanDns.trust);
        }

        @Override
        @NotNull
        public ClientIdPrefix prefix() {
            return DefaultImpls.prefix(this);
        }

        private static final boolean NoValidation$lambda$0(List list) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"<unused var>");
            return true;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix$X509SanDns$Companion;", "", "<init>", "()V", "NoValidation", "Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix$X509SanDns;", "getNoValidation$eudi_lib_jvm_siop_openid4vp_kt", "()Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix$X509SanDns;", "eudi-lib-jvm-siop-openid4vp-kt"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final X509SanDns getNoValidation$eudi_lib_jvm_siop_openid4vp_kt() {
                return NoValidation;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

