/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp.internal.request;

import eu.europa.ec.eudi.openid4vp.Client;
import eu.europa.ec.eudi.openid4vp.HashAlgorithm;
import eu.europa.ec.eudi.openid4vp.ResponseMode;
import eu.europa.ec.eudi.openid4vp.SupportedTransactionDataType;
import eu.europa.ec.eudi.openid4vp.TransactionData;
import eu.europa.ec.eudi.openid4vp.TransactionDataType;
import eu.europa.ec.eudi.openid4vp.internal.request.AuthenticatedClient;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0002\u001a\u001a\u0010\u0006\u001a\u00020\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u001a\u001a\u0010\u0006\u001a\u00020\u0007*\u00020\f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a8\u0006\r"}, d2={"toClient", "Leu/europa/ec/eudi/openid4vp/Client;", "Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedClient;", "uri", "Ljava/net/URI;", "Leu/europa/ec/eudi/openid4vp/ResponseMode;", "ensureSupported", "", "Leu/europa/ec/eudi/openid4vp/TransactionData;", "supportedTransactionDataTypes", "", "Leu/europa/ec/eudi/openid4vp/SupportedTransactionDataType;", "Leu/europa/ec/eudi/openid4vp/TransactionData$SdJwtVc;", "eudi-lib-jvm-siop-openid4vp-kt"})
@SourceDebugExtension(value={"SMAP\nRequestObjectValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestObjectValidator.kt\neu/europa/ec/eudi/openid4vp/internal/request/RequestObjectValidatorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,415:1\n295#2,2:416\n*S KotlinDebug\n*F\n+ 1 RequestObjectValidator.kt\neu/europa/ec/eudi/openid4vp/internal/request/RequestObjectValidatorKt\n*L\n404#1:416,2\n*E\n"})
public final class RequestObjectValidatorKt {
    private static final Client toClient(AuthenticatedClient $this$toClient) {
        Client client;
        AuthenticatedClient authenticatedClient = $this$toClient;
        if (authenticatedClient instanceof AuthenticatedClient.Preregistered) {
            client = new Client.Preregistered(((AuthenticatedClient.Preregistered)$this$toClient).getPreregisteredClient().getClientId(), ((AuthenticatedClient.Preregistered)$this$toClient).getPreregisteredClient().getLegalName());
        } else if (authenticatedClient instanceof AuthenticatedClient.RedirectUri) {
            client = new Client.RedirectUri(((AuthenticatedClient.RedirectUri)$this$toClient).getClientId());
        } else if (authenticatedClient instanceof AuthenticatedClient.DecentralizedIdentifier) {
            client = new Client.DecentralizedIdentifier(((AuthenticatedClient.DecentralizedIdentifier)$this$toClient).getClient-VvDq4Xs());
        } else if (authenticatedClient instanceof AuthenticatedClient.VerifierAttestation) {
            client = new Client.VerifierAttestation(((AuthenticatedClient.VerifierAttestation)$this$toClient).getClientId());
        } else if (authenticatedClient instanceof AuthenticatedClient.X509SanDns) {
            client = new Client.X509SanDns(((AuthenticatedClient.X509SanDns)$this$toClient).getClientId(), ((AuthenticatedClient.X509SanDns)$this$toClient).getChain().get(0));
        } else if (authenticatedClient instanceof AuthenticatedClient.X509Hash) {
            client = new Client.X509Hash(((AuthenticatedClient.X509Hash)$this$toClient).getClientId(), ((AuthenticatedClient.X509Hash)$this$toClient).getChain().get(0));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return client;
    }

    private static final URI uri(ResponseMode $this$uri) {
        URI uRI;
        ResponseMode responseMode = $this$uri;
        if (responseMode instanceof ResponseMode.DirectPost) {
            URI uRI2 = ((ResponseMode.DirectPost)$this$uri).getResponseURI().toURI();
            uRI = uRI2;
            Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"toURI(...)");
        } else if (responseMode instanceof ResponseMode.DirectPostJwt) {
            URI uRI3 = ((ResponseMode.DirectPostJwt)$this$uri).getResponseURI().toURI();
            uRI = uRI3;
            Intrinsics.checkNotNullExpressionValue((Object)uRI3, (String)"toURI(...)");
        } else if (responseMode instanceof ResponseMode.Fragment) {
            uRI = ((ResponseMode.Fragment)$this$uri).getRedirectUri();
        } else if (responseMode instanceof ResponseMode.FragmentJwt) {
            uRI = ((ResponseMode.FragmentJwt)$this$uri).getRedirectUri();
        } else if (responseMode instanceof ResponseMode.Query) {
            uRI = ((ResponseMode.Query)$this$uri).getRedirectUri();
        } else if (responseMode instanceof ResponseMode.QueryJwt) {
            uRI = ((ResponseMode.QueryJwt)$this$uri).getRedirectUri();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return uRI;
    }

    private static final void ensureSupported(TransactionData $this$ensureSupported, List<? extends SupportedTransactionDataType> supportedTransactionDataTypes) {
        if (!($this$ensureSupported instanceof TransactionData.SdJwtVc)) {
            throw new NoWhenBranchMatchedException();
        }
        RequestObjectValidatorKt.ensureSupported((TransactionData.SdJwtVc)$this$ensureSupported, supportedTransactionDataTypes);
    }

    private static final void ensureSupported(TransactionData.SdJwtVc $this$ensureSupported, List<? extends SupportedTransactionDataType> supportedTransactionDataTypes) {
        Object v0;
        String type;
        block3: {
            type = $this$ensureSupported.getType-SIznf40();
            Iterable $this$firstOrNull$iv = supportedTransactionDataTypes;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SupportedTransactionDataType it = (SupportedTransactionDataType)element$iv;
                boolean bl = false;
                if (!TransactionDataType.equals-impl0(it.getType-SIznf40(), type)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        SupportedTransactionDataType supportedType = v0;
        if (!(supportedType instanceof SupportedTransactionDataType.SdJwtVc)) {
            boolean $i$a$-require-RequestObjectValidatorKt$ensureSupported$32 = false;
            String $i$a$-require-RequestObjectValidatorKt$ensureSupported$32 = "Unsupported Transaction Data 'type': '" + TransactionDataType.toString-impl(type) + "'";
            throw new IllegalArgumentException($i$a$-require-RequestObjectValidatorKt$ensureSupported$32.toString());
        }
        List<HashAlgorithm> hashAlgorithms = $this$ensureSupported.getHashAlgorithmsOrDefault();
        Set<HashAlgorithm> supportedHashAlgorithms = ((SupportedTransactionDataType.SdJwtVc)supportedType).getHashAlgorithms();
        if (!(!((Collection)CollectionsKt.intersect((Iterable)supportedHashAlgorithms, (Iterable)hashAlgorithms)).isEmpty())) {
            boolean bl = false;
            String string = "Unsupported Transaction Data 'transaction_data_hashes_alg': '" + hashAlgorithms + "'";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final /* synthetic */ URI access$uri(ResponseMode $receiver) {
        return RequestObjectValidatorKt.uri($receiver);
    }

    public static final /* synthetic */ Client access$toClient(AuthenticatedClient $receiver) {
        return RequestObjectValidatorKt.toClient($receiver);
    }

    public static final /* synthetic */ void access$ensureSupported(TransactionData $receiver, List supportedTransactionDataTypes) {
        RequestObjectValidatorKt.ensureSupported($receiver, (List<? extends SupportedTransactionDataType>)supportedTransactionDataTypes);
    }
}

