/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp.internal.response;

import com.nimbusds.jwt.JWTClaimsSet;
import eu.europa.ec.eudi.openid4vp.internal.response.AuthorizationRequestErrorCode;
import eu.europa.ec.eudi.openid4vp.internal.response.AuthorizationResponsePayload;
import eu.europa.ec.eudi.openid4vp.internal.response.DefaultResponseDispatcherKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J\f\u0010\u0011\u001a\u00020\u000b*\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Leu/europa/ec/eudi/openid4vp/internal/response/JwtPayloadFactory;", "", "<init>", "()V", "VP_TOKEN_CLAIM", "", "STATE_CLAIM", "ID_TOKEN_CLAIM", "ERROR_CLAIM", "ERROR_DESCRIPTION_CLAIM", "encryptedJwtClaimSet", "Lcom/nimbusds/jwt/JWTClaimsSet;", "data", "Leu/europa/ec/eudi/openid4vp/internal/response/AuthorizationResponsePayload;", "payloadClaims", "", "Lkotlinx/serialization/json/JsonObjectBuilder;", "asJWTClaimSet", "Lkotlinx/serialization/json/JsonObject;", "eudi-lib-jvm-siop-openid4vp-kt"})
@SourceDebugExtension(value={"SMAP\nResponseEncryption.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseEncryption.kt\neu/europa/ec/eudi/openid4vp/internal/response/JwtPayloadFactory\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,166:1\n29#2,3:167\n205#3:170\n*S KotlinDebug\n*F\n+ 1 ResponseEncryption.kt\neu/europa/ec/eudi/openid4vp/internal/response/JwtPayloadFactory\n*L\n92#1:167,3\n126#1:170\n*E\n"})
final class JwtPayloadFactory {
    @NotNull
    public static final JwtPayloadFactory INSTANCE = new JwtPayloadFactory();
    @NotNull
    private static final String VP_TOKEN_CLAIM = "vp_token";
    @NotNull
    private static final String STATE_CLAIM = "state";
    @NotNull
    private static final String ID_TOKEN_CLAIM = "id_token";
    @NotNull
    private static final String ERROR_CLAIM = "error";
    @NotNull
    private static final String ERROR_DESCRIPTION_CLAIM = "error_description";

    private JwtPayloadFactory() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JWTClaimsSet encryptedJwtClaimSet(@NotNull AuthorizationResponsePayload data) {
        void $this$encryptedJwtClaimSet_u24lambda_u240;
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        JwtPayloadFactory jwtPayloadFactory = this;
        boolean bl = false;
        INSTANCE.payloadClaims((JsonObjectBuilder)$this$encryptedJwtClaimSet_u24lambda_u240, data);
        return jwtPayloadFactory.asJWTClaimSet(builder$iv.build());
    }

    private final void payloadClaims(JsonObjectBuilder $this$payloadClaims, AuthorizationResponsePayload data) {
        String string = data.getState();
        if (string != null) {
            String it = string;
            boolean bl = false;
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$payloadClaims, (String)STATE_CLAIM, (String)it);
        }
        AuthorizationResponsePayload authorizationResponsePayload = data;
        if (authorizationResponsePayload instanceof AuthorizationResponsePayload.SiopAuthentication) {
            v1 = JsonElementBuildersKt.put((JsonObjectBuilder)$this$payloadClaims, (String)ID_TOKEN_CLAIM, (String)((AuthorizationResponsePayload.SiopAuthentication)data).getIdToken());
        } else if (authorizationResponsePayload instanceof AuthorizationResponsePayload.OpenId4VPAuthorization) {
            v1 = $this$payloadClaims.put(VP_TOKEN_CLAIM, (JsonElement)DefaultResponseDispatcherKt.asJsonObject-pvVQDEE(((AuthorizationResponsePayload.OpenId4VPAuthorization)data).getVerifiablePresentations-C3kSdWY()));
        } else if (authorizationResponsePayload instanceof AuthorizationResponsePayload.SiopOpenId4VPAuthentication) {
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$payloadClaims, (String)ID_TOKEN_CLAIM, (String)((AuthorizationResponsePayload.SiopOpenId4VPAuthentication)data).getIdToken());
            v1 = $this$payloadClaims.put(VP_TOKEN_CLAIM, (JsonElement)DefaultResponseDispatcherKt.asJsonObject-pvVQDEE(((AuthorizationResponsePayload.SiopOpenId4VPAuthentication)data).getVerifiablePresentations-C3kSdWY()));
        } else if (authorizationResponsePayload instanceof AuthorizationResponsePayload.InvalidRequest) {
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$payloadClaims, (String)ERROR_CLAIM, (String)AuthorizationRequestErrorCode.Companion.fromError(((AuthorizationResponsePayload.InvalidRequest)data).getError()).getCode());
            v1 = JsonElementBuildersKt.put((JsonObjectBuilder)$this$payloadClaims, (String)ERROR_DESCRIPTION_CLAIM, (String)String.valueOf(((AuthorizationResponsePayload.InvalidRequest)data).getError()));
        } else if (authorizationResponsePayload instanceof AuthorizationResponsePayload.NoConsensusResponseData) {
            v1 = JsonElementBuildersKt.put((JsonObjectBuilder)$this$payloadClaims, (String)ERROR_CLAIM, (String)AuthorizationRequestErrorCode.ACCESS_DENIED.getCode());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final JWTClaimsSet asJWTClaimSet(JsonObject $this$asJWTClaimSet) {
        Json this_$iv = (Json)Json.Default;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        String jsonStr = this_$iv.encodeToString((SerializationStrategy)JsonObject.Companion.serializer(), (Object)$this$asJWTClaimSet);
        JWTClaimsSet jWTClaimsSet = JWTClaimsSet.parse((String)jsonStr);
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"parse(...)");
        return jWTClaimsSet;
    }
}

