/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp.internal.response;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWTClaimsSet;
import eu.europa.ec.eudi.openid4vp.EncryptionParameters;
import eu.europa.ec.eudi.openid4vp.ResponseEncryptionSpecification;
import eu.europa.ec.eudi.openid4vp.internal.response.AuthorizationResponsePayload;
import eu.europa.ec.eudi.openid4vp.internal.response.EncrypterFactory;
import eu.europa.ec.eudi.openid4vp.internal.response.JwtPayloadFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00060\u0001j\u0002`\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001aC\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0019\b\u0002\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\u0002\b\u0012H\u0002\u00a8\u0006\u0013"}, d2={"encrypt", "", "Leu/europa/ec/eudi/openid4vp/Jwt;", "Leu/europa/ec/eudi/openid4vp/ResponseEncryptionSpecification;", "data", "Leu/europa/ec/eudi/openid4vp/internal/response/AuthorizationResponsePayload;", "jweHeader", "Lcom/nimbusds/jose/JWEHeader;", "jweAlgorithm", "Lcom/nimbusds/jose/JWEAlgorithm;", "encryptionMethod", "Lcom/nimbusds/jose/EncryptionMethod;", "recipientKey", "Lcom/nimbusds/jose/jwk/JWK;", "builderAction", "Lkotlin/Function1;", "Lcom/nimbusds/jose/JWEHeader$Builder;", "", "Lkotlin/ExtensionFunctionType;", "eudi-lib-jvm-siop-openid4vp-kt"})
@SourceDebugExtension(value={"SMAP\nResponseEncryption.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseEncryption.kt\neu/europa/ec/eudi/openid4vp/internal/response/ResponseEncryptionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n1#2:167\n*E\n"})
public final class ResponseEncryptionKt {
    @NotNull
    public static final String encrypt(@NotNull ResponseEncryptionSpecification $this$encrypt, @NotNull AuthorizationResponsePayload data) throws JOSEException {
        EncryptedJWT encryptedJWT;
        Intrinsics.checkNotNullParameter((Object)$this$encrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        JWEHeader header = ResponseEncryptionKt.jweHeader$default($this$encrypt.getEncryptionAlgorithm(), $this$encrypt.getEncryptionMethod(), $this$encrypt.getRecipientKey(), data, null, 16, null);
        JWTClaimsSet claims = JwtPayloadFactory.INSTANCE.encryptedJwtClaimSet(data);
        JWEEncrypter encrypter = EncrypterFactory.INSTANCE.createEncrypter($this$encrypt.getEncryptionAlgorithm(), $this$encrypt.getRecipientKey());
        EncryptedJWT $this$encrypt_u24lambda_u240 = encryptedJWT = new EncryptedJWT(header, claims);
        boolean bl = false;
        $this$encrypt_u24lambda_u240.encrypt(encrypter);
        EncryptedJWT encryptedJwt = encryptedJWT;
        String string = encryptedJwt.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serialize(...)");
        return string;
    }

    private static final JWEHeader jweHeader(JWEAlgorithm jweAlgorithm, EncryptionMethod encryptionMethod, JWK recipientKey, AuthorizationResponsePayload data, Function1<? super JWEHeader.Builder, Unit> builderAction) {
        Base64URL p0;
        JWEHeader.Builder builder;
        Pair pair;
        if (JWEAlgorithm.Family.ECDH_ES.contains((Object)jweAlgorithm) && !(data.getEncryptionParameters() instanceof EncryptionParameters.DiffieHellman)) {
            boolean $i$a$-require-ResponseEncryptionKt$jweHeader$32 = false;
            String $i$a$-require-ResponseEncryptionKt$jweHeader$32 = "Diffie-Hellman encryption parameters are required for " + jweAlgorithm.getName();
            throw new IllegalArgumentException($i$a$-require-ResponseEncryptionKt$jweHeader$32.toString());
        }
        EncryptionParameters encryptionParameters = data.getEncryptionParameters();
        if (encryptionParameters instanceof EncryptionParameters.DiffieHellman) {
            Base64URL base64URL;
            String string = data.getNonce();
            if (string != null) {
                String it = string;
                boolean bl = false;
                base64URL = Base64URL.encode((String)it);
            } else {
                base64URL = null;
            }
            Base64URL apv = base64URL;
            pair = TuplesKt.to((Object)apv, (Object)((EncryptionParameters.DiffieHellman)encryptionParameters).getApu());
        } else {
            pair = TuplesKt.to(null, null);
        }
        Pair pair2 = pair;
        Base64URL apv = (Base64URL)pair2.component1();
        Base64URL apu = (Base64URL)pair2.component2();
        JWEHeader.Builder $this$jweHeader_u24lambda_u245 = builder = new JWEHeader.Builder(jweAlgorithm, encryptionMethod);
        boolean bl = false;
        builderAction.invoke((Object)$this$jweHeader_u24lambda_u245);
        Base64URL base64URL = apv;
        if (base64URL != null) {
            p0 = base64URL;
            boolean bl2 = false;
            $this$jweHeader_u24lambda_u245.agreementPartyVInfo(p0);
        }
        Base64URL base64URL2 = apu;
        if (base64URL2 != null) {
            p0 = base64URL2;
            boolean bl3 = false;
            $this$jweHeader_u24lambda_u245.agreementPartyUInfo(p0);
        }
        $this$jweHeader_u24lambda_u245.keyID(recipientKey.getKeyID());
        JWEHeader jWEHeader = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)jWEHeader, (String)"build(...)");
        return jWEHeader;
    }

    static /* synthetic */ JWEHeader jweHeader$default(JWEAlgorithm jWEAlgorithm, EncryptionMethod encryptionMethod, JWK jWK, AuthorizationResponsePayload authorizationResponsePayload, Function1 function1, int n, Object object) {
        if ((n & 0x10) != 0) {
            function1 = ResponseEncryptionKt::jweHeader$lambda$1;
        }
        return ResponseEncryptionKt.jweHeader(jWEAlgorithm, encryptionMethod, jWK, authorizationResponsePayload, (Function1<? super JWEHeader.Builder, Unit>)function1);
    }

    private static final Unit jweHeader$lambda$1(JWEHeader.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"<this>");
        return Unit.INSTANCE;
    }
}

