/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common;

import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ASiCContent
implements Serializable {
    private static final long serialVersionUID = -6871206656998856916L;
    private DSSDocument asicContainer;
    private ASiCContainerType containerType;
    private String zipComment;
    private DSSDocument mimeTypeDocument;
    private List<DSSDocument> signedDocuments = new ArrayList<DSSDocument>();
    private List<DSSDocument> signatureDocuments = new ArrayList<DSSDocument>();
    private List<DSSDocument> manifestDocuments = new ArrayList<DSSDocument>();
    private List<DSSDocument> archiveManifestDocuments = new ArrayList<DSSDocument>();
    private List<DSSDocument> evidenceRecordManifestDocuments = new ArrayList<DSSDocument>();
    private List<DSSDocument> timestampDocuments = new ArrayList<DSSDocument>();
    private List<DSSDocument> evidenceRecordDocuments = new ArrayList<DSSDocument>();
    private List<DSSDocument> unsupportedDocuments = new ArrayList<DSSDocument>();
    private List<DSSDocument> folders = new ArrayList<DSSDocument>();
    private List<DSSDocument> containerDocuments = new ArrayList<DSSDocument>();

    public DSSDocument getAsicContainer() {
        return this.asicContainer;
    }

    public void setAsicContainer(DSSDocument asicContainer) {
        this.asicContainer = asicContainer;
    }

    public ASiCContainerType getContainerType() {
        return this.containerType;
    }

    public void setContainerType(ASiCContainerType containerType) {
        this.containerType = containerType;
    }

    public String getZipComment() {
        return this.zipComment;
    }

    public void setZipComment(String zipComment) {
        this.zipComment = zipComment;
    }

    public DSSDocument getMimeTypeDocument() {
        return this.mimeTypeDocument;
    }

    public void setMimeTypeDocument(DSSDocument mimeTypeDocument) {
        this.mimeTypeDocument = mimeTypeDocument;
    }

    public List<DSSDocument> getSignatureDocuments() {
        return this.signatureDocuments;
    }

    public void setSignatureDocuments(List<DSSDocument> signatureDocuments) {
        this.signatureDocuments = signatureDocuments;
    }

    public List<DSSDocument> getManifestDocuments() {
        return this.manifestDocuments;
    }

    public void setManifestDocuments(List<DSSDocument> manifestDocuments) {
        this.manifestDocuments = manifestDocuments;
    }

    public List<DSSDocument> getArchiveManifestDocuments() {
        return this.archiveManifestDocuments;
    }

    public void setArchiveManifestDocuments(List<DSSDocument> archiveManifestDocuments) {
        this.archiveManifestDocuments = archiveManifestDocuments;
    }

    public List<DSSDocument> getEvidenceRecordManifestDocuments() {
        return this.evidenceRecordManifestDocuments;
    }

    public void setEvidenceRecordManifestDocuments(List<DSSDocument> evidenceRecordManifestDocuments) {
        this.evidenceRecordManifestDocuments = evidenceRecordManifestDocuments;
    }

    public List<DSSDocument> getTimestampDocuments() {
        return this.timestampDocuments;
    }

    public void setTimestampDocuments(List<DSSDocument> timestampDocuments) {
        this.timestampDocuments = timestampDocuments;
    }

    public List<DSSDocument> getEvidenceRecordDocuments() {
        return this.evidenceRecordDocuments;
    }

    public void setEvidenceRecordDocuments(List<DSSDocument> evidenceRecordDocuments) {
        this.evidenceRecordDocuments = evidenceRecordDocuments;
    }

    public List<DSSDocument> getSignedDocuments() {
        return this.signedDocuments;
    }

    public void setSignedDocuments(List<DSSDocument> signedDocuments) {
        this.signedDocuments = signedDocuments;
    }

    public List<DSSDocument> getUnsupportedDocuments() {
        return this.unsupportedDocuments;
    }

    public void setUnsupportedDocuments(List<DSSDocument> unsupportedDocuments) {
        this.unsupportedDocuments = unsupportedDocuments;
    }

    public List<DSSDocument> getFolders() {
        return this.folders;
    }

    public void setFolders(List<DSSDocument> folders) {
        this.folders = folders;
    }

    public List<DSSDocument> getContainerDocuments() {
        return this.containerDocuments;
    }

    public void setContainerDocuments(List<DSSDocument> containerDocuments) {
        this.containerDocuments = containerDocuments;
    }

    public List<DSSDocument> getRootLevelSignedDocuments() {
        if (Utils.isCollectionEmpty(this.getSignedDocuments())) {
            return Collections.emptyList();
        }
        ArrayList<DSSDocument> rootLevelDocuments = new ArrayList<DSSDocument>();
        for (DSSDocument document : this.getSignedDocuments()) {
            if (document.getName() == null || document.getName().contains("/") || document.getName().contains("\\")) continue;
            rootLevelDocuments.add(document);
        }
        return rootLevelDocuments;
    }

    public List<DSSDocument> getAllManifestDocuments() {
        ArrayList<DSSDocument> allManifestsList = new ArrayList<DSSDocument>();
        allManifestsList.addAll(this.getManifestDocuments());
        allManifestsList.addAll(this.getArchiveManifestDocuments());
        allManifestsList.addAll(this.getEvidenceRecordManifestDocuments());
        return allManifestsList;
    }

    public List<DSSDocument> getAllDocuments() {
        ArrayList<DSSDocument> allDocuments = new ArrayList<DSSDocument>();
        if (this.mimeTypeDocument != null) {
            allDocuments.add(this.mimeTypeDocument);
        }
        if (Utils.isCollectionNotEmpty(this.signedDocuments)) {
            allDocuments.addAll(this.signedDocuments);
        }
        if (Utils.isCollectionNotEmpty(this.signatureDocuments)) {
            allDocuments.addAll(this.signatureDocuments);
        }
        if (Utils.isCollectionNotEmpty(this.manifestDocuments)) {
            allDocuments.addAll(this.manifestDocuments);
        }
        if (Utils.isCollectionNotEmpty(this.archiveManifestDocuments)) {
            allDocuments.addAll(this.archiveManifestDocuments);
        }
        if (Utils.isCollectionNotEmpty(this.evidenceRecordManifestDocuments)) {
            allDocuments.addAll(this.evidenceRecordManifestDocuments);
        }
        if (Utils.isCollectionNotEmpty(this.timestampDocuments)) {
            allDocuments.addAll(this.timestampDocuments);
        }
        if (Utils.isCollectionNotEmpty(this.evidenceRecordDocuments)) {
            allDocuments.addAll(this.evidenceRecordDocuments);
        }
        if (Utils.isCollectionNotEmpty(this.unsupportedDocuments)) {
            allDocuments.addAll(this.unsupportedDocuments);
        }
        if (Utils.isCollectionNotEmpty(this.folders)) {
            allDocuments.addAll(this.folders);
        }
        return allDocuments;
    }
}

