/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public abstract class AbstractASiCFilenameFactory
implements Serializable {
    private static final long serialVersionUID = 7868238704099416943L;

    protected AbstractASiCFilenameFactory() {
    }

    protected String getNextAvailableDocumentName(String nameTemplate, Collection<String> existingDocumentNames) {
        return this.getDocumentNameRecursively(nameTemplate, new HashSet<String>(existingDocumentNames));
    }

    private String getDocumentNameRecursively(String nameTemplate, Collection<String> existingDocumentNames) {
        int number = existingDocumentNames.size() + 1;
        String numberStr = String.valueOf(number);
        String zeroPad = "000";
        String candidateSuffix = numberStr.length() < zeroPad.length() ? zeroPad.substring(numberStr.length()) + numberStr : numberStr;
        String candidateName = nameTemplate.replace("001", candidateSuffix);
        if (!this.isAvailableName(candidateName, existingDocumentNames)) {
            existingDocumentNames = new ArrayList<String>(existingDocumentNames);
            existingDocumentNames.add(candidateName);
            return this.getDocumentNameRecursively(nameTemplate, existingDocumentNames);
        }
        return candidateName;
    }

    protected boolean isAvailableName(String filename, Collection<String> restrictedNames) {
        return !restrictedNames.contains(filename);
    }

    protected String getWithMetaInfFolder(String filename) {
        if (!filename.startsWith("META-INF/")) {
            filename = "META-INF/" + filename;
        }
        return filename;
    }

    protected void assertASiCContentIsValid(ASiCContent asicContent) {
        Objects.requireNonNull(asicContent, "ASiCContent shall be provided!");
        Objects.requireNonNull(asicContent.getContainerType(), "Type of ASiC Container shall be defined!");
        if (ASiCContainerType.ASiC_S != asicContent.getContainerType() && ASiCContainerType.ASiC_E != asicContent.getContainerType()) {
            throw new IllegalArgumentException("The type of the ASiCContent shall be one of ASiC-S or ASiC-E!");
        }
    }

    protected void assertFilenameValid(String filename, List<DSSDocument> documentsOfType) {
        if (!this.isAvailableName(filename, DSSUtils.getDocumentNames(documentsOfType))) {
            throw new IllegalInputException(String.format("The filename '%s' cannot be used, as a document of the same name is already present within the container!", filename));
        }
    }

    protected String getValidDataPackageFilename(String dataPackageFilename, ASiCContent asicContent) {
        this.assertFilenameValid(dataPackageFilename, asicContent.getSignedDocuments());
        if (dataPackageFilename.contains("/")) {
            throw new IllegalArgumentException("A data package file within ASiC container shall be on the root level!");
        }
        if (!dataPackageFilename.toLowerCase().endsWith(".zip")) {
            throw new IllegalArgumentException("A data package filename within ASiC container shall ends with '.zip'!");
        }
        return dataPackageFilename;
    }
}

