/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.server.signing.rest;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.ws.dto.DigestDTO;
import eu.europa.esig.dss.ws.dto.SignatureValueDTO;
import eu.europa.esig.dss.ws.dto.ToBeSignedDTO;
import eu.europa.esig.dss.ws.server.signing.common.RemoteSignatureTokenConnection;
import eu.europa.esig.dss.ws.server.signing.dto.RemoteKeyEntry;
import eu.europa.esig.dss.ws.server.signing.rest.client.RestSignatureTokenConnection;
import java.util.List;

public class RestSignatureTokenConnectionImpl
implements RestSignatureTokenConnection {
    private RemoteSignatureTokenConnection token;

    public void setToken(RemoteSignatureTokenConnection token) {
        this.token = token;
    }

    public List<RemoteKeyEntry> getKeys() throws DSSException {
        return this.token.getKeys();
    }

    public RemoteKeyEntry getKey(String alias) throws DSSException {
        return this.token.getKey(alias);
    }

    public SignatureValueDTO sign(ToBeSignedDTO toBeSigned, DigestAlgorithm digestAlgorithm, String alias) throws DSSException {
        return this.token.sign(toBeSigned, digestAlgorithm, alias);
    }

    public SignatureValueDTO sign(ToBeSignedDTO toBeSigned, DigestAlgorithm digestAlgorithm, MaskGenerationFunction mgf, String alias) throws DSSException {
        return this.token.sign(toBeSigned, digestAlgorithm, mgf, alias);
    }

    public SignatureValueDTO sign(ToBeSignedDTO toBeSigned, SignatureAlgorithm signatureAlgorithm, String alias) {
        return this.token.sign(toBeSigned, signatureAlgorithm, alias);
    }

    public SignatureValueDTO signDigest(DigestDTO digest, String alias) throws DSSException {
        return this.token.signDigest(digest, alias);
    }

    public SignatureValueDTO signDigest(DigestDTO digest, MaskGenerationFunction mgf, String alias) throws DSSException {
        return this.token.signDigest(digest, mgf, alias);
    }

    public SignatureValueDTO signDigest(DigestDTO digest, SignatureAlgorithm signatureAlgorithm, String alias) {
        return this.token.signDigest(digest, signatureAlgorithm, alias);
    }
}

