/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.crl;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.service.http.commons.CommonsDataLoader;
import eu.europa.esig.dss.spi.CertificateExtensionsUtils;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.client.http.Protocol;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSourceAlternateUrlsSupport;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineCRLSource
implements CRLSource,
RevocationSourceAlternateUrlsSupport<CRL> {
    private static final long serialVersionUID = 6912729291417315212L;
    private static final Logger LOG = LoggerFactory.getLogger(OnlineCRLSource.class);
    private Protocol preferredProtocol;
    private DataLoader dataLoader;

    public OnlineCRLSource() {
        this.dataLoader = new CommonsDataLoader();
        LOG.trace("+OnlineCRLSource with the default data loader.");
    }

    public OnlineCRLSource(DataLoader dataLoader) {
        this.dataLoader = dataLoader;
        LOG.trace("+OnlineCRLSource with the specific data loader.");
    }

    public void setPreferredProtocol(Protocol preferredProtocol) {
        this.preferredProtocol = preferredProtocol;
    }

    public void setDataLoader(DataLoader dataLoader) {
        this.dataLoader = dataLoader;
    }

    public CRLToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        return this.getRevocationToken(certificateToken, issuerCertificateToken, Collections.emptyList());
    }

    public CRLToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerToken, List<String> alternativeUrls) {
        Objects.requireNonNull(certificateToken, "CertificateToken cannot be null!");
        Objects.requireNonNull(issuerToken, "Issuer CertificateToken cannot be null!");
        Objects.requireNonNull(this.dataLoader, "DataLoader is not provided !");
        LOG.trace("--> OnlineCRLSource queried for {}", (Object)certificateToken.getDSSIdAsString());
        List<String> crlUrls = this.getCRLAccessURLs(certificateToken, alternativeUrls);
        if (Utils.isCollectionEmpty(crlUrls)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No CRL location found for certificate with Id '{}'", (Object)certificateToken.getDSSIdAsString());
            }
            return null;
        }
        int nbTries = crlUrls.size();
        for (String crlUrl : crlUrls) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Trying to retrieve a CRL from URL '{}'...", (Object)crlUrl);
            }
            --nbTries;
            try {
                CRLBinary crlBinary = this.executeCRLRequest(crlUrl);
                CRLValidity crlValidity = CRLUtils.buildCRLValidity((CRLBinary)crlBinary, (CertificateToken)issuerToken);
                CRLToken crlToken = new CRLToken(certificateToken, crlValidity);
                crlToken.setExternalOrigin(RevocationOrigin.EXTERNAL);
                crlToken.setSourceURL(crlUrl);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("CRL '{}' has been retrieved from a source with URL '{}'.", (Object)crlToken.getDSSIdAsString(), (Object)crlUrl);
                }
                return crlToken;
            }
            catch (Exception e) {
                if (nbTries == 0) {
                    throw new DSSExternalResourceException(String.format("Unable to retrieve CRL for certificate with Id '%s' from URL '%s'. Reason : %s", certificateToken.getDSSIdAsString(), crlUrl, e.getMessage()), (Throwable)e);
                }
                LOG.warn("Unable to retrieve CRL with URL '{}' : {}", (Object)crlUrl, (Object)e.getMessage());
            }
        }
        throw new IllegalStateException(String.format("Invalid state within OnlineCRLSource for a certificate call with id '%s'", certificateToken.getDSSIdAsString()));
    }

    protected List<String> getCRLAccessURLs(CertificateToken certificateToken, List<String> alternativeUrls) {
        if (Utils.isCollectionNotEmpty(alternativeUrls)) {
            LOG.info("CRL alternative urls : {}", alternativeUrls);
        }
        List crlAccessUrls = CertificateExtensionsUtils.getCRLAccessUrls((CertificateToken)certificateToken);
        ArrayList<String> crlUrls = new ArrayList<String>();
        crlUrls.addAll(crlAccessUrls);
        crlUrls.addAll(alternativeUrls);
        this.prioritize(crlUrls);
        return crlUrls;
    }

    protected CRLBinary executeCRLRequest(String crlUrl) {
        byte[] bytes = this.dataLoader.get(crlUrl);
        if (Utils.isArrayNotEmpty((byte[])bytes)) {
            return CRLUtils.buildCRLBinary((byte[])bytes);
        }
        throw new DSSExternalResourceException(String.format("CRL DataLoader for certificate with url '%s' responded with an empty byte array!", crlUrl));
    }

    private void prioritize(List<String> urls) {
        if (this.preferredProtocol != null) {
            ArrayList<String> priorityUrls = new ArrayList<String>();
            for (String url : urls) {
                if (!this.preferredProtocol.isTheSame(url)) continue;
                priorityUrls.add(url);
            }
            urls.removeAll(priorityUrls);
            for (int ii = priorityUrls.size() - 1; ii >= 0; --ii) {
                urls.add(0, (String)priorityUrls.get(ii));
            }
        }
    }
}

