/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.signature.common;

import eu.europa.esig.dss.asic.cades.signature.ASiCWithCAdESService;
import eu.europa.esig.dss.asic.xades.signature.ASiCWithXAdESService;
import eu.europa.esig.dss.cades.signature.CAdESService;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.TimestampContainerForm;
import eu.europa.esig.dss.jades.signature.JAdESService;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.SerializableCounterSignatureParameters;
import eu.europa.esig.dss.model.SerializableSignatureParameters;
import eu.europa.esig.dss.model.SerializableTimestampParameters;
import eu.europa.esig.dss.model.TimestampParameters;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.pades.signature.PAdESService;
import eu.europa.esig.dss.signature.CounterSignatureService;
import eu.europa.esig.dss.signature.DocumentSignatureService;
import eu.europa.esig.dss.ws.converter.DTOConverter;
import eu.europa.esig.dss.ws.converter.RemoteDocumentConverter;
import eu.europa.esig.dss.ws.dto.RemoteDocument;
import eu.europa.esig.dss.ws.dto.SignatureValueDTO;
import eu.europa.esig.dss.ws.dto.ToBeSignedDTO;
import eu.europa.esig.dss.ws.signature.common.AbstractRemoteSignatureServiceImpl;
import eu.europa.esig.dss.ws.signature.common.RemoteDocumentSignatureService;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteSignatureParameters;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteTimestampParameters;
import eu.europa.esig.dss.xades.signature.XAdESService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDocumentSignatureServiceImpl
extends AbstractRemoteSignatureServiceImpl
implements RemoteDocumentSignatureService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteDocumentSignatureServiceImpl.class);
    private XAdESService xadesService;
    private CAdESService cadesService;
    private PAdESService padesService;
    private JAdESService jadesService;
    private ASiCWithXAdESService asicWithXAdESService;
    private ASiCWithCAdESService asicWithCAdESService;

    public void setXadesService(XAdESService xadesService) {
        this.xadesService = xadesService;
    }

    public void setCadesService(CAdESService cadesService) {
        this.cadesService = cadesService;
    }

    public void setPadesService(PAdESService padesService) {
        this.padesService = padesService;
    }

    public void setJadesService(JAdESService jadesService) {
        this.jadesService = jadesService;
    }

    public void setAsicWithXAdESService(ASiCWithXAdESService asicWithXAdESService) {
        this.asicWithXAdESService = asicWithXAdESService;
    }

    public void setAsicWithCAdESService(ASiCWithCAdESService asicWithCAdESService) {
        this.asicWithCAdESService = asicWithCAdESService;
    }

    private DocumentSignatureService getServiceForSignature(SignatureForm signatureForm, ASiCContainerType asicContainerType) {
        if (asicContainerType != null) {
            switch (signatureForm) {
                case XAdES: {
                    return this.asicWithXAdESService;
                }
                case CAdES: {
                    return this.asicWithCAdESService;
                }
            }
            throw new UnsupportedOperationException("Unrecognized format (XAdES or CAdES are allowed with ASiC) : " + signatureForm);
        }
        switch (signatureForm) {
            case XAdES: {
                return this.xadesService;
            }
            case CAdES: {
                return this.cadesService;
            }
            case PAdES: {
                return this.padesService;
            }
            case JAdES: {
                return this.jadesService;
            }
        }
        throw new UnsupportedOperationException("Unrecognized format " + signatureForm);
    }

    private CounterSignatureService getServiceForCounterSignature(SignatureForm signatureForm, ASiCContainerType asicContainerType) {
        if (asicContainerType != null) {
            switch (signatureForm) {
                case XAdES: {
                    return this.asicWithXAdESService;
                }
                case CAdES: {
                    return this.asicWithCAdESService;
                }
            }
            throw new UnsupportedOperationException("Unrecognized format (XAdES or CAdES are allowed with ASiC) : " + signatureForm);
        }
        switch (signatureForm) {
            case XAdES: {
                return this.xadesService;
            }
            case CAdES: {
                return this.cadesService;
            }
            case PAdES: {
                throw new UnsupportedOperationException(String.format("The Counter Signature is not supported with %s", signatureForm));
            }
            case JAdES: {
                return this.jadesService;
            }
        }
        throw new UnsupportedOperationException("Unrecognized format " + signatureForm);
    }

    private DocumentSignatureService getServiceForTimestamp(TimestampContainerForm timestampContainerForm) {
        Objects.requireNonNull(timestampContainerForm, "The timestampContainerForm must be defined!");
        switch (timestampContainerForm) {
            case PDF: {
                return this.padesService;
            }
            case ASiC_E: 
            case ASiC_S: {
                return this.asicWithCAdESService;
            }
        }
        throw new UnsupportedOperationException("Unrecognized format (only PDF, ASiC-E and ASiC-S are allowed) : " + timestampContainerForm);
    }

    @Override
    public ToBeSignedDTO getDataToSign(RemoteDocument remoteDocument, RemoteSignatureParameters remoteParameters) {
        Objects.requireNonNull(remoteDocument, "remoteDocument must be defined!");
        Objects.requireNonNull(remoteParameters, "remoteParameters must be defined!");
        Objects.requireNonNull(remoteParameters.getSignatureLevel(), "signatureLevel must be defined!");
        LOG.info("GetDataToSign in process...");
        SerializableSignatureParameters parameters = this.createParameters(remoteParameters);
        DocumentSignatureService service = this.getServiceForSignature(remoteParameters.getSignatureLevel().getSignatureForm(), remoteParameters.getAsicContainerType());
        DSSDocument dssDocument = RemoteDocumentConverter.toDSSDocument((RemoteDocument)remoteDocument);
        ToBeSigned dataToSign = service.getDataToSign(dssDocument, parameters);
        LOG.info("GetDataToSign is finished");
        return DTOConverter.toToBeSignedDTO((ToBeSigned)dataToSign);
    }

    @Override
    public RemoteDocument signDocument(RemoteDocument remoteDocument, RemoteSignatureParameters remoteParameters, SignatureValueDTO signatureValueDTO) {
        Objects.requireNonNull(remoteDocument, "remoteDocument must be defined!");
        Objects.requireNonNull(remoteParameters, "remoteParameters must be defined!");
        Objects.requireNonNull(remoteParameters.getSignatureLevel(), "signatureLevel must be defined!");
        LOG.info("SignDocument in process...");
        SerializableSignatureParameters parameters = this.createParameters(remoteParameters);
        DocumentSignatureService service = this.getServiceForSignature(remoteParameters.getSignatureLevel().getSignatureForm(), remoteParameters.getAsicContainerType());
        DSSDocument dssDocument = RemoteDocumentConverter.toDSSDocument((RemoteDocument)remoteDocument);
        DSSDocument signDocument = service.signDocument(dssDocument, parameters, this.toSignatureValue(signatureValueDTO));
        LOG.info("SignDocument is finished");
        return RemoteDocumentConverter.toRemoteDocument((DSSDocument)signDocument);
    }

    @Override
    public RemoteDocument extendDocument(RemoteDocument remoteDocument, RemoteSignatureParameters remoteParameters) {
        Objects.requireNonNull(remoteDocument, "remoteDocument must be defined!");
        Objects.requireNonNull(remoteParameters, "remoteParameters must be defined!");
        Objects.requireNonNull(remoteParameters.getSignatureLevel(), "signatureLevel must be defined!");
        LOG.info("ExtendDocument in process...");
        SerializableSignatureParameters parameters = this.createParameters(remoteParameters);
        DocumentSignatureService service = this.getServiceForSignature(remoteParameters.getSignatureLevel().getSignatureForm(), remoteParameters.getAsicContainerType());
        DSSDocument dssDocument = RemoteDocumentConverter.toDSSDocument((RemoteDocument)remoteDocument);
        DSSDocument extendDocument = service.extendDocument(dssDocument, parameters);
        LOG.info("ExtendDocument is finished");
        return RemoteDocumentConverter.toRemoteDocument((DSSDocument)extendDocument);
    }

    @Override
    public RemoteDocument timestamp(RemoteDocument remoteDocument, RemoteTimestampParameters remoteParameters) {
        Objects.requireNonNull(remoteDocument, "remoteDocument must be defined!");
        Objects.requireNonNull(remoteParameters, "remoteParameters must be defined!");
        Objects.requireNonNull(remoteParameters.getTimestampContainerForm(), "signatureForm must be defined!");
        LOG.info("Timestamp document in process...");
        TimestampParameters parameters = this.toTimestampParameters(remoteParameters);
        DocumentSignatureService service = this.getServiceForTimestamp(remoteParameters.getTimestampContainerForm());
        DSSDocument dssDocument = RemoteDocumentConverter.toDSSDocument((RemoteDocument)remoteDocument);
        DSSDocument timestampedDocument = service.timestamp(dssDocument, (SerializableTimestampParameters)parameters);
        LOG.info("Timestamp document is finished");
        return RemoteDocumentConverter.toRemoteDocument((DSSDocument)timestampedDocument);
    }

    @Override
    public ToBeSignedDTO getDataToBeCounterSigned(RemoteDocument signatureDocument, RemoteSignatureParameters remoteParameters) {
        Objects.requireNonNull(signatureDocument, "signatureDocument must be defined!");
        Objects.requireNonNull(remoteParameters, "remoteParameters must be defined!");
        Objects.requireNonNull(remoteParameters.getSignatureLevel(), "signatureLevel must be defined!");
        LOG.info("GetDataToCounterSign in process...");
        SerializableCounterSignatureParameters counterSignatureParameters = this.createCounterSignatureParameters(remoteParameters);
        CounterSignatureService counterSignatureService = this.getServiceForCounterSignature(remoteParameters.getSignatureLevel().getSignatureForm(), remoteParameters.getAsicContainerType());
        DSSDocument dssDocument = RemoteDocumentConverter.toDSSDocument((RemoteDocument)signatureDocument);
        ToBeSigned dataToSign = counterSignatureService.getDataToBeCounterSigned(dssDocument, counterSignatureParameters);
        LOG.info("GetDataToCounterSign is finished");
        return DTOConverter.toToBeSignedDTO((ToBeSigned)dataToSign);
    }

    @Override
    public RemoteDocument counterSignSignature(RemoteDocument signatureDocument, RemoteSignatureParameters remoteParameters, SignatureValueDTO signatureValueDTO) {
        Objects.requireNonNull(signatureDocument, "signatureDocument must be defined!");
        Objects.requireNonNull(remoteParameters, "remoteParameters must be defined!");
        Objects.requireNonNull(remoteParameters.getSignatureLevel(), "signatureLevel must be defined!");
        LOG.info("CounterSignDocument in process...");
        SerializableCounterSignatureParameters parameters = this.createCounterSignatureParameters(remoteParameters);
        CounterSignatureService counterSignatureService = this.getServiceForCounterSignature(remoteParameters.getSignatureLevel().getSignatureForm(), remoteParameters.getAsicContainerType());
        DSSDocument dssDocument = RemoteDocumentConverter.toDSSDocument((RemoteDocument)signatureDocument);
        DSSDocument signDocument = counterSignatureService.counterSignSignature(dssDocument, parameters, this.toSignatureValue(signatureValueDTO));
        LOG.info("CounterSignDocument is finished");
        return RemoteDocumentConverter.toRemoteDocument((DSSDocument)signDocument);
    }
}

