/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.exception;

import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class DSSDataLoaderMultipleException
extends DSSExternalResourceException {
    private static final long serialVersionUID = 4981228392826668216L;
    private final Map<String, Throwable> urlExceptionMap;

    public DSSDataLoaderMultipleException(Map<String, Throwable> urlExceptionMap) {
        this.urlExceptionMap = urlExceptionMap;
    }

    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Throwable> exceptionEntry : this.urlExceptionMap.entrySet()) {
            Throwable exception = exceptionEntry.getValue();
            String errorMessage = exception.getMessage();
            if (exception instanceof DSSExternalResourceException) {
                errorMessage = ((DSSExternalResourceException)((Object)exception)).getCauseMessage();
            }
            stringBuilder.append("Failed to get data from URL '").append(exceptionEntry.getKey()).append("'. Reason : ");
            stringBuilder.append('[').append(errorMessage).append("]. ");
        }
        return stringBuilder.toString();
    }

    public StackTraceElement[] getStackTrace() {
        ArrayList<StackTraceElement> stackTraceElements = new ArrayList<StackTraceElement>();
        for (Throwable exception : this.urlExceptionMap.values()) {
            stackTraceElements.addAll(Arrays.asList(exception.getStackTrace()));
        }
        return stackTraceElements.toArray(new StackTraceElement[stackTraceElements.size()]);
    }

    @Override
    String getCauseMessage() {
        return this.getMessage();
    }
}

