/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation;

import eu.europa.esig.dss.alert.StatusAlert;
import eu.europa.esig.dss.alert.status.MessageStatus;
import eu.europa.esig.dss.enumerations.SigningOperation;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.validation.SignatureValidationContext;
import eu.europa.esig.dss.spi.validation.ValidationAlerter;
import eu.europa.esig.dss.spi.validation.status.RevocationFreshnessStatus;
import eu.europa.esig.dss.spi.validation.status.SignatureStatus;
import eu.europa.esig.dss.spi.validation.status.TokenStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureValidationAlerter
implements ValidationAlerter {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureValidationAlerter.class);
    private final SignatureValidationContext validationContext;
    private SigningOperation signingOperation;

    public SignatureValidationAlerter(SignatureValidationContext validationContext) {
        this.validationContext = validationContext;
    }

    public void setSigningOperation(SigningOperation signingOperation) {
        this.signingOperation = signingOperation;
    }

    @Override
    public void assertAllRequiredRevocationDataPresent() {
        StatusAlert alertOnMissingRevocationData = this.validationContext.getCertificateVerifier().getAlertOnMissingRevocationData();
        if (alertOnMissingRevocationData == null) {
            LOG.trace("The verification of #assertAllRequiredRevocationDataPresent has been skipped. Please define CertificateVerifier#alertOnMissingRevocationData to execute validation.");
            return;
        }
        TokenStatus status = this.validationContext.allRequiredRevocationDataPresent();
        boolean success = status.isEmpty();
        if (!success) {
            this.populateMessage((MessageStatus)status);
            alertOnMissingRevocationData.alert((Object)status);
        }
    }

    @Override
    public void assertAllPOECoveredByRevocationData() {
        StatusAlert alertOnUncoveredPOE = this.validationContext.getCertificateVerifier().getAlertOnUncoveredPOE();
        if (alertOnUncoveredPOE == null) {
            LOG.trace("The verification of #assertAllRequiredRevocationDataPresent has been skipped. Please define CertificateVerifier#alertOnUncoveredPOE to execute validation.");
            return;
        }
        RevocationFreshnessStatus status = this.validationContext.allPOECoveredByRevocationData();
        boolean success = status.isEmpty();
        if (!success) {
            this.populateMessage((MessageStatus)status);
            alertOnUncoveredPOE.alert((Object)status);
        }
    }

    @Override
    public void assertAllTimestampsValid() {
        StatusAlert alertOnInvalidTimestamp = this.validationContext.getCertificateVerifier().getAlertOnInvalidTimestamp();
        if (alertOnInvalidTimestamp == null) {
            LOG.trace("The verification of #assertAllTimestampsValid has been skipped. Please define CertificateVerifier#alertOnInvalidTimestamp to execute validation.");
            return;
        }
        TokenStatus status = this.validationContext.allTimestampsValid();
        boolean success = status.isEmpty();
        if (!success) {
            this.populateMessage((MessageStatus)status);
            alertOnInvalidTimestamp.alert((Object)status);
        }
    }

    @Override
    public void assertCertificateNotRevoked(CertificateToken certificateToken) {
        StatusAlert alertOnRevokedCertificate = this.validationContext.getCertificateVerifier().getAlertOnRevokedCertificate();
        if (alertOnRevokedCertificate == null) {
            LOG.trace("The verification of #assertCertificateNotRevoked has been skipped. Please define CertificateVerifier#alertOnRevokedCertificate to execute validation.");
            return;
        }
        TokenStatus status = this.validationContext.certificateNotRevoked(certificateToken);
        boolean success = status.isEmpty();
        if (!success) {
            this.populateMessage((MessageStatus)status);
            alertOnRevokedCertificate.alert((Object)status);
        }
    }

    @Override
    public void assertAllSignatureCertificatesNotRevoked() {
        StatusAlert alertOnRevokedCertificate = this.validationContext.getCertificateVerifier().getAlertOnRevokedCertificate();
        if (alertOnRevokedCertificate == null) {
            LOG.trace("The verification of #assertAllSignatureCertificatesNotRevoked has been skipped. Please define CertificateVerifier#alertOnRevokedCertificate to execute validation.");
            return;
        }
        TokenStatus status = this.validationContext.allSignatureCertificatesNotRevoked();
        boolean success = status.isEmpty();
        if (!success) {
            this.populateMessage((MessageStatus)status);
            alertOnRevokedCertificate.alert((Object)status);
        }
    }

    @Override
    public void assertAllSignatureCertificateHaveFreshRevocationData() {
        StatusAlert alertOnNoRevocationAfterBestSignatureTime = this.validationContext.getCertificateVerifier().getAlertOnNoRevocationAfterBestSignatureTime();
        if (alertOnNoRevocationAfterBestSignatureTime == null) {
            LOG.trace("The verification of #assertAllSignatureCertificateHaveFreshRevocationData has been skipped. Please define CertificateVerifier#alertOnNoRevocationAfterBestSignatureTime to execute validation.");
            return;
        }
        RevocationFreshnessStatus status = this.validationContext.allSignatureCertificateHaveFreshRevocationData();
        boolean success = status.isEmpty();
        if (!success) {
            this.populateMessage((MessageStatus)status);
            alertOnNoRevocationAfterBestSignatureTime.alert((Object)status);
        }
    }

    @Override
    public void assertAllSignaturesNotExpired() {
        StatusAlert alertOnExpiredCertificate = this.validationContext.getCertificateVerifier().getAlertOnExpiredCertificate();
        if (alertOnExpiredCertificate == null) {
            LOG.trace("The verification of #assertAllSignaturesNotExpired has been skipped. Please define CertificateVerifier#alertOnExpiredCertificate to execute validation.");
            return;
        }
        SignatureStatus status = this.validationContext.allSignaturesNotExpired();
        boolean success = status.isEmpty();
        if (!success) {
            this.populateMessage((MessageStatus)status);
            alertOnExpiredCertificate.alert((Object)status);
        }
    }

    @Override
    public void assertCertificateNotExpired(CertificateToken certificateToken) {
        StatusAlert alertOnExpiredCertificate = this.validationContext.getCertificateVerifier().getAlertOnExpiredCertificate();
        if (alertOnExpiredCertificate == null) {
            LOG.trace("The verification of #assertCertificateNotExpired has been skipped. Please define CertificateVerifier#alertOnExpiredCertificate to execute validation.");
            return;
        }
        TokenStatus status = this.validationContext.certificateNotExpired(certificateToken);
        boolean success = status.isEmpty();
        if (!success) {
            this.populateMessage((MessageStatus)status);
            alertOnExpiredCertificate.alert((Object)status);
        }
    }

    @Override
    public void assertAllSignaturesAreYetValid() {
        StatusAlert alertOnNotYetValidCertificate = this.validationContext.getCertificateVerifier().getAlertOnNotYetValidCertificate();
        if (alertOnNotYetValidCertificate == null) {
            LOG.trace("The verification of #assertAllSignaturesAreYetValid has been skipped. Please define CertificateVerifier#alertOnNotYetValidCertificate to execute validation.");
            return;
        }
        SignatureStatus status = this.validationContext.allSignaturesAreYetValid();
        boolean success = status.isEmpty();
        if (!success) {
            this.populateMessage((MessageStatus)status);
            alertOnNotYetValidCertificate.alert((Object)status);
        }
    }

    @Override
    public void assertCertificateIsYetValid(CertificateToken certificateToken) {
        StatusAlert alertOnNotYetValidCertificate = this.validationContext.getCertificateVerifier().getAlertOnNotYetValidCertificate();
        if (alertOnNotYetValidCertificate == null) {
            LOG.trace("The verification of #assertCertificateIsYetValid has been skipped. Please define CertificateVerifier#alertOnNotYetValidCertificate to execute validation.");
            return;
        }
        TokenStatus status = this.validationContext.certificateIsYetValid(certificateToken);
        boolean success = status.isEmpty();
        if (!success) {
            this.populateMessage((MessageStatus)status);
            alertOnNotYetValidCertificate.alert((Object)status);
        }
    }

    protected void populateMessage(MessageStatus status) {
        if (status != null && this.signingOperation != null) {
            String originalMessage = status.getMessage();
            switch (this.signingOperation) {
                case SIGN: 
                case COUNTER_SIGN: {
                    status.setMessage(String.format("Error on signature creation : %s", originalMessage));
                    break;
                }
                case EXTEND: {
                    status.setMessage(String.format("Error on signature augmentation : %s", originalMessage));
                    break;
                }
                case TIMESTAMP: {
                    status.setMessage(String.format("Error on timestamp : %s", originalMessage));
                    break;
                }
                case ADD_EVIDENCE_RECORD: {
                    status.setMessage(String.format("Error on evidence record incorporation : %s", originalMessage));
                    break;
                }
                case ADD_SIG_POLICY_STORE: {
                    status.setMessage(String.format("Error on signature policy store incorporation : %s", originalMessage));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("The operation '%s' is not supported!", this.signingOperation));
                }
            }
        }
    }
}

