/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation.analyzer.evidencerecord;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.validation.analyzer.DocumentAnalyzerFactory;
import eu.europa.esig.dss.spi.validation.analyzer.evidencerecord.EvidenceRecordAnalyzer;
import java.util.Objects;
import java.util.ServiceLoader;

public interface EvidenceRecordAnalyzerFactory
extends DocumentAnalyzerFactory {
    @Override
    public boolean isSupported(DSSDocument var1);

    @Override
    public EvidenceRecordAnalyzer create(DSSDocument var1);

    public static boolean isSupportedDocument(DSSDocument document) {
        Objects.requireNonNull(document, "DSSDocument is null");
        ServiceLoader<EvidenceRecordAnalyzerFactory> serviceLoaders = ServiceLoader.load(EvidenceRecordAnalyzerFactory.class);
        for (EvidenceRecordAnalyzerFactory factory : serviceLoaders) {
            if (!factory.isSupported(document)) continue;
            return true;
        }
        return false;
    }

    public static EvidenceRecordAnalyzer fromDocument(DSSDocument document) throws UnsupportedOperationException {
        Objects.requireNonNull(document, "DSSDocument is null");
        ServiceLoader<EvidenceRecordAnalyzerFactory> serviceLoaders = ServiceLoader.load(EvidenceRecordAnalyzerFactory.class);
        for (EvidenceRecordAnalyzerFactory factory : serviceLoaders) {
            if (!factory.isSupported(document)) continue;
            return factory.create(document);
        }
        throw new UnsupportedOperationException("Document format not recognized/handled");
    }
}

