/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.identifier.EntityIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.X500PrincipalHelper;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateSourceEntity;
import eu.europa.esig.dss.spi.x509.SignerIdentifier;
import java.io.Serializable;
import java.security.PublicKey;
import java.util.Date;
import java.util.List;
import java.util.Set;

public interface CertificateSource
extends Serializable {
    public CertificateToken addCertificate(CertificateToken var1);

    public CertificateSourceType getCertificateSourceType();

    public List<CertificateToken> getCertificates();

    public boolean isTrusted(CertificateToken var1);

    public boolean isTrustedAtTime(CertificateToken var1, Date var2);

    public boolean isKnown(CertificateToken var1);

    public Set<CertificateToken> getBySubject(X500PrincipalHelper var1);

    public Set<CertificateToken> getBySignerIdentifier(SignerIdentifier var1);

    public Set<CertificateToken> getByCertificateDigest(Digest var1);

    public Set<CertificateToken> getByPublicKey(PublicKey var1);

    public Set<CertificateToken> getByEntityKey(EntityIdentifier var1);

    public Set<CertificateToken> getBySki(byte[] var1);

    public Set<CertificateToken> findTokensFromCertRef(CertificateRef var1);

    public List<CertificateSourceEntity> getEntities();

    public boolean isAllSelfSigned();

    public boolean isCertificateSourceEqual(CertificateSource var1);

    public boolean isCertificateSourceEquivalent(CertificateSource var1);
}

