/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.identifier.TokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.spi.x509.revocation.MultipleRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.RevocationTokenRefMatcher;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class OfflineRevocationSource<R extends Revocation>
implements RevocationSource<R>,
MultipleRevocationSource<R> {
    private static final long serialVersionUID = 8270762277613989997L;
    private final Map<EncapsulatedRevocationTokenIdentifier<R>, Set<RevocationOrigin>> binaryOrigins = new HashMap<EncapsulatedRevocationTokenIdentifier<R>, Set<RevocationOrigin>>();
    private final Map<RevocationToken<R>, Set<RevocationOrigin>> tokenOrigins = new HashMap<RevocationToken<R>, Set<RevocationOrigin>>();
    private final Map<RevocationRef<R>, Set<RevocationRefOrigin>> referenceOrigins = new HashMap<RevocationRef<R>, Set<RevocationRefOrigin>>();
    private final RevocationTokenRefMatcher<R> tokenRefMatcher;

    protected OfflineRevocationSource(RevocationTokenRefMatcher<R> tokenRefMatcher) {
        Objects.requireNonNull(tokenRefMatcher);
        this.tokenRefMatcher = tokenRefMatcher;
    }

    public void addBinary(EncapsulatedRevocationTokenIdentifier<R> binary, RevocationOrigin origin) {
        Objects.requireNonNull(binary, "The binary is null");
        Objects.requireNonNull(origin, "The origin is null");
        this.binaryOrigins.computeIfAbsent(binary, k -> new HashSet()).add(origin);
    }

    public void addRevocation(RevocationToken<R> token, RevocationOrigin origin) {
        Objects.requireNonNull(token, "The token is null");
        Objects.requireNonNull(origin, "The origin is null");
        this.tokenOrigins.computeIfAbsent(token, k -> new HashSet()).add(origin);
    }

    public void addRevocation(RevocationToken<R> token, EncapsulatedRevocationTokenIdentifier<R> binary) {
        Objects.requireNonNull(token, "The token is null");
        Objects.requireNonNull(binary, "The origin is null");
        Set<RevocationOrigin> origins = this.getAllRevocationBinariesWithOrigins().get(binary);
        if (origins == null) {
            throw new IllegalStateException(String.format("Unable to find the binary '%s'", binary.asXmlId()));
        }
        for (RevocationOrigin origin : origins) {
            this.addRevocation(token, origin);
        }
    }

    public void addRevocationReference(RevocationRef<R> reference, RevocationRefOrigin origin) {
        Objects.requireNonNull(reference, "The reference is null");
        Objects.requireNonNull(origin, "The origin is null");
        this.referenceOrigins.computeIfAbsent(reference, k -> new HashSet()).add(origin);
    }

    public Set<EncapsulatedRevocationTokenIdentifier<R>> getAllRevocationBinaries() {
        return this.getAllRevocationBinariesWithOrigins().keySet();
    }

    public Map<EncapsulatedRevocationTokenIdentifier<R>, Set<RevocationOrigin>> getAllRevocationBinariesWithOrigins() {
        return this.binaryOrigins;
    }

    public Set<RevocationToken<R>> getAllRevocationTokens() {
        return this.getAllRevocationTokensWithOrigins().keySet();
    }

    public Map<RevocationToken<R>, Set<RevocationOrigin>> getAllRevocationTokensWithOrigins() {
        return this.tokenOrigins;
    }

    public Map<RevocationToken<R>, Set<RevocationOrigin>> getUniqueRevocationTokensWithOrigins() {
        HashMap<RevocationToken<R>, Set<RevocationOrigin>> result = new HashMap<RevocationToken<R>, Set<RevocationOrigin>>();
        ArrayList<TokenIdentifier> knownIds = new ArrayList<TokenIdentifier>();
        for (Map.Entry<RevocationToken<R>, Set<RevocationOrigin>> entry : this.getAllRevocationTokensWithOrigins().entrySet()) {
            TokenIdentifier currentId = entry.getKey().getDSSId();
            if (knownIds.contains(currentId)) continue;
            result.put(entry.getKey(), entry.getValue());
            knownIds.add(currentId);
        }
        return result;
    }

    public Set<RevocationRef<R>> getAllRevocationReferences() {
        return this.getRevocationReferencesWithOrigins().keySet();
    }

    protected Map<RevocationRef<R>, Set<RevocationRefOrigin>> getRevocationReferencesWithOrigins() {
        return this.referenceOrigins;
    }

    @Override
    public RevocationToken<R> getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        RevocationToken latestRevocationToken = null;
        List revocationTokens = this.getRevocationTokens(certificateToken, issuerCertificateToken);
        if (Utils.isCollectionNotEmpty(revocationTokens)) {
            for (RevocationToken revocationToken : revocationTokens) {
                if (latestRevocationToken != null && (revocationToken.getThisUpdate() == null || !latestRevocationToken.getThisUpdate().before(revocationToken.getThisUpdate()))) continue;
                latestRevocationToken = revocationToken;
            }
        }
        return latestRevocationToken;
    }

    public List<EncapsulatedRevocationTokenIdentifier<R>> getCMSSignedDataRevocationBinaries() {
        return this.getBinariesByOrigin(RevocationOrigin.CMS_SIGNED_DATA);
    }

    public List<RevocationToken<R>> getCMSSignedDataRevocationTokens() {
        return this.getTokensByOrigin(RevocationOrigin.CMS_SIGNED_DATA);
    }

    public List<EncapsulatedRevocationTokenIdentifier<R>> getRevocationValuesBinaries() {
        return this.getBinariesByOrigin(RevocationOrigin.REVOCATION_VALUES);
    }

    public List<RevocationToken<R>> getRevocationValuesTokens() {
        return this.getTokensByOrigin(RevocationOrigin.REVOCATION_VALUES);
    }

    public List<EncapsulatedRevocationTokenIdentifier<R>> getAttributeRevocationValuesBinaries() {
        return this.getBinariesByOrigin(RevocationOrigin.ATTRIBUTE_REVOCATION_VALUES);
    }

    public List<RevocationToken<R>> getAttributeRevocationValuesTokens() {
        return this.getTokensByOrigin(RevocationOrigin.ATTRIBUTE_REVOCATION_VALUES);
    }

    public List<EncapsulatedRevocationTokenIdentifier<R>> getTimestampValidationDataBinaries() {
        return this.getBinariesByOrigin(RevocationOrigin.TIMESTAMP_VALIDATION_DATA);
    }

    public List<RevocationToken<R>> getTimestampValidationDataTokens() {
        return this.getTokensByOrigin(RevocationOrigin.TIMESTAMP_VALIDATION_DATA);
    }

    public List<EncapsulatedRevocationTokenIdentifier<R>> getAnyValidationDataBinaries() {
        return this.getBinariesByOrigin(RevocationOrigin.ANY_VALIDATION_DATA);
    }

    public List<RevocationToken<R>> getAnyValidationDataTokens() {
        return this.getTokensByOrigin(RevocationOrigin.ANY_VALIDATION_DATA);
    }

    public List<EncapsulatedRevocationTokenIdentifier<R>> getDSSDictionaryBinaries() {
        return this.getBinariesByOrigin(RevocationOrigin.DSS_DICTIONARY);
    }

    public List<RevocationToken<R>> getDSSDictionaryTokens() {
        return this.getTokensByOrigin(RevocationOrigin.DSS_DICTIONARY);
    }

    public List<EncapsulatedRevocationTokenIdentifier<R>> getVRIDictionaryBinaries() {
        return this.getBinariesByOrigin(RevocationOrigin.VRI_DICTIONARY);
    }

    public List<RevocationToken<R>> getVRIDictionaryTokens() {
        return this.getTokensByOrigin(RevocationOrigin.VRI_DICTIONARY);
    }

    public List<EncapsulatedRevocationTokenIdentifier<R>> getADBERevocationValuesBinaries() {
        return this.getBinariesByOrigin(RevocationOrigin.ADBE_REVOCATION_INFO_ARCHIVAL);
    }

    public List<RevocationToken<R>> getADBERevocationValuesTokens() {
        return this.getTokensByOrigin(RevocationOrigin.ADBE_REVOCATION_INFO_ARCHIVAL);
    }

    public List<RevocationRef<R>> getCompleteRevocationRefs() {
        return this.getReferencesByOrigin(RevocationRefOrigin.COMPLETE_REVOCATION_REFS);
    }

    public List<RevocationRef<R>> getAttributeRevocationRefs() {
        return this.getReferencesByOrigin(RevocationRefOrigin.ATTRIBUTE_REVOCATION_REFS);
    }

    public Map<RevocationRef<R>, Set<RevocationRefOrigin>> findRefsAndOriginsForRevocationToken(RevocationToken<R> revocationToken) {
        HashMap<RevocationRef<R>, Set<RevocationRefOrigin>> result = new HashMap<RevocationRef<R>, Set<RevocationRefOrigin>>();
        for (Map.Entry<RevocationRef<R>, Set<RevocationRefOrigin>> entry : this.getRevocationReferencesWithOrigins().entrySet()) {
            RevocationRef<R> currentReference = entry.getKey();
            if (!this.tokenRefMatcher.match(revocationToken, currentReference)) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public Map<RevocationRef<R>, Set<RevocationRefOrigin>> findRefsAndOriginsForBinary(EncapsulatedRevocationTokenIdentifier<R> identifier) {
        HashMap<RevocationRef<R>, Set<RevocationRefOrigin>> result = new HashMap<RevocationRef<R>, Set<RevocationRefOrigin>>();
        for (Map.Entry<RevocationRef<R>, Set<RevocationRefOrigin>> entry : this.getRevocationReferencesWithOrigins().entrySet()) {
            RevocationRef<R> currentReference = entry.getKey();
            if (!this.tokenRefMatcher.match(identifier, currentReference)) continue;
            result.put(currentReference, entry.getValue());
        }
        return result;
    }

    public EncapsulatedRevocationTokenIdentifier<R> findBinaryForReference(RevocationRef<R> ref) {
        for (EncapsulatedRevocationTokenIdentifier<R> binary : this.getAllRevocationBinariesWithOrigins().keySet()) {
            if (!this.tokenRefMatcher.match(binary, ref)) continue;
            return binary;
        }
        return null;
    }

    public Map<RevocationRef<R>, Set<RevocationRefOrigin>> getOrphanRevocationReferencesWithOrigins() {
        HashMap<RevocationRef<R>, Set<RevocationRefOrigin>> result = new HashMap<RevocationRef<R>, Set<RevocationRefOrigin>>();
        for (Map.Entry<RevocationRef<R>, Set<RevocationRefOrigin>> entry : this.getRevocationReferencesWithOrigins().entrySet()) {
            RevocationRef<R> ref = entry.getKey();
            if (!this.isOrphan(ref)) continue;
            result.put(ref, entry.getValue());
        }
        return result;
    }

    public boolean isOrphan(RevocationRef<R> reference) {
        for (RevocationToken<R> token : this.getAllRevocationTokensWithOrigins().keySet()) {
            if (!this.tokenRefMatcher.match(token, reference)) continue;
            return false;
        }
        return true;
    }

    public Set<EncapsulatedRevocationTokenIdentifier<R>> getAllReferencedRevocationBinaries() {
        HashSet<EncapsulatedRevocationTokenIdentifier<R>> result = new HashSet<EncapsulatedRevocationTokenIdentifier<R>>();
        for (RevocationRef<R> reference : this.getRevocationReferencesWithOrigins().keySet()) {
            for (EncapsulatedRevocationTokenIdentifier<R> identifier : this.getAllRevocationBinariesWithOrigins().keySet()) {
                if (!this.tokenRefMatcher.match(identifier, reference)) continue;
                result.add(identifier);
            }
        }
        return result;
    }

    public boolean isEmpty() {
        return Utils.isMapEmpty(this.getAllRevocationBinariesWithOrigins()) && Utils.isMapEmpty(this.getAllRevocationTokensWithOrigins()) && Utils.isMapEmpty(this.getRevocationReferencesWithOrigins());
    }

    private List<EncapsulatedRevocationTokenIdentifier<R>> getBinariesByOrigin(RevocationOrigin origin) {
        ArrayList<EncapsulatedRevocationTokenIdentifier<R>> result = new ArrayList<EncapsulatedRevocationTokenIdentifier<R>>();
        for (Map.Entry<EncapsulatedRevocationTokenIdentifier<R>, Set<RevocationOrigin>> entry : this.getAllRevocationBinariesWithOrigins().entrySet()) {
            Set<RevocationOrigin> currentOrigins = entry.getValue();
            if (!Utils.isCollectionNotEmpty(currentOrigins) || !currentOrigins.contains(origin)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private List<RevocationToken<R>> getTokensByOrigin(RevocationOrigin origin) {
        ArrayList<RevocationToken<R>> result = new ArrayList<RevocationToken<R>>();
        for (Map.Entry<RevocationToken<R>, Set<RevocationOrigin>> entry : this.getAllRevocationTokensWithOrigins().entrySet()) {
            Set<RevocationOrigin> currentOrigins = entry.getValue();
            if (!Utils.isCollectionNotEmpty(currentOrigins) || !currentOrigins.contains(origin)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private List<RevocationRef<R>> getReferencesByOrigin(RevocationRefOrigin origin) {
        ArrayList<RevocationRef<R>> result = new ArrayList<RevocationRef<R>>();
        for (Map.Entry<RevocationRef<R>, Set<RevocationRefOrigin>> entry : this.getRevocationReferencesWithOrigins().entrySet()) {
            Set<RevocationRefOrigin> currentOrigins = entry.getValue();
            if (!Utils.isCollectionNotEmpty(currentOrigins) || !currentOrigins.contains(origin)) continue;
            result.add(entry.getKey());
        }
        return result;
    }
}

