/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.alerts.detections;

import eu.europa.esig.dss.alert.detector.AlertDetector;
import eu.europa.esig.dss.spi.tsl.LOTLInfo;
import eu.europa.esig.dss.spi.tsl.ParsingInfoRecord;
import eu.europa.esig.dss.tsl.function.LOTLSigningCertificatesAnnouncementSchemeInformationURI;
import eu.europa.esig.dss.tsl.function.OfficialJournalSchemeInformationURI;
import eu.europa.esig.dss.tsl.source.LOTLSource;
import eu.europa.esig.dss.utils.Utils;

public class OJUrlChangeDetection
implements AlertDetector<LOTLInfo> {
    private final LOTLSource lotlSource;

    public OJUrlChangeDetection(LOTLSource lotlSource) {
        this.lotlSource = lotlSource;
    }

    public boolean detect(LOTLInfo info) {
        String signingCertificateAnnouncementUrl;
        OfficialJournalSchemeInformationURI journalSchemeInformation;
        String officialJournalURL;
        LOTLSigningCertificatesAnnouncementSchemeInformationURI signingCertificatesAnnouncementPredicate;
        if (!Utils.areStringsEqual((String)this.lotlSource.getUrl(), (String)info.getUrl())) {
            return false;
        }
        ParsingInfoRecord parsingCacheInfo = info.getParsingCacheInfo();
        return parsingCacheInfo.isDesynchronized() && (signingCertificatesAnnouncementPredicate = this.lotlSource.getSigningCertificatesAnnouncementPredicate()) instanceof OfficialJournalSchemeInformationURI && !Utils.areStringsEqual((String)(officialJournalURL = (journalSchemeInformation = (OfficialJournalSchemeInformationURI)signingCertificatesAnnouncementPredicate).getOfficialJournalURL()), (String)(signingCertificateAnnouncementUrl = parsingCacheInfo.getSigningCertificateAnnouncementUrl()));
    }
}

