/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.cache.state;

import eu.europa.esig.dss.tsl.cache.CachedResult;
import eu.europa.esig.dss.tsl.cache.state.CacheContext;
import eu.europa.esig.dss.tsl.cache.state.CacheStateEnum;
import eu.europa.esig.dss.tsl.cache.state.CachedExceptionWrapper;
import eu.europa.esig.dss.tsl.cache.state.CurrentCacheContext;
import eu.europa.esig.dss.utils.Utils;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedEntry<R extends CachedResult> {
    private static final Logger LOG = LoggerFactory.getLogger(CachedEntry.class);
    private final CacheContext cacheContext = new CurrentCacheContext();
    private R cachedResult;

    public CachedEntry() {
    }

    public CachedEntry(R cachedResult) {
        this.update(cachedResult);
    }

    public CacheStateEnum getCurrentState() {
        return this.cacheContext.getCurrentState();
    }

    public Date getLastStateTransitionTime() {
        return this.cacheContext.getLastStateTransitionTime();
    }

    public Date getLastSuccessSynchronizationTime() {
        return this.cacheContext.getLastSuccessSynchronizationTime();
    }

    public R getCachedResult() {
        return this.cachedResult;
    }

    public void update(R newCachedResult) {
        Objects.requireNonNull(newCachedResult, "Cached result cannot be overrided with a null value");
        this.cacheContext.desync();
        this.cachedResult = newCachedResult;
    }

    public void syncUpdateDate() {
        this.cacheContext.syncUpdateDate();
    }

    public void error(CachedExceptionWrapper exception) {
        if (this.isNewError(exception)) {
            this.cacheContext.error(exception);
            this.cachedResult = null;
        } else {
            LOG.trace("The ERROR is already recorded.");
            this.cacheContext.errorUpdateDate(exception);
        }
    }

    private boolean isNewError(CachedExceptionWrapper wrappedException) {
        return !this.isError() || !Utils.areStringsEqual((String)this.getExceptionStackTrace(), (String)wrappedException.getStackTrace());
    }

    public void expire() {
        this.cacheContext.refreshNeeded();
    }

    public void sync() {
        this.cacheContext.sync();
    }

    public void toBeDeleted() {
        this.cacheContext.toBeDeleted();
    }

    public boolean isToBeDeleted() {
        return this.cacheContext.isToBeDeleted();
    }

    public boolean isDesync() {
        return this.cacheContext.isDesync();
    }

    public boolean isRefreshNeeded() {
        return this.cacheContext.isRefreshNeeded();
    }

    public boolean isEmpty() {
        return this.cachedResult == null;
    }

    public boolean isError() {
        return this.cacheContext.isError();
    }

    public String getExceptionMessage() {
        if (this.cacheContext.getException() != null) {
            return this.cacheContext.getException().getExceptionMessage();
        }
        return null;
    }

    public String getExceptionStackTrace() {
        if (this.cacheContext.getException() != null) {
            return this.cacheContext.getException().getStackTrace();
        }
        return null;
    }

    public Date getExceptionFirstOccurrenceTime() {
        if (this.cacheContext.getException() != null) {
            return this.cacheContext.getException().getDate();
        }
        return null;
    }

    public Date getExceptionLastOccurrenceTime() {
        if (this.cacheContext.getException() != null) {
            return this.cacheContext.getException().getLastOccurrenceDate();
        }
        return null;
    }
}

