/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.dto.condition;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.tsl.Condition;
import eu.europa.esig.trustedlist.enums.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompositeCondition
implements Condition {
    private static final long serialVersionUID = -3756905347291887068L;
    private Assert matchingCriteriaIndicator;
    private List<Condition> children = new ArrayList<Condition>();

    public CompositeCondition() {
        this.matchingCriteriaIndicator = Assert.ALL;
    }

    public CompositeCondition(Assert matchingCriteriaIndicator) {
        this.matchingCriteriaIndicator = matchingCriteriaIndicator;
    }

    public final List<Condition> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChild(Condition condition) {
        this.children.add(condition);
    }

    public Assert getMatchingCriteriaIndicator() {
        return this.matchingCriteriaIndicator;
    }

    public boolean check(CertificateToken certificateToken) {
        switch (this.matchingCriteriaIndicator) {
            case ALL: {
                for (Condition condition : this.children) {
                    if (condition.check(certificateToken)) continue;
                    return false;
                }
                return true;
            }
            case AT_LEAST_ONE: {
                for (Condition condition : this.children) {
                    if (!condition.check(certificateToken)) continue;
                    return true;
                }
                return false;
            }
            case NONE: {
                for (Condition condition : this.children) {
                    if (!condition.check(certificateToken)) continue;
                    return false;
                }
                return true;
            }
        }
        throw new DSSException("Unsupported MatchingCriteriaIndicator : " + this.matchingCriteriaIndicator);
    }

    public String toString(String indent) {
        if (indent == null) {
            indent = "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(indent).append("CriteriaListCondition: ").append(this.matchingCriteriaIndicator.name()).append('\n');
        if (this.children != null) {
            indent = indent + "\t";
            for (Condition condition : this.children) {
                builder.append(condition.toString(indent));
            }
        }
        return builder.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

