/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.function;

import eu.europa.esig.dss.tsl.function.TrustServicePredicate;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.qualification.trust.TrustedServiceStatus;
import eu.europa.esig.trustedlist.jaxb.tsl.ServiceHistoryInstanceType;
import eu.europa.esig.trustedlist.jaxb.tsl.ServiceHistoryType;
import eu.europa.esig.trustedlist.jaxb.tsl.TSPServiceInformationType;
import eu.europa.esig.trustedlist.jaxb.tsl.TSPServiceType;
import java.util.Collection;

public class GrantedTrustService
implements TrustServicePredicate {
    @Override
    public boolean test(TSPServiceType trustedService) {
        if (trustedService != null) {
            TSPServiceInformationType serviceInformation = trustedService.getServiceInformation();
            if (TrustedServiceStatus.isAcceptableStatusAfterEIDAS((String)serviceInformation.getServiceStatus()) || TrustedServiceStatus.isAcceptableStatusBeforeEIDAS((String)serviceInformation.getServiceStatus())) {
                return true;
            }
            ServiceHistoryType serviceHistory = trustedService.getServiceHistory();
            if (serviceHistory != null && Utils.isCollectionNotEmpty((Collection)serviceHistory.getServiceHistoryInstance())) {
                for (ServiceHistoryInstanceType serviceHistoryInstance : serviceHistory.getServiceHistoryInstance()) {
                    if (!TrustedServiceStatus.isAcceptableStatusAfterEIDAS((String)serviceHistoryInstance.getServiceStatus()) && !TrustedServiceStatus.isAcceptableStatusBeforeEIDAS((String)serviceHistoryInstance.getServiceStatus())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

