/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.function.converter;

import eu.europa.esig.dss.enumerations.MRAEquivalenceContext;
import eu.europa.esig.dss.spi.tsl.CertificateContentEquivalence;
import eu.europa.esig.dss.spi.tsl.Condition;
import eu.europa.esig.dss.spi.tsl.QCStatementOids;
import eu.europa.esig.dss.spi.tsl.ServiceEquivalence;
import eu.europa.esig.dss.spi.tsl.ServiceTypeASi;
import eu.europa.esig.dss.tsl.dto.condition.CompositeCondition;
import eu.europa.esig.dss.tsl.dto.condition.QCStatementCondition;
import eu.europa.esig.dss.tsl.function.converter.CriteriaListTypeConverter;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.trustedlist.jaxb.ecc.CriteriaListType;
import eu.europa.esig.trustedlist.jaxb.ecc.QualifierType;
import eu.europa.esig.trustedlist.jaxb.mra.CertificateContentReferenceEquivalenceType;
import eu.europa.esig.trustedlist.jaxb.mra.CertificateContentReferencesEquivalenceListType;
import eu.europa.esig.trustedlist.jaxb.mra.QualifierEquivalenceListType;
import eu.europa.esig.trustedlist.jaxb.mra.QualifierEquivalenceType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceEquivalenceInformationType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceTSLQualificationExtensionEquivalenceListType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceTSLStatusEquivalenceListType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceTSLStatusEquivalenceType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceTSLStatusList;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceTSLTypeEquivalenceListType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceTSLTypeListType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceTSLTypeType;
import eu.europa.esig.trustedlist.jaxb.tsl.AdditionalServiceInformationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustServiceEquivalenceConverter
implements Function<TrustServiceEquivalenceInformationType, ServiceEquivalence> {
    private static final Logger LOG = LoggerFactory.getLogger(TrustServiceEquivalenceConverter.class);
    private final CriteriaListTypeConverter criteriaConverter = new CriteriaListTypeConverter();

    @Override
    public ServiceEquivalence apply(TrustServiceEquivalenceInformationType t) {
        ServiceEquivalence result = new ServiceEquivalence();
        result.setLegalInfoIdentifier(t.getTrustServiceLegalIdentifier());
        result.setStartDate(t.getTrustServiceEquivalenceStatusStartingTime().toGregorianCalendar().getTime());
        result.setStatus(t.getTrustServiceEquivalenceStatus());
        this.fillTypeASiEquivalence(t, result);
        this.fillStatusEquivalence(t, result);
        this.fillCertificateEquivalence(t, result);
        this.fillQualifierEquivalence(t, result);
        return result;
    }

    private void fillTypeASiEquivalence(TrustServiceEquivalenceInformationType t, ServiceEquivalence result) {
        TrustServiceTSLTypeEquivalenceListType serviceTSLTypeEquivalenceList = t.getTrustServiceTSLTypeEquivalenceList();
        if (serviceTSLTypeEquivalenceList != null) {
            TrustServiceTSLTypeListType expected = serviceTSLTypeEquivalenceList.getTrustServiceTSLTypeListPointedParty();
            TrustServiceTSLTypeListType substitute = serviceTSLTypeEquivalenceList.getTrustServiceTSLTypeListPointingParty();
            List expectedServiceTSLTypes = expected.getTrustServiceTSLType();
            List substituteServiceTSLTypes = substitute.getTrustServiceTSLType();
            HashMap<ServiceTypeASi, ServiceTypeASi> typeAsiEquivalence = new HashMap<ServiceTypeASi, ServiceTypeASi>();
            for (TrustServiceTSLTypeType expectedTypeASI : expectedServiceTSLTypes) {
                ServiceTypeASi staExpected = this.getServiceTypeASi(expectedTypeASI);
                for (TrustServiceTSLTypeType substituteTypeASI : substituteServiceTSLTypes) {
                    ServiceTypeASi staSubstitute = this.getServiceTypeASi(substituteTypeASI);
                    typeAsiEquivalence.put(staExpected, staSubstitute);
                }
            }
            result.setTypeAsiEquivalence(typeAsiEquivalence);
        }
    }

    private ServiceTypeASi getServiceTypeASi(TrustServiceTSLTypeType expectedTypeASI) {
        ServiceTypeASi sta = new ServiceTypeASi();
        sta.setType(expectedTypeASI.getServiceTypeIdentifier());
        AdditionalServiceInformationType additionalServiceInformation = expectedTypeASI.getAdditionalServiceInformation();
        if (additionalServiceInformation != null && additionalServiceInformation.getURI() != null) {
            sta.setAsi(additionalServiceInformation.getURI().getValue());
        }
        return sta;
    }

    private void fillStatusEquivalence(TrustServiceEquivalenceInformationType t, ServiceEquivalence result) {
        TrustServiceTSLStatusEquivalenceListType serviceTSLStatusEquivalenceList = t.getTrustServiceTSLStatusEquivalenceList();
        HashMap<List<String>, List<String>> statusEquivalenceMap = new HashMap<List<String>, List<String>>();
        TrustServiceTSLStatusEquivalenceType validEquivalences = serviceTSLStatusEquivalenceList.getTrustServiceTSLStatusValidEquivalence();
        this.extractEquivalences(validEquivalences, statusEquivalenceMap);
        TrustServiceTSLStatusEquivalenceType invalidEquivalences = serviceTSLStatusEquivalenceList.getTrustServiceTSLStatusInvalidEquivalence();
        this.extractEquivalences(invalidEquivalences, statusEquivalenceMap);
        result.setStatusEquivalence(statusEquivalenceMap);
    }

    private void extractEquivalences(TrustServiceTSLStatusEquivalenceType statusEquivalence, Map<List<String>, List<String>> statusEquivalenceMap) {
        if (statusEquivalence != null) {
            TrustServiceTSLStatusList serviceTSLStatusListExpected = statusEquivalence.getTrustServiceTSLStatusListPointedParty();
            List expected = serviceTSLStatusListExpected.getServiceStatus();
            TrustServiceTSLStatusList serviceTSLStatusListSubstitute = statusEquivalence.getTrustServiceTSLStatusListPointingParty();
            List substitute = serviceTSLStatusListSubstitute.getServiceStatus();
            statusEquivalenceMap.put(expected, substitute);
        }
    }

    private void fillCertificateEquivalence(TrustServiceEquivalenceInformationType t, ServiceEquivalence result) {
        CertificateContentReferencesEquivalenceListType certificateContentEquivalenceList = t.getCertificateContentReferencesEquivalenceList();
        if (certificateContentEquivalenceList != null && Utils.isCollectionNotEmpty((Collection)certificateContentEquivalenceList.getCertificateContentReferenceEquivalence())) {
            EnumMap<MRAEquivalenceContext, CertificateContentEquivalence> certificateContentEquivalences = new EnumMap<MRAEquivalenceContext, CertificateContentEquivalence>(MRAEquivalenceContext.class);
            for (CertificateContentReferenceEquivalenceType certEquiv : certificateContentEquivalenceList.getCertificateContentReferenceEquivalence()) {
                CriteriaListType expected = certEquiv.getCertificateContentDeclarationPointedParty();
                CriteriaListType substitute = certEquiv.getCertificateContentDeclarationPointingParty();
                Condition condition = this.criteriaConverter.apply(substitute);
                CertificateContentEquivalence equiv = new CertificateContentEquivalence();
                equiv.setCondition(this.criteriaConverter.apply(expected));
                equiv.setContentReplacement(this.getQCStatementOids(condition));
                certificateContentEquivalences.put(certEquiv.getCertificateContentReferenceEquivalenceContext(), equiv);
            }
            result.setCertificateContentEquivalences(certificateContentEquivalences);
        }
    }

    private QCStatementOids getQCStatementOids(Condition condition) {
        QCStatementOids result = new QCStatementOids();
        ArrayList<String> qcStatementIds = new ArrayList<String>();
        ArrayList<String> qcTypeIds = new ArrayList<String>();
        ArrayList<String> qcCClegislations = new ArrayList<String>();
        ArrayList<String> qcStatementIdsToRemove = new ArrayList<String>();
        ArrayList<String> qcTypeIdsToRemove = new ArrayList<String>();
        ArrayList<String> qcCClegislationsToRemove = new ArrayList<String>();
        if (condition instanceof CompositeCondition) {
            CompositeCondition composite = (CompositeCondition)condition;
            switch (composite.getMatchingCriteriaIndicator()) {
                case ALL: {
                    for (Condition childCondition : composite.getChildren()) {
                        this.populateFromChild(childCondition, qcStatementIds, qcTypeIds, qcCClegislations, qcStatementIdsToRemove, qcTypeIdsToRemove, qcCClegislationsToRemove);
                    }
                    break;
                }
                case AT_LEAST_ONE: {
                    if (composite.getChildren().size() > 1) {
                        LOG.info("First equivalence condition is used out of '{}'!", (Object)composite.getChildren().size());
                    }
                    Condition firstCondition = composite.getChildren().get(0);
                    this.populateFromChild(firstCondition, qcStatementIds, qcTypeIds, qcCClegislations, qcStatementIdsToRemove, qcTypeIdsToRemove, qcCClegislationsToRemove);
                    break;
                }
                case NONE: {
                    for (Condition childCondition : composite.getChildren()) {
                        this.populateFromChild(childCondition, qcStatementIdsToRemove, qcTypeIdsToRemove, qcCClegislationsToRemove, qcStatementIds, qcTypeIds, qcCClegislations);
                    }
                    break;
                }
                default: {
                    LOG.warn("Unsupported assert {}", (Object)composite.getMatchingCriteriaIndicator());
                }
            }
        }
        if (condition instanceof QCStatementCondition) {
            String legislation;
            String type;
            QCStatementCondition qcCondition = (QCStatementCondition)condition;
            String oid = qcCondition.getOid();
            if (Utils.isStringNotEmpty((String)oid)) {
                qcStatementIds.add(oid);
            }
            if (Utils.isStringNotEmpty((String)(type = qcCondition.getType()))) {
                qcTypeIds.add(type);
            }
            if (Utils.isStringNotEmpty((String)(legislation = qcCondition.getLegislation()))) {
                qcCClegislations.add(legislation);
            }
        }
        result.setQcStatementIds(qcStatementIds);
        result.setQcTypeIds(qcTypeIds);
        result.setQcCClegislations(qcCClegislations);
        result.setQcStatementIdsToRemove(qcStatementIdsToRemove);
        result.setQcTypeIdsToRemove(qcTypeIdsToRemove);
        result.setQcCClegislationsToRemove(qcCClegislationsToRemove);
        return result;
    }

    private void populateFromChild(Condition condition, List<String> qcStatementIds, List<String> qcTypeIds, List<String> qcCClegislations, List<String> qcStatementIdsToRemove, List<String> qcTypeIdsToRemove, List<String> qcCClegislationsToRemove) {
        QCStatementOids conditionResult = this.getQCStatementOids(condition);
        for (String conditionQCStatementId : conditionResult.getQcStatementIds()) {
            if (qcStatementIds.contains(conditionQCStatementId)) continue;
            qcStatementIds.add(conditionQCStatementId);
        }
        for (String conditionQCTypeId : conditionResult.getQcTypeIds()) {
            if (qcTypeIds.contains(conditionQCTypeId)) continue;
            qcTypeIds.add(conditionQCTypeId);
        }
        for (String conditionQcCClegislation : conditionResult.getQcCClegislations()) {
            if (qcCClegislations.contains(conditionQcCClegislation)) continue;
            qcCClegislations.add(conditionQcCClegislation);
        }
        for (String childQCStatementId : conditionResult.getQcStatementIdsToRemove()) {
            if (qcStatementIdsToRemove.contains(childQCStatementId)) continue;
            qcStatementIdsToRemove.add(childQCStatementId);
        }
        for (String childQCTypeId : conditionResult.getQcTypeIdsToRemove()) {
            if (qcTypeIdsToRemove.contains(childQCTypeId)) continue;
            qcTypeIdsToRemove.add(childQCTypeId);
        }
        for (String childQcCClegislation : conditionResult.getQcCClegislationsToRemove()) {
            if (qcCClegislationsToRemove.contains(childQcCClegislation)) continue;
            qcCClegislationsToRemove.add(childQcCClegislation);
        }
    }

    private void fillQualifierEquivalence(TrustServiceEquivalenceInformationType t, ServiceEquivalence result) {
        TrustServiceTSLQualificationExtensionEquivalenceListType qualificationExtensionEquivalenceListType = t.getTrustServiceTSLQualificationExtensionEquivalenceList();
        if (qualificationExtensionEquivalenceListType != null && Utils.isCollectionNotEmpty((Collection)qualificationExtensionEquivalenceListType.getQualifierEquivalenceList())) {
            HashMap<String, String> qualifierEquivalenceMap = new HashMap<String, String>();
            for (QualifierEquivalenceListType qualifierEquivalenceList : qualificationExtensionEquivalenceListType.getQualifierEquivalenceList()) {
                List qualifierEquivalence = qualifierEquivalenceList.getQualifierEquivalence();
                for (QualifierEquivalenceType qualifierEquivalenceType : qualifierEquivalence) {
                    QualifierType qualifierExpected = qualifierEquivalenceType.getQualifierPointedParty();
                    QualifierType qualifierSubstitute = qualifierEquivalenceType.getQualifierPointingParty();
                    qualifierEquivalenceMap.put(qualifierExpected.getUri(), qualifierSubstitute.getUri());
                }
            }
            result.setQualifierEquivalence(qualifierEquivalenceMap);
        }
    }
}

